/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.pm.pkg.component;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.ComponentName;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.ArrayMap;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.pm.parsing.pkg.PackageImpl;
import com.android.internal.pm.pkg.component.ParsedComponent;
import com.android.internal.pm.pkg.component.ParsedIntentInfo;
import com.android.internal.pm.pkg.component.ParsedIntentInfoImpl;
import com.android.internal.pm.pkg.parsing.ParsingUtils;
import com.android.internal.util.CollectionUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
public abstract class ParsedComponentImpl
implements ParsedComponent,
Parcelable {
    @NonNull
    private String name;
    private int icon;
    private int labelRes;
    @Nullable
    private CharSequence nonLocalizedLabel;
    private int logo;
    private int banner;
    private int descriptionRes;
    private int flags;
    @NonNull
    private String packageName;
    @NonNull
    private List<ParsedIntentInfoImpl> intents = Collections.emptyList();
    @Nullable
    private ComponentName componentName;
    @Nullable
    private Bundle metaData;
    @NonNull
    private Map<String, PackageManager.Property> mProperties = Collections.emptyMap();

    public ParsedComponentImpl() {
    }

    protected ParsedComponentImpl(ParsedComponent other) {
        this.metaData = other.getMetaData();
        this.name = other.getName();
        this.icon = other.getIcon();
        this.labelRes = other.getLabelRes();
        this.nonLocalizedLabel = other.getNonLocalizedLabel();
        this.logo = other.getLogo();
        this.banner = other.getBanner();
        this.descriptionRes = other.getDescriptionRes();
        this.flags = other.getFlags();
        this.packageName = other.getPackageName();
        this.componentName = other.getComponentName();
        this.intents = new ArrayList<ParsedIntentInfoImpl>(((ParsedComponentImpl)other).intents);
        this.mProperties = new ArrayMap<String, PackageManager.Property>();
        this.mProperties.putAll(other.getProperties());
    }

    public void addIntent(ParsedIntentInfoImpl intent) {
        this.intents = CollectionUtils.add(this.intents, intent);
    }

    public void addProperty(@NonNull PackageManager.Property property) {
        this.mProperties = CollectionUtils.add(this.mProperties, property.getName(), property);
    }

    public ParsedComponentImpl setName(String name) {
        this.name = TextUtils.safeIntern(name);
        return this;
    }

    public void setPackageName(@NonNull String packageName) {
        this.packageName = TextUtils.safeIntern(packageName);
        this.componentName = null;
    }

    @Override
    @NonNull
    public ComponentName getComponentName() {
        if (this.componentName == null) {
            this.componentName = new ComponentName(this.getPackageName(), this.getName());
        }
        return this.componentName;
    }

    @Override
    @NonNull
    public Bundle getMetaData() {
        return this.metaData == null ? Bundle.EMPTY : this.metaData;
    }

    @Override
    @NonNull
    public List<ParsedIntentInfo> getIntents() {
        return new ArrayList<ParsedIntentInfo>(this.intents);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.name);
        dest.writeInt(this.getIcon());
        dest.writeInt(this.getLabelRes());
        dest.writeCharSequence(this.getNonLocalizedLabel());
        dest.writeInt(this.getLogo());
        dest.writeInt(this.getBanner());
        dest.writeInt(this.getDescriptionRes());
        dest.writeInt(this.getFlags());
        PackageImpl.sForInternedString.parcel(this.packageName, dest, flags);
        dest.writeTypedList(this.intents);
        dest.writeBundle(this.metaData);
        dest.writeMap(this.mProperties);
    }

    protected ParsedComponentImpl(Parcel in) {
        ClassLoader boot = Object.class.getClassLoader();
        this.name = in.readString();
        this.icon = in.readInt();
        this.labelRes = in.readInt();
        this.nonLocalizedLabel = in.readCharSequence();
        this.logo = in.readInt();
        this.banner = in.readInt();
        this.descriptionRes = in.readInt();
        this.flags = in.readInt();
        this.packageName = PackageImpl.sForInternedString.unparcel(in);
        this.intents = ParsingUtils.createTypedInterfaceList(in, ParsedIntentInfoImpl.CREATOR);
        this.metaData = in.readBundle(boot);
        this.mProperties = in.readHashMap(boot);
    }

    @Override
    @NonNull
    public String getName() {
        return this.name;
    }

    @Override
    public int getIcon() {
        return this.icon;
    }

    @Override
    public int getLabelRes() {
        return this.labelRes;
    }

    @Override
    @Nullable
    public CharSequence getNonLocalizedLabel() {
        return this.nonLocalizedLabel;
    }

    @Override
    public int getLogo() {
        return this.logo;
    }

    @Override
    public int getBanner() {
        return this.banner;
    }

    @Override
    public int getDescriptionRes() {
        return this.descriptionRes;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    @Override
    @NonNull
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    @NonNull
    public Map<String, PackageManager.Property> getProperties() {
        return this.mProperties;
    }

    @NonNull
    public ParsedComponentImpl setIcon(int value) {
        this.icon = value;
        return this;
    }

    @NonNull
    public ParsedComponentImpl setLabelRes(int value) {
        this.labelRes = value;
        return this;
    }

    @NonNull
    public ParsedComponentImpl setNonLocalizedLabel(@NonNull CharSequence value) {
        this.nonLocalizedLabel = value;
        return this;
    }

    @NonNull
    public ParsedComponentImpl setLogo(int value) {
        this.logo = value;
        return this;
    }

    @NonNull
    public ParsedComponentImpl setBanner(int value) {
        this.banner = value;
        return this;
    }

    @NonNull
    public ParsedComponentImpl setDescriptionRes(int value) {
        this.descriptionRes = value;
        return this;
    }

    @NonNull
    public ParsedComponentImpl setFlags(int value) {
        this.flags = value;
        return this;
    }

    @NonNull
    public ParsedComponentImpl setMetaData(@NonNull Bundle value) {
        this.metaData = value;
        return this;
    }

    @Deprecated
    private void __metadata() {
    }
}

