/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.pm.parsing;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.Attribution;
import android.content.pm.ComponentInfo;
import android.content.pm.ConfigurationInfo;
import android.content.pm.FallbackCategoryProvider;
import android.content.pm.FeatureGroupInfo;
import android.content.pm.FeatureInfo;
import android.content.pm.InstrumentationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageItemInfo;
import android.content.pm.PackageManager;
import android.content.pm.PathPermission;
import android.content.pm.PermissionInfo;
import android.content.pm.ProviderInfo;
import android.content.pm.ServiceInfo;
import android.content.pm.Signature;
import android.content.pm.SigningDetails;
import android.content.pm.SigningInfo;
import android.os.Bundle;
import android.os.PatternMatcher;
import android.os.UserHandle;
import android.util.Slog;
import com.android.internal.pm.parsing.pkg.AndroidPackageHidden;
import com.android.internal.pm.parsing.pkg.AndroidPackageLegacyUtils;
import com.android.internal.pm.parsing.pkg.PackageImpl;
import com.android.internal.pm.pkg.component.ComponentParseUtils;
import com.android.internal.pm.pkg.component.ParsedActivity;
import com.android.internal.pm.pkg.component.ParsedAttribution;
import com.android.internal.pm.pkg.component.ParsedComponent;
import com.android.internal.pm.pkg.component.ParsedInstrumentation;
import com.android.internal.pm.pkg.component.ParsedMainComponent;
import com.android.internal.pm.pkg.component.ParsedPermission;
import com.android.internal.pm.pkg.component.ParsedProvider;
import com.android.internal.pm.pkg.component.ParsedService;
import com.android.internal.pm.pkg.component.ParsedUsesPermission;
import com.android.internal.pm.pkg.parsing.ParsingPackageHidden;
import com.android.internal.pm.pkg.parsing.ParsingPackageUtils;
import com.android.internal.util.ArrayUtils;
import com.android.server.pm.pkg.AndroidPackage;
import java.util.List;

public class PackageInfoCommonUtils {
    private static final String TAG = "PackageParsing";
    private static final boolean DEBUG = false;

    @Nullable
    public static PackageInfo generate(@Nullable AndroidPackage pkg, long flags, int userId) {
        ParsedActivity a;
        int i;
        ComponentInfo[] res;
        int size;
        int size2;
        if (pkg == null) {
            return null;
        }
        ApplicationInfo applicationInfo = PackageInfoCommonUtils.generateApplicationInfo(pkg, flags, userId);
        PackageInfo info = new PackageInfo();
        info.packageName = pkg.getPackageName();
        info.splitNames = pkg.getSplitNames();
        info.versionCode = ((ParsingPackageHidden)((Object)pkg)).getVersionCode();
        info.versionCodeMajor = ((ParsingPackageHidden)((Object)pkg)).getVersionCodeMajor();
        info.baseRevisionCode = pkg.getBaseRevisionCode();
        info.splitRevisionCodes = pkg.getSplitRevisionCodes();
        info.versionName = pkg.getVersionName();
        if (!pkg.isLeavingSharedUser()) {
            info.sharedUserId = pkg.getSharedUserId();
            info.sharedUserLabel = pkg.getSharedUserLabelResourceId();
        }
        info.applicationInfo = applicationInfo;
        info.installLocation = pkg.getInstallLocation();
        if ((info.applicationInfo.flags & 1) != 0 || (info.applicationInfo.flags & 0x80) != 0) {
            info.requiredForAllUsers = pkg.isRequiredForAllUsers();
        }
        info.restrictedAccountType = pkg.getRestrictedAccountType();
        info.requiredAccountType = pkg.getRequiredAccountType();
        info.overlayTarget = pkg.getOverlayTarget();
        info.targetOverlayableName = pkg.getOverlayTargetOverlayableName();
        info.overlayCategory = pkg.getOverlayCategory();
        info.overlayPriority = pkg.getOverlayPriority();
        info.mOverlayIsStatic = pkg.isOverlayIsStatic();
        info.compileSdkVersion = pkg.getCompileSdkVersion();
        info.compileSdkVersionCodename = pkg.getCompileSdkVersionCodeName();
        info.isStub = pkg.isStub();
        info.coreApp = pkg.isCoreApp();
        info.isApex = pkg.isApex();
        if ((flags & 0x4000L) != 0L) {
            size2 = pkg.getConfigPreferences().size();
            if (size2 > 0) {
                info.configPreferences = new ConfigurationInfo[size2];
                pkg.getConfigPreferences().toArray(info.configPreferences);
            }
            if ((size2 = pkg.getRequestedFeatures().size()) > 0) {
                info.reqFeatures = new FeatureInfo[size2];
                pkg.getRequestedFeatures().toArray(info.reqFeatures);
            }
            if ((size2 = pkg.getFeatureGroups().size()) > 0) {
                info.featureGroups = new FeatureGroupInfo[size2];
                pkg.getFeatureGroups().toArray(info.featureGroups);
            }
        }
        if ((flags & 0x1000L) != 0L) {
            List<ParsedUsesPermission> usesPermissions;
            size2 = ArrayUtils.size(pkg.getPermissions());
            if (size2 > 0) {
                info.permissions = new PermissionInfo[size2];
                for (int i2 = 0; i2 < size2; ++i2) {
                    PermissionInfo permissionInfo;
                    ParsedPermission permission2 = pkg.getPermissions().get(i2);
                    info.permissions[i2] = permissionInfo = PackageInfoCommonUtils.generatePermissionInfo(permission2, flags);
                }
            }
            if ((size2 = (usesPermissions = pkg.getUsesPermissions()).size()) > 0) {
                info.requestedPermissions = new String[size2];
                info.requestedPermissionsFlags = new int[size2];
                for (int i3 = 0; i3 < size2; ++i3) {
                    ParsedUsesPermission usesPermission = usesPermissions.get(i3);
                    info.requestedPermissions[i3] = usesPermission.getName();
                    int n = i3;
                    info.requestedPermissionsFlags[n] = info.requestedPermissionsFlags[n] | 1;
                    if ((usesPermission.getUsesPermissionFlags() & 0x10000) != 0) {
                        int n2 = i3;
                        info.requestedPermissionsFlags[n2] = info.requestedPermissionsFlags[n2] | 0x10000;
                    }
                    if (!pkg.getImplicitPermissions().contains(info.requestedPermissions[i3])) continue;
                    int n3 = i3;
                    info.requestedPermissionsFlags[n3] = info.requestedPermissionsFlags[n3] | 4;
                }
            }
        }
        if ((flags & 0x80000000L) != 0L) {
            size2 = ArrayUtils.size(pkg.getAttributions());
            if (size2 > 0) {
                info.attributions = new Attribution[size2];
                for (int i4 = 0; i4 < size2; ++i4) {
                    ParsedAttribution parsedAttribution = pkg.getAttributions().get(i4);
                    if (parsedAttribution == null) continue;
                    info.attributions[i4] = new Attribution(parsedAttribution.getTag(), parsedAttribution.getLabel());
                }
            }
            info.applicationInfo.privateFlagsExt = pkg.isAttributionsUserVisible() ? (info.applicationInfo.privateFlagsExt |= 4) : (info.applicationInfo.privateFlagsExt &= 0xFFFFFFFB);
        } else {
            info.applicationInfo.privateFlagsExt &= 0xFFFFFFFB;
        }
        SigningDetails signingDetails = pkg.getSigningDetails();
        if ((flags & 0x40L) != 0L) {
            if (signingDetails.hasPastSigningCertificates()) {
                info.signatures = new Signature[1];
                info.signatures[0] = signingDetails.getPastSigningCertificates()[0];
            } else if (signingDetails.hasSignatures()) {
                int numberOfSigs = signingDetails.getSignatures().length;
                info.signatures = new Signature[numberOfSigs];
                System.arraycopy(signingDetails.getSignatures(), 0, info.signatures, 0, numberOfSigs);
            }
        }
        if ((flags & 0x8000000L) != 0L) {
            info.signingInfo = signingDetails != SigningDetails.UNKNOWN ? new SigningInfo(signingDetails) : null;
        }
        if ((flags & 1L) != 0L && (size = pkg.getActivities().size()) > 0) {
            int num = 0;
            res = new ActivityInfo[size];
            for (i = 0; i < size; ++i) {
                a = pkg.getActivities().get(i);
                if (!PackageInfoCommonUtils.isMatch(pkg, a.isDirectBootAware(), flags) || PackageManager.APP_DETAILS_ACTIVITY_CLASS_NAME.equals(a.getName())) continue;
                res[num++] = PackageInfoCommonUtils.generateActivityInfo(a, flags, applicationInfo);
            }
            info.activities = ArrayUtils.trimToSize(res, num);
        }
        if ((flags & 2L) != 0L && (size = pkg.getReceivers().size()) > 0) {
            int num = 0;
            res = new ActivityInfo[size];
            for (i = 0; i < size; ++i) {
                a = pkg.getReceivers().get(i);
                if (!PackageInfoCommonUtils.isMatch(pkg, a.isDirectBootAware(), flags)) continue;
                res[num++] = PackageInfoCommonUtils.generateActivityInfo(a, flags, applicationInfo);
            }
            info.receivers = (ActivityInfo[])ArrayUtils.trimToSize(res, num);
        }
        if ((flags & 4L) != 0L && (size = pkg.getServices().size()) > 0) {
            int num = 0;
            res = new ServiceInfo[size];
            for (i = 0; i < size; ++i) {
                ParsedService s = pkg.getServices().get(i);
                if (!PackageInfoCommonUtils.isMatch(pkg, s.isDirectBootAware(), flags)) continue;
                res[num++] = PackageInfoCommonUtils.generateServiceInfo(s, flags, applicationInfo);
            }
            info.services = (ServiceInfo[])ArrayUtils.trimToSize(res, num);
        }
        if ((flags & 8L) != 0L && (size = pkg.getProviders().size()) > 0) {
            int num = 0;
            res = new ProviderInfo[size];
            for (i = 0; i < size; ++i) {
                ParsedProvider pr = pkg.getProviders().get(i);
                if (!PackageInfoCommonUtils.isMatch(pkg, pr.isDirectBootAware(), flags)) continue;
                res[num++] = PackageInfoCommonUtils.generateProviderInfo(pkg, pr, flags, applicationInfo, userId);
            }
            info.providers = (ProviderInfo[])ArrayUtils.trimToSize(res, num);
        }
        if ((flags & 0x10L) != 0L && (size = pkg.getInstrumentations().size()) > 0) {
            info.instrumentation = new InstrumentationInfo[size];
            for (int i5 = 0; i5 < size; ++i5) {
                info.instrumentation[i5] = PackageInfoCommonUtils.generateInstrumentationInfo(pkg.getInstrumentations().get(i5), pkg, flags, userId);
            }
        }
        return info;
    }

    private static void updateApplicationInfo(ApplicationInfo ai, long flags) {
        if ((flags & 0x80L) == 0L) {
            ai.metaData = null;
        }
        if ((flags & 0x400L) == 0L) {
            ai.sharedLibraryFiles = null;
            ai.sharedLibraryInfos = null;
        }
        if (!ParsingPackageUtils.sCompatibilityModeEnabled) {
            ai.disableCompatibilityMode();
        }
        if (ai.category == -1) {
            ai.category = FallbackCategoryProvider.getFallbackCategory(ai.packageName);
        }
        ai.seInfoUser = ":complete";
    }

    @Nullable
    private static ApplicationInfo generateApplicationInfo(@NonNull AndroidPackage pkg, long flags, int userId) {
        ApplicationInfo info = ((AndroidPackageHidden)((Object)pkg)).toAppInfoWithoutState();
        PackageInfoCommonUtils.updateApplicationInfo(info, flags);
        PackageInfoCommonUtils.initForUser(info, pkg, userId);
        info.primaryCpuAbi = AndroidPackageLegacyUtils.getRawPrimaryCpuAbi(pkg);
        info.secondaryCpuAbi = AndroidPackageLegacyUtils.getRawSecondaryCpuAbi(pkg);
        if ((flags & 0x80L) != 0L) {
            info.metaData = pkg.getMetaData();
        }
        if ((flags & 0x400L) != 0L) {
            List<String> usesLibraryFiles = pkg.getUsesLibraries();
            info.sharedLibraryFiles = usesLibraryFiles.isEmpty() ? null : usesLibraryFiles.toArray(new String[0]);
        }
        return info;
    }

    @Nullable
    private static ActivityInfo generateActivityInfo(ParsedActivity a, long flags, @NonNull ApplicationInfo applicationInfo) {
        Bundle metaData;
        if (a == null) {
            return null;
        }
        ActivityInfo ai = new ActivityInfo();
        ai.targetActivity = a.getTargetActivity();
        ai.processName = a.getProcessName();
        ai.exported = a.isExported();
        ai.theme = a.getTheme();
        ai.uiOptions = a.getUiOptions();
        ai.parentActivityName = a.getParentActivityName();
        ai.permission = a.getPermission();
        ai.taskAffinity = a.getTaskAffinity();
        ai.flags = a.getFlags();
        ai.privateFlags = a.getPrivateFlags();
        ai.launchMode = a.getLaunchMode();
        ai.documentLaunchMode = a.getDocumentLaunchMode();
        ai.maxRecents = a.getMaxRecents();
        ai.configChanges = a.getConfigChanges();
        ai.softInputMode = a.getSoftInputMode();
        ai.persistableMode = a.getPersistableMode();
        ai.lockTaskLaunchMode = a.getLockTaskLaunchMode();
        ai.screenOrientation = a.getScreenOrientation();
        ai.resizeMode = a.getResizeMode();
        ai.setMaxAspectRatio(a.getMaxAspectRatio());
        ai.setMinAspectRatio(a.getMinAspectRatio());
        ai.supportsSizeChanges = a.isSupportsSizeChanges();
        ai.requestedVrComponent = a.getRequestedVrComponent();
        ai.rotationAnimation = a.getRotationAnimation();
        ai.colorMode = a.getColorMode();
        ai.windowLayout = a.getWindowLayout();
        ai.attributionTags = a.getAttributionTags();
        ai.metaData = (flags & 0x80L) != 0L ? ((metaData = a.getMetaData()).isEmpty() ? null : metaData) : null;
        ai.applicationInfo = applicationInfo;
        ai.requiredDisplayCategory = a.getRequiredDisplayCategory();
        ai.setKnownActivityEmbeddingCerts(a.getKnownActivityEmbeddingCerts());
        PackageInfoCommonUtils.assignFieldsComponentInfoParsedMainComponent(ai, a);
        return ai;
    }

    @Nullable
    private static ServiceInfo generateServiceInfo(ParsedService s, long flags, @NonNull ApplicationInfo applicationInfo) {
        if (s == null) {
            return null;
        }
        ServiceInfo si = new ServiceInfo();
        si.exported = s.isExported();
        si.flags = s.getFlags();
        si.permission = s.getPermission();
        si.processName = s.getProcessName();
        si.mForegroundServiceType = s.getForegroundServiceType();
        si.applicationInfo = applicationInfo;
        if ((flags & 0x80L) != 0L) {
            Bundle metaData = s.getMetaData();
            si.metaData = metaData.isEmpty() ? null : metaData;
        }
        PackageInfoCommonUtils.assignFieldsComponentInfoParsedMainComponent(si, s);
        return si;
    }

    @Nullable
    private static ProviderInfo generateProviderInfo(AndroidPackage pkg, ParsedProvider p, long flags, @NonNull ApplicationInfo applicationInfo, int userId) {
        if (p == null) {
            return null;
        }
        if (!pkg.getPackageName().equals(applicationInfo.packageName)) {
            Slog.wtf(TAG, "AppInfo's package name is different. Expected=" + pkg.getPackageName() + " actual=" + applicationInfo.packageName);
            applicationInfo = PackageInfoCommonUtils.generateApplicationInfo(pkg, flags, userId);
        }
        ProviderInfo pi = new ProviderInfo();
        pi.exported = p.isExported();
        pi.flags = p.getFlags();
        pi.processName = p.getProcessName();
        pi.authority = p.getAuthority();
        pi.isSyncable = p.isSyncable();
        pi.readPermission = p.getReadPermission();
        pi.writePermission = p.getWritePermission();
        pi.grantUriPermissions = p.isGrantUriPermissions();
        pi.forceUriPermissions = p.isForceUriPermissions();
        pi.multiprocess = p.isMultiProcess();
        pi.initOrder = p.getInitOrder();
        pi.uriPermissionPatterns = p.getUriPermissionPatterns().toArray(new PatternMatcher[0]);
        pi.pathPermissions = p.getPathPermissions().toArray(new PathPermission[0]);
        if ((flags & 0x800L) == 0L) {
            pi.uriPermissionPatterns = null;
        }
        if ((flags & 0x80L) != 0L) {
            Bundle metaData = p.getMetaData();
            pi.metaData = metaData.isEmpty() ? null : metaData;
        }
        pi.applicationInfo = applicationInfo;
        PackageInfoCommonUtils.assignFieldsComponentInfoParsedMainComponent(pi, p);
        return pi;
    }

    @Nullable
    private static InstrumentationInfo generateInstrumentationInfo(ParsedInstrumentation i, AndroidPackage pkg, long flags, int userId) {
        Bundle metaData;
        if (i == null) {
            return null;
        }
        InstrumentationInfo info = new InstrumentationInfo();
        info.targetPackage = i.getTargetPackage();
        info.targetProcesses = i.getTargetProcesses();
        info.handleProfiling = i.isHandleProfiling();
        info.functionalTest = i.isFunctionalTest();
        info.sourceDir = pkg.getBaseApkPath();
        info.publicSourceDir = pkg.getBaseApkPath();
        info.splitNames = pkg.getSplitNames();
        info.splitSourceDirs = pkg.getSplitCodePaths().length == 0 ? null : pkg.getSplitCodePaths();
        info.splitPublicSourceDirs = pkg.getSplitCodePaths().length == 0 ? null : pkg.getSplitCodePaths();
        info.splitDependencies = pkg.getSplitDependencies().size() == 0 ? null : pkg.getSplitDependencies();
        PackageInfoCommonUtils.initForUser(info, pkg, userId);
        info.primaryCpuAbi = AndroidPackageLegacyUtils.getRawPrimaryCpuAbi(pkg);
        info.secondaryCpuAbi = AndroidPackageLegacyUtils.getRawSecondaryCpuAbi(pkg);
        info.nativeLibraryDir = pkg.getNativeLibraryDir();
        info.secondaryNativeLibraryDir = pkg.getSecondaryNativeLibraryDir();
        PackageInfoCommonUtils.assignFieldsPackageItemInfoParsedComponent(info, i);
        info.metaData = (flags & 0x80L) == 0L ? null : ((metaData = i.getMetaData()).isEmpty() ? null : metaData);
        return info;
    }

    @Nullable
    private static PermissionInfo generatePermissionInfo(ParsedPermission p, long flags) {
        Bundle metaData;
        if (p == null) {
            return null;
        }
        PermissionInfo pi = new PermissionInfo(p.getBackgroundPermission());
        PackageInfoCommonUtils.assignFieldsPackageItemInfoParsedComponent(pi, p);
        pi.group = p.getGroup();
        pi.requestRes = p.getRequestRes();
        pi.protectionLevel = p.getProtectionLevel();
        pi.descriptionRes = p.getDescriptionRes();
        pi.flags = p.getFlags();
        pi.knownCerts = p.getKnownCerts();
        pi.requiresPurpose = p.isPurposeRequired();
        pi.validPurposes = p.getValidPurposes();
        pi.metaData = (flags & 0x80L) == 0L ? null : ((metaData = p.getMetaData()).isEmpty() ? null : metaData);
        return pi;
    }

    private static void assignFieldsComponentInfoParsedMainComponent(@NonNull ComponentInfo info, @NonNull ParsedMainComponent component) {
        PackageInfoCommonUtils.assignFieldsPackageItemInfoParsedComponent(info, component);
        info.descriptionRes = component.getDescriptionRes();
        info.directBootAware = component.isDirectBootAware();
        info.enabled = component.isEnabled();
        info.splitName = component.getSplitName();
        info.attributionTags = component.getAttributionTags();
        info.nonLocalizedLabel = component.getNonLocalizedLabel();
        info.icon = component.getIcon();
    }

    private static void assignFieldsPackageItemInfoParsedComponent(@NonNull PackageItemInfo packageItemInfo, @NonNull ParsedComponent component) {
        packageItemInfo.nonLocalizedLabel = ComponentParseUtils.getNonLocalizedLabel(component);
        packageItemInfo.icon = ComponentParseUtils.getIcon(component);
        packageItemInfo.banner = component.getBanner();
        packageItemInfo.labelRes = component.getLabelRes();
        packageItemInfo.logo = component.getLogo();
        packageItemInfo.name = component.getName();
        packageItemInfo.packageName = component.getPackageName();
    }

    private static void initForUser(ApplicationInfo output, AndroidPackage input, int userId) {
        PackageImpl pkg = (PackageImpl)input;
        String packageName = input.getPackageName();
        output.uid = UserHandle.getUid(userId, UserHandle.getAppId(input.getUid()));
        String credentialDir = pkg.getBaseAppDataCredentialProtectedDirForSystemUser();
        String deviceDir = pkg.getBaseAppDataDeviceProtectedDirForSystemUser();
        if (credentialDir != null && deviceDir != null) {
            if (userId == 0) {
                output.credentialProtectedDataDir = credentialDir + packageName;
                output.deviceProtectedDataDir = deviceDir + packageName;
            } else {
                String userIdString = String.valueOf(userId);
                int credentialLength = credentialDir.length();
                output.credentialProtectedDataDir = new StringBuilder(credentialDir).replace(credentialLength - 2, credentialLength - 1, userIdString).append(packageName).toString();
                int deviceLength = deviceDir.length();
                output.deviceProtectedDataDir = new StringBuilder(deviceDir).replace(deviceLength - 2, deviceLength - 1, userIdString).append(packageName).toString();
            }
        }
        output.dataDir = input.isDefaultToDeviceProtectedStorage() ? output.deviceProtectedDataDir : output.credentialProtectedDataDir;
    }

    private static void initForUser(InstrumentationInfo output, AndroidPackage input, int userId) {
        PackageImpl pkg = (PackageImpl)input;
        String packageName = input.getPackageName();
        String credentialDir = pkg.getBaseAppDataCredentialProtectedDirForSystemUser();
        String deviceDir = pkg.getBaseAppDataDeviceProtectedDirForSystemUser();
        if (credentialDir != null && deviceDir != null) {
            if (userId == 0) {
                output.credentialProtectedDataDir = credentialDir + packageName;
                output.deviceProtectedDataDir = deviceDir + packageName;
            } else {
                String userIdString = String.valueOf(userId);
                int credentialLength = credentialDir.length();
                output.credentialProtectedDataDir = new StringBuilder(credentialDir).replace(credentialLength - 2, credentialLength - 1, userIdString).append(packageName).toString();
                int deviceLength = deviceDir.length();
                output.deviceProtectedDataDir = new StringBuilder(deviceDir).replace(deviceLength - 2, deviceLength - 1, userIdString).append(packageName).toString();
            }
        }
        output.dataDir = input.isDefaultToDeviceProtectedStorage() ? output.deviceProtectedDataDir : output.credentialProtectedDataDir;
    }

    private static boolean isMatch(AndroidPackage pkg, boolean isComponentDirectBootAware, long flags) {
        boolean isSystem = ((AndroidPackageHidden)((Object)pkg)).isSystem();
        if ((flags & 0x100000L) != 0L && !isSystem) {
            return PackageInfoCommonUtils.reportIfDebug(false, flags);
        }
        boolean matchesUnaware = (flags & 0x40000L) != 0L && !isComponentDirectBootAware;
        boolean matchesAware = (flags & 0x80000L) != 0L && isComponentDirectBootAware;
        return PackageInfoCommonUtils.reportIfDebug(matchesUnaware || matchesAware, flags);
    }

    private static boolean reportIfDebug(boolean result, long flags) {
        return result;
    }
}

