/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.annotation.NonNull;
import android.os.Handler;
import android.os.HandlerExecutor;
import android.os.HandlerThread;
import android.os.Looper;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import java.util.concurrent.Executor;

@RavenwoodKeepWholeClass
public class BackgroundThread
extends HandlerThread {
    private static final long SLOW_DISPATCH_THRESHOLD_MS = 10000L;
    private static final long SLOW_DELIVERY_THRESHOLD_MS = 30000L;
    private static volatile BackgroundThread sInstance;
    private static volatile Handler sHandler;
    private static volatile HandlerExecutor sHandlerExecutor;

    private BackgroundThread() {
        super("android.bg", 10);
    }

    private static void ensureThreadStartedLocked() {
        if (sInstance == null) {
            sInstance = new BackgroundThread();
            sInstance.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ensureThreadReady() {
        if (sHandler != null) {
            return;
        }
        Class<BackgroundThread> clazz = BackgroundThread.class;
        synchronized (BackgroundThread.class) {
            if (sHandler == null) {
                BackgroundThread.ensureThreadStartedLocked();
                Looper looper = sInstance.getLooper();
                looper.setTraceTag(524288L);
                looper.setSlowLogThresholdMs(10000L, 30000L);
                Handler handler = new Handler(looper, null, false, true);
                sHandlerExecutor = new HandlerExecutor(handler);
                sHandler = handler;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void startIfNeeded() {
        if (sInstance != null) return;
        Class<BackgroundThread> clazz = BackgroundThread.class;
        synchronized (BackgroundThread.class) {
            BackgroundThread.ensureThreadStartedLocked();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    @NonNull
    public static BackgroundThread get() {
        BackgroundThread.ensureThreadReady();
        return sInstance;
    }

    @NonNull
    public static Handler getHandler() {
        BackgroundThread.ensureThreadReady();
        return sHandler;
    }

    @NonNull
    public static Executor getExecutor() {
        BackgroundThread.ensureThreadReady();
        return sHandlerExecutor;
    }
}

