/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.app.AppGlobals;
import android.content.pm.PackageInfo;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.SparseArray;
import com.android.internal.annotations.VisibleForTesting;
import java.util.List;

public class AppIdToPackageMap {
    private final SparseArray<String> mAppIdToPackageMap;

    @VisibleForTesting
    public AppIdToPackageMap(SparseArray<String> appIdToPackageMap) {
        this.mAppIdToPackageMap = appIdToPackageMap;
    }

    public static AppIdToPackageMap getSnapshot() {
        List packages;
        try {
            packages = AppGlobals.getPackageManager().getInstalledPackages(794624L, 0).getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        SparseArray<String> map = new SparseArray<String>();
        for (PackageInfo pkg : packages) {
            int uid = pkg.applicationInfo.uid;
            if (pkg.sharedUserId != null && map.indexOfKey(uid) >= 0) {
                map.put(uid, "shared:" + pkg.sharedUserId);
                continue;
            }
            map.put(uid, pkg.packageName);
        }
        return new AppIdToPackageMap(map);
    }

    public String mapAppId(int appId) {
        String pkgName = this.mAppIdToPackageMap.get(appId);
        return pkgName == null ? String.valueOf(appId) : pkgName;
    }

    public String mapUid(int uid) {
        int appId = UserHandle.getAppId(uid);
        String pkgName = this.mAppIdToPackageMap.get(appId);
        String uidStr = UserHandle.formatUid(uid);
        return pkgName == null ? uidStr : pkgName + '/' + uidStr;
    }
}

