/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.org.bouncycastle.asn1;

import com.android.internal.org.bouncycastle.asn1.ASN1Encodable;
import com.android.internal.org.bouncycastle.asn1.ASN1OutputStream;
import com.android.internal.org.bouncycastle.asn1.ASN1Primitive;
import com.android.internal.org.bouncycastle.asn1.ASN1String;
import com.android.internal.org.bouncycastle.asn1.ASN1TaggedObject;
import com.android.internal.org.bouncycastle.asn1.ASN1UniversalType;
import com.android.internal.org.bouncycastle.asn1.DERNumericString;
import com.android.internal.org.bouncycastle.asn1.DEROctetString;
import com.android.internal.org.bouncycastle.util.Arrays;
import com.android.internal.org.bouncycastle.util.Strings;
import java.io.IOException;

public abstract class ASN1NumericString
extends ASN1Primitive
implements ASN1String {
    static final ASN1UniversalType TYPE = new ASN1UniversalType(ASN1NumericString.class, 18){

        @Override
        ASN1Primitive fromImplicitPrimitive(DEROctetString octetString) {
            return ASN1NumericString.createPrimitive(octetString.getOctets());
        }
    };
    final byte[] contents;

    public static ASN1NumericString getInstance(Object obj) {
        ASN1Primitive primitive;
        if (obj == null || obj instanceof ASN1NumericString) {
            return (ASN1NumericString)obj;
        }
        if (obj instanceof ASN1Encodable && (primitive = ((ASN1Encodable)obj).toASN1Primitive()) instanceof ASN1NumericString) {
            return (ASN1NumericString)primitive;
        }
        if (obj instanceof byte[]) {
            try {
                return (ASN1NumericString)TYPE.fromByteArray((byte[])obj);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("encoding error in getInstance: " + ((Object)e).toString());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static ASN1NumericString getInstance(ASN1TaggedObject taggedObject, boolean explicit) {
        return (ASN1NumericString)TYPE.getContextInstance(taggedObject, explicit);
    }

    ASN1NumericString(String string2, boolean validate) {
        if (validate && !ASN1NumericString.isNumericString(string2)) {
            throw new IllegalArgumentException("string contains illegal characters");
        }
        this.contents = Strings.toByteArray(string2);
    }

    ASN1NumericString(byte[] contents, boolean clone) {
        this.contents = clone ? Arrays.clone(contents) : contents;
    }

    @Override
    public String getString() {
        return Strings.fromByteArray(this.contents);
    }

    public String toString() {
        return this.getString();
    }

    public byte[] getOctets() {
        return Arrays.clone(this.contents);
    }

    @Override
    boolean encodeConstructed() {
        return false;
    }

    @Override
    int encodedLength(boolean withTag) {
        return ASN1OutputStream.getLengthOfEncodingDL(withTag, this.contents.length);
    }

    @Override
    void encode(ASN1OutputStream out, boolean withTag) throws IOException {
        out.writeEncodingDL(withTag, 18, this.contents);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.contents);
    }

    @Override
    boolean asn1Equals(ASN1Primitive other) {
        if (!(other instanceof ASN1NumericString)) {
            return false;
        }
        ASN1NumericString that = (ASN1NumericString)other;
        return Arrays.areEqual(this.contents, that.contents);
    }

    public static boolean isNumericString(String str) {
        for (int i = str.length() - 1; i >= 0; --i) {
            char ch = str.charAt(i);
            if (ch > '\u007f') {
                return false;
            }
            if ('0' <= ch && ch <= '9' || ch == ' ') continue;
            return false;
        }
        return true;
    }

    static boolean isNumericString(byte[] contents) {
        block3: for (int i = 0; i < contents.length; ++i) {
            switch (contents[i]) {
                case 32: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    static ASN1NumericString createPrimitive(byte[] contents) {
        return new DERNumericString(contents, false);
    }
}

