/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.net.utils;

import com.android.internal.annotations.VisibleForTesting;
import java.util.Locale;
import java.util.Objects;

public class Log {
    private static final boolean VDBG = false;
    private final String mTAG;
    private final boolean mIsVdbg;
    private final boolean mLogSensitive;

    public Log(String tag, boolean logSensitive) {
        this(tag, false, logSensitive);
    }

    @VisibleForTesting
    Log(String tag, boolean isVdbg, boolean logSensitive) {
        this.mTAG = tag;
        this.mIsVdbg = isVdbg;
        this.mLogSensitive = logSensitive;
    }

    public void v(String prefix, String msg) {
        if (this.isLoggable(2)) {
            android.util.Log.v(this.mTAG, prefix + ": " + msg);
        }
    }

    public void v(String prefix, String msg, Throwable tr) {
        if (this.isLoggable(2)) {
            android.util.Log.v(this.mTAG, prefix + ": " + msg, tr);
        }
    }

    public void d(String prefix, String msg) {
        if (this.isLoggable(3)) {
            android.util.Log.d(this.mTAG, prefix + ": " + msg);
        }
    }

    public void d(String prefix, String msg, Throwable tr) {
        if (this.isLoggable(3)) {
            android.util.Log.d(this.mTAG, prefix + ": " + msg, tr);
        }
    }

    public void i(String prefix, String msg) {
        if (this.isLoggable(4)) {
            android.util.Log.i(this.mTAG, prefix + ": " + msg);
        }
    }

    public void i(String prefix, String msg, Throwable tr) {
        if (this.isLoggable(4)) {
            android.util.Log.i(this.mTAG, prefix + ": " + msg, tr);
        }
    }

    public void w(String prefix, String msg) {
        if (this.isLoggable(5)) {
            android.util.Log.w(this.mTAG, prefix + ": " + msg);
        }
    }

    public void w(String prefix, String msg, Throwable tr) {
        if (this.isLoggable(5)) {
            android.util.Log.w(this.mTAG, prefix + ": " + msg, tr);
        }
    }

    public void e(String prefix, String msg) {
        if (this.isLoggable(6)) {
            android.util.Log.e(this.mTAG, prefix + ": " + msg);
        }
    }

    public void e(String prefix, String msg, Throwable tr) {
        if (this.isLoggable(6)) {
            android.util.Log.e(this.mTAG, prefix + ": " + msg, tr);
        }
    }

    public void wtf(String prefix, String msg) {
        android.util.Log.wtf(this.mTAG, prefix + ": " + msg);
    }

    public void wtf(String prefix, String msg, Throwable tr) {
        android.util.Log.wtf(this.mTAG, prefix + ": " + msg, tr);
    }

    public String pii(Object pii) {
        if (!this.mIsVdbg || !this.mLogSensitive) {
            return String.valueOf(Objects.hashCode(pii));
        }
        if (pii instanceof byte[]) {
            return Log.byteArrayToHexString((byte[])pii);
        }
        return String.valueOf(pii);
    }

    private boolean isLoggable(int level) {
        return android.util.Log.isLoggable(this.mTAG, level);
    }

    public static String byteArrayToHexString(byte[] data) {
        if (data == null || data.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (byte b : data) {
            sb.append(String.format(Locale.US, "%02X", b));
        }
        return sb.toString();
    }
}

