/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.net.ipsec.ike.ike3gpp;

import android.annotation.NonNull;
import com.android.internal.net.ipsec.ike.message.IkeNotifyPayload;
import java.nio.ByteBuffer;

public class Ike3gppDeviceIdentityUtils {
    private static final int DEVICE_IDENTITY_PAYLOAD_LENGTH = 11;
    private static final short DEVICE_IDENTITY_PAYLOAD_LENGTH_FIELD_VAL = 9;
    private static final byte DEVICE_IDENTITY_TYPE_IMEI = 1;
    private static final byte DEVICE_IDENTITY_TYPE_IMEISV = 2;
    private static final int ENCODED_DEVICE_IDENTITY_LENGTH = 8;
    private static final int IMEI_LENGTH = 15;
    private static final int IMEISV_LENGTH = 16;

    static IkeNotifyPayload generateDeviceIdentityPayload(@NonNull String deviceIdentity) throws IllegalArgumentException {
        if (!Ike3gppDeviceIdentityUtils.isValidDeviceIdentity(deviceIdentity)) {
            throw new IllegalArgumentException("device identity should be a 15 or 16 digit numeric string");
        }
        ByteBuffer payloadData = ByteBuffer.allocate(11);
        payloadData.putShort((short)9);
        byte deviceIdentityType = deviceIdentity.length() == 15 ? (byte)1 : 2;
        payloadData.put(deviceIdentityType);
        if (deviceIdentityType == 1) {
            deviceIdentity = deviceIdentity + "0";
        }
        byte[] encodedIdentity = new byte[8];
        int i = 0;
        int j = 0;
        while (i + 1 < 16) {
            byte nibble1 = (byte)Character.getNumericValue(deviceIdentity.charAt(i + 1));
            byte nibble2 = (byte)Character.getNumericValue(deviceIdentity.charAt(i));
            encodedIdentity[j] = deviceIdentityType == 1 && j == 7 ? (byte)(0xF0 | nibble2) : (byte)(nibble1 << 4 | nibble2);
            i += 2;
            ++j;
        }
        payloadData.put(encodedIdentity);
        return new IkeNotifyPayload(41101, payloadData.array());
    }

    public static boolean isValidDeviceIdentity(String deviceIdentity) {
        int deviceIdentityLen;
        return deviceIdentity != null && ((deviceIdentityLen = deviceIdentity.length()) == 15 || deviceIdentityLen == 16) && deviceIdentity.matches("[0-9]+");
    }
}

