/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.jank;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class DisplayRefreshRate {
    public static final int UNKNOWN_REFRESH_RATE = 0;
    public static final int VARIABLE_REFRESH_RATE = 1;
    public static final int REFRESH_RATE_30_HZ = 2;
    public static final int REFRESH_RATE_60_HZ = 3;
    public static final int REFRESH_RATE_90_HZ = 4;
    public static final int REFRESH_RATE_120_HZ = 5;
    public static final int REFRESH_RATE_240_HZ = 6;

    private DisplayRefreshRate() {
    }

    public static int getRefreshRate(long frameIntervalNs) {
        long rate = Math.round(1.0E9 / (double)frameIntervalNs);
        if (rate < 50L) {
            return 2;
        }
        if (rate < 80L) {
            return 3;
        }
        if (rate < 110L) {
            return 4;
        }
        if (rate < 180L) {
            return 5;
        }
        return 6;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RefreshRate {
    }
}

