/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.database;

import android.compat.annotation.UnsupportedAppUsage;
import android.database.AbstractCursor;
import android.database.Cursor;
import android.database.DataSetObserver;
import android.util.Log;

public class SortCursor
extends AbstractCursor {
    private static final String TAG = "SortCursor";
    @UnsupportedAppUsage
    private Cursor mCursor;
    @UnsupportedAppUsage
    private Cursor[] mCursors;
    private int[] mSortColumns;
    private final int ROWCACHESIZE = 64;
    private int[] mRowNumCache = new int[64];
    private int[] mCursorCache = new int[64];
    private int[][] mCurRowNumCache;
    private int mLastCacheHit = -1;
    private DataSetObserver mObserver = new DataSetObserver(){

        @Override
        public void onChanged() {
            SortCursor.this.mPos = -1;
        }

        @Override
        public void onInvalidated() {
            SortCursor.this.mPos = -1;
        }
    };

    @UnsupportedAppUsage
    public SortCursor(Cursor[] cursors, String sortcolumn) {
        this.mCursors = cursors;
        int length = this.mCursors.length;
        this.mSortColumns = new int[length];
        for (int i = 0; i < length; ++i) {
            if (this.mCursors[i] == null) continue;
            this.mCursors[i].registerDataSetObserver(this.mObserver);
            this.mCursors[i].moveToFirst();
            this.mSortColumns[i] = this.mCursors[i].getColumnIndexOrThrow(sortcolumn);
        }
        this.mCursor = null;
        String smallest = "";
        for (int j = 0; j < length; ++j) {
            if (this.mCursors[j] == null || this.mCursors[j].isAfterLast()) continue;
            String current = this.mCursors[j].getString(this.mSortColumns[j]);
            if (this.mCursor != null && current.compareToIgnoreCase(smallest) >= 0) continue;
            smallest = current;
            this.mCursor = this.mCursors[j];
        }
        for (int i = this.mRowNumCache.length - 1; i >= 0; --i) {
            this.mRowNumCache[i] = -2;
        }
        this.mCurRowNumCache = new int[64][length];
    }

    @Override
    public int getCount() {
        int count = 0;
        int length = this.mCursors.length;
        for (int i = 0; i < length; ++i) {
            if (this.mCursors[i] == null) continue;
            count += this.mCursors[i].getCount();
        }
        return count;
    }

    @Override
    public boolean onMove(int oldPosition, int newPosition) {
        int i;
        int i2;
        if (oldPosition == newPosition) {
            return true;
        }
        int cache_entry = newPosition % 64;
        if (this.mRowNumCache[cache_entry] == newPosition) {
            int which = this.mCursorCache[cache_entry];
            this.mCursor = this.mCursors[which];
            if (this.mCursor == null) {
                Log.w(TAG, "onMove: cache results in a null cursor.");
                return false;
            }
            this.mCursor.moveToPosition(this.mCurRowNumCache[cache_entry][which]);
            this.mLastCacheHit = cache_entry;
            return true;
        }
        this.mCursor = null;
        int length = this.mCursors.length;
        if (this.mLastCacheHit >= 0) {
            for (i2 = 0; i2 < length; ++i2) {
                if (this.mCursors[i2] == null) continue;
                this.mCursors[i2].moveToPosition(this.mCurRowNumCache[this.mLastCacheHit][i2]);
            }
        }
        if (newPosition < oldPosition || oldPosition == -1) {
            for (i2 = 0; i2 < length; ++i2) {
                if (this.mCursors[i2] == null) continue;
                this.mCursors[i2].moveToFirst();
            }
            oldPosition = 0;
        }
        if (oldPosition < 0) {
            oldPosition = 0;
        }
        int smallestIdx = -1;
        for (i = oldPosition; i <= newPosition; ++i) {
            String smallest = "";
            smallestIdx = -1;
            for (int j = 0; j < length; ++j) {
                if (this.mCursors[j] == null || this.mCursors[j].isAfterLast()) continue;
                String current = this.mCursors[j].getString(this.mSortColumns[j]);
                if (smallestIdx >= 0 && current.compareToIgnoreCase(smallest) >= 0) continue;
                smallest = current;
                smallestIdx = j;
            }
            if (i == newPosition) break;
            if (this.mCursors[smallestIdx] == null) continue;
            this.mCursors[smallestIdx].moveToNext();
        }
        this.mCursor = this.mCursors[smallestIdx];
        this.mRowNumCache[cache_entry] = newPosition;
        this.mCursorCache[cache_entry] = smallestIdx;
        for (i = 0; i < length; ++i) {
            if (this.mCursors[i] == null) continue;
            this.mCurRowNumCache[cache_entry][i] = this.mCursors[i].getPosition();
        }
        this.mLastCacheHit = -1;
        return true;
    }

    @Override
    public String getString(int column) {
        return this.mCursor.getString(column);
    }

    @Override
    public short getShort(int column) {
        return this.mCursor.getShort(column);
    }

    @Override
    public int getInt(int column) {
        return this.mCursor.getInt(column);
    }

    @Override
    public long getLong(int column) {
        return this.mCursor.getLong(column);
    }

    @Override
    public float getFloat(int column) {
        return this.mCursor.getFloat(column);
    }

    @Override
    public double getDouble(int column) {
        return this.mCursor.getDouble(column);
    }

    @Override
    public int getType(int column) {
        return this.mCursor.getType(column);
    }

    @Override
    public boolean isNull(int column) {
        return this.mCursor.isNull(column);
    }

    @Override
    public byte[] getBlob(int column) {
        return this.mCursor.getBlob(column);
    }

    @Override
    public String[] getColumnNames() {
        if (this.mCursor != null) {
            return this.mCursor.getColumnNames();
        }
        int length = this.mCursors.length;
        for (int i = 0; i < length; ++i) {
            if (this.mCursors[i] == null) continue;
            return this.mCursors[i].getColumnNames();
        }
        throw new IllegalStateException("No cursor that can return names");
    }

    @Override
    public void deactivate() {
        int length = this.mCursors.length;
        for (int i = 0; i < length; ++i) {
            if (this.mCursors[i] == null) continue;
            this.mCursors[i].deactivate();
        }
    }

    @Override
    public void close() {
        int length = this.mCursors.length;
        for (int i = 0; i < length; ++i) {
            if (this.mCursors[i] == null) continue;
            this.mCursors[i].close();
        }
    }

    @Override
    public void registerDataSetObserver(DataSetObserver observer) {
        int length = this.mCursors.length;
        for (int i = 0; i < length; ++i) {
            if (this.mCursors[i] == null) continue;
            this.mCursors[i].registerDataSetObserver(observer);
        }
    }

    @Override
    public void unregisterDataSetObserver(DataSetObserver observer) {
        int length = this.mCursors.length;
        for (int i = 0; i < length; ++i) {
            if (this.mCursors[i] == null) continue;
            this.mCursors[i].unregisterDataSetObserver(observer);
        }
    }

    @Override
    public boolean requery() {
        int length = this.mCursors.length;
        for (int i = 0; i < length; ++i) {
            if (this.mCursors[i] == null || this.mCursors[i].requery()) continue;
            return false;
        }
        return true;
    }
}

