/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.content.om;

import android.annotation.NonNull;
import android.content.Context;
import android.content.om.OverlayIdentifier;
import android.content.om.OverlayInfo;
import android.content.om.OverlayManagerTransaction;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.parsing.FrameworkParsingPackageUtils;
import android.content.res.AssetManager;
import android.os.FabricatedOverlayInfo;
import android.os.FabricatedOverlayInternal;
import android.os.FabricatedOverlayInternalEntry;
import android.os.FileUtils;
import android.os.Process;
import android.os.UserHandle;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.hidden_from_bootclasspath.android.content.res.Flags;
import com.android.internal.util.Preconditions;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class OverlayManagerImpl {
    private static final String TAG = "OverlayManagerImpl";
    private static final boolean DEBUG = false;
    private static final String FRRO_EXTENSION = ".frro";
    private static final String IDMAP_EXTENSION = ".idmap";
    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    public static final String SELF_TARGET = ".self_target";
    @NonNull
    private final Context mContext;
    private Path mBasePath;

    public OverlayManagerImpl(@NonNull Context context) {
        this.mContext = Objects.requireNonNull(context);
        if (!Process.myUserHandle().equals(context.getUser())) {
            throw new SecurityException("Self-Targeting doesn't support multiple user now!");
        }
    }

    private static void cleanExpiredOverlays(Path selfTargetingBasePath, Path folderForCurrentBaseApk) {
        try {
            final String currentBaseFolder = folderForCurrentBaseApk.toString();
            final String selfTargetingDir = selfTargetingBasePath.getFileName().toString();
            Files.walkFileTree(selfTargetingBasePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    String fileName = dir.getFileName().toString();
                    return fileName.equals(currentBaseFolder) ? FileVisitResult.SKIP_SUBTREE : super.preVisitDirectory(dir, attrs);
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (!file.toFile().delete()) {
                        Log.w(OverlayManagerImpl.TAG, "Failed to delete file " + file);
                    }
                    return super.visitFile(file, attrs);
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    String fileName = dir.getFileName().toString();
                    if (!(fileName.equals(currentBaseFolder) || fileName.equals(selfTargetingDir) || dir.toFile().delete())) {
                        Log.w(OverlayManagerImpl.TAG, "Failed to delete dir " + dir);
                    }
                    return super.postVisitDirectory(dir, exc);
                }
            });
        }
        catch (IOException e) {
            Log.w(TAG, "Unknown fail " + e);
        }
    }

    @VisibleForTesting
    public void ensureBaseDir() {
        String baseApkPath = this.mContext.getApplicationInfo().getBaseCodePath();
        Path baseApkFolderName = Path.of(baseApkPath, new String[0]).getParent().getFileName();
        File selfTargetingBaseFile = this.mContext.getDir(SELF_TARGET, 0);
        Preconditions.checkArgument(selfTargetingBaseFile.isDirectory() && selfTargetingBaseFile.exists() && selfTargetingBaseFile.canWrite() && selfTargetingBaseFile.canRead() && selfTargetingBaseFile.canExecute(), "Can't work for this context");
        OverlayManagerImpl.cleanExpiredOverlays(selfTargetingBaseFile.toPath(), baseApkFolderName);
        File baseFile = new File(selfTargetingBaseFile, baseApkFolderName.toString());
        if (!baseFile.exists()) {
            if (!baseFile.mkdirs()) {
                Log.w(TAG, "Failed to create directory " + baseFile);
            }
            FileUtils.setPermissions(baseFile, 448, -1, -1);
        }
        Preconditions.checkArgument(baseFile.isDirectory() && baseFile.exists() && baseFile.canWrite() && baseFile.canRead() && baseFile.canExecute(), "Can't create a workspace for this context");
        this.mBasePath = baseFile.toPath();
    }

    private boolean isSameWithTargetSignature(String targetPackage) {
        PackageManager packageManager = this.mContext.getPackageManager();
        String packageName = this.mContext.getPackageName();
        if (TextUtils.equals(packageName, targetPackage)) {
            return true;
        }
        return packageManager.checkSignatures(packageName, targetPackage) == 0;
    }

    public static String checkOverlayNameValid(@NonNull String name) {
        String overlayName = Preconditions.checkStringNotEmpty(name, "overlayName should be neither empty nor null string");
        String checkOverlayNameResult = FrameworkParsingPackageUtils.validateName(overlayName, false, true);
        Preconditions.checkArgument(checkOverlayNameResult == null, TextUtils.formatSimple("Invalid overlayName \"%s\". The check result is %s.", overlayName, checkOverlayNameResult));
        return overlayName;
    }

    private void checkPackageName(@NonNull String packageName) {
        Preconditions.checkStringNotEmpty(packageName);
        Preconditions.checkArgument(TextUtils.equals(this.mContext.getPackageName(), packageName), TextUtils.formatSimple("UID %d doesn't own the package %s", Process.myUid(), packageName));
    }

    public void registerFabricatedOverlay(@NonNull FabricatedOverlayInternal overlayInternal) throws IOException, PackageManager.NameNotFoundException {
        this.ensureBaseDir();
        Objects.requireNonNull(overlayInternal);
        List<FabricatedOverlayInternalEntry> entryList = Objects.requireNonNull(overlayInternal.entries);
        Preconditions.checkArgument(!entryList.isEmpty(), "overlay entries shouldn't be empty");
        String overlayName = OverlayManagerImpl.checkOverlayNameValid(overlayInternal.overlayName);
        this.checkPackageName(overlayInternal.packageName);
        if (Flags.selfTargetingAndroidResourceFrro()) {
            Preconditions.checkStringNotEmpty(overlayInternal.targetPackageName);
        } else {
            this.checkPackageName(overlayInternal.targetPackageName);
            Preconditions.checkStringNotEmpty(overlayInternal.targetOverlayable, "Target overlayable should be neither null nor empty string.");
        }
        ApplicationInfo applicationInfo = this.mContext.getApplicationInfo();
        String targetPackage = null;
        targetPackage = Flags.selfTargetingAndroidResourceFrro() && TextUtils.equals(overlayInternal.targetPackageName, "android") ? AssetManager.FRAMEWORK_APK_PATH : Preconditions.checkStringNotEmpty(applicationInfo.getBaseCodePath());
        Path frroPath = this.mBasePath.resolve(overlayName + FRRO_EXTENSION);
        Path idmapPath = this.mBasePath.resolve(overlayName + IDMAP_EXTENSION);
        OverlayManagerImpl.createFrroFile(frroPath.toString(), overlayInternal);
        try {
            OverlayManagerImpl.createIdmapFile(targetPackage, frroPath.toString(), idmapPath.toString(), overlayName, applicationInfo.isSystemApp() || applicationInfo.isSystemExt(), applicationInfo.isVendor(), applicationInfo.isProduct(), this.isSameWithTargetSignature(overlayInternal.targetPackageName), applicationInfo.isOdm(), applicationInfo.isOem());
        }
        catch (IOException e) {
            if (!frroPath.toFile().delete()) {
                Log.w(TAG, "Failed to delete file " + frroPath);
            }
            throw e;
        }
    }

    public void unregisterFabricatedOverlay(@NonNull String overlayName) {
        this.ensureBaseDir();
        OverlayManagerImpl.checkOverlayNameValid(overlayName);
        Path frroPath = this.mBasePath.resolve(overlayName + FRRO_EXTENSION);
        Path idmapPath = this.mBasePath.resolve(overlayName + IDMAP_EXTENSION);
        if (!frroPath.toFile().delete()) {
            Log.w(TAG, "Failed to delete file " + frroPath);
        }
        if (!idmapPath.toFile().delete()) {
            Log.w(TAG, "Failed to delete file " + idmapPath);
        }
    }

    public void commit(@NonNull OverlayManagerTransaction transaction) throws PackageManager.NameNotFoundException, IOException {
        Objects.requireNonNull(transaction);
        Iterator<OverlayManagerTransaction.Request> it = transaction.getRequests();
        while (it.hasNext()) {
            OverlayManagerTransaction.Request request = it.next();
            if (request.type == 2) {
                FabricatedOverlayInternal fabricatedOverlayInternal = Objects.requireNonNull(request.extras.getParcelable("fabricated_overlay", FabricatedOverlayInternal.class));
                if (TextUtils.isEmpty(fabricatedOverlayInternal.packageName)) {
                    fabricatedOverlayInternal.packageName = this.mContext.getPackageName();
                } else if (!TextUtils.equals(fabricatedOverlayInternal.packageName, this.mContext.getPackageName())) {
                    throw new IllegalArgumentException("Unknown package name in transaction");
                }
                this.registerFabricatedOverlay(fabricatedOverlayInternal);
                continue;
            }
            if (request.type == 3) {
                OverlayIdentifier overlayIdentifier = Objects.requireNonNull(request.overlay);
                this.unregisterFabricatedOverlay(overlayIdentifier.getOverlayName());
                continue;
            }
            throw new IllegalArgumentException("Unknown request in transaction " + request);
        }
    }

    @NonNull
    public List<OverlayInfo> getOverlayInfosForTarget(@NonNull String targetPackage) {
        this.ensureBaseDir();
        File base = this.mBasePath.toFile();
        File[] frroFiles = base.listFiles((dir, name) -> {
            if (!name.endsWith(FRRO_EXTENSION)) {
                return false;
            }
            String idmapFileName = name.substring(0, name.length() - FRRO_EXTENSION.length()) + IDMAP_EXTENSION;
            File idmapFile = new File(dir, idmapFileName);
            return idmapFile.exists();
        });
        ArrayList<OverlayInfo> overlayInfos = new ArrayList<OverlayInfo>();
        for (File file : frroFiles) {
            FabricatedOverlayInfo fabricatedOverlayInfo;
            try {
                fabricatedOverlayInfo = OverlayManagerImpl.getFabricatedOverlayInfo(file.getAbsolutePath());
            }
            catch (IOException e) {
                Log.w(TAG, "can't load " + file);
                continue;
            }
            if (!TextUtils.equals(targetPackage, fabricatedOverlayInfo.targetPackageName)) continue;
            OverlayInfo overlayInfo = new OverlayInfo(fabricatedOverlayInfo.packageName, fabricatedOverlayInfo.overlayName, fabricatedOverlayInfo.targetPackageName, fabricatedOverlayInfo.targetOverlayable, null, file.getAbsolutePath(), 3, UserHandle.myUserId(), Integer.MAX_VALUE, true, true);
            overlayInfos.add(overlayInfo);
        }
        return overlayInfos;
    }

    private static void createFrroFile(@NonNull String string2, @NonNull FabricatedOverlayInternal fabricatedOverlayInternal) throws IOException {
        OverrideMethod.invokeV("com.android.internal.content.om.OverlayManagerImpl#createFrroFile(Ljava/lang/String;Landroid/os/FabricatedOverlayInternal;)V", true, null);
    }

    private static void createIdmapFile(@NonNull String string2, @NonNull String string3, @NonNull String string4, @NonNull String string5, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) throws IOException {
        OverrideMethod.invokeV("com.android.internal.content.om.OverlayManagerImpl#createIdmapFile(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZZZZZZ)V", true, null);
    }

    private static FabricatedOverlayInfo getFabricatedOverlayInfo(@NonNull String string2) throws IOException {
        return (FabricatedOverlayInfo)OverrideMethod.invokeA("com.android.internal.content.om.OverlayManagerImpl#getFabricatedOverlayInfo(Ljava/lang/String;)Landroid/os/FabricatedOverlayInfo;", true, null);
    }
}

