/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app.chooser;

import android.annotation.Nullable;
import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.LauncherApps;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ShortcutInfo;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.Icon;
import android.os.Bundle;
import android.os.UserHandle;
import android.service.chooser.ChooserTarget;
import android.text.SpannableStringBuilder;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.app.ResolverActivity;
import com.android.internal.app.ResolverListAdapter;
import com.android.internal.app.SimpleIconFactory;
import com.android.internal.app.chooser.ChooserTargetInfo;
import com.android.internal.app.chooser.DisplayResolveInfo;
import com.android.internal.app.chooser.TargetInfo;
import java.util.ArrayList;
import java.util.List;

public class SelectableTargetInfo
implements ChooserTargetInfo {
    private static final String TAG = "SelectableTargetInfo";
    private final Context mContext;
    private final DisplayResolveInfo mSourceInfo;
    private final ResolveInfo mBackupResolveInfo;
    private final ChooserTarget mChooserTarget;
    private final String mDisplayLabel;
    private final PackageManager mPm;
    private final SelectableTargetInfoCommunicator mSelectableTargetInfoCommunicator;
    @GuardedBy(value={"this"})
    private ShortcutInfo mShortcutInfo;
    private Drawable mBadgeIcon = null;
    private CharSequence mBadgeContentDescription;
    @GuardedBy(value={"this"})
    private Drawable mDisplayIcon;
    private final Intent mFillInIntent;
    private final int mFillInFlags;
    private final boolean mIsPinned;
    private final float mModifiedScore;
    private boolean mIsSuspended = false;

    public SelectableTargetInfo(Context context, DisplayResolveInfo sourceInfo, ChooserTarget chooserTarget, float modifiedScore, SelectableTargetInfoCommunicator selectableTargetInfoComunicator, @Nullable ShortcutInfo shortcutInfo) {
        ActivityInfo ai;
        ResolveInfo ri;
        this.mContext = context;
        this.mSourceInfo = sourceInfo;
        this.mChooserTarget = chooserTarget;
        this.mModifiedScore = modifiedScore;
        this.mPm = this.mContext.getPackageManager();
        this.mSelectableTargetInfoCommunicator = selectableTargetInfoComunicator;
        this.mShortcutInfo = shortcutInfo;
        boolean bl = this.mIsPinned = shortcutInfo != null && shortcutInfo.isPinned();
        if (sourceInfo != null && (ri = sourceInfo.getResolveInfo()) != null && (ai = ri.activityInfo) != null && ai.applicationInfo != null) {
            PackageManager pm = this.mContext.getPackageManager();
            this.mBadgeIcon = pm.getApplicationIcon(ai.applicationInfo);
            this.mBadgeContentDescription = pm.getApplicationLabel(ai.applicationInfo);
            this.mIsSuspended = (ai.applicationInfo.flags & 0x40000000) != 0;
        }
        this.mBackupResolveInfo = sourceInfo != null ? null : this.mContext.getPackageManager().resolveActivity(this.getResolvedIntent(), 0);
        this.mFillInIntent = null;
        this.mFillInFlags = 0;
        this.mDisplayLabel = this.sanitizeDisplayLabel(chooserTarget.getTitle());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SelectableTargetInfo(SelectableTargetInfo other, Intent fillInIntent, int flags) {
        this.mContext = other.mContext;
        this.mPm = other.mPm;
        this.mSelectableTargetInfoCommunicator = other.mSelectableTargetInfoCommunicator;
        this.mSourceInfo = other.mSourceInfo;
        this.mBackupResolveInfo = other.mBackupResolveInfo;
        this.mChooserTarget = other.mChooserTarget;
        this.mBadgeIcon = other.mBadgeIcon;
        this.mBadgeContentDescription = other.mBadgeContentDescription;
        SelectableTargetInfo selectableTargetInfo = other;
        synchronized (selectableTargetInfo) {
            this.mShortcutInfo = other.mShortcutInfo;
            this.mDisplayIcon = other.mDisplayIcon;
        }
        this.mFillInIntent = fillInIntent;
        this.mFillInFlags = flags;
        this.mModifiedScore = other.mModifiedScore;
        this.mIsPinned = other.mIsPinned;
        this.mDisplayLabel = this.sanitizeDisplayLabel(this.mChooserTarget.getTitle());
    }

    private String sanitizeDisplayLabel(CharSequence label) {
        SpannableStringBuilder sb = new SpannableStringBuilder(label);
        sb.clearSpans();
        return sb.toString();
    }

    @Override
    public boolean isSuspended() {
        return this.mIsSuspended;
    }

    public DisplayResolveInfo getDisplayResolveInfo() {
        return this.mSourceInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadIcon() {
        boolean shouldLoadIcon;
        Drawable icon;
        ShortcutInfo shortcutInfo;
        SelectableTargetInfo selectableTargetInfo = this;
        synchronized (selectableTargetInfo) {
            shortcutInfo = this.mShortcutInfo;
            icon = this.mDisplayIcon;
        }
        boolean bl = shouldLoadIcon = icon == null && shortcutInfo != null;
        if (shouldLoadIcon) {
            icon = this.getChooserTargetIconDrawable(this.mChooserTarget, shortcutInfo);
            SelectableTargetInfo selectableTargetInfo2 = this;
            synchronized (selectableTargetInfo2) {
                this.mDisplayIcon = icon;
                this.mShortcutInfo = null;
            }
        }
        return shouldLoadIcon;
    }

    private Drawable getChooserTargetIconDrawable(ChooserTarget target, @Nullable ShortcutInfo shortcutInfo) {
        Drawable directShareIcon = null;
        Icon icon = target.getIcon();
        if (icon != null) {
            directShareIcon = icon.loadDrawable(this.mContext);
        } else if (shortcutInfo != null) {
            LauncherApps launcherApps = (LauncherApps)this.mContext.getSystemService("launcherapps");
            directShareIcon = launcherApps.getShortcutIconDrawable(shortcutInfo, 0);
        }
        if (directShareIcon == null) {
            return null;
        }
        ActivityInfo info = null;
        try {
            info = this.mPm.getActivityInfo(target.getComponentName(), 0);
        }
        catch (PackageManager.NameNotFoundException error) {
            Log.e(TAG, "Could not find activity associated with ChooserTarget");
        }
        if (info == null) {
            return null;
        }
        Bitmap appIcon = this.mSelectableTargetInfoCommunicator.makePresentationGetter(info).getIconBitmap(null);
        SimpleIconFactory sif = SimpleIconFactory.obtain(this.mContext);
        Bitmap directShareBadgedIcon = sif.createAppBadgedIconBitmap(directShareIcon, appIcon);
        sif.recycle();
        return new BitmapDrawable(this.mContext.getResources(), directShareBadgedIcon);
    }

    @Override
    public float getModifiedScore() {
        return this.mModifiedScore;
    }

    @Override
    public Intent getResolvedIntent() {
        if (this.mSourceInfo != null) {
            return this.mSourceInfo.getResolvedIntent();
        }
        Intent targetIntent = new Intent(this.mSelectableTargetInfoCommunicator.getTargetIntent());
        targetIntent.setComponent(this.mChooserTarget.getComponentName());
        targetIntent.putExtras(this.mChooserTarget.getIntentExtras());
        return targetIntent;
    }

    @Override
    public ComponentName getResolvedComponentName() {
        if (this.mSourceInfo != null) {
            return this.mSourceInfo.getResolvedComponentName();
        }
        if (this.mBackupResolveInfo != null) {
            return new ComponentName(this.mBackupResolveInfo.activityInfo.packageName, this.mBackupResolveInfo.activityInfo.name);
        }
        return null;
    }

    private Intent getBaseIntentToSend() {
        Intent result = this.getResolvedIntent();
        if (result == null) {
            Log.e(TAG, "ChooserTargetInfo: no base intent available to send");
        } else {
            result = new Intent(result);
            if (this.mFillInIntent != null) {
                result.fillIn(this.mFillInIntent, this.mFillInFlags);
            }
            result.fillIn(this.mSelectableTargetInfoCommunicator.getReferrerFillInIntent(), 0);
        }
        return result;
    }

    @Override
    public boolean start(Activity activity, Bundle options) {
        throw new RuntimeException("ChooserTargets should be started as caller.");
    }

    @Override
    public boolean startAsCaller(ResolverActivity activity, Bundle options, int userId) {
        Intent intent = this.getBaseIntentToSend();
        if (intent == null) {
            return false;
        }
        intent.setComponent(this.mChooserTarget.getComponentName());
        intent.putExtras(this.mChooserTarget.getIntentExtras());
        TargetInfo.prepareIntentForCrossProfileLaunch(intent, userId);
        TargetInfo.refreshIntentCreatorToken(intent);
        boolean ignoreTargetSecurity = this.mSourceInfo != null && this.mSourceInfo.getResolvedComponentName().getPackageName().equals(this.mChooserTarget.getComponentName().getPackageName());
        activity.startActivityAsCaller(intent, options, ignoreTargetSecurity, userId);
        return true;
    }

    @Override
    public boolean startAsUser(Activity activity, Bundle options, UserHandle user) {
        throw new RuntimeException("ChooserTargets should be started as caller.");
    }

    @Override
    public ResolveInfo getResolveInfo() {
        return this.mSourceInfo != null ? this.mSourceInfo.getResolveInfo() : this.mBackupResolveInfo;
    }

    @Override
    public CharSequence getDisplayLabel() {
        return this.mDisplayLabel;
    }

    @Override
    public CharSequence getExtendedInfo() {
        return null;
    }

    @Override
    public synchronized Drawable getDisplayIcon(Context context) {
        return this.mDisplayIcon;
    }

    public synchronized boolean hasDisplayIcon() {
        return this.mDisplayIcon != null;
    }

    @Override
    public ChooserTarget getChooserTarget() {
        return this.mChooserTarget;
    }

    @Override
    public TargetInfo cloneFilledIn(Intent fillInIntent, int flags) {
        return new SelectableTargetInfo(this, fillInIntent, flags);
    }

    @Override
    public List<Intent> getAllSourceIntents() {
        ArrayList<Intent> results = new ArrayList<Intent>();
        if (this.mSourceInfo != null) {
            results.add(this.mSourceInfo.getAllSourceIntents().get(0));
        }
        return results;
    }

    @Override
    public boolean isPinned() {
        return this.mIsPinned;
    }

    public static interface SelectableTargetInfoCommunicator {
        public ResolverListAdapter.ActivityInfoPresentationGetter makePresentationGetter(ActivityInfo var1);

        public Intent getTargetIntent();

        public Intent getReferrerFillInIntent();
    }
}

