/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.admin.DevicePolicyEventLogger;
import android.app.admin.DevicePolicyManager;
import android.content.Context;
import android.content.pm.ResolveInfo;
import android.os.UserHandle;
import com.android.internal.app.AbstractMultiProfilePagerAdapter;
import com.android.internal.app.ResolverActivity;
import com.android.internal.app.ResolverListAdapter;
import java.util.List;

public class NoAppsAvailableEmptyStateProvider
implements AbstractMultiProfilePagerAdapter.EmptyStateProvider {
    @NonNull
    private final Context mContext;
    @Nullable
    private final UserHandle mWorkProfileUserHandle;
    @Nullable
    private final UserHandle mPersonalProfileUserHandle;
    @NonNull
    private final String mMetricsCategory;
    @NonNull
    private final UserHandle mTabOwnerUserHandleForLaunch;

    public NoAppsAvailableEmptyStateProvider(Context context, UserHandle workProfileUserHandle, UserHandle personalProfileUserHandle, String metricsCategory, UserHandle tabOwnerUserHandleForLaunch) {
        this.mContext = context;
        this.mWorkProfileUserHandle = workProfileUserHandle;
        this.mPersonalProfileUserHandle = personalProfileUserHandle;
        this.mMetricsCategory = metricsCategory;
        this.mTabOwnerUserHandleForLaunch = tabOwnerUserHandleForLaunch;
    }

    @Override
    @Nullable
    public AbstractMultiProfilePagerAdapter.EmptyState getEmptyState(ResolverListAdapter resolverListAdapter) {
        UserHandle listUserHandle = resolverListAdapter.getUserHandle();
        if (this.mWorkProfileUserHandle != null && (this.mTabOwnerUserHandleForLaunch.equals(listUserHandle) || !this.hasAppsInOtherProfile(resolverListAdapter))) {
            String title = listUserHandle == this.mPersonalProfileUserHandle ? this.mContext.getSystemService(DevicePolicyManager.class).getResources().getString("Core.RESOLVER_NO_PERSONAL_APPS", () -> this.mContext.getString(17041704)) : this.mContext.getSystemService(DevicePolicyManager.class).getResources().getString("Core.RESOLVER_NO_WORK_APPS", () -> this.mContext.getString(17041705));
            return new NoAppsAvailableEmptyState(title, this.mMetricsCategory, listUserHandle == this.mPersonalProfileUserHandle);
        }
        if (this.mWorkProfileUserHandle == null) {
            return new DefaultEmptyState();
        }
        return null;
    }

    private boolean hasAppsInOtherProfile(ResolverListAdapter adapter) {
        if (this.mWorkProfileUserHandle == null) {
            return false;
        }
        List<ResolverActivity.ResolvedComponentInfo> resolversForIntent = adapter.getResolversForUser(this.mTabOwnerUserHandleForLaunch);
        for (ResolverActivity.ResolvedComponentInfo info : resolversForIntent) {
            ResolveInfo resolveInfo = info.getResolveInfoAt(0);
            if (resolveInfo.targetUserId == -2) continue;
            return true;
        }
        return false;
    }

    public static class NoAppsAvailableEmptyState
    implements AbstractMultiProfilePagerAdapter.EmptyState {
        @NonNull
        private String mTitle;
        @NonNull
        private String mMetricsCategory;
        private boolean mIsPersonalProfile;

        public NoAppsAvailableEmptyState(String title, String metricsCategory, boolean isPersonalProfile) {
            this.mTitle = title;
            this.mMetricsCategory = metricsCategory;
            this.mIsPersonalProfile = isPersonalProfile;
        }

        @Override
        @Nullable
        public String getTitle() {
            return this.mTitle;
        }

        @Override
        public void onEmptyStateShown() {
            DevicePolicyEventLogger.createEvent(160).setStrings(this.mMetricsCategory).setBoolean(this.mIsPersonalProfile).write();
        }
    }

    public static class DefaultEmptyState
    implements AbstractMultiProfilePagerAdapter.EmptyState {
        @Override
        public boolean useDefaultEmptyView() {
            return true;
        }
    }
}

