/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.app.Activity;
import android.app.Dialog;
import android.app.DialogFragment;
import android.app.FragmentManager;
import android.content.Context;
import android.media.MediaRouter;
import android.util.Log;
import android.view.View;
import com.android.internal.app.MediaRouteChooserDialog;
import com.android.internal.app.MediaRouteChooserDialogFragment;
import com.android.internal.app.MediaRouteControllerDialog;
import com.android.internal.app.MediaRouteControllerDialogFragment;

public abstract class MediaRouteDialogPresenter {
    private static final String TAG = "MediaRouter";
    private static final String CHOOSER_FRAGMENT_TAG = "android.app.MediaRouteButton:MediaRouteChooserDialogFragment";
    private static final String CONTROLLER_FRAGMENT_TAG = "android.app.MediaRouteButton:MediaRouteControllerDialogFragment";

    public static DialogFragment showDialogFragment(Activity activity, int routeTypes, View.OnClickListener extendedSettingsClickListener) {
        MediaRouter router = (MediaRouter)activity.getSystemService("media_router");
        FragmentManager fm = activity.getFragmentManager();
        MediaRouter.RouteInfo route = router.getSelectedRoute();
        if (route.isDefault() || !route.matchesTypes(routeTypes)) {
            if (fm.findFragmentByTag(CHOOSER_FRAGMENT_TAG) != null) {
                Log.w(TAG, "showDialog(): Route chooser dialog already showing!");
                return null;
            }
            MediaRouteChooserDialogFragment f = new MediaRouteChooserDialogFragment();
            f.setRouteTypes(routeTypes);
            f.setExtendedSettingsClickListener(extendedSettingsClickListener);
            f.show(fm, CHOOSER_FRAGMENT_TAG);
            return f;
        }
        if (fm.findFragmentByTag(CONTROLLER_FRAGMENT_TAG) != null) {
            Log.w(TAG, "showDialog(): Route controller dialog already showing!");
            return null;
        }
        MediaRouteControllerDialogFragment f = new MediaRouteControllerDialogFragment();
        f.show(fm, CONTROLLER_FRAGMENT_TAG);
        return f;
    }

    public static Dialog createDialog(Context context, int routeTypes, View.OnClickListener extendedSettingsClickListener) {
        int theme = MediaRouteChooserDialog.isLightTheme(context) ? 16974130 : 16974126;
        return MediaRouteDialogPresenter.createDialog(context, routeTypes, extendedSettingsClickListener, theme);
    }

    public static Dialog createDialog(Context context, int routeTypes, View.OnClickListener extendedSettingsClickListener, int theme) {
        return MediaRouteDialogPresenter.createDialog(context, routeTypes, extendedSettingsClickListener, theme, true);
    }

    public static Dialog createDialog(Context context, int routeTypes, View.OnClickListener extendedSettingsClickListener, int theme, boolean showProgressBarWhenEmpty) {
        if (MediaRouteDialogPresenter.shouldShowChooserDialog(context, routeTypes)) {
            MediaRouteChooserDialog d = new MediaRouteChooserDialog(context, theme, showProgressBarWhenEmpty);
            d.setRouteTypes(routeTypes);
            d.setExtendedSettingsClickListener(extendedSettingsClickListener);
            return d;
        }
        return new MediaRouteControllerDialog(context, theme);
    }

    public static boolean shouldShowChooserDialog(Context context, int routeTypes) {
        MediaRouter router = context.getSystemService(MediaRouter.class);
        MediaRouter.RouteInfo route = router.getSelectedRoute();
        return route.isDefault() || !route.matchesTypes(routeTypes);
    }
}

