/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.app.AlertDialog;
import android.content.Context;
import android.os.Bundle;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import com.android.internal.app.MediaRouteChooserContentManager;

public class MediaRouteChooserDialog
extends AlertDialog
implements MediaRouteChooserContentManager.Delegate {
    private View.OnClickListener mExtendedSettingsClickListener;
    private Button mExtendedSettingsButton;
    private final boolean mShowProgressBarWhenEmpty;
    private final MediaRouteChooserContentManager mContentManager;

    public MediaRouteChooserDialog(Context context, int theme) {
        this(context, theme, true);
    }

    public MediaRouteChooserDialog(Context context, int theme, boolean showProgressBarWhenEmpty) {
        super(context, theme);
        this.mShowProgressBarWhenEmpty = showProgressBarWhenEmpty;
        this.mContentManager = new MediaRouteChooserContentManager(context, this);
    }

    public void setRouteTypes(int types) {
        this.mContentManager.setRouteTypes(types);
    }

    public void setExtendedSettingsClickListener(View.OnClickListener listener) {
        if (listener != this.mExtendedSettingsClickListener) {
            this.mExtendedSettingsClickListener = listener;
            this.updateExtendedSettingsButton();
        }
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        View containerView = LayoutInflater.from(this.getContext()).inflate(17367216, null);
        this.setView(containerView);
        this.setTitle(this.mContentManager.getRouteTypes() == 4 ? 17040870 : 17040869);
        this.setIcon(MediaRouteChooserDialog.isLightTheme(this.getContext()) ? 17302841 : 17302840);
        super.onCreate(savedInstanceState);
        this.mExtendedSettingsButton = (Button)this.findViewById(16909283);
        this.updateExtendedSettingsButton();
        this.mContentManager.bindViews(containerView);
    }

    private void updateExtendedSettingsButton() {
        if (this.mExtendedSettingsButton != null) {
            this.mExtendedSettingsButton.setOnClickListener(this.mExtendedSettingsClickListener);
            this.mExtendedSettingsButton.setVisibility(this.mExtendedSettingsClickListener != null ? 0 : 8);
        }
    }

    @Override
    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mContentManager.onAttachedToWindow();
    }

    @Override
    public void onDetachedFromWindow() {
        this.mContentManager.onDetachedFromWindow();
        super.onDetachedFromWindow();
    }

    @Override
    public void dismissView() {
        this.dismiss();
    }

    @Override
    public boolean showProgressBarWhenEmpty() {
        return this.mShowProgressBarWhenEmpty;
    }

    static boolean isLightTheme(Context context) {
        TypedValue value = new TypedValue();
        return context.getTheme().resolveAttribute(16844176, value, true) && value.data != 0;
    }
}

