/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.hardware.soundtrigger.SoundTrigger;
import android.media.permission.Identity;
import android.media.soundtrigger_middleware.ISoundTriggerInjection;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.android.internal.app.ISoundTriggerSession;
import java.util.ArrayList;
import java.util.List;

public interface ISoundTriggerService
extends IInterface {
    public ISoundTriggerSession attachAsOriginator(Identity var1, SoundTrigger.ModuleProperties var2, IBinder var3) throws RemoteException;

    public ISoundTriggerSession attachAsMiddleman(Identity var1, Identity var2, SoundTrigger.ModuleProperties var3, IBinder var4) throws RemoteException;

    public List<SoundTrigger.ModuleProperties> listModuleProperties(Identity var1) throws RemoteException;

    public void attachInjection(ISoundTriggerInjection var1) throws RemoteException;

    public void setInPhoneCallState(boolean var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ISoundTriggerService {
        public static final String DESCRIPTOR = "com.android.internal.app.ISoundTriggerService";
        static final int TRANSACTION_attachAsOriginator = 1;
        static final int TRANSACTION_attachAsMiddleman = 2;
        static final int TRANSACTION_listModuleProperties = 3;
        static final int TRANSACTION_attachInjection = 4;
        static final int TRANSACTION_setInPhoneCallState = 5;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ISoundTriggerService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof ISoundTriggerService) {
                return (ISoundTriggerService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "attachAsOriginator";
                }
                case 2: {
                    return "attachAsMiddleman";
                }
                case 3: {
                    return "listModuleProperties";
                }
                case 4: {
                    return "attachInjection";
                }
                case 5: {
                    return "setInPhoneCallState";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    Identity _arg0 = data.readTypedObject(Identity.CREATOR);
                    SoundTrigger.ModuleProperties _arg1 = data.readTypedObject(SoundTrigger.ModuleProperties.CREATOR);
                    IBinder _arg2 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    ISoundTriggerSession _result = this.attachAsOriginator(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 2: {
                    Identity _arg0 = data.readTypedObject(Identity.CREATOR);
                    Identity _arg1 = data.readTypedObject(Identity.CREATOR);
                    SoundTrigger.ModuleProperties _arg2 = data.readTypedObject(SoundTrigger.ModuleProperties.CREATOR);
                    IBinder _arg3 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    ISoundTriggerSession _result = this.attachAsMiddleman(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 3: {
                    Identity _arg0 = data.readTypedObject(Identity.CREATOR);
                    data.enforceNoDataAvail();
                    List<SoundTrigger.ModuleProperties> _result = this.listModuleProperties(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 4: {
                    ISoundTriggerInjection _arg0 = ISoundTriggerInjection.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.attachInjection(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setInPhoneCallState(_arg0);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 4;
        }

        private static class Proxy
        implements ISoundTriggerService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ISoundTriggerSession attachAsOriginator(Identity originatorIdentity, SoundTrigger.ModuleProperties moduleProperties, IBinder client) throws RemoteException {
                ISoundTriggerSession _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(originatorIdentity, 0);
                    _data.writeTypedObject(moduleProperties, 0);
                    _data.writeStrongBinder(client);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = ISoundTriggerSession.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ISoundTriggerSession attachAsMiddleman(Identity middlemanIdentity, Identity originatorIdentity, SoundTrigger.ModuleProperties moduleProperties, IBinder client) throws RemoteException {
                ISoundTriggerSession _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(middlemanIdentity, 0);
                    _data.writeTypedObject(originatorIdentity, 0);
                    _data.writeTypedObject(moduleProperties, 0);
                    _data.writeStrongBinder(client);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = ISoundTriggerSession.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<SoundTrigger.ModuleProperties> listModuleProperties(Identity originatorIdentity) throws RemoteException {
                ArrayList<SoundTrigger.ModuleProperties> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(originatorIdentity, 0);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(SoundTrigger.ModuleProperties.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void attachInjection(ISoundTriggerInjection injection) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(injection);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setInPhoneCallState(boolean isInPhoneCall) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(isInPhoneCall);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ISoundTriggerService {
        @Override
        public ISoundTriggerSession attachAsOriginator(Identity originatorIdentity, SoundTrigger.ModuleProperties moduleProperties, IBinder client) throws RemoteException {
            return null;
        }

        @Override
        public ISoundTriggerSession attachAsMiddleman(Identity middlemanIdentity, Identity originatorIdentity, SoundTrigger.ModuleProperties moduleProperties, IBinder client) throws RemoteException {
            return null;
        }

        @Override
        public List<SoundTrigger.ModuleProperties> listModuleProperties(Identity originatorIdentity) throws RemoteException {
            return null;
        }

        @Override
        public void attachInjection(ISoundTriggerInjection injection) throws RemoteException {
        }

        @Override
        public void setInPhoneCallState(boolean isInPhoneCall) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

