/*
 * Decompiled with CFR 0.152.
 */
package com.android.adservices;

import android.annotation.Nullable;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import com.android.adservices.LogUtil;
import java.util.List;
import java.util.stream.Collectors;

public class AdServicesCommon {
    public static final String ACTION_TOPICS_SERVICE = "android.adservices.TOPICS_SERVICE";
    public static final String ACTION_CUSTOM_AUDIENCE_SERVICE = "android.adservices.customaudience.CUSTOM_AUDIENCE_SERVICE";
    public static final String ACTION_AD_SELECTION_SERVICE = "android.adservices.adselection.AD_SELECTION_SERVICE";
    public static final String ACTION_PROTECTED_SIGNALS_SERVICE = "android.adservices.signals.PROTECTED_SIGNALS_SERVICE";
    public static final String ACTION_MEASUREMENT_SERVICE = "android.adservices.MEASUREMENT_SERVICE";
    public static final String ACTION_ADID_SERVICE = "android.adservices.ADID_SERVICE";
    public static final String ACTION_ADID_PROVIDER_SERVICE = "android.adservices.adid.AdIdProviderService";
    public static final String ACTION_APPSETID_SERVICE = "android.adservices.APPSETID_SERVICE";
    public static final String ACTION_APPSETID_PROVIDER_SERVICE = "android.adservices.appsetid.AppSetIdProviderService";
    public static final String ACTION_AD_SERVICES_COMMON_SERVICE = "android.adservices.AD_SERVICES_COMMON_SERVICE";
    public static final String ACTION_AD_SERVICES_COBALT_UPLOAD_SERVICE = "android.adservices.cobalt.AdServicesCobaltUploadService";
    public static final String ACTION_SHELL_COMMAND_SERVICE = "android.adservices.SHELL_COMMAND_SERVICE";
    public static final String ACTION_ON_DEVICE_PERSONALIZATION_SERVICE = "android.OnDevicePersonalizationService";
    public static final String ADSERVICES_APK_PACKAGE_NAME_SUFFIX = "android.adservices.api";
    public static final String ADEXTSERVICES_PACKAGE_NAME_SUFFIX = "android.ext.services";
    public static final String ADSERVICES_APEX_NAME_SUFFIX = "android.adservices";
    public static final String EXTSERVICES_APEX_NAME_SUFFIX = "android.extservices";
    public static final String SYSTEM_PROPERTY_FOR_DEBUGGING_PREFIX = "debug.adservices.";
    public static final String SYSTEM_PROPERTY_FOR_DEBUGGING_FEATURE_RAM_LOW = "debug.adservices.low_ram_device";
    public static final String BINDER_TIMEOUT_SYSTEM_PROPERTY_NAME = "binder_timeout";
    public static final String SYSTEM_PROPERTY_FOR_DEBUGGING_BINDER_TIMEOUT = "debug.adservices.binder_timeout";
    public static final String ADSERVICES_CLASS_PATH_PREFIX = "com.android.adservices.";

    private AdServicesCommon() {
    }

    public static ServiceInfo resolveAdServicesService(@Nullable List<ResolveInfo> intentResolveInfos, String intentAction) {
        int size = intentResolveInfos == null ? 0 : intentResolveInfos.size();
        AdServicesCommon.enforceSingleServiceForAdIdAndAppSetId(intentAction, size);
        switch (size) {
            case 0: {
                LogUtil.e("Failed to find resolveInfo for adServices service. Intent action: %s", intentAction);
                return null;
            }
            case 1: {
                return intentResolveInfos.get((int)0).serviceInfo;
            }
            case 2: {
                ServiceInfo serviceInfo = AdServicesCommon.getServiceInfoIfAdServices(intentResolveInfos.get(0));
                return serviceInfo == null ? AdServicesCommon.getServiceInfoIfAdServices(intentResolveInfos.get(1)) : serviceInfo;
            }
        }
        List intents = intentResolveInfos.stream().filter(s -> s != null && s.serviceInfo != null).map(s -> s.serviceInfo.packageName).collect(Collectors.toList());
        LogUtil.e("Found multiple services %s for %s", intents, intentAction);
        return null;
    }

    private static ServiceInfo getServiceInfoIfAdServices(@Nullable ResolveInfo resolveInfo) {
        if (resolveInfo == null) {
            return null;
        }
        ServiceInfo serviceInfo = resolveInfo.serviceInfo;
        if (serviceInfo == null || serviceInfo.packageName == null) {
            return null;
        }
        return serviceInfo.packageName.endsWith(ADSERVICES_APK_PACKAGE_NAME_SUFFIX) ? serviceInfo : null;
    }

    private static void enforceSingleServiceForAdIdAndAppSetId(String intentAction, int numberOfResolvedServices) {
        if ((ACTION_ADID_PROVIDER_SERVICE.equals(intentAction) || ACTION_APPSETID_PROVIDER_SERVICE.equals(intentAction)) && numberOfResolvedServices > 1) {
            throw new IllegalStateException("Found multiple services for " + intentAction);
        }
    }
}

