/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Bundle;
import android.os.IBinder;
import android.view.WindowManager;

public interface WindowProvider {
    public static final String KEY_IS_WINDOW_PROVIDER_SERVICE = "android.window.WindowProvider.isWindowProviderService";
    public static final String KEY_REPARENT_TO_DEFAULT_DISPLAY_WITH_DISPLAY_REMOVAL = "android.window.WindowProvider.reparentToDefaultDisplayWithDisplayRemoval";

    public int getWindowType();

    @Nullable
    public Bundle getWindowContextOptions();

    @NonNull
    public IBinder getWindowContextToken();

    default public int getWindowTypeOverride() {
        return -1;
    }

    default public boolean isValidWindowType(int type) {
        if (type == this.getWindowType()) {
            return true;
        }
        return WindowManager.LayoutParams.isSubWindowType(type);
    }
}

