/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.os.Handler;
import android.os.Looper;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.util.Log;
import android.util.TypedValue;
import android.view.IWindow;
import android.view.IWindowSession;
import android.view.ImeBackAnimationController;
import android.view.MotionEvent;
import android.view.ViewRootImpl;
import android.window.BackEvent;
import android.window.BackMotionEvent;
import android.window.BackProgressAnimator;
import android.window.BackTouchTracker;
import android.window.CompatOnBackInvokedCallback;
import android.window.IBackAnimationHandoffHandler;
import android.window.IOnBackInvokedCallback;
import android.window.ImeOnBackInvokedDispatcher;
import android.window.OnBackAnimationCallback;
import android.window.OnBackInvokedCallback;
import android.window.OnBackInvokedCallbackInfo;
import android.window.OnBackInvokedDispatcher;
import android.window.SystemOverrideOnBackInvokedCallback;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.hidden_from_bootclasspath.com.android.window.flags.Flags;
import com.android.layoutlib.androidx.annotation.VisibleForTesting;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;

public class WindowOnBackInvokedDispatcher
implements OnBackInvokedDispatcher {
    private IWindowSession mWindowSession;
    private IWindow mWindow;
    private ViewRootImpl mViewRoot;
    @VisibleForTesting
    public final BackTouchTracker mTouchTracker = new BackTouchTracker();
    @VisibleForTesting
    public final BackProgressAnimator mProgressAnimator = new BackProgressAnimator();
    @NonNull
    private final Handler mHandler;
    private static final String TAG = "WindowOnBackDispatcher";
    private static final boolean ENABLE_PREDICTIVE_BACK = SystemProperties.getInt("persist.wm.debug.predictive_back", 1) != 0;
    private static final boolean ALWAYS_ENFORCE_PREDICTIVE_BACK = SystemProperties.getInt("persist.wm.debug.predictive_back_always_enforce", 0) != 0;
    private static final boolean PREDICTIVE_BACK_FALLBACK_WINDOW_ATTRIBUTE = SystemProperties.getInt("persist.wm.debug.predictive_back_fallback_window_attribute", 0) != 0;
    @Nullable
    private ImeOnBackInvokedDispatcher mImeDispatcher;
    @Nullable
    private ImeBackAnimationController mImeBackAnimationController;
    @GuardedBy(value={"mLock"})
    private final HashMap<OnBackInvokedCallback, Integer> mAllCallbacks = new HashMap();
    @VisibleForTesting
    @GuardedBy(value={"mLock"})
    public final TreeMap<Integer, ArrayList<OnBackInvokedCallback>> mOnBackInvokedCallbacks = new TreeMap();
    @VisibleForTesting
    public OnBackInvokedCallback mSystemNavigationObserverCallback = null;
    private Checker mChecker;
    private final Object mLock = new Object();
    private float mBackSwipeLinearThreshold;
    private float mNonLinearProgressFactor;

    public WindowOnBackInvokedDispatcher(@NonNull Context context, Looper looper) {
        this.mChecker = new Checker(context);
        this.mHandler = new Handler(looper);
    }

    public void onMotionEvent(MotionEvent ev) {
        if (!this.isBackGestureInProgress() || ev == null || ev.getAction() != 2) {
            return;
        }
        this.mTouchTracker.update(ev.getX(), ev.getY());
        if (this.mTouchTracker.shouldUpdateStartLocation()) {
            this.mTouchTracker.updateStartLocation();
        }
        if (!this.mProgressAnimator.isBackAnimationInProgress()) {
            return;
        }
        BackMotionEvent backEvent = this.mTouchTracker.createProgressEvent();
        this.mProgressAnimator.onBackProgressed(backEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachToWindow(@NonNull IWindowSession windowSession, @NonNull IWindow window, @Nullable ViewRootImpl viewRoot, @Nullable ImeBackAnimationController imeBackAnimationController) {
        Object object = this.mLock;
        synchronized (object) {
            this.mWindowSession = windowSession;
            this.mWindow = window;
            this.mViewRoot = viewRoot;
            this.mImeBackAnimationController = imeBackAnimationController;
            if (!this.mAllCallbacks.isEmpty()) {
                this.setTopOnBackInvokedCallback(this.getTopCallback());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detachFromWindow() {
        Object object = this.mLock;
        synchronized (object) {
            this.clear();
            this.mWindow = null;
            this.mWindowSession = null;
            this.mViewRoot = null;
            this.mImeBackAnimationController = null;
        }
    }

    @Override
    public void registerOnBackInvokedCallback(int priority, @NonNull OnBackInvokedCallback callback) {
        if (this.mChecker.checkApplicationCallbackRegistration(priority, callback)) {
            this.registerOnBackInvokedCallbackUnchecked(callback, priority);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerSystemNavigationObserverCallback(@NonNull OnBackInvokedCallback callback) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mAllCallbacks.containsKey(callback)) {
                this.removeCallbackInternal(callback);
            }
            this.mSystemNavigationObserverCallback = callback;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOnBackInvokedCallbackUnchecked(@NonNull OnBackInvokedCallback callback, int priority) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mImeDispatcher != null) {
                this.mImeDispatcher.registerOnBackInvokedCallback(priority, callback);
                return;
            }
            if (Flags.predictiveBackPrioritySystemNavigationObserver() && Flags.predictiveBackSystemOverrideCallback() && priority == -2 && callback instanceof SystemOverrideOnBackInvokedCallback) {
                Log.e(TAG, "System override callbacks cannot be registered to NAVIGATION_OBSERVER");
                return;
            }
            if (Flags.predictiveBackPrioritySystemNavigationObserver() && priority == -2) {
                this.registerSystemNavigationObserverCallback(callback);
                return;
            }
            if (callback instanceof ImeOnBackInvokedDispatcher.ImeOnBackInvokedCallback && callback instanceof ImeOnBackInvokedDispatcher.DefaultImeOnBackAnimationCallback && this.mImeBackAnimationController != null) {
                callback = this.mImeBackAnimationController;
            }
            if (!this.mOnBackInvokedCallbacks.containsKey(priority)) {
                this.mOnBackInvokedCallbacks.put(priority, new ArrayList());
            }
            ArrayList<OnBackInvokedCallback> callbacks = this.mOnBackInvokedCallbacks.get(priority);
            if (this.mAllCallbacks.containsKey(callback)) {
                Integer prevPriority = this.mAllCallbacks.get(callback);
                this.mOnBackInvokedCallbacks.get(prevPriority).remove(callback);
            }
            if (this.mSystemNavigationObserverCallback == callback) {
                this.mSystemNavigationObserverCallback = null;
            }
            OnBackInvokedCallback previousTopCallback = this.getTopCallback();
            callbacks.add(callback);
            this.mAllCallbacks.put(callback, priority);
            if (previousTopCallback == null || previousTopCallback != callback && this.mAllCallbacks.get(previousTopCallback) <= priority) {
                this.setTopOnBackInvokedCallback(callback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterOnBackInvokedCallback(@NonNull OnBackInvokedCallback callback) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mImeDispatcher != null) {
                this.mImeDispatcher.unregisterOnBackInvokedCallback(callback);
                return;
            }
            if (this.mSystemNavigationObserverCallback == callback) {
                this.mSystemNavigationObserverCallback = null;
                return;
            }
            if (callback instanceof ImeOnBackInvokedDispatcher.DefaultImeOnBackAnimationCallback) {
                callback = this.mImeBackAnimationController;
            }
            if (!this.mAllCallbacks.containsKey(callback)) {
                return;
            }
            this.removeCallbackInternal(callback);
        }
    }

    private void removeCallbackInternal(@NonNull OnBackInvokedCallback callback) {
        OnBackInvokedCallback previousTopCallback = this.getTopCallback();
        Integer priority = this.mAllCallbacks.get(callback);
        ArrayList<OnBackInvokedCallback> callbacks = this.mOnBackInvokedCallbacks.get(priority);
        callbacks.remove(callback);
        if (callbacks.isEmpty()) {
            this.mOnBackInvokedCallbacks.remove(priority);
        }
        this.mAllCallbacks.remove(callback);
        if (previousTopCallback == callback) {
            this.mProgressAnimator.removeOnBackCancelledFinishCallback();
            this.mProgressAnimator.removeOnBackInvokedFinishCallback();
            this.sendCancelledIfInProgress(callback);
            this.mHandler.post(this.mProgressAnimator::reset);
            this.setTopOnBackInvokedCallback(this.getTopCallback());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBackGestureInProgress() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mTouchTracker.isActive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInterceptedMotionEvent() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mTouchTracker.isInterceptedMotionEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMotionEventIntercepted() {
        Object object = this.mLock;
        synchronized (object) {
            this.mTouchTracker.setMotionEventIntercepted();
        }
    }

    private void sendCancelledIfInProgress(@NonNull OnBackInvokedCallback callback) {
        boolean isInProgress = this.mProgressAnimator.isBackAnimationInProgress();
        if (isInProgress && callback instanceof OnBackAnimationCallback) {
            OnBackAnimationCallback animatedCallback = (OnBackAnimationCallback)callback;
            animatedCallback.onBackCancelled();
        }
    }

    @Override
    public void registerSystemOnBackInvokedCallback(@NonNull OnBackInvokedCallback callback) {
        this.registerOnBackInvokedCallbackUnchecked(callback, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mImeDispatcher != null) {
                this.mImeDispatcher.clear();
                this.mImeDispatcher = null;
            }
            if (!this.mAllCallbacks.isEmpty()) {
                OnBackInvokedCallback topCallback = this.getTopCallback();
                if (topCallback != null) {
                    this.sendCancelledIfInProgress(topCallback);
                } else {
                    Log.e(TAG, "There is no topCallback, even if mAllCallbacks is not empty");
                }
                this.setTopOnBackInvokedCallback(null);
            }
            this.mHandler.post(this.mProgressAnimator::reset);
            this.mAllCallbacks.clear();
            this.mOnBackInvokedCallbacks.clear();
            this.mSystemNavigationObserverCallback = null;
        }
    }

    private boolean callOnKeyPreIme() {
        if (this.mViewRoot != null && !this.isOnBackInvokedCallbackEnabled()) {
            return this.mViewRoot.injectBackKeyEvents(true);
        }
        return false;
    }

    public void tryInvokeSystemNavigationObserverCallback() {
        OnBackInvokedCallback topCallback = this.getTopCallback();
        Integer callbackPriority = this.mAllCallbacks.getOrDefault(topCallback, null);
        boolean isSystemOverride = topCallback instanceof SystemOverrideOnBackInvokedCallback;
        if (callbackPriority != null && callbackPriority == -1 || isSystemOverride) {
            this.invokeSystemNavigationObserverCallback();
        }
    }

    private void invokeSystemNavigationObserverCallback() {
        if (this.mSystemNavigationObserverCallback != null) {
            this.mSystemNavigationObserverCallback.onBackInvoked();
        }
    }

    private void setTopOnBackInvokedCallback(@Nullable OnBackInvokedCallback callback) {
        if (this.mWindowSession == null || this.mWindow == null) {
            return;
        }
        try {
            OnBackInvokedCallbackInfo callbackInfo = null;
            if (callback != null) {
                int priority = this.mAllCallbacks.get(callback);
                int overrideAnimation = 0;
                if (callback instanceof SystemOverrideOnBackInvokedCallback) {
                    overrideAnimation = ((SystemOverrideOnBackInvokedCallback)callback).overrideBehavior();
                }
                boolean isSystemCallback = priority == -1 || overrideAnimation != 0;
                OnBackInvokedCallbackWrapper iCallback = new OnBackInvokedCallbackWrapper(callback, this.mTouchTracker, this.mProgressAnimator, this.mHandler, this::callOnKeyPreIme, this::invokeSystemNavigationObserverCallback, isSystemCallback);
                callbackInfo = new OnBackInvokedCallbackInfo(iCallback, priority, callback instanceof OnBackAnimationCallback, overrideAnimation);
            }
            Log.d(TAG, "setTopOnBackInvokedCallback (unwrapped): " + callback);
            this.mWindowSession.setOnBackInvokedCallbackInfo(this.mWindow, callbackInfo);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to set OnBackInvokedCallback to WM. Error: " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OnBackInvokedCallback getTopCallback() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mAllCallbacks.isEmpty()) {
                return null;
            }
            for (Integer priority : this.mOnBackInvokedCallbacks.descendingKeySet()) {
                ArrayList<OnBackInvokedCallback> callbacks = this.mOnBackInvokedCallbacks.get(priority);
                if (callbacks.isEmpty()) continue;
                return callbacks.get(callbacks.size() - 1);
            }
        }
        return null;
    }

    public void updateContext(@NonNull Context context) {
        this.mChecker = new Checker(context);
        Resources res = context.getResources();
        this.mBackSwipeLinearThreshold = res.getDimension(17105517);
        TypedValue typedValue = new TypedValue();
        res.getValue(17104998, typedValue, true);
        this.mNonLinearProgressFactor = typedValue.getFloat();
        this.onConfigurationChanged(context.getResources().getConfiguration());
    }

    public void onConfigurationChanged(Configuration configuration) {
        float maxDistance = configuration.windowConfiguration.getMaxBounds().width();
        float linearDistance = Math.min(maxDistance, this.mBackSwipeLinearThreshold);
        this.mTouchTracker.setProgressThresholds(linearDistance, maxDistance, this.mNonLinearProgressFactor);
    }

    public boolean isOnBackInvokedCallbackEnabled() {
        Context hostContext = this.mChecker.getContext();
        if (hostContext == null) {
            Log.w(TAG, "OnBackInvokedCallback is disabled, host context is removed!");
            return false;
        }
        return WindowOnBackInvokedDispatcher.isOnBackInvokedCallbackEnabled(hostContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(String prefix, PrintWriter writer) {
        String innerPrefix = prefix + "    ";
        writer.println(prefix + "WindowOnBackDispatcher:");
        Object object = this.mLock;
        synchronized (object) {
            if (this.mAllCallbacks.isEmpty()) {
                writer.println(prefix + "<None>");
                return;
            }
            writer.println(innerPrefix + "Top Callback: " + this.getTopCallback());
            writer.println(innerPrefix + "Callbacks: ");
            this.mAllCallbacks.forEach((callback, priority) -> writer.println(innerPrefix + "  Callback: " + callback + " Priority=" + priority));
        }
    }

    public static boolean isOnBackInvokedCallbackEnabled(@NonNull Context context) {
        Context originalContext = context;
        while (context instanceof ContextWrapper && !(context instanceof Activity)) {
            context = ((ContextWrapper)context).getBaseContext();
        }
        ActivityInfo activityInfo = context instanceof Activity ? ((Activity)context).getActivityInfo() : null;
        ApplicationInfo applicationInfo = context.getApplicationInfo();
        return WindowOnBackInvokedDispatcher.isOnBackInvokedCallbackEnabled(activityInfo, applicationInfo, () -> originalContext);
    }

    @Override
    public void setImeOnBackInvokedDispatcher(@NonNull ImeOnBackInvokedDispatcher imeDispatcher) {
        this.mImeDispatcher = imeDispatcher;
        this.mImeDispatcher.setHandler(this.mHandler);
    }

    public boolean hasImeOnBackInvokedDispatcher() {
        return this.mImeDispatcher != null;
    }

    public static boolean isOnBackInvokedCallbackEnabled(@Nullable ActivityInfo activityInfo, @NonNull ApplicationInfo applicationInfo, @NonNull Supplier<Context> contextSupplier) {
        if (!ENABLE_PREDICTIVE_BACK) {
            return false;
        }
        if (ALWAYS_ENFORCE_PREDICTIVE_BACK) {
            return true;
        }
        if (activityInfo != null && activityInfo.hasOnBackInvokedCallbackEnabled()) {
            boolean requestsPredictiveBack = activityInfo.isOnBackInvokedCallbackEnabled();
            return requestsPredictiveBack;
        }
        boolean requestsPredictiveBack = applicationInfo.isOnBackInvokedCallbackEnabled();
        if (requestsPredictiveBack) {
            return true;
        }
        if (PREDICTIVE_BACK_FALLBACK_WINDOW_ATTRIBUTE) {
            Context context = contextSupplier.get();
            boolean windowSwipeToDismiss = true;
            if (context != null) {
                TypedArray array2 = context.obtainStyledAttributes(new int[]{16843763});
                if (array2.getIndexCount() > 0) {
                    windowSwipeToDismiss = array2.getBoolean(0, true);
                }
                array2.recycle();
            }
            requestsPredictiveBack = windowSwipeToDismiss;
        }
        return requestsPredictiveBack;
    }

    public static class Checker {
        private WeakReference<Context> mContext;

        public Checker(@NonNull Context context) {
            this.mContext = new WeakReference<Context>(context);
        }

        public boolean checkApplicationCallbackRegistration(int priority, OnBackInvokedCallback callback) {
            Context hostContext = this.getContext();
            if (hostContext == null) {
                Log.w(WindowOnBackInvokedDispatcher.TAG, "OnBackInvokedCallback is disabled, host context is removed!");
                return false;
            }
            if (!WindowOnBackInvokedDispatcher.isOnBackInvokedCallbackEnabled(hostContext) && !(callback instanceof CompatOnBackInvokedCallback)) {
                Log.w(WindowOnBackInvokedDispatcher.TAG, "OnBackInvokedCallback is not enabled for the application.\nSet 'android:enableOnBackInvokedCallback=\"true\"' in the application manifest.");
                return false;
            }
            if (Flags.predictiveBackPrioritySystemNavigationObserver() ? priority < 0 && priority != -2 : priority < 0) {
                throw new IllegalArgumentException("Application registered OnBackInvokedCallback cannot have negative priority. Priority: " + priority);
            }
            Objects.requireNonNull(callback);
            return true;
        }

        @Nullable
        private Context getContext() {
            return (Context)this.mContext.get();
        }
    }

    private static class OnBackInvokedCallbackWrapper
    extends IOnBackInvokedCallback.Stub {
        @NonNull
        private final WeakReference<OnBackInvokedCallback> mCallback;
        @NonNull
        private final BackProgressAnimator mProgressAnimator;
        @NonNull
        private final BackTouchTracker mTouchTracker;
        @NonNull
        private final Handler mHandler;
        @NonNull
        private final BooleanSupplier mOnKeyPreIme;
        @NonNull
        private final Runnable mSystemNavigationObserverCallbackRunnable;
        private final boolean mIsSystemCallback;

        OnBackInvokedCallbackWrapper(@NonNull OnBackInvokedCallback callback, @NonNull BackTouchTracker touchTracker, @NonNull BackProgressAnimator progressAnimator, @NonNull Handler handler, @NonNull BooleanSupplier onKeyPreIme, @NonNull Runnable systemNavigationObserverCallbackRunnable, boolean isSystemCallback) {
            this.mCallback = new WeakReference<OnBackInvokedCallback>(callback);
            this.mTouchTracker = touchTracker;
            this.mProgressAnimator = progressAnimator;
            this.mHandler = handler;
            this.mOnKeyPreIme = onKeyPreIme;
            this.mSystemNavigationObserverCallbackRunnable = systemNavigationObserverCallbackRunnable;
            this.mIsSystemCallback = isSystemCallback;
        }

        @Override
        public void onBackStarted(BackMotionEvent backEvent) {
            this.mHandler.post(() -> {
                OnBackAnimationCallback callback = this.getBackAnimationCallback();
                if (callback != null && this.mProgressAnimator.isBackAnimationInProgress()) {
                    this.mProgressAnimator.reset();
                }
                this.mTouchTracker.setState(BackTouchTracker.TouchTrackerState.ACTIVE);
                this.mTouchTracker.setShouldUpdateStartLocation(true);
                this.mTouchTracker.setGestureStartLocation(backEvent.getTouchX(), backEvent.getTouchY(), backEvent.getSwipeEdge());
                if (callback != null) {
                    callback.onBackStarted(BackEvent.fromBackMotionEvent(backEvent));
                    this.mProgressAnimator.onBackStarted(backEvent, callback::onBackProgressed);
                }
            });
        }

        @Override
        public void setHandoffHandler(IBackAnimationHandoffHandler handoffHandler) {
        }

        @Override
        public void onBackProgressed(BackMotionEvent backEvent) {
            this.mHandler.post(() -> {
                if (this.getBackAnimationCallback() != null) {
                    this.mProgressAnimator.onBackProgressed(backEvent);
                }
            });
        }

        @Override
        public void onBackCancelled() {
            this.mHandler.post(() -> {
                OnBackAnimationCallback callback = this.getBackAnimationCallback();
                this.mTouchTracker.reset();
                if (callback == null) {
                    return;
                }
                this.mProgressAnimator.onBackCancelled(callback::onBackCancelled);
            });
        }

        @Override
        public void onBackInvoked() throws RemoteException {
            this.mHandler.post(() -> {
                this.mTouchTracker.reset();
                if (this.consumedByOnKeyPreIme()) {
                    return;
                }
                boolean isInProgress = this.mProgressAnimator.isBackAnimationInProgress();
                OnBackInvokedCallback callback = (OnBackInvokedCallback)this.mCallback.get();
                if (callback == null) {
                    this.mProgressAnimator.reset();
                    Log.d(WindowOnBackInvokedDispatcher.TAG, "Trying to call onBackInvoked() on a null callback reference.");
                    return;
                }
                if (callback instanceof OnBackAnimationCallback && !isInProgress) {
                    Log.w(WindowOnBackInvokedDispatcher.TAG, "ProgressAnimator was not in progress, skip onBackInvoked().");
                    return;
                }
                OnBackAnimationCallback animationCallback = this.getBackAnimationCallback();
                if (animationCallback != null && !(callback instanceof ImeBackAnimationController) && !Flags.predictiveBackTimestampApi()) {
                    this.mProgressAnimator.onBackInvoked(() -> {
                        if (this.mIsSystemCallback) {
                            this.mSystemNavigationObserverCallbackRunnable.run();
                        }
                        callback.onBackInvoked();
                    });
                } else {
                    this.mProgressAnimator.reset();
                    if (this.mIsSystemCallback) {
                        this.mSystemNavigationObserverCallbackRunnable.run();
                    }
                    callback.onBackInvoked();
                }
            });
        }

        private boolean consumedByOnKeyPreIme() {
            OnBackInvokedCallback callback = (OnBackInvokedCallback)this.mCallback.get();
            if (callback instanceof ImeBackAnimationController || callback instanceof ImeOnBackInvokedDispatcher.ImeOnBackInvokedCallback) {
                try {
                    boolean consumed = this.mOnKeyPreIme.getAsBoolean();
                    if (consumed) {
                        OnBackAnimationCallback animationCallback = this.getBackAnimationCallback();
                        if (animationCallback != null) {
                            this.mProgressAnimator.onBackCancelled(animationCallback::onBackCancelled);
                        }
                        return true;
                    }
                }
                catch (Exception e) {
                    Log.d(WindowOnBackInvokedDispatcher.TAG, "Failed to call onKeyPreIme", e);
                }
            }
            return false;
        }

        @Override
        public void setTriggerBack(boolean triggerBack) throws RemoteException {
            this.mTouchTracker.setTriggerBack(triggerBack);
        }

        @Nullable
        private OnBackAnimationCallback getBackAnimationCallback() {
            OnBackInvokedCallback callback = (OnBackInvokedCallback)this.mCallback.get();
            return callback instanceof OnBackAnimationCallback ? (OnBackAnimationCallback)callback : null;
        }
    }
}

