/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.ComponentCallbacks;
import android.content.ComponentCallbacksController;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.Configuration;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.view.WindowManagerImpl;
import android.window.ConfigurationDispatcher;
import android.window.WindowBase;
import android.window.WindowContextController;
import android.window.WindowProvider;
import android.window.WindowTokenClient;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.hidden_from_bootclasspath.com.android.window.flags.Flags;
import java.lang.ref.Reference;
import java.util.Objects;

public class WindowContext
extends ContextWrapper
implements WindowProvider,
ConfigurationDispatcher {
    private final int mType;
    @Nullable
    private final Bundle mOptions;
    private int mWindowTypeOverride = -1;
    private final ComponentCallbacksController mCallbacksController = new ComponentCallbacksController();
    private final WindowContextController mController;
    private WindowManager mWindowManager;
    private Window mWindow;

    public WindowContext(@NonNull Context base, int type, @Nullable Bundle options) {
        super(base);
        this.mType = type;
        this.mOptions = options;
        this.mWindowManager = WindowManagerImpl.createWindowContextWindowManager((Context)this);
        WindowTokenClient token = (WindowTokenClient)Objects.requireNonNull(this.getWindowContextToken());
        this.mController = new WindowContextController(Objects.requireNonNull(token));
        if (!Flags.reparentToDefaultWithDisplayRemoval() && WindowContext.shouldFallbackToDefaultDisplay(this.mOptions)) {
            throw new UnsupportedOperationException("com.android.window.flags.reparent_to_default_with_display_removal is not enabled");
        }
        Reference.reachabilityFence(this);
    }

    public void attachToDisplayArea() {
        this.mController.attachToDisplayArea(this.mType, this.getDisplayId(), this.mOptions);
    }

    public void reparentToDisplay(int displayId) {
        if (Flags.reparentWindowTokenApi()) {
            if (displayId == this.getDisplayId()) {
                return;
            }
            super.updateDisplay(displayId);
            this.mController.reparentToDisplayArea(this.mType, displayId, this.mOptions);
        }
    }

    @Override
    public Object getSystemService(String name) {
        if ("window".equals(name)) {
            return this.mWindowManager;
        }
        return super.getSystemService(name);
    }

    protected void finalize() throws Throwable {
        try {
            this.release();
        }
        finally {
            super.finalize();
        }
    }

    @VisibleForTesting
    public void release() {
        this.mController.detachIfNeeded();
        this.destroy();
    }

    @Override
    public void destroy() {
        try {
            this.mCallbacksController.clearCallbacks();
            this.getBaseContext().destroy();
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    @Override
    public void registerComponentCallbacks(@NonNull ComponentCallbacks callback) {
        this.mCallbacksController.registerCallbacks(callback);
    }

    @Override
    public void unregisterComponentCallbacks(@NonNull ComponentCallbacks callback) {
        this.mCallbacksController.unregisterCallbacks(callback);
    }

    public void setWindowTypeOverride(int windowTypeOverride) {
        if (!Flags.enableWindowContextOverrideType()) {
            return;
        }
        if (!this.isValidWindowType(windowTypeOverride) && windowTypeOverride != -1) {
            throw new IllegalArgumentException("The window type override must be either " + this.mType + " or a sub window type, but it's " + windowTypeOverride);
        }
        this.mWindowTypeOverride = windowTypeOverride;
    }

    public void attachWindow(@NonNull View window) {
        if (!Flags.enableWindowContextOverrideType()) {
            return;
        }
        if (this.mWindow != null) {
            throw new IllegalStateException("This WindowContext has already attached a window. Window=" + this.mWindow + " Please create another WindowContext if you want to attach another window.");
        }
        this.mWindow = new WindowWrapper(this, window);
        boolean hardwareAccelerated = (this.getApplicationInfo().flags & 0x20000000) != 0;
        this.mWindow.setWindowManager(this.mWindowManager, this.getWindowContextToken(), null, hardwareAccelerated, false);
    }

    public static boolean shouldFallbackToDefaultDisplay(@Nullable Bundle options) {
        return options != null && options.getBoolean("android.window.WindowProvider.reparentToDefaultDisplayWithDisplayRemoval", false);
    }

    @Override
    public int getWindowType() {
        return this.mType;
    }

    @Override
    @Nullable
    public Bundle getWindowContextOptions() {
        return this.mOptions;
    }

    @Override
    public int getWindowTypeOverride() {
        return this.mWindowTypeOverride;
    }

    @Override
    public boolean shouldReportPrivateChanges() {
        return true;
    }

    @Override
    public void dispatchConfigurationChanged(@NonNull Configuration newConfig) {
        this.mCallbacksController.dispatchConfigurationChanged(newConfig);
    }

    private static class WindowWrapper
    extends WindowBase {
        @NonNull
        private final View mDecorView;

        WindowWrapper(@NonNull Context context, @NonNull View decorView) {
            super(context);
            this.mDecorView = Objects.requireNonNull(decorView);
        }

        @Override
        @NonNull
        public LayoutInflater getLayoutInflater() {
            return LayoutInflater.from(this.mDecorView.getContext());
        }

        @Override
        @NonNull
        public View getDecorView() {
            return this.mDecorView;
        }

        @Override
        public View peekDecorView() {
            return this.mDecorView;
        }
    }
}

