/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.app.Instrumentation;
import android.app.PendingIntent;
import android.app.TaskInfo;
import android.app.WindowConfiguration;
import android.content.Intent;
import android.content.pm.ShortcutInfo;
import android.content.res.Configuration;
import android.graphics.Insets;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArrayMap;
import android.util.Log;
import android.view.InsetsFrameProvider;
import android.view.SurfaceControl;
import android.view.WindowInsets;
import android.window.ITaskFragmentOrganizer;
import android.window.KeyguardState;
import android.window.TaskFragmentCreationParams;
import android.window.TaskFragmentOperation;
import android.window.WindowContainerToken;
import com.android.internal.hidden_from_bootclasspath.com.android.window.flags.Flags;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class WindowContainerTransaction
implements Parcelable {
    private final ArrayMap<IBinder, Change> mChanges = new ArrayMap();
    private final ArrayList<HierarchyOp> mHierarchyOps = new ArrayList();
    @Nullable
    private IBinder mErrorCallbackToken;
    @Nullable
    private ITaskFragmentOrganizer mTaskFragmentOrganizer;
    @NonNull
    public static final Parcelable.Creator<WindowContainerTransaction> CREATOR = new Parcelable.Creator<WindowContainerTransaction>(){

        @Override
        public WindowContainerTransaction createFromParcel(@NonNull Parcel in) {
            return new WindowContainerTransaction(in);
        }

        public WindowContainerTransaction[] newArray(int size) {
            return new WindowContainerTransaction[size];
        }
    };

    public WindowContainerTransaction() {
    }

    private WindowContainerTransaction(@NonNull Parcel in) {
        in.readMap(this.mChanges, null);
        in.readTypedList(this.mHierarchyOps, HierarchyOp.CREATOR);
        this.mErrorCallbackToken = in.readStrongBinder();
        this.mTaskFragmentOrganizer = ITaskFragmentOrganizer.Stub.asInterface(in.readStrongBinder());
    }

    @NonNull
    private Change getOrCreateChange(IBinder token) {
        Change out = this.mChanges.get(token);
        if (out == null) {
            out = new Change();
            this.mChanges.put(token, out);
        }
        return out;
    }

    public void clear() {
        this.mChanges.clear();
        this.mHierarchyOps.clear();
        this.mErrorCallbackToken = null;
        this.mTaskFragmentOrganizer = null;
    }

    @NonNull
    public WindowContainerTransaction setBounds(@NonNull WindowContainerToken container, @NonNull Rect bounds) {
        Change chg = this.getOrCreateChange(container.asBinder());
        chg.mConfiguration.windowConfiguration.setBounds(bounds);
        chg.mConfigSetMask |= 0x20000000;
        chg.mWindowSetMask |= 1;
        return this;
    }

    @NonNull
    public WindowContainerTransaction setAppBounds(@NonNull WindowContainerToken container, @NonNull Rect appBounds) {
        Change chg = this.getOrCreateChange(container.asBinder());
        chg.mConfiguration.windowConfiguration.setAppBounds(appBounds);
        chg.mConfigSetMask |= 0x20000000;
        chg.mWindowSetMask |= 2;
        return this;
    }

    @NonNull
    public WindowContainerTransaction setScreenSizeDp(@NonNull WindowContainerToken container, int w, int h) {
        Change chg = this.getOrCreateChange(container.asBinder());
        chg.mConfiguration.screenWidthDp = w;
        chg.mConfiguration.screenHeightDp = h;
        chg.mConfigSetMask |= 0x400;
        return this;
    }

    @NonNull
    public WindowContainerTransaction setDensityDpi(@NonNull WindowContainerToken container, int densityDpi) {
        Change chg = this.getOrCreateChange(container.asBinder());
        chg.mConfiguration.densityDpi = densityDpi;
        chg.mConfigSetMask |= 0x1000;
        return this;
    }

    @NonNull
    public WindowContainerTransaction setBoundsChangeTransaction(@NonNull WindowContainerToken container, @NonNull SurfaceControl.Transaction t) {
        Change chg = this.getOrCreateChange(container.asBinder());
        chg.mBoundsChangeTransaction = t;
        chg.mChangeMask |= 2;
        return this;
    }

    @NonNull
    public WindowContainerTransaction setActivityWindowingMode(@NonNull WindowContainerToken container, int windowingMode) {
        Change chg = this.getOrCreateChange(container.asBinder());
        chg.mActivityWindowingMode = windowingMode;
        return this;
    }

    @NonNull
    public WindowContainerTransaction setWindowingMode(@NonNull WindowContainerToken container, int windowingMode) {
        Change chg = this.getOrCreateChange(container.asBinder());
        chg.mWindowingMode = windowingMode;
        return this;
    }

    @NonNull
    public WindowContainerTransaction setLaunchNextToBubble(@NonNull WindowContainerToken container, boolean launchNextToBubble) {
        Change chg = this.getOrCreateChange(container.asBinder());
        chg.mLaunchNextToBubble = launchNextToBubble;
        chg.mChangeMask |= 0x400;
        return this;
    }

    @NonNull
    public WindowContainerTransaction setFocusable(@NonNull WindowContainerToken container, boolean focusable) {
        Change chg = this.getOrCreateChange(container.asBinder());
        chg.mFocusable = focusable;
        chg.mChangeMask |= 1;
        return this;
    }

    @SuppressLint(value={"UnflaggedApi"})
    @NonNull
    public WindowContainerTransaction setExcludeImeInsets(@NonNull WindowContainerToken container, boolean exclude) {
        HierarchyOp hierarchyOp = new HierarchyOp.Builder(21).setContainer(container.asBinder()).setExcludeInsetsTypes(exclude ? WindowInsets.Type.ime() : 0).build();
        this.mHierarchyOps.add(hierarchyOp);
        return this;
    }

    @NonNull
    public WindowContainerTransaction setSystemBarVisibilityOverride(@NonNull WindowContainerToken display, @NonNull IBinder caller, int forciblyShowingInsetsTypes, int forciblyHidingInsetsTypes) {
        int forciblyShowingAndHidingTypes = forciblyShowingInsetsTypes & forciblyHidingInsetsTypes;
        if (forciblyShowingAndHidingTypes != 0) {
            throw new IllegalArgumentException(WindowInsets.Type.toString(forciblyShowingAndHidingTypes) + " cannot be forcibly shown and hidden at the same time.");
        }
        HierarchyOp hierarchyOp = new HierarchyOp.Builder(26).setContainer(display.asBinder()).setCaller(caller).setSystemBarVisibilityOverride(forciblyShowingInsetsTypes, forciblyHidingInsetsTypes).build();
        this.mHierarchyOps.add(hierarchyOp);
        return this;
    }

    @NonNull
    public WindowContainerTransaction setHidden(@NonNull WindowContainerToken container, boolean hidden) {
        Change chg = this.getOrCreateChange(container.asBinder());
        chg.mHidden = hidden;
        chg.mChangeMask |= 8;
        return this;
    }

    @NonNull
    public WindowContainerTransaction setSmallestScreenWidthDp(@NonNull WindowContainerToken container, int widthDp) {
        Change cfg = this.getOrCreateChange(container.asBinder());
        cfg.mConfiguration.smallestScreenWidthDp = widthDp;
        cfg.mConfigSetMask |= 0x800;
        return this;
    }

    @NonNull
    public WindowContainerTransaction setIgnoreOrientationRequest(@NonNull WindowContainerToken container, boolean ignoreOrientationRequest) {
        Change chg = this.getOrCreateChange(container.asBinder());
        chg.mIgnoreOrientationRequest = ignoreOrientationRequest;
        chg.mChangeMask |= 0x10;
        return this;
    }

    @NonNull
    public WindowContainerTransaction setForceTranslucent(@NonNull WindowContainerToken container, boolean forceTranslucent) {
        Change chg = this.getOrCreateChange(container.asBinder());
        chg.mForceTranslucent = forceTranslucent;
        chg.mChangeMask |= 0x40;
        return this;
    }

    @NonNull
    public WindowContainerTransaction setRelativeBounds(@NonNull WindowContainerToken container, @NonNull Rect relBounds) {
        Change chg = this.getOrCreateChange(container.asBinder());
        if (chg.mRelativeBounds == null) {
            chg.mRelativeBounds = new Rect();
        }
        chg.mRelativeBounds.set(relBounds);
        chg.mChangeMask |= 0x100;
        chg.mConfigSetMask |= 0x20000000;
        chg.mWindowSetMask |= 1;
        return this;
    }

    @NonNull
    public WindowContainerTransaction setDragResizing(@NonNull WindowContainerToken container, boolean dragResizing) {
        Change change = this.getOrCreateChange(container.asBinder());
        change.mChangeMask |= 0x80;
        change.mDragResizing = dragResizing;
        return this;
    }

    @NonNull
    public WindowContainerTransaction setAlwaysOnTop(@NonNull WindowContainerToken windowContainer, boolean alwaysOnTop) {
        HierarchyOp hierarchyOp = new HierarchyOp.Builder(12).setContainer(windowContainer.asBinder()).setAlwaysOnTop(alwaysOnTop).build();
        this.mHierarchyOps.add(hierarchyOp);
        return this;
    }

    @NonNull
    public WindowContainerTransaction setReparentLeafTaskIfRelaunch(@NonNull WindowContainerToken windowContainer, boolean reparentLeafTaskIfRelaunch) {
        HierarchyOp hierarchyOp = new HierarchyOp.Builder(16).setContainer(windowContainer.asBinder()).setReparentLeafTaskIfRelaunch(reparentLeafTaskIfRelaunch).build();
        this.mHierarchyOps.add(hierarchyOp);
        return this;
    }

    @NonNull
    public WindowContainerTransaction deferConfigToTransitionEnd(@NonNull WindowContainerToken container) {
        Change change = this.getOrCreateChange(container.asBinder());
        change.mConfigAtTransitionEnd = true;
        return this;
    }

    @NonNull
    public WindowContainerTransaction setTaskTrimmableFromRecents(@NonNull WindowContainerToken container, boolean isTrimmableFromRecents) {
        this.mHierarchyOps.add(HierarchyOp.createForSetTaskTrimmableFromRecents(container.asBinder(), isTrimmableFromRecents));
        return this;
    }

    @NonNull
    @FlaggedApi(value="com.android.window.flags.safe_region_letterboxing")
    public WindowContainerTransaction setSafeRegionBounds(@NonNull WindowContainerToken container, @Nullable Rect safeRegionBounds) {
        this.mHierarchyOps.add(HierarchyOp.createForSetSafeRegionBounds(container.asBinder(), safeRegionBounds));
        return this;
    }

    @NonNull
    public WindowContainerTransaction setTaskForceExcludedFromRecents(@NonNull WindowContainerToken container, boolean forceExcluded) {
        if (!Flags.excludeTaskFromRecents()) {
            throw new IllegalStateException("Flag com.android.window.flags.exclude_task_from_recents is not enabled");
        }
        Change chg = this.getOrCreateChange(container.asBinder());
        chg.mChangeMask |= 0x200;
        chg.mForceExcludedFromRecents = forceExcluded;
        return this;
    }

    @NonNull
    public WindowContainerTransaction setSelfMovable(@NonNull WindowContainerToken container, @TaskInfo.SelfMovable int selfMovable) {
        Change change = this.getOrCreateChange(container.asBinder());
        change.mSelfMovable = selfMovable;
        return this;
    }

    @NonNull
    public WindowContainerTransaction setIsTaskMoveAllowed(@NonNull WindowContainerToken container, boolean isTaskMoveAllowed) {
        Change change = this.getOrCreateChange(container.asBinder());
        change.mChangeMask |= 0x2000;
        change.mIsTaskMoveAllowed = isTaskMoveAllowed;
        return this;
    }

    @NonNull
    public WindowContainerTransaction setInterceptBackPressedOnTaskRoot(@NonNull WindowContainerToken container, boolean interceptBackPressed) {
        Change change = this.getOrCreateChange(container.asBinder());
        change.mChangeMask |= 0x4000;
        change.mInterceptBackPressed = interceptBackPressed;
        return this;
    }

    @NonNull
    public WindowContainerTransaction reorder(@NonNull WindowContainerToken child, boolean onTop) {
        return this.reorder(child, onTop, false);
    }

    @NonNull
    public WindowContainerTransaction reorder(@NonNull WindowContainerToken child, boolean onTop, boolean includingParents) {
        this.mHierarchyOps.add(HierarchyOp.createForReorder(child.asBinder(), onTop, includingParents));
        return this;
    }

    @NonNull
    public WindowContainerTransaction reparent(@NonNull WindowContainerToken child, @Nullable WindowContainerToken parent, boolean onTop) {
        this.mHierarchyOps.add(HierarchyOp.createForReparent(child.asBinder(), parent == null ? null : parent.asBinder(), onTop));
        return this;
    }

    @NonNull
    public WindowContainerTransaction reparentTasks(@Nullable WindowContainerToken currentParent, @Nullable WindowContainerToken newParent, @Nullable int[] windowingModes, @Nullable int[] activityTypes, boolean onTop, boolean reparentTopOnly) {
        this.mHierarchyOps.add(HierarchyOp.createForChildrenTasksReparent(currentParent != null ? currentParent.asBinder() : null, newParent != null ? newParent.asBinder() : null, windowingModes, activityTypes, onTop, reparentTopOnly));
        return this;
    }

    @NonNull
    public WindowContainerTransaction reparentTasks(@Nullable WindowContainerToken currentParent, @Nullable WindowContainerToken newParent, @Nullable int[] windowingModes, @Nullable int[] activityTypes, boolean onTop) {
        return this.reparentTasks(currentParent, newParent, windowingModes, activityTypes, onTop, false);
    }

    @NonNull
    public WindowContainerTransaction removeTask(@NonNull WindowContainerToken containerToken) {
        this.mHierarchyOps.add(HierarchyOp.createForRemoveTask(containerToken.asBinder()));
        return this;
    }

    @NonNull
    public WindowContainerTransaction removeRootTask(@NonNull WindowContainerToken containerToken) {
        this.mHierarchyOps.add(HierarchyOp.createForRemoveRootTask(containerToken.asBinder()));
        return this;
    }

    @NonNull
    public WindowContainerTransaction restoreTransientOrder(@NonNull WindowContainerToken container) {
        HierarchyOp hierarchyOp = new HierarchyOp.Builder(9).setContainer(container.asBinder()).build();
        this.mHierarchyOps.add(hierarchyOp);
        return this;
    }

    @NonNull
    public WindowContainerTransaction restoreBackNavi() {
        HierarchyOp hierarchyOp = new HierarchyOp.Builder(20).build();
        this.mHierarchyOps.add(hierarchyOp);
        return this;
    }

    @NonNull
    public WindowContainerTransaction startTask(int taskId, @Nullable Bundle options) {
        if (Instrumentation.DEBUG_START_ACTIVITY) {
            Log.d("Instrumentation", "WCT.startTask: taskId=" + taskId + " options=" + options, new Throwable());
        }
        this.mHierarchyOps.add(HierarchyOp.createForTaskLaunch(taskId, options));
        return this;
    }

    @NonNull
    public WindowContainerTransaction sendPendingIntent(@Nullable PendingIntent sender, @Nullable Intent fillInIntent, @Nullable Bundle options) {
        if (Instrumentation.DEBUG_START_ACTIVITY) {
            Log.d("Instrumentation", "WCT.sendPendingIntent: sender=" + (sender != null ? sender.getIntent() : "null") + " fillInIntent=" + fillInIntent + " options=" + options, new Throwable());
        }
        this.mHierarchyOps.add(new HierarchyOp.Builder(7).setLaunchOptions(options).setPendingIntent(sender).setActivityIntent(fillInIntent).build());
        return this;
    }

    @NonNull
    public WindowContainerTransaction startShortcut(@NonNull String callingPackage, @NonNull ShortcutInfo shortcutInfo, @Nullable Bundle options) {
        if (Instrumentation.DEBUG_START_ACTIVITY) {
            Log.d("Instrumentation", "WCT.startShortcut: shortcutInfo=" + shortcutInfo + " options=" + options, new Throwable());
        }
        this.mHierarchyOps.add(HierarchyOp.createForStartShortcut(callingPackage, shortcutInfo, options));
        return this;
    }

    @NonNull
    public WindowContainerTransaction setLaunchRoot(@NonNull WindowContainerToken container, @Nullable int[] windowingModes, @Nullable int[] activityTypes) {
        this.mHierarchyOps.add(HierarchyOp.createForSetLaunchRoot(container.asBinder(), windowingModes, activityTypes));
        return this;
    }

    @Deprecated
    @NonNull
    public WindowContainerTransaction setAdjacentRoots(@NonNull WindowContainerToken root1, @NonNull WindowContainerToken root2) {
        return this.setAdjacentRootSet(root1, root2);
    }

    @NonNull
    public WindowContainerTransaction setAdjacentRootSet(WindowContainerToken ... roots) {
        if (roots.length < 2) {
            throw new IllegalArgumentException("setAdjacentRootSet must have size >= 2");
        }
        IBinder[] rootTokens = new IBinder[roots.length];
        for (int i = 0; i < roots.length; ++i) {
            rootTokens[i] = roots[i].asBinder();
        }
        this.mHierarchyOps.add(new HierarchyOp.Builder(4).setContainers(rootTokens).build());
        return this;
    }

    @NonNull
    public WindowContainerTransaction clearAdjacentRoots(@NonNull WindowContainerToken root) {
        this.mHierarchyOps.add(HierarchyOp.createForClearAdjacentRoots(root.asBinder()));
        return this;
    }

    @NonNull
    public WindowContainerTransaction setLaunchAdjacentFlagRoot(@NonNull WindowContainerToken container) {
        this.mHierarchyOps.add(HierarchyOp.createForSetLaunchAdjacentFlagRoot(container.asBinder(), false));
        return this;
    }

    @NonNull
    public WindowContainerTransaction clearLaunchAdjacentFlagRoot(@NonNull WindowContainerToken container) {
        this.mHierarchyOps.add(HierarchyOp.createForSetLaunchAdjacentFlagRoot(container.asBinder(), true));
        return this;
    }

    @NonNull
    public WindowContainerTransaction setDisableLaunchAdjacent(@NonNull WindowContainerToken container, boolean disabled) {
        Change chg = this.getOrCreateChange(container.asBinder());
        chg.mChangeMask |= 0x1000;
        chg.mDisableLaunchAdjacent = disabled;
        return this;
    }

    @NonNull
    public WindowContainerTransaction movePipActivityToPinnedRootTask(@NonNull WindowContainerToken parentToken, @NonNull Rect bounds) {
        this.mHierarchyOps.add(new HierarchyOp.Builder(18).setContainer(parentToken.asBinder()).setBounds(bounds).build());
        return this;
    }

    @NonNull
    public WindowContainerTransaction scheduleFinishEnterPip(@NonNull WindowContainerToken container, @NonNull Rect bounds) {
        Change chg = this.getOrCreateChange(container.asBinder());
        chg.mChangeMask |= 4;
        return this;
    }

    @NonNull
    public WindowContainerTransaction setDoNotPip(@NonNull WindowContainerToken container) {
        Change chg = this.getOrCreateChange(container.asBinder());
        chg.mChangeMask |= 0x20;
        return this;
    }

    @NonNull
    public WindowContainerTransaction setDisablePip(@NonNull WindowContainerToken container, boolean disablePip) {
        Change chg = this.getOrCreateChange(container.asBinder());
        chg.mChangeMask |= 0x800;
        chg.mDisablePip = disablePip;
        return this;
    }

    @NonNull
    public WindowContainerTransaction addInsetsSource(@NonNull WindowContainerToken receiver, @Nullable IBinder owner, int index, int type, @Nullable Rect frame, @Nullable Rect[] boundingRects, int flags) {
        return this.addInsetsSource(receiver, owner, new InsetsFrameProvider(owner, index, type).setSource(3).setArbitraryRectangle(frame).setBoundingRects(boundingRects).setFlags(flags));
    }

    @NonNull
    public WindowContainerTransaction addInsetsSource(@NonNull WindowContainerToken receiver, @Nullable IBinder owner, int index, int type, @NonNull Insets insets, @Nullable Rect[] boundingRects, int flags) {
        return this.addInsetsSource(receiver, owner, new InsetsFrameProvider(owner, index, type).setSource(4).setInsetsSize(insets).setBoundingRects(boundingRects).setFlags(flags));
    }

    @NonNull
    private WindowContainerTransaction addInsetsSource(@NonNull WindowContainerToken receiver, IBinder owner, InsetsFrameProvider provider) {
        HierarchyOp hierarchyOp = new HierarchyOp.Builder(10).setContainer(receiver.asBinder()).setInsetsFrameProvider(provider).setCaller(owner).build();
        this.mHierarchyOps.add(hierarchyOp);
        return this;
    }

    @NonNull
    public WindowContainerTransaction removeInsetsSource(@NonNull WindowContainerToken receiver, @Nullable IBinder owner, int index, int type) {
        HierarchyOp hierarchyOp = new HierarchyOp.Builder(11).setContainer(receiver.asBinder()).setInsetsFrameProvider(new InsetsFrameProvider(owner, index, type)).setCaller(owner).build();
        this.mHierarchyOps.add(hierarchyOp);
        return this;
    }

    @NonNull
    public WindowContainerTransaction addKeyguardState(@NonNull KeyguardState keyguardState) {
        Objects.requireNonNull(keyguardState);
        HierarchyOp hierarchyOp = new HierarchyOp.Builder(22).setKeyguardState(keyguardState).build();
        this.mHierarchyOps.add(hierarchyOp);
        return this;
    }

    @NonNull
    public WindowContainerTransaction setTaskFragmentOrganizer(@NonNull ITaskFragmentOrganizer organizer) {
        this.mTaskFragmentOrganizer = organizer;
        return this;
    }

    @NonNull
    public WindowContainerTransaction setErrorCallbackToken(@NonNull IBinder errorCallbackToken) {
        if (this.mErrorCallbackToken != null) {
            throw new IllegalStateException("Can't set multiple error token for one transaction.");
        }
        this.mErrorCallbackToken = errorCallbackToken;
        return this;
    }

    @NonNull
    public WindowContainerTransaction createTaskFragment(@NonNull TaskFragmentCreationParams taskFragmentCreationParams) {
        TaskFragmentOperation operation = new TaskFragmentOperation.Builder(0).setTaskFragmentCreationParams(taskFragmentCreationParams).build();
        return this.addTaskFragmentOperation(taskFragmentCreationParams.getFragmentToken(), operation);
    }

    @NonNull
    public WindowContainerTransaction deleteTaskFragment(@NonNull IBinder fragmentToken) {
        TaskFragmentOperation operation = new TaskFragmentOperation.Builder(1).build();
        return this.addTaskFragmentOperation(fragmentToken, operation);
    }

    @NonNull
    public WindowContainerTransaction startActivityInTaskFragment(@NonNull IBinder fragmentToken, @NonNull IBinder callerToken, @NonNull Intent activityIntent, @Nullable Bundle activityOptions) {
        TaskFragmentOperation operation = new TaskFragmentOperation.Builder(2).setActivityToken(callerToken).setActivityIntent(activityIntent).setBundle(activityOptions).build();
        return this.addTaskFragmentOperation(fragmentToken, operation);
    }

    @NonNull
    public WindowContainerTransaction reparentActivityToTaskFragment(@NonNull IBinder fragmentToken, @NonNull IBinder activityToken) {
        TaskFragmentOperation operation = new TaskFragmentOperation.Builder(3).setActivityToken(activityToken).build();
        return this.addTaskFragmentOperation(fragmentToken, operation);
    }

    @NonNull
    public WindowContainerTransaction setAdjacentTaskFragments(@NonNull IBinder fragmentToken1, @NonNull IBinder fragmentToken2, @Nullable TaskFragmentAdjacentParams params) {
        TaskFragmentOperation operation = new TaskFragmentOperation.Builder(4).setSecondaryFragmentToken(fragmentToken2).setBundle(params != null ? params.toBundle() : null).build();
        return this.addTaskFragmentOperation(fragmentToken1, operation);
    }

    @NonNull
    public WindowContainerTransaction clearAdjacentTaskFragments(@NonNull IBinder fragmentToken) {
        TaskFragmentOperation operation = new TaskFragmentOperation.Builder(5).build();
        return this.addTaskFragmentOperation(fragmentToken, operation);
    }

    @NonNull
    public WindowContainerTransaction requestFocusOnTaskFragment(@NonNull IBinder fragmentToken) {
        TaskFragmentOperation operation = new TaskFragmentOperation.Builder(6).build();
        return this.addTaskFragmentOperation(fragmentToken, operation);
    }

    @NonNull
    public WindowContainerTransaction finishActivity(@NonNull IBinder activityToken) {
        HierarchyOp hierarchyOp = new HierarchyOp.Builder(14).setContainer(activityToken).build();
        this.mHierarchyOps.add(hierarchyOp);
        return this;
    }

    @NonNull
    public WindowContainerTransaction setCompanionTaskFragment(@NonNull IBinder fragmentToken, @Nullable IBinder companionFragmentToken) {
        TaskFragmentOperation operation = new TaskFragmentOperation.Builder(7).setSecondaryFragmentToken(companionFragmentToken).build();
        return this.addTaskFragmentOperation(fragmentToken, operation);
    }

    @NonNull
    public WindowContainerTransaction addTaskFragmentOperation(@NonNull IBinder fragmentToken, @NonNull TaskFragmentOperation taskFragmentOperation) {
        Objects.requireNonNull(fragmentToken);
        Objects.requireNonNull(taskFragmentOperation);
        HierarchyOp hierarchyOp = new HierarchyOp.Builder(17).setContainer(fragmentToken).setTaskFragmentOperation(taskFragmentOperation).build();
        this.mHierarchyOps.add(hierarchyOp);
        return this;
    }

    public WindowContainerTransaction setReachabilityOffset(@NonNull WindowContainerToken container, int taskId, int x, int y) {
        this.mHierarchyOps.add(HierarchyOp.createForReachability(container.asBinder(), taskId, x, y));
        return this;
    }

    public void merge(@NonNull WindowContainerTransaction other, boolean transfer) {
        IBinder otherTaskFragmentOrganizerAsBinder;
        int i;
        int n = other.mChanges.size();
        for (i = 0; i < n; ++i) {
            IBinder key = other.mChanges.keyAt(i);
            Change existing = this.mChanges.get(key);
            if (existing == null) {
                existing = new Change();
                this.mChanges.put(key, existing);
            }
            existing.merge(other.mChanges.valueAt(i), transfer);
        }
        n = other.mHierarchyOps.size();
        for (i = 0; i < n; ++i) {
            HierarchyOp otherHierarchyOp = other.mHierarchyOps.get(i);
            this.mHierarchyOps.add(transfer ? otherHierarchyOp : new HierarchyOp(otherHierarchyOp));
        }
        if (this.mErrorCallbackToken != null && other.mErrorCallbackToken != null && this.mErrorCallbackToken != other.mErrorCallbackToken) {
            throw new IllegalArgumentException("Can't merge two WCTs with different error token");
        }
        IBinder taskFragmentOrganizerAsBinder = this.mTaskFragmentOrganizer != null ? this.mTaskFragmentOrganizer.asBinder() : null;
        IBinder iBinder = otherTaskFragmentOrganizerAsBinder = other.mTaskFragmentOrganizer != null ? other.mTaskFragmentOrganizer.asBinder() : null;
        if (!Objects.equals(taskFragmentOrganizerAsBinder, otherTaskFragmentOrganizerAsBinder)) {
            throw new IllegalArgumentException("Can't merge two WCTs from different TaskFragmentOrganizers");
        }
        this.mErrorCallbackToken = this.mErrorCallbackToken != null ? this.mErrorCallbackToken : other.mErrorCallbackToken;
    }

    public boolean isEmpty() {
        return this.mChanges.isEmpty() && this.mHierarchyOps.isEmpty();
    }

    @NonNull
    public Map<IBinder, Change> getChanges() {
        return this.mChanges;
    }

    @NonNull
    public List<HierarchyOp> getHierarchyOps() {
        return this.mHierarchyOps;
    }

    @Nullable
    public IBinder getErrorCallbackToken() {
        return this.mErrorCallbackToken;
    }

    @Nullable
    public ITaskFragmentOrganizer getTaskFragmentOrganizer() {
        return this.mTaskFragmentOrganizer;
    }

    @NonNull
    public String toString() {
        return "WindowContainerTransaction { changes= " + this.mChanges + " hops= " + this.mHierarchyOps + " errorCallbackToken=" + this.mErrorCallbackToken + " taskFragmentOrganizer=" + this.mTaskFragmentOrganizer + " }";
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeMap(this.mChanges);
        dest.writeTypedList(this.mHierarchyOps);
        dest.writeStrongBinder(this.mErrorCallbackToken);
        dest.writeStrongInterface(this.mTaskFragmentOrganizer);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static class HierarchyOp
    implements Parcelable {
        public static final int HIERARCHY_OP_TYPE_REPARENT = 0;
        public static final int HIERARCHY_OP_TYPE_REORDER = 1;
        public static final int HIERARCHY_OP_TYPE_CHILDREN_TASKS_REPARENT = 2;
        public static final int HIERARCHY_OP_TYPE_SET_LAUNCH_ROOT = 3;
        public static final int HIERARCHY_OP_TYPE_SET_ADJACENT_ROOTS = 4;
        public static final int HIERARCHY_OP_TYPE_LAUNCH_TASK = 5;
        public static final int HIERARCHY_OP_TYPE_SET_LAUNCH_ADJACENT_FLAG_ROOT = 6;
        public static final int HIERARCHY_OP_TYPE_PENDING_INTENT = 7;
        public static final int HIERARCHY_OP_TYPE_START_SHORTCUT = 8;
        public static final int HIERARCHY_OP_TYPE_RESTORE_TRANSIENT_ORDER = 9;
        public static final int HIERARCHY_OP_TYPE_ADD_INSETS_FRAME_PROVIDER = 10;
        public static final int HIERARCHY_OP_TYPE_REMOVE_INSETS_FRAME_PROVIDER = 11;
        public static final int HIERARCHY_OP_TYPE_SET_ALWAYS_ON_TOP = 12;
        public static final int HIERARCHY_OP_TYPE_REMOVE_TASK = 13;
        public static final int HIERARCHY_OP_TYPE_FINISH_ACTIVITY = 14;
        public static final int HIERARCHY_OP_TYPE_CLEAR_ADJACENT_ROOTS = 15;
        public static final int HIERARCHY_OP_TYPE_SET_REPARENT_LEAF_TASK_IF_RELAUNCH = 16;
        public static final int HIERARCHY_OP_TYPE_ADD_TASK_FRAGMENT_OPERATION = 17;
        public static final int HIERARCHY_OP_TYPE_MOVE_PIP_ACTIVITY_TO_PINNED_TASK = 18;
        public static final int HIERARCHY_OP_TYPE_SET_IS_TRIMMABLE = 19;
        public static final int HIERARCHY_OP_TYPE_RESTORE_BACK_NAVIGATION = 20;
        public static final int HIERARCHY_OP_TYPE_SET_EXCLUDE_INSETS_TYPES = 21;
        public static final int HIERARCHY_OP_TYPE_SET_KEYGUARD_STATE = 22;
        public static final int HIERARCHY_OP_TYPE_REMOVE_ROOT_TASK = 23;
        public static final int HIERARCHY_OP_TYPE_APP_COMPAT_REACHABILITY = 24;
        public static final int HIERARCHY_OP_TYPE_SET_SAFE_REGION_BOUNDS = 25;
        public static final int HIERARCHY_OP_TYPE_SET_SYSTEM_BAR_VISIBILITY_OVERRIDE = 26;
        public static final String LAUNCH_KEY_TASK_ID = "android:transaction.hop.taskId";
        public static final String LAUNCH_KEY_SHORTCUT_CALLING_PACKAGE = "android:transaction.hop.shortcut_calling_package";
        public static final String REACHABILITY_EVENT_X = "android:transaction.reachability_x";
        public static final String REACHABILITY_EVENT_Y = "android:transaction.reachability_y";
        private final int mType;
        @Nullable
        private IBinder mContainer;
        @Nullable
        private IBinder[] mContainers;
        @Nullable
        private IBinder mReparent;
        @Nullable
        private InsetsFrameProvider mInsetsFrameProvider;
        @Nullable
        private IBinder mCaller;
        private boolean mToTop;
        private boolean mReparentTopOnly;
        @Nullable
        private int[] mWindowingModes;
        @Nullable
        private int[] mActivityTypes;
        @Nullable
        private Bundle mLaunchOptions;
        @Nullable
        private Bundle mAppCompatOptions;
        @Nullable
        private Intent mActivityIntent;
        @Nullable
        private TaskFragmentOperation mTaskFragmentOperation;
        @Nullable
        private KeyguardState mKeyguardState;
        @Nullable
        private PendingIntent mPendingIntent;
        @Nullable
        private ShortcutInfo mShortcutInfo;
        @Nullable
        private Rect mBounds;
        private boolean mIncludingParents;
        private boolean mAlwaysOnTop;
        private boolean mReparentLeafTaskIfRelaunch;
        private boolean mIsTrimmableFromRecents;
        private int mExcludeInsetsTypes;
        private int mForciblyShowingInsetsTypes;
        private int mForciblyHidingInsetsTypes;
        @Nullable
        private Rect mSafeRegionBounds;
        public static final Parcelable.Creator<HierarchyOp> CREATOR = new Parcelable.Creator<HierarchyOp>(){

            @Override
            public HierarchyOp createFromParcel(@NonNull Parcel in) {
                return new HierarchyOp(in);
            }

            public HierarchyOp[] newArray(int size) {
                return new HierarchyOp[size];
            }
        };

        @NonNull
        public static HierarchyOp createForReparent(@NonNull IBinder container, @Nullable IBinder reparent, boolean toTop) {
            return new Builder(0).setContainer(container).setReparentContainer(reparent).setToTop(toTop).build();
        }

        @NonNull
        public static HierarchyOp createForReorder(@NonNull IBinder container, boolean toTop, boolean includingParents) {
            return new Builder(1).setContainer(container).setReparentContainer(container).setToTop(toTop).setIncludingParents(includingParents).build();
        }

        @NonNull
        public static HierarchyOp createForChildrenTasksReparent(@Nullable IBinder currentParent, @Nullable IBinder newParent, @Nullable int[] windowingModes, @Nullable int[] activityTypes, boolean onTop, boolean reparentTopOnly) {
            return new Builder(2).setContainer(currentParent).setReparentContainer(newParent).setWindowingModes(windowingModes).setActivityTypes(activityTypes).setToTop(onTop).setReparentTopOnly(reparentTopOnly).build();
        }

        @NonNull
        public static HierarchyOp createForSetLaunchRoot(@Nullable IBinder container, @Nullable int[] windowingModes, @Nullable int[] activityTypes) {
            return new Builder(3).setContainer(container).setWindowingModes(windowingModes).setActivityTypes(activityTypes).build();
        }

        @NonNull
        public static HierarchyOp createForAdjacentRoots(@Nullable IBinder root1, @Nullable IBinder root2) {
            return new Builder(4).setContainer(root1).setReparentContainer(root2).build();
        }

        @NonNull
        public static HierarchyOp createForTaskLaunch(int taskId, @Nullable Bundle options) {
            Bundle fullOptions = options == null ? new Bundle() : options;
            fullOptions.putInt(LAUNCH_KEY_TASK_ID, taskId);
            return new Builder(5).setToTop(true).setLaunchOptions(fullOptions).build();
        }

        @NonNull
        public static HierarchyOp createForStartShortcut(@NonNull String callingPackage, @NonNull ShortcutInfo shortcutInfo, @Nullable Bundle options) {
            Bundle fullOptions = options == null ? new Bundle() : options;
            fullOptions.putString(LAUNCH_KEY_SHORTCUT_CALLING_PACKAGE, callingPackage);
            return new Builder(8).setShortcutInfo(shortcutInfo).setLaunchOptions(fullOptions).build();
        }

        @NonNull
        public static HierarchyOp createForSetLaunchAdjacentFlagRoot(@Nullable IBinder container, boolean clearRoot) {
            return new Builder(6).setContainer(container).setToTop(clearRoot).build();
        }

        @NonNull
        public static HierarchyOp createForRemoveTask(@NonNull IBinder container) {
            return new Builder(13).setContainer(container).build();
        }

        @NonNull
        public static HierarchyOp createForRemoveRootTask(@NonNull IBinder container) {
            return new Builder(23).setContainer(container).build();
        }

        @NonNull
        public static HierarchyOp createForClearAdjacentRoots(@NonNull IBinder root) {
            return new Builder(15).setContainer(root).build();
        }

        @NonNull
        public static HierarchyOp createForReachability(IBinder container, int taskId, int x, int y) {
            Bundle appCompatOptions = new Bundle();
            appCompatOptions.putInt(LAUNCH_KEY_TASK_ID, taskId);
            appCompatOptions.putInt(REACHABILITY_EVENT_X, x);
            appCompatOptions.putInt(REACHABILITY_EVENT_Y, y);
            return new Builder(24).setAppCompatOptions(appCompatOptions).setContainer(container).build();
        }

        @NonNull
        @FlaggedApi(value="com.android.window.flags.enable_desktop_windowing_wallpaper_activity")
        public static HierarchyOp createForSetTaskTrimmableFromRecents(@NonNull IBinder container, boolean isTrimmableFromRecents) {
            return new Builder(19).setContainer(container).setIsTrimmableFromRecents(isTrimmableFromRecents).build();
        }

        @NonNull
        @FlaggedApi(value="com.android.window.flags.safe_region_letterboxing")
        public static HierarchyOp createForSetSafeRegionBounds(@NonNull IBinder container, @Nullable Rect safeRegionBounds) {
            return new Builder(25).setContainer(container).setSafeRegionBounds(safeRegionBounds).build();
        }

        private HierarchyOp(int type) {
            this.mType = type;
        }

        public HierarchyOp(@NonNull HierarchyOp copy) {
            this.mType = copy.mType;
            this.mContainer = copy.mContainer;
            this.mContainers = copy.mContainers;
            this.mBounds = copy.mBounds;
            this.mIncludingParents = copy.mIncludingParents;
            this.mReparent = copy.mReparent;
            this.mInsetsFrameProvider = copy.mInsetsFrameProvider;
            this.mCaller = copy.mCaller;
            this.mToTop = copy.mToTop;
            this.mReparentTopOnly = copy.mReparentTopOnly;
            this.mWindowingModes = copy.mWindowingModes;
            this.mActivityTypes = copy.mActivityTypes;
            this.mLaunchOptions = copy.mLaunchOptions;
            this.mAppCompatOptions = copy.mAppCompatOptions;
            this.mActivityIntent = copy.mActivityIntent;
            this.mTaskFragmentOperation = copy.mTaskFragmentOperation;
            this.mKeyguardState = copy.mKeyguardState;
            this.mPendingIntent = copy.mPendingIntent;
            this.mShortcutInfo = copy.mShortcutInfo;
            this.mAlwaysOnTop = copy.mAlwaysOnTop;
            this.mReparentLeafTaskIfRelaunch = copy.mReparentLeafTaskIfRelaunch;
            this.mIsTrimmableFromRecents = copy.mIsTrimmableFromRecents;
            this.mExcludeInsetsTypes = copy.mExcludeInsetsTypes;
            this.mForciblyShowingInsetsTypes = copy.mForciblyShowingInsetsTypes;
            this.mForciblyHidingInsetsTypes = copy.mForciblyHidingInsetsTypes;
            this.mSafeRegionBounds = copy.mSafeRegionBounds;
        }

        private HierarchyOp(@NonNull Parcel in) {
            this.mType = in.readInt();
            this.mContainer = in.readStrongBinder();
            this.mContainers = in.createBinderArray();
            this.mBounds = in.readTypedObject(Rect.CREATOR);
            this.mIncludingParents = in.readBoolean();
            this.mReparent = in.readStrongBinder();
            this.mInsetsFrameProvider = in.readTypedObject(InsetsFrameProvider.CREATOR);
            this.mCaller = in.readStrongBinder();
            this.mToTop = in.readBoolean();
            this.mReparentTopOnly = in.readBoolean();
            this.mWindowingModes = in.createIntArray();
            this.mActivityTypes = in.createIntArray();
            this.mLaunchOptions = in.readBundle();
            this.mAppCompatOptions = in.readBundle(this.getClass().getClassLoader());
            this.mActivityIntent = in.readTypedObject(Intent.CREATOR);
            this.mTaskFragmentOperation = in.readTypedObject(TaskFragmentOperation.CREATOR);
            this.mKeyguardState = in.readTypedObject(KeyguardState.CREATOR);
            this.mPendingIntent = in.readTypedObject(PendingIntent.CREATOR);
            this.mShortcutInfo = in.readTypedObject(ShortcutInfo.CREATOR);
            this.mAlwaysOnTop = in.readBoolean();
            this.mReparentLeafTaskIfRelaunch = in.readBoolean();
            this.mIsTrimmableFromRecents = in.readBoolean();
            this.mExcludeInsetsTypes = in.readInt();
            this.mForciblyShowingInsetsTypes = in.readInt();
            this.mForciblyHidingInsetsTypes = in.readInt();
            this.mSafeRegionBounds = in.readTypedObject(Rect.CREATOR);
        }

        public int getType() {
            return this.mType;
        }

        public boolean isReparent() {
            return this.mType == 0;
        }

        @Nullable
        public IBinder getNewParent() {
            return this.mReparent;
        }

        @Nullable
        public InsetsFrameProvider getInsetsFrameProvider() {
            return this.mInsetsFrameProvider;
        }

        @Nullable
        public IBinder getCaller() {
            return this.mCaller;
        }

        @NonNull
        public IBinder getContainer() {
            return this.mContainer;
        }

        @NonNull
        public IBinder[] getContainers() {
            return this.mContainers;
        }

        public boolean getToTop() {
            return this.mToTop;
        }

        public boolean getReparentTopOnly() {
            return this.mReparentTopOnly;
        }

        @Nullable
        public int[] getWindowingModes() {
            return this.mWindowingModes;
        }

        @Nullable
        public int[] getActivityTypes() {
            return this.mActivityTypes;
        }

        @Nullable
        public Bundle getLaunchOptions() {
            return this.mLaunchOptions;
        }

        @Nullable
        public Bundle getAppCompatOptions() {
            return this.mAppCompatOptions;
        }

        @Nullable
        public Intent getActivityIntent() {
            return this.mActivityIntent;
        }

        public boolean isAlwaysOnTop() {
            return this.mAlwaysOnTop;
        }

        public boolean isReparentLeafTaskIfRelaunch() {
            return this.mReparentLeafTaskIfRelaunch;
        }

        @Nullable
        public TaskFragmentOperation getTaskFragmentOperation() {
            return this.mTaskFragmentOperation;
        }

        @Nullable
        public KeyguardState getKeyguardState() {
            return this.mKeyguardState;
        }

        @Nullable
        public PendingIntent getPendingIntent() {
            return this.mPendingIntent;
        }

        @Nullable
        public ShortcutInfo getShortcutInfo() {
            return this.mShortcutInfo;
        }

        @NonNull
        public Rect getBounds() {
            return this.mBounds;
        }

        public boolean includingParents() {
            return this.mIncludingParents;
        }

        public boolean isTrimmableFromRecents() {
            return this.mIsTrimmableFromRecents;
        }

        public int getExcludeInsetsTypes() {
            return this.mExcludeInsetsTypes;
        }

        public int getForciblyShowingInsetsTypes() {
            return this.mForciblyShowingInsetsTypes;
        }

        public int getForciblyHidingInsetsTypes() {
            return this.mForciblyHidingInsetsTypes;
        }

        @Nullable
        public Rect getSafeRegionBounds() {
            return this.mSafeRegionBounds;
        }

        public static String hopToString(int type) {
            switch (type) {
                case 0: {
                    return "reparent";
                }
                case 1: {
                    return "reorder";
                }
                case 2: {
                    return "childrenTasksReparent";
                }
                case 3: {
                    return "setLaunchRoot";
                }
                case 4: {
                    return "setAdjacentRoots";
                }
                case 5: {
                    return "launchTask";
                }
                case 6: {
                    return "setAdjacentFlagRoot";
                }
                case 7: {
                    return "pendingIntent";
                }
                case 8: {
                    return "startShortcut";
                }
                case 9: {
                    return "restoreTransientOrder";
                }
                case 10: {
                    return "addInsetsFrameProvider";
                }
                case 11: {
                    return "removeInsetsFrameProvider";
                }
                case 12: {
                    return "setAlwaysOnTop";
                }
                case 13: {
                    return "removeTask";
                }
                case 23: {
                    return "removeRootTask";
                }
                case 14: {
                    return "finishActivity";
                }
                case 15: {
                    return "clearAdjacentRoots";
                }
                case 16: {
                    return "setReparentLeafTaskIfRelaunch";
                }
                case 17: {
                    return "addTaskFragmentOperation";
                }
                case 18: {
                    return "movePipActivityToPinnedTask";
                }
                case 19: {
                    return "setIsTrimmable";
                }
                case 20: {
                    return "restoreBackNav";
                }
                case 21: {
                    return "setExcludeInsetsTypes";
                }
                case 22: {
                    return "setKeyguardState";
                }
                case 25: {
                    return "setSafeRegionBounds";
                }
                case 26: {
                    return "setSystemBarVisibilityOverride";
                }
            }
            return "HOP(" + type + ")";
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{").append(HierarchyOp.hopToString(this.mType)).append(": ");
            switch (this.mType) {
                case 2: {
                    sb.append("from=").append(this.mContainer).append(" to=").append(this.mReparent).append(" mToTop=").append(this.mToTop).append(" mReparentTopOnly=").append(this.mReparentTopOnly).append(" mWindowingMode=").append(Arrays.toString(this.mWindowingModes)).append(" mActivityType=").append(Arrays.toString(this.mActivityTypes));
                    break;
                }
                case 3: {
                    sb.append("container=").append(this.mContainer).append(" mWindowingMode=").append(Arrays.toString(this.mWindowingModes)).append(" mActivityType=").append(Arrays.toString(this.mActivityTypes));
                    break;
                }
                case 0: {
                    sb.append(this.mContainer).append(" to ").append(this.mToTop ? "top of " : "bottom of ").append(this.mReparent);
                    break;
                }
                case 1: {
                    sb.append(this.mContainer).append(" to ").append(this.mToTop ? "top" : "bottom");
                    break;
                }
                case 4: {
                    for (IBinder container : this.mContainers) {
                        if (container == this.mContainers[0]) {
                            sb.append("adjacentRoots=").append(container);
                            continue;
                        }
                        sb.append(", ").append(container);
                    }
                    break;
                }
                case 5: {
                    sb.append(this.mLaunchOptions);
                    break;
                }
                case 24: {
                    sb.append(this.mAppCompatOptions);
                    break;
                }
                case 6: {
                    sb.append("container=").append(this.mContainer).append(" clearRoot=").append(this.mToTop);
                    break;
                }
                case 8: {
                    sb.append("options=").append(this.mLaunchOptions).append(" info=").append(this.mShortcutInfo);
                    break;
                }
                case 7: {
                    sb.append("options=").append(this.mLaunchOptions);
                    break;
                }
                case 10: 
                case 11: {
                    sb.append("container=").append(this.mContainer).append(" provider=").append(this.mInsetsFrameProvider).append(" caller=").append(this.mCaller);
                    break;
                }
                case 12: {
                    sb.append("container=").append(this.mContainer).append(" alwaysOnTop=").append(this.mAlwaysOnTop);
                    break;
                }
                case 13: {
                    sb.append("task=").append(this.mContainer);
                    break;
                }
                case 23: {
                    sb.append("rootTask=").append(this.mContainer);
                    break;
                }
                case 14: {
                    sb.append("activity=").append(this.mContainer);
                    break;
                }
                case 15: {
                    sb.append("container=").append(this.mContainer);
                    break;
                }
                case 16: {
                    sb.append("container= ").append(this.mContainer).append(" reparentLeafTaskIfRelaunch= ").append(this.mReparentLeafTaskIfRelaunch);
                    break;
                }
                case 17: {
                    sb.append("fragmentToken= ").append(this.mContainer).append(" operation= ").append(this.mTaskFragmentOperation);
                    break;
                }
                case 21: {
                    sb.append("container= ").append(this.mContainer).append(" mExcludeInsetsTypes= ").append(WindowInsets.Type.toString(this.mExcludeInsetsTypes));
                    break;
                }
                case 22: {
                    sb.append("KeyguardState= ").append(this.mKeyguardState);
                    break;
                }
                case 19: {
                    sb.append("container= ").append(this.mContainer).append(" isTrimmable= ").append(this.mIsTrimmableFromRecents);
                    break;
                }
                case 25: {
                    sb.append("container= ").append(this.mContainer).append(" safeRegionBounds= ").append(this.mSafeRegionBounds);
                    break;
                }
                case 26: {
                    sb.append(" container=").append(this.mContainer).append(" caller=").append(this.mCaller).append(" mForciblyShowingInsetsTypes=").append(WindowInsets.Type.toString(this.mForciblyShowingInsetsTypes)).append(" mForciblyHidingInsetsTypes=").append(WindowInsets.Type.toString(this.mForciblyHidingInsetsTypes));
                    break;
                }
                default: {
                    sb.append("container=").append(this.mContainer).append(" reparent=").append(this.mReparent).append(" mToTop=").append(this.mToTop).append(" mWindowingMode=").append(Arrays.toString(this.mWindowingModes)).append(" mActivityType=").append(Arrays.toString(this.mActivityTypes));
                }
            }
            return sb.append("}").toString();
        }

        @Override
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeInt(this.mType);
            dest.writeStrongBinder(this.mContainer);
            dest.writeBinderArray(this.mContainers);
            dest.writeTypedObject(this.mBounds, flags);
            dest.writeBoolean(this.mIncludingParents);
            dest.writeStrongBinder(this.mReparent);
            dest.writeTypedObject(this.mInsetsFrameProvider, flags);
            dest.writeStrongBinder(this.mCaller);
            dest.writeBoolean(this.mToTop);
            dest.writeBoolean(this.mReparentTopOnly);
            dest.writeIntArray(this.mWindowingModes);
            dest.writeIntArray(this.mActivityTypes);
            dest.writeBundle(this.mLaunchOptions);
            dest.writeBundle(this.mAppCompatOptions);
            dest.writeTypedObject(this.mActivityIntent, flags);
            dest.writeTypedObject(this.mTaskFragmentOperation, flags);
            dest.writeTypedObject(this.mKeyguardState, flags);
            dest.writeTypedObject(this.mPendingIntent, flags);
            dest.writeTypedObject(this.mShortcutInfo, flags);
            dest.writeBoolean(this.mAlwaysOnTop);
            dest.writeBoolean(this.mReparentLeafTaskIfRelaunch);
            dest.writeBoolean(this.mIsTrimmableFromRecents);
            dest.writeInt(this.mExcludeInsetsTypes);
            dest.writeInt(this.mForciblyShowingInsetsTypes);
            dest.writeInt(this.mForciblyHidingInsetsTypes);
            dest.writeTypedObject(this.mSafeRegionBounds, flags);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        private static class Builder {
            private final int mType;
            @Nullable
            private IBinder mContainer;
            @Nullable
            private IBinder[] mContainers;
            @Nullable
            private IBinder mReparent;
            @Nullable
            private InsetsFrameProvider mInsetsFrameProvider;
            @Nullable
            private IBinder mCaller;
            private boolean mToTop;
            private boolean mReparentTopOnly;
            @Nullable
            private int[] mWindowingModes;
            @Nullable
            private int[] mActivityTypes;
            @Nullable
            private Bundle mLaunchOptions;
            @Nullable
            private Bundle mAppCompatOptions;
            @Nullable
            private Intent mActivityIntent;
            @Nullable
            private TaskFragmentOperation mTaskFragmentOperation;
            @Nullable
            private KeyguardState mKeyguardState;
            @Nullable
            private PendingIntent mPendingIntent;
            @Nullable
            private ShortcutInfo mShortcutInfo;
            @Nullable
            private Rect mBounds;
            private boolean mIncludingParents;
            private boolean mAlwaysOnTop;
            private boolean mReparentLeafTaskIfRelaunch;
            private boolean mIsTrimmableFromRecents;
            private int mExcludeInsetsTypes;
            private int mForciblyShowingInsetsTypes;
            private int mForciblyHidingInsetsTypes;
            @Nullable
            private Rect mSafeRegionBounds;

            Builder(int type) {
                this.mType = type;
            }

            Builder setContainer(@Nullable IBinder container) {
                this.mContainer = container;
                return this;
            }

            Builder setContainers(@Nullable IBinder[] containers) {
                this.mContainers = containers;
                return this;
            }

            Builder setReparentContainer(@Nullable IBinder reparentContainer) {
                this.mReparent = reparentContainer;
                return this;
            }

            Builder setInsetsFrameProvider(InsetsFrameProvider provider) {
                this.mInsetsFrameProvider = provider;
                return this;
            }

            Builder setCaller(@Nullable IBinder caller) {
                this.mCaller = caller;
                return this;
            }

            Builder setToTop(boolean toTop) {
                this.mToTop = toTop;
                return this;
            }

            Builder setReparentTopOnly(boolean reparentTopOnly) {
                this.mReparentTopOnly = reparentTopOnly;
                return this;
            }

            Builder setWindowingModes(@Nullable int[] windowingModes) {
                this.mWindowingModes = windowingModes;
                return this;
            }

            Builder setActivityTypes(@Nullable int[] activityTypes) {
                this.mActivityTypes = activityTypes;
                return this;
            }

            Builder setLaunchOptions(@Nullable Bundle launchOptions) {
                this.mLaunchOptions = launchOptions;
                return this;
            }

            Builder setAppCompatOptions(@Nullable Bundle appCompatOptions) {
                this.mAppCompatOptions = appCompatOptions;
                return this;
            }

            Builder setActivityIntent(@Nullable Intent activityIntent) {
                this.mActivityIntent = activityIntent;
                return this;
            }

            Builder setPendingIntent(@Nullable PendingIntent sender) {
                this.mPendingIntent = sender;
                return this;
            }

            Builder setAlwaysOnTop(boolean alwaysOnTop) {
                this.mAlwaysOnTop = alwaysOnTop;
                return this;
            }

            Builder setTaskFragmentOperation(@Nullable TaskFragmentOperation taskFragmentOperation) {
                this.mTaskFragmentOperation = taskFragmentOperation;
                return this;
            }

            Builder setKeyguardState(@Nullable KeyguardState keyguardState) {
                this.mKeyguardState = keyguardState;
                return this;
            }

            Builder setReparentLeafTaskIfRelaunch(boolean reparentLeafTaskIfRelaunch) {
                this.mReparentLeafTaskIfRelaunch = reparentLeafTaskIfRelaunch;
                return this;
            }

            Builder setShortcutInfo(@Nullable ShortcutInfo shortcutInfo) {
                this.mShortcutInfo = shortcutInfo;
                return this;
            }

            Builder setBounds(@NonNull Rect bounds) {
                this.mBounds = bounds;
                return this;
            }

            Builder setIncludingParents(boolean value) {
                this.mIncludingParents = value;
                return this;
            }

            Builder setIsTrimmableFromRecents(boolean isTrimmableFromRecents) {
                this.mIsTrimmableFromRecents = isTrimmableFromRecents;
                return this;
            }

            Builder setExcludeInsetsTypes(int excludeInsetsTypes) {
                this.mExcludeInsetsTypes = excludeInsetsTypes;
                return this;
            }

            Builder setSystemBarVisibilityOverride(int forciblyShowingInsetsTypes, int forciblyHidingInsetsTypes) {
                this.mForciblyShowingInsetsTypes = forciblyShowingInsetsTypes;
                this.mForciblyHidingInsetsTypes = forciblyHidingInsetsTypes;
                return this;
            }

            Builder setSafeRegionBounds(Rect safeRegionBounds) {
                this.mSafeRegionBounds = safeRegionBounds;
                return this;
            }

            @NonNull
            HierarchyOp build() {
                HierarchyOp hierarchyOp = new HierarchyOp(this.mType);
                hierarchyOp.mContainer = this.mContainer;
                hierarchyOp.mContainers = this.mContainers;
                hierarchyOp.mReparent = this.mReparent;
                hierarchyOp.mWindowingModes = this.mWindowingModes != null ? Arrays.copyOf(this.mWindowingModes, this.mWindowingModes.length) : null;
                hierarchyOp.mActivityTypes = this.mActivityTypes != null ? Arrays.copyOf(this.mActivityTypes, this.mActivityTypes.length) : null;
                hierarchyOp.mInsetsFrameProvider = this.mInsetsFrameProvider;
                hierarchyOp.mCaller = this.mCaller;
                hierarchyOp.mToTop = this.mToTop;
                hierarchyOp.mReparentTopOnly = this.mReparentTopOnly;
                hierarchyOp.mLaunchOptions = this.mLaunchOptions;
                hierarchyOp.mAppCompatOptions = this.mAppCompatOptions;
                hierarchyOp.mActivityIntent = this.mActivityIntent;
                hierarchyOp.mPendingIntent = this.mPendingIntent;
                hierarchyOp.mAlwaysOnTop = this.mAlwaysOnTop;
                hierarchyOp.mTaskFragmentOperation = this.mTaskFragmentOperation;
                hierarchyOp.mKeyguardState = this.mKeyguardState;
                hierarchyOp.mShortcutInfo = this.mShortcutInfo;
                hierarchyOp.mBounds = this.mBounds;
                hierarchyOp.mIncludingParents = this.mIncludingParents;
                hierarchyOp.mReparentLeafTaskIfRelaunch = this.mReparentLeafTaskIfRelaunch;
                hierarchyOp.mIsTrimmableFromRecents = this.mIsTrimmableFromRecents;
                hierarchyOp.mExcludeInsetsTypes = this.mExcludeInsetsTypes;
                hierarchyOp.mForciblyShowingInsetsTypes = this.mForciblyShowingInsetsTypes;
                hierarchyOp.mForciblyHidingInsetsTypes = this.mForciblyHidingInsetsTypes;
                hierarchyOp.mSafeRegionBounds = this.mSafeRegionBounds;
                return hierarchyOp;
            }
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface HierarchyOpType {
        }
    }

    public static class Change
    implements Parcelable {
        public static final int CHANGE_FOCUSABLE = 1;
        public static final int CHANGE_BOUNDS_TRANSACTION = 2;
        public static final int CHANGE_PIP_CALLBACK = 4;
        public static final int CHANGE_HIDDEN = 8;
        public static final int CHANGE_IGNORE_ORIENTATION_REQUEST = 16;
        public static final int CHANGE_FORCE_NO_PIP = 32;
        public static final int CHANGE_FORCE_TRANSLUCENT = 64;
        public static final int CHANGE_DRAG_RESIZING = 128;
        public static final int CHANGE_RELATIVE_BOUNDS = 256;
        public static final int CHANGE_FORCE_EXCLUDED_FROM_RECENTS = 512;
        public static final int CHANGE_LAUNCH_NEXT_TO_BUBBLE = 1024;
        public static final int CHANGE_DISABLE_PIP = 2048;
        public static final int CHANGE_DISABLE_LAUNCH_ADJACENT = 4096;
        public static final int CHANGE_IS_TASK_MOVE_ALLOWED = 8192;
        public static final int CHANGE_INTERCEPT_BACK_PRESSED = 16384;
        private final Configuration mConfiguration = new Configuration();
        private boolean mFocusable = true;
        private boolean mHidden = false;
        private boolean mIgnoreOrientationRequest = false;
        private boolean mForceTranslucent = false;
        private boolean mDragResizing = false;
        private boolean mForceExcludedFromRecents = false;
        private boolean mDisablePip = false;
        private boolean mDisableLaunchAdjacent = false;
        private boolean mIsTaskMoveAllowed = false;
        private boolean mInterceptBackPressed = false;
        private int mChangeMask = 0;
        private int mConfigSetMask = 0;
        @WindowConfiguration.WindowConfig
        private int mWindowSetMask = 0;
        private SurfaceControl.Transaction mBoundsChangeTransaction = null;
        @Nullable
        private Rect mRelativeBounds = null;
        private boolean mConfigAtTransitionEnd = false;
        private int mActivityWindowingMode = -1;
        private int mWindowingMode = -1;
        @TaskInfo.SelfMovable
        private int mSelfMovable = -1;
        private boolean mLaunchNextToBubble = false;
        public static final Parcelable.Creator<Change> CREATOR = new Parcelable.Creator<Change>(){

            @Override
            public Change createFromParcel(@NonNull Parcel in) {
                return new Change(in);
            }

            public Change[] newArray(int size) {
                return new Change[size];
            }
        };

        private Change() {
        }

        private Change(@NonNull Parcel in) {
            this.mConfiguration.readFromParcel(in);
            this.mFocusable = in.readBoolean();
            this.mHidden = in.readBoolean();
            this.mIgnoreOrientationRequest = in.readBoolean();
            this.mForceTranslucent = in.readBoolean();
            this.mDragResizing = in.readBoolean();
            this.mForceExcludedFromRecents = in.readBoolean();
            this.mLaunchNextToBubble = in.readBoolean();
            this.mDisablePip = in.readBoolean();
            this.mDisableLaunchAdjacent = in.readBoolean();
            this.mIsTaskMoveAllowed = in.readBoolean();
            this.mInterceptBackPressed = in.readBoolean();
            this.mChangeMask = in.readInt();
            this.mConfigSetMask = in.readInt();
            this.mWindowSetMask = in.readInt();
            if ((this.mChangeMask & 2) != 0) {
                this.mBoundsChangeTransaction = SurfaceControl.Transaction.CREATOR.createFromParcel(in);
            }
            if ((this.mChangeMask & 0x100) != 0) {
                this.mRelativeBounds = new Rect();
                this.mRelativeBounds.readFromParcel(in);
            }
            this.mConfigAtTransitionEnd = in.readBoolean();
            this.mWindowingMode = in.readInt();
            this.mActivityWindowingMode = in.readInt();
            this.mSelfMovable = in.readInt();
        }

        public void merge(@NonNull Change other, boolean transfer) {
            this.mConfiguration.setTo(other.mConfiguration, other.mConfigSetMask, other.mWindowSetMask);
            this.mConfigSetMask |= other.mConfigSetMask;
            this.mWindowSetMask |= other.mWindowSetMask;
            if ((other.mChangeMask & 1) != 0) {
                this.mFocusable = other.mFocusable;
            }
            if (transfer && (other.mChangeMask & 2) != 0) {
                this.mBoundsChangeTransaction = other.mBoundsChangeTransaction;
                other.mBoundsChangeTransaction = null;
            }
            if ((other.mChangeMask & 8) != 0) {
                this.mHidden = other.mHidden;
            }
            if ((other.mChangeMask & 0x10) != 0) {
                this.mIgnoreOrientationRequest = other.mIgnoreOrientationRequest;
            }
            if ((other.mChangeMask & 0x40) != 0) {
                this.mForceTranslucent = other.mForceTranslucent;
            }
            if ((other.mChangeMask & 0x80) != 0) {
                this.mDragResizing = other.mDragResizing;
            }
            if ((other.mChangeMask & 0x200) != 0) {
                this.mForceExcludedFromRecents = other.mForceExcludedFromRecents;
            }
            if ((other.mChangeMask & 0x400) != 0) {
                this.mLaunchNextToBubble = other.mLaunchNextToBubble;
            }
            if ((other.mChangeMask & 0x800) != 0) {
                this.mDisablePip = other.mDisablePip;
            }
            if ((other.mChangeMask & 0x1000) != 0) {
                this.mDisableLaunchAdjacent = other.mDisableLaunchAdjacent;
            }
            if ((other.mChangeMask & 0x2000) != 0) {
                this.mIsTaskMoveAllowed = other.mIsTaskMoveAllowed;
            }
            if ((other.mChangeMask & 0x4000) != 0) {
                this.mInterceptBackPressed = other.mInterceptBackPressed;
            }
            this.mChangeMask |= other.mChangeMask;
            if (other.mActivityWindowingMode >= 0) {
                this.mActivityWindowingMode = other.mActivityWindowingMode;
            }
            if (other.mWindowingMode >= 0) {
                this.mWindowingMode = other.mWindowingMode;
            }
            if (other.mSelfMovable != -1) {
                this.mSelfMovable = other.mSelfMovable;
            }
            if (other.mRelativeBounds != null) {
                this.mRelativeBounds = transfer ? other.mRelativeBounds : new Rect(other.mRelativeBounds);
            }
            this.mConfigAtTransitionEnd = this.mConfigAtTransitionEnd || other.mConfigAtTransitionEnd;
        }

        public int getWindowingMode() {
            return this.mWindowingMode;
        }

        public int getActivityWindowingMode() {
            return this.mActivityWindowingMode;
        }

        @NonNull
        public Configuration getConfiguration() {
            return this.mConfiguration;
        }

        public boolean getLaunchNextToBubble() {
            if ((this.mChangeMask & 0x400) == 0) {
                throw new RuntimeException("mLaunchNextToBubble not set. check CHANGE_LAUNCH_NEXT_TO_BUBBLE first");
            }
            return this.mLaunchNextToBubble;
        }

        public boolean getFocusable() {
            if ((this.mChangeMask & 1) == 0) {
                throw new RuntimeException("Focusable not set. check CHANGE_FOCUSABLE first");
            }
            return this.mFocusable;
        }

        public boolean getHidden() {
            if ((this.mChangeMask & 8) == 0) {
                throw new RuntimeException("Hidden not set. check CHANGE_HIDDEN first");
            }
            return this.mHidden;
        }

        public boolean getIgnoreOrientationRequest() {
            if ((this.mChangeMask & 0x10) == 0) {
                throw new RuntimeException("IgnoreOrientationRequest not set. Check CHANGE_IGNORE_ORIENTATION_REQUEST first");
            }
            return this.mIgnoreOrientationRequest;
        }

        public boolean getForceTranslucent() {
            if ((this.mChangeMask & 0x40) == 0) {
                throw new RuntimeException("Force translucent not set. Check CHANGE_FORCE_TRANSLUCENT first");
            }
            return this.mForceTranslucent;
        }

        public boolean getDragResizing() {
            if ((this.mChangeMask & 0x80) == 0) {
                throw new RuntimeException("Drag resizing not set. Check CHANGE_DRAG_RESIZING first");
            }
            return this.mDragResizing;
        }

        public boolean getForceExcludedFromRecents() {
            if (!Flags.excludeTaskFromRecents()) {
                throw new IllegalStateException("Flag com.android.window.flags.exclude_task_from_recents is not enabled");
            }
            return this.mForceExcludedFromRecents;
        }

        public boolean getDisablePip() {
            return this.mDisablePip;
        }

        public boolean getDisableLaunchAdjacent() {
            return this.mDisableLaunchAdjacent;
        }

        public boolean getInterceptBackPressed() {
            if ((this.mChangeMask & 0x4000) == 0) {
                throw new RuntimeException("Intercept back pressed not set. Check CHANGE_INTERCEPT_BACK_PRESSED first");
            }
            return this.mInterceptBackPressed;
        }

        public boolean getConfigAtTransitionEnd() {
            return this.mConfigAtTransitionEnd;
        }

        @TaskInfo.SelfMovable
        public int getSelfMovable() {
            return this.mSelfMovable;
        }

        public boolean getIsTaskMoveAllowed() {
            return this.mIsTaskMoveAllowed;
        }

        public int getChangeMask() {
            return this.mChangeMask;
        }

        public int getConfigSetMask() {
            return this.mConfigSetMask;
        }

        @WindowConfiguration.WindowConfig
        public int getWindowSetMask() {
            return this.mWindowSetMask;
        }

        @Nullable
        public SurfaceControl.Transaction getBoundsChangeTransaction() {
            return this.mBoundsChangeTransaction;
        }

        @Nullable
        public Rect getRelativeBounds() {
            return this.mRelativeBounds;
        }

        public String toString() {
            boolean changesBounds = (this.mConfigSetMask & 0x20000000) != 0 && (this.mWindowSetMask & 1) != 0;
            boolean changesAppBounds = (this.mConfigSetMask & 0x20000000) != 0 && (this.mWindowSetMask & 2) != 0;
            boolean changesSs = (this.mConfigSetMask & 0x400) != 0;
            boolean changesSss = (this.mConfigSetMask & 0x800) != 0;
            StringBuilder sb = new StringBuilder();
            sb.append('{');
            if (changesBounds) {
                sb.append("bounds:").append(this.mConfiguration.windowConfiguration.getBounds()).append(",");
            }
            if (changesAppBounds) {
                sb.append("appbounds:").append(this.mConfiguration.windowConfiguration.getAppBounds()).append(",");
            }
            if (changesSss) {
                sb.append("ssw:").append(this.mConfiguration.smallestScreenWidthDp).append(",");
            }
            if (changesSs) {
                sb.append("sw/h:").append(this.mConfiguration.screenWidthDp).append("x").append(this.mConfiguration.screenHeightDp).append(",");
            }
            if ((this.mChangeMask & 1) != 0) {
                sb.append("focusable:").append(this.mFocusable).append(",");
            }
            if ((this.mChangeMask & 0x40) != 0) {
                sb.append("forceTranslucent:").append(this.mForceTranslucent).append(",");
            }
            if ((this.mChangeMask & 8) != 0) {
                sb.append("hidden:").append(this.mHidden).append(",");
            }
            if ((this.mChangeMask & 0x80) != 0) {
                sb.append("dragResizing:").append(this.mDragResizing).append(",");
            }
            if ((this.mChangeMask & 0x200) != 0) {
                sb.append("forceExcludedFromRecents:").append(this.mForceExcludedFromRecents).append(",");
            }
            if ((this.mChangeMask & 0x800) != 0) {
                sb.append("disablePip:").append(this.mDisablePip).append(",");
            }
            if ((this.mChangeMask & 0x1000) != 0) {
                sb.append("disableLaunchAdjacent:").append(this.mDisableLaunchAdjacent).append(",");
            }
            if ((this.mChangeMask & 0x2000) != 0) {
                sb.append("isTaskMoveAllowed:").append(this.mIsTaskMoveAllowed).append(",");
            }
            if ((this.mChangeMask & 0x4000) != 0) {
                sb.append("interceptBack:" + this.mInterceptBackPressed + ",");
            }
            if (this.mBoundsChangeTransaction != null) {
                sb.append("hasBoundsTransaction,");
            }
            if ((this.mChangeMask & 0x10) != 0) {
                sb.append("ignoreOrientationRequest:").append(this.mIgnoreOrientationRequest).append(",");
            }
            if ((this.mChangeMask & 0x100) != 0) {
                sb.append("relativeBounds:").append(this.mRelativeBounds).append(",");
            }
            if ((this.mChangeMask & 0x400) != 0) {
                sb.append("launchNextToBubble:").append(this.mLaunchNextToBubble).append(",");
            }
            if (this.mConfigAtTransitionEnd) {
                sb.append("configAtTransitionEnd").append(",");
            }
            sb.append("}");
            return sb.toString();
        }

        @Override
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            this.mConfiguration.writeToParcel(dest, flags);
            dest.writeBoolean(this.mFocusable);
            dest.writeBoolean(this.mHidden);
            dest.writeBoolean(this.mIgnoreOrientationRequest);
            dest.writeBoolean(this.mForceTranslucent);
            dest.writeBoolean(this.mDragResizing);
            dest.writeBoolean(this.mForceExcludedFromRecents);
            dest.writeBoolean(this.mLaunchNextToBubble);
            dest.writeBoolean(this.mDisablePip);
            dest.writeBoolean(this.mDisableLaunchAdjacent);
            dest.writeBoolean(this.mIsTaskMoveAllowed);
            dest.writeBoolean(this.mInterceptBackPressed);
            dest.writeInt(this.mChangeMask);
            dest.writeInt(this.mConfigSetMask);
            dest.writeInt(this.mWindowSetMask);
            if (this.mBoundsChangeTransaction != null) {
                this.mBoundsChangeTransaction.writeToParcel(dest, flags);
            }
            if (this.mRelativeBounds != null) {
                this.mRelativeBounds.writeToParcel(dest, flags);
            }
            dest.writeBoolean(this.mConfigAtTransitionEnd);
            dest.writeInt(this.mWindowingMode);
            dest.writeInt(this.mActivityWindowingMode);
            dest.writeInt(this.mSelfMovable);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface ChangeMask {
        }
    }

    public static class TaskFragmentAdjacentParams {
        private static final String DELAY_PRIMARY_LAST_ACTIVITY_REMOVAL = "android:transaction.adjacent.option.delay_primary_removal";
        private static final String DELAY_SECONDARY_LAST_ACTIVITY_REMOVAL = "android:transaction.adjacent.option.delay_secondary_removal";
        private boolean mDelayPrimaryLastActivityRemoval;
        private boolean mDelaySecondaryLastActivityRemoval;

        public TaskFragmentAdjacentParams() {
        }

        public TaskFragmentAdjacentParams(@NonNull Bundle bundle) {
            this.mDelayPrimaryLastActivityRemoval = bundle.getBoolean(DELAY_PRIMARY_LAST_ACTIVITY_REMOVAL);
            this.mDelaySecondaryLastActivityRemoval = bundle.getBoolean(DELAY_SECONDARY_LAST_ACTIVITY_REMOVAL);
        }

        public void setShouldDelayPrimaryLastActivityRemoval(boolean delay) {
            this.mDelayPrimaryLastActivityRemoval = delay;
        }

        public void setShouldDelaySecondaryLastActivityRemoval(boolean delay) {
            this.mDelaySecondaryLastActivityRemoval = delay;
        }

        public boolean shouldDelayPrimaryLastActivityRemoval() {
            return this.mDelayPrimaryLastActivityRemoval;
        }

        public boolean shouldDelaySecondaryLastActivityRemoval() {
            return this.mDelaySecondaryLastActivityRemoval;
        }

        @NonNull
        Bundle toBundle() {
            Bundle b = new Bundle();
            b.putBoolean(DELAY_PRIMARY_LAST_ACTIVITY_REMOVAL, this.mDelayPrimaryLastActivityRemoval);
            b.putBoolean(DELAY_SECONDARY_LAST_ACTIVITY_REMOVAL, this.mDelaySecondaryLastActivityRemoval);
            return b;
        }
    }
}

