/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.annotation.FlaggedApi;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.layoutlib.androidx.annotation.NonNull;
import java.util.Objects;

@FlaggedApi(value="com.android.window.flags.trusted_presentation_listener_for_window")
public class TrustedPresentationThresholds
implements Parcelable {
    private final float mMinAlpha;
    private final float mMinFractionRendered;
    private final int mStabilityRequirementMs;
    @FlaggedApi(value="com.android.window.flags.trusted_presentation_listener_for_window")
    @NonNull
    public static final Parcelable.Creator<TrustedPresentationThresholds> CREATOR = new Parcelable.Creator<TrustedPresentationThresholds>(){

        @FlaggedApi(value="com.android.window.flags.trusted_presentation_listener_for_window")
        public TrustedPresentationThresholds[] newArray(int size) {
            return new TrustedPresentationThresholds[size];
        }

        @Override
        @FlaggedApi(value="com.android.window.flags.trusted_presentation_listener_for_window")
        public TrustedPresentationThresholds createFromParcel(@NonNull Parcel in) {
            return new TrustedPresentationThresholds(in);
        }
    };

    @FlaggedApi(value="com.android.window.flags.trusted_presentation_listener_for_window")
    public float getMinAlpha() {
        return this.mMinAlpha;
    }

    @FlaggedApi(value="com.android.window.flags.trusted_presentation_listener_for_window")
    public float getMinFractionRendered() {
        return this.mMinFractionRendered;
    }

    @FlaggedApi(value="com.android.window.flags.trusted_presentation_listener_for_window")
    public int getStabilityRequirementMillis() {
        return this.mStabilityRequirementMs;
    }

    private void checkValid() {
        if (this.mMinAlpha <= 0.0f || this.mMinFractionRendered <= 0.0f || this.mStabilityRequirementMs < 1) {
            throw new IllegalArgumentException("TrustedPresentationThresholds values are invalid");
        }
    }

    @FlaggedApi(value="com.android.window.flags.trusted_presentation_listener_for_window")
    public TrustedPresentationThresholds(float minAlpha, float minFractionRendered, int stabilityRequirementMs) {
        this.mMinAlpha = minAlpha;
        this.mMinFractionRendered = minFractionRendered;
        this.mStabilityRequirementMs = stabilityRequirementMs;
        this.checkValid();
    }

    @FlaggedApi(value="com.android.window.flags.trusted_presentation_listener_for_window")
    public String toString() {
        return "TrustedPresentationThresholds { minAlpha = " + this.mMinAlpha + ", minFractionRendered = " + this.mMinFractionRendered + ", stabilityRequirementMs = " + this.mStabilityRequirementMs + " }";
    }

    @Override
    @FlaggedApi(value="com.android.window.flags.trusted_presentation_listener_for_window")
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeFloat(this.mMinAlpha);
        dest.writeFloat(this.mMinFractionRendered);
        dest.writeInt(this.mStabilityRequirementMs);
    }

    @Override
    @FlaggedApi(value="com.android.window.flags.trusted_presentation_listener_for_window")
    public int describeContents() {
        return 0;
    }

    @FlaggedApi(value="com.android.window.flags.trusted_presentation_listener_for_window")
    public int hashCode() {
        return Objects.hash(Float.valueOf(this.mMinAlpha), Float.valueOf(this.mMinFractionRendered), this.mStabilityRequirementMs);
    }

    @FlaggedApi(value="com.android.window.flags.trusted_presentation_listener_for_window")
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TrustedPresentationThresholds)) {
            return false;
        }
        TrustedPresentationThresholds that = (TrustedPresentationThresholds)o;
        return this.mMinAlpha == that.mMinAlpha && this.mMinFractionRendered == that.mMinFractionRendered && this.mStabilityRequirementMs == that.mStabilityRequirementMs;
    }

    TrustedPresentationThresholds(@NonNull Parcel in) {
        this.mMinAlpha = in.readFloat();
        this.mMinFractionRendered = in.readFloat();
        this.mStabilityRequirementMs = in.readInt();
        this.checkValid();
    }
}

