/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

public class TaskFragmentAnimationParams
implements Parcelable {
    public static final TaskFragmentAnimationParams DEFAULT = new Builder().build();
    public static final int DEFAULT_ANIMATION_BACKGROUND_COLOR = 0;
    private final int mAnimationBackgroundColor;
    private final int mOpenAnimationResId;
    private final int mChangeAnimationResId;
    private final int mCloseAnimationResId;
    @NonNull
    public static final Parcelable.Creator<TaskFragmentAnimationParams> CREATOR = new Parcelable.Creator<TaskFragmentAnimationParams>(){

        @Override
        public TaskFragmentAnimationParams createFromParcel(Parcel in) {
            return new TaskFragmentAnimationParams(in);
        }

        public TaskFragmentAnimationParams[] newArray(int size) {
            return new TaskFragmentAnimationParams[size];
        }
    };

    private TaskFragmentAnimationParams(int animationBackgroundColor, int openAnimationResId, int changeAnimationResId, int closeAnimationResId) {
        this.mAnimationBackgroundColor = animationBackgroundColor;
        this.mOpenAnimationResId = openAnimationResId;
        this.mChangeAnimationResId = changeAnimationResId;
        this.mCloseAnimationResId = closeAnimationResId;
    }

    public int getAnimationBackgroundColor() {
        return this.mAnimationBackgroundColor;
    }

    public int getOpenAnimationResId() {
        return this.mOpenAnimationResId;
    }

    public int getChangeAnimationResId() {
        return this.mChangeAnimationResId;
    }

    public int getCloseAnimationResId() {
        return this.mCloseAnimationResId;
    }

    private TaskFragmentAnimationParams(Parcel in) {
        this.mAnimationBackgroundColor = in.readInt();
        this.mOpenAnimationResId = in.readInt();
        this.mChangeAnimationResId = in.readInt();
        this.mCloseAnimationResId = in.readInt();
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mAnimationBackgroundColor);
        dest.writeInt(this.mOpenAnimationResId);
        dest.writeInt(this.mChangeAnimationResId);
        dest.writeInt(this.mCloseAnimationResId);
    }

    public String toString() {
        return "TaskFragmentAnimationParams{ animationBgColor=" + Integer.toHexString(this.mAnimationBackgroundColor) + " openAnimResId=" + this.mOpenAnimationResId + " changeAnimResId=" + this.mChangeAnimationResId + " closeAnimResId=" + this.mCloseAnimationResId + "}";
    }

    public int hashCode() {
        return Objects.hash(this.mAnimationBackgroundColor, this.mOpenAnimationResId, this.mChangeAnimationResId, this.mCloseAnimationResId);
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof TaskFragmentAnimationParams)) {
            return false;
        }
        TaskFragmentAnimationParams other = (TaskFragmentAnimationParams)obj;
        return this.mAnimationBackgroundColor == other.mAnimationBackgroundColor && this.mOpenAnimationResId == other.mOpenAnimationResId && this.mChangeAnimationResId == other.mChangeAnimationResId && this.mCloseAnimationResId == other.mCloseAnimationResId;
    }

    public boolean hasOverrideAnimation() {
        return this.mOpenAnimationResId != -1 || this.mChangeAnimationResId != -1 || this.mCloseAnimationResId != -1;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static class Builder {
        private int mAnimationBackgroundColor = 0;
        private int mOpenAnimationResId = -1;
        private int mChangeAnimationResId = -1;
        private int mCloseAnimationResId = -1;

        @NonNull
        public Builder setAnimationBackgroundColor(int color2) {
            this.mAnimationBackgroundColor = color2;
            return this;
        }

        @NonNull
        public Builder setOpenAnimationResId(int resId) {
            this.mOpenAnimationResId = resId;
            return this;
        }

        @NonNull
        public Builder setChangeAnimationResId(int resId) {
            this.mChangeAnimationResId = resId;
            return this;
        }

        @NonNull
        public Builder setCloseAnimationResId(int resId) {
            this.mCloseAnimationResId = resId;
            return this;
        }

        @NonNull
        public TaskFragmentAnimationParams build() {
            return new TaskFragmentAnimationParams(this.mAnimationBackgroundColor, this.mOpenAnimationResId, this.mChangeAnimationResId, this.mCloseAnimationResId);
        }
    }
}

