/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.Context;
import android.util.Pair;
import android.window.ImeOnBackInvokedDispatcher;
import android.window.OnBackInvokedCallback;
import android.window.OnBackInvokedDispatcher;
import android.window.WindowOnBackInvokedDispatcher;
import com.android.internal.hidden_from_bootclasspath.com.android.window.flags.Flags;
import java.util.ArrayList;
import java.util.List;

public class ProxyOnBackInvokedDispatcher
implements OnBackInvokedDispatcher {
    private final List<Pair<OnBackInvokedCallback, Integer>> mCallbacks = new ArrayList<Pair<OnBackInvokedCallback, Integer>>();
    private final Object mLock = new Object();
    private OnBackInvokedDispatcher mActualDispatcher = null;
    private ImeOnBackInvokedDispatcher mImeDispatcher;
    private final WindowOnBackInvokedDispatcher.Checker mChecker;

    public ProxyOnBackInvokedDispatcher(@NonNull Context context) {
        this.mChecker = new WindowOnBackInvokedDispatcher.Checker(context);
    }

    @Override
    public void registerOnBackInvokedCallback(int priority, @NonNull OnBackInvokedCallback callback) {
        if (this.mChecker.checkApplicationCallbackRegistration(priority, callback)) {
            this.registerOnBackInvokedCallbackUnchecked(callback, priority);
        }
    }

    @Override
    public void registerSystemOnBackInvokedCallback(@NonNull OnBackInvokedCallback callback) {
        this.registerOnBackInvokedCallbackUnchecked(callback, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterOnBackInvokedCallback(@NonNull OnBackInvokedCallback callback) {
        Object object = this.mLock;
        synchronized (object) {
            this.mCallbacks.removeIf(p -> ((OnBackInvokedCallback)p.first).equals(callback));
            if (this.mActualDispatcher != null) {
                this.mActualDispatcher.unregisterOnBackInvokedCallback(callback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerOnBackInvokedCallbackUnchecked(@NonNull OnBackInvokedCallback callback, int priority) {
        Object object = this.mLock;
        synchronized (object) {
            this.mCallbacks.add(Pair.create(callback, priority));
            if (this.mActualDispatcher != null) {
                if (priority == -1) {
                    this.mActualDispatcher.registerSystemOnBackInvokedCallback(callback);
                } else {
                    this.mActualDispatcher.registerOnBackInvokedCallback(priority, callback);
                }
            }
        }
    }

    private void transferCallbacksToDispatcher() {
        if (this.mActualDispatcher == null) {
            return;
        }
        if (this.mImeDispatcher != null) {
            this.mActualDispatcher.setImeOnBackInvokedDispatcher(this.mImeDispatcher);
        }
        for (Pair<OnBackInvokedCallback, Integer> callbackPair : this.mCallbacks) {
            int priority = (Integer)callbackPair.second;
            if (Flags.predictiveBackPrioritySystemNavigationObserver()) {
                if (priority >= 0 || priority == -2) {
                    this.mActualDispatcher.registerOnBackInvokedCallback(priority, (OnBackInvokedCallback)callbackPair.first);
                    continue;
                }
                this.mActualDispatcher.registerSystemOnBackInvokedCallback((OnBackInvokedCallback)callbackPair.first);
                continue;
            }
            if (priority >= 0) {
                this.mActualDispatcher.registerOnBackInvokedCallback(priority, (OnBackInvokedCallback)callbackPair.first);
                continue;
            }
            this.mActualDispatcher.registerSystemOnBackInvokedCallback((OnBackInvokedCallback)callbackPair.first);
        }
        this.mCallbacks.clear();
        this.mImeDispatcher = null;
    }

    private void clearCallbacksOnDispatcher() {
        if (this.mActualDispatcher == null) {
            return;
        }
        for (Pair<OnBackInvokedCallback, Integer> callback : this.mCallbacks) {
            this.mActualDispatcher.unregisterOnBackInvokedCallback((OnBackInvokedCallback)callback.first);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.mLock;
        synchronized (object) {
            this.mCallbacks.clear();
            this.mImeDispatcher = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActualDispatcher(@Nullable OnBackInvokedDispatcher actualDispatcher) {
        Object object = this.mLock;
        synchronized (object) {
            if (actualDispatcher == this.mActualDispatcher) {
                return;
            }
            this.clearCallbacksOnDispatcher();
            this.mActualDispatcher = actualDispatcher;
            this.transferCallbacksToDispatcher();
        }
    }

    @Override
    public void setImeOnBackInvokedDispatcher(@NonNull ImeOnBackInvokedDispatcher imeDispatcher) {
        if (this.mActualDispatcher != null) {
            this.mActualDispatcher.setImeOnBackInvokedDispatcher(imeDispatcher);
        } else {
            this.mImeDispatcher = imeDispatcher;
        }
    }
}

