/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.SurfaceControl;
import android.window.StartingWindowRemovalInfo;
import android.window.TransitionInfo;
import android.window.TransitionRequestInfo;

public interface ITransitionPlayer
extends IInterface {
    public static final String DESCRIPTOR = "android.window.ITransitionPlayer";

    public void onTransitionReady(IBinder var1, TransitionInfo var2, SurfaceControl.Transaction var3, SurfaceControl.Transaction var4) throws RemoteException;

    public void requestStartTransition(IBinder var1, TransitionRequestInfo var2) throws RemoteException;

    public void removeStartingWindow(StartingWindowRemovalInfo var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ITransitionPlayer {
        static final int TRANSACTION_onTransitionReady = 1;
        static final int TRANSACTION_requestStartTransition = 2;
        static final int TRANSACTION_removeStartingWindow = 3;

        public Stub() {
            this.attachInterface(this, ITransitionPlayer.DESCRIPTOR);
        }

        public static ITransitionPlayer asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ITransitionPlayer.DESCRIPTOR);
            if (iin != null && iin instanceof ITransitionPlayer) {
                return (ITransitionPlayer)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onTransitionReady";
                }
                case 2: {
                    return "requestStartTransition";
                }
                case 3: {
                    return "removeStartingWindow";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ITransitionPlayer.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    IBinder _arg0 = data.readStrongBinder();
                    TransitionInfo _arg1 = data.readTypedObject(TransitionInfo.CREATOR);
                    SurfaceControl.Transaction _arg2 = data.readTypedObject(SurfaceControl.Transaction.CREATOR);
                    SurfaceControl.Transaction _arg3 = data.readTypedObject(SurfaceControl.Transaction.CREATOR);
                    data.enforceNoDataAvail();
                    this.onTransitionReady(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 2: {
                    IBinder _arg0 = data.readStrongBinder();
                    TransitionRequestInfo _arg1 = data.readTypedObject(TransitionRequestInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.requestStartTransition(_arg0, _arg1);
                    break;
                }
                case 3: {
                    StartingWindowRemovalInfo _arg0 = data.readTypedObject(StartingWindowRemovalInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.removeStartingWindow(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 2;
        }

        private static class Proxy
        implements ITransitionPlayer {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ITransitionPlayer.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTransitionReady(IBinder transitionToken, TransitionInfo info, SurfaceControl.Transaction t, SurfaceControl.Transaction finishT) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ITransitionPlayer.DESCRIPTOR);
                    _data.writeStrongBinder(transitionToken);
                    _data.writeTypedObject(info, 0);
                    _data.writeTypedObject(t, 0);
                    _data.writeTypedObject(finishT, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestStartTransition(IBinder transitionToken, TransitionRequestInfo request) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ITransitionPlayer.DESCRIPTOR);
                    _data.writeStrongBinder(transitionToken);
                    _data.writeTypedObject(request, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeStartingWindow(StartingWindowRemovalInfo removalInfo) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ITransitionPlayer.DESCRIPTOR);
                    _data.writeTypedObject(removalInfo, 0);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ITransitionPlayer {
        @Override
        public void onTransitionReady(IBinder transitionToken, TransitionInfo info, SurfaceControl.Transaction t, SurfaceControl.Transaction finishT) throws RemoteException {
        }

        @Override
        public void requestStartTransition(IBinder transitionToken, TransitionRequestInfo request) throws RemoteException {
        }

        @Override
        public void removeStartingWindow(StartingWindowRemovalInfo removalInfo) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

