/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IScreenRecordingCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.window.IScreenRecordingCallback";

    public void onScreenRecordingStateChanged(boolean var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IScreenRecordingCallback {
        static final int TRANSACTION_onScreenRecordingStateChanged = 1;

        public Stub() {
            this.attachInterface(this, IScreenRecordingCallback.DESCRIPTOR);
        }

        public static IScreenRecordingCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IScreenRecordingCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IScreenRecordingCallback) {
                return (IScreenRecordingCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onScreenRecordingStateChanged";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IScreenRecordingCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.onScreenRecordingStateChanged(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 0;
        }

        private static class Proxy
        implements IScreenRecordingCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IScreenRecordingCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onScreenRecordingStateChanged(boolean visibleInScreenRecording) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IScreenRecordingCallback.DESCRIPTOR);
                    _data.writeBoolean(visibleInScreenRecording);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IScreenRecordingCallback {
        @Override
        public void onScreenRecordingStateChanged(boolean visibleInScreenRecording) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

