/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.SurfaceControl;
import android.window.DisplayAreaInfo;

public interface IDisplayAreaOrganizer
extends IInterface {
    public static final String DESCRIPTOR = "android.window.IDisplayAreaOrganizer";

    public void onDisplayAreaAppeared(DisplayAreaInfo var1, SurfaceControl var2) throws RemoteException;

    public void onDisplayAreaVanished(DisplayAreaInfo var1) throws RemoteException;

    public void onDisplayAreaInfoChanged(DisplayAreaInfo var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IDisplayAreaOrganizer {
        static final int TRANSACTION_onDisplayAreaAppeared = 1;
        static final int TRANSACTION_onDisplayAreaVanished = 2;
        static final int TRANSACTION_onDisplayAreaInfoChanged = 3;

        public Stub() {
            this.attachInterface(this, IDisplayAreaOrganizer.DESCRIPTOR);
        }

        public static IDisplayAreaOrganizer asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IDisplayAreaOrganizer.DESCRIPTOR);
            if (iin != null && iin instanceof IDisplayAreaOrganizer) {
                return (IDisplayAreaOrganizer)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onDisplayAreaAppeared";
                }
                case 2: {
                    return "onDisplayAreaVanished";
                }
                case 3: {
                    return "onDisplayAreaInfoChanged";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IDisplayAreaOrganizer.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    DisplayAreaInfo _arg0 = data.readTypedObject(DisplayAreaInfo.CREATOR);
                    SurfaceControl _arg1 = data.readTypedObject(SurfaceControl.CREATOR);
                    data.enforceNoDataAvail();
                    this.onDisplayAreaAppeared(_arg0, _arg1);
                    break;
                }
                case 2: {
                    DisplayAreaInfo _arg0 = data.readTypedObject(DisplayAreaInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.onDisplayAreaVanished(_arg0);
                    break;
                }
                case 3: {
                    DisplayAreaInfo _arg0 = data.readTypedObject(DisplayAreaInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.onDisplayAreaInfoChanged(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 2;
        }

        private static class Proxy
        implements IDisplayAreaOrganizer {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IDisplayAreaOrganizer.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDisplayAreaAppeared(DisplayAreaInfo displayAreaInfo, SurfaceControl leash) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IDisplayAreaOrganizer.DESCRIPTOR);
                    _data.writeTypedObject(displayAreaInfo, 0);
                    _data.writeTypedObject(leash, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDisplayAreaVanished(DisplayAreaInfo displayAreaInfo) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IDisplayAreaOrganizer.DESCRIPTOR);
                    _data.writeTypedObject(displayAreaInfo, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDisplayAreaInfoChanged(DisplayAreaInfo displayAreaInfo) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IDisplayAreaOrganizer.DESCRIPTOR);
                    _data.writeTypedObject(displayAreaInfo, 0);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IDisplayAreaOrganizer {
        @Override
        public void onDisplayAreaAppeared(DisplayAreaInfo displayAreaInfo, SurfaceControl leash) throws RemoteException {
        }

        @Override
        public void onDisplayAreaVanished(DisplayAreaInfo displayAreaInfo) throws RemoteException {
        }

        @Override
        public void onDisplayAreaInfoChanged(DisplayAreaInfo displayAreaInfo) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

