/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.ActivityThread;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.annotations.VisibleForTesting;
import com.android.server.LocalServices;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

public abstract class ConfigurationChangeSetting
implements Parcelable {
    public static final int SETTING_TYPE_UNKNOWN = -1;
    public static final int SETTING_TYPE_DISPLAY_DENSITY = 0;
    public static final int SETTING_TYPE_FONT_SCALE = 1;
    private final int mSettingType;
    public static final Parcelable.Creator<ConfigurationChangeSetting> CREATOR = new CreatorImpl();

    private ConfigurationChangeSetting(int settingType) {
        this.mSettingType = settingType;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mSettingType);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public void apply(int userId) {
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    public static class CreatorImpl
    implements Parcelable.Creator<ConfigurationChangeSetting> {
        private final boolean mIsSystem;

        private CreatorImpl() {
            this(ActivityThread.isSystem());
        }

        @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
        public CreatorImpl(boolean isSystem) {
            this.mIsSystem = isSystem;
        }

        @Override
        public ConfigurationChangeSetting createFromParcel(@NonNull Parcel in) {
            int settingType = in.readInt();
            if (this.mIsSystem) {
                return LocalServices.getService(ConfigurationChangeSettingInternal.class).createImplFromParcel(settingType, in);
            }
            switch (settingType) {
                case 0: {
                    return DensitySetting.CREATOR.createFromParcel(in);
                }
                case 1: {
                    return FontScaleSetting.CREATOR.createFromParcel(in);
                }
            }
            throw new IllegalArgumentException("Unknown setting type " + settingType);
        }

        public ConfigurationChangeSetting[] newArray(int size) {
            return new ConfigurationChangeSetting[size];
        }
    }

    public static class FontScaleSetting
    extends ConfigurationChangeSetting {
        protected final float mFontScaleFactor;
        public static final Parcelable.Creator<FontScaleSetting> CREATOR = new Parcelable.Creator<FontScaleSetting>(){

            @Override
            public FontScaleSetting createFromParcel(@NonNull Parcel in) {
                return new FontScaleSetting(in);
            }

            public FontScaleSetting[] newArray(int size) {
                return new FontScaleSetting[size];
            }
        };

        public FontScaleSetting(float fontScaleFactor) {
            super(1);
            this.mFontScaleFactor = fontScaleFactor;
        }

        protected FontScaleSetting(@NonNull Parcel in) {
            this(in.readFloat());
        }

        @Override
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeFloat(this.mFontScaleFactor);
        }

        public boolean equals(@Nullable Object obj) {
            if (!(obj instanceof FontScaleSetting)) {
                return false;
            }
            FontScaleSetting other = (FontScaleSetting)obj;
            return Float.compare(this.mFontScaleFactor, other.mFontScaleFactor) == 0;
        }

        public int hashCode() {
            return Objects.hash(Float.valueOf(this.mFontScaleFactor));
        }
    }

    public static class DensitySetting
    extends ConfigurationChangeSetting {
        protected final int mDisplayId;
        protected final int mDensity;
        public static final Parcelable.Creator<DensitySetting> CREATOR = new Parcelable.Creator<DensitySetting>(){

            @Override
            public DensitySetting createFromParcel(@NonNull Parcel in) {
                return new DensitySetting(in);
            }

            public DensitySetting[] newArray(int size) {
                return new DensitySetting[size];
            }
        };

        public DensitySetting(int displayId, int density) {
            super(0);
            this.mDisplayId = displayId;
            this.mDensity = density;
        }

        protected DensitySetting(@NonNull Parcel in) {
            this(in.readInt(), in.readInt());
        }

        @Override
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.mDisplayId);
            dest.writeInt(this.mDensity);
        }

        public boolean equals(@Nullable Object obj) {
            if (!(obj instanceof DensitySetting)) {
                return false;
            }
            DensitySetting other = (DensitySetting)obj;
            return this.mDisplayId == other.mDisplayId && this.mDensity == other.mDensity;
        }

        public int hashCode() {
            return Objects.hash(this.mDisplayId, this.mDensity);
        }
    }

    public static interface ConfigurationChangeSettingInternal {
        @NonNull
        public ConfigurationChangeSetting createImplFromParcel(int var1, @NonNull Parcel var2);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SettingType {
    }
}

