/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.annotation.FlaggedApi;
import android.window.BackMotionEvent;
import com.android.internal.hidden_from_bootclasspath.com.android.window.flags.Flags;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class BackEvent {
    public static final int EDGE_LEFT = 0;
    public static final int EDGE_RIGHT = 1;
    @FlaggedApi(value="com.android.window.flags.predictive_back_swipe_edge_none_api")
    public static final int EDGE_NONE = 2;
    private final float mTouchX;
    private final float mTouchY;
    private final float mProgress;
    private final long mFrameTimeMillis;
    private final int mSwipeEdge;

    public static BackEvent fromBackMotionEvent(BackMotionEvent backMotionEvent) {
        if (Flags.predictiveBackTimestampApi()) {
            return new BackEvent(backMotionEvent.getTouchX(), backMotionEvent.getTouchY(), backMotionEvent.getProgress(), backMotionEvent.getSwipeEdge(), backMotionEvent.getFrameTimeMillis());
        }
        return new BackEvent(backMotionEvent.getTouchX(), backMotionEvent.getTouchY(), backMotionEvent.getProgress(), backMotionEvent.getSwipeEdge());
    }

    public BackEvent(float touchX, float touchY, float progress, int swipeEdge) {
        this.mTouchX = touchX;
        this.mTouchY = touchY;
        this.mProgress = progress;
        this.mSwipeEdge = swipeEdge;
        this.mFrameTimeMillis = 0L;
    }

    @FlaggedApi(value="com.android.window.flags.predictive_back_timestamp_api")
    public BackEvent(float touchX, float touchY, float progress, int swipeEdge, long frameTimeMillis) {
        this.mTouchX = touchX;
        this.mTouchY = touchY;
        this.mProgress = progress;
        this.mSwipeEdge = swipeEdge;
        this.mFrameTimeMillis = frameTimeMillis;
    }

    public float getProgress() {
        return this.mProgress;
    }

    public float getTouchX() {
        return this.mTouchX;
    }

    public float getTouchY() {
        return this.mTouchY;
    }

    public int getSwipeEdge() {
        return this.mSwipeEdge;
    }

    @FlaggedApi(value="com.android.window.flags.predictive_back_timestamp_api")
    public long getFrameTimeMillis() {
        return this.mFrameTimeMillis;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BackEvent)) {
            return false;
        }
        BackEvent that = (BackEvent)other;
        return this.mTouchX == that.mTouchX && this.mTouchY == that.mTouchY && this.mProgress == that.mProgress && this.mSwipeEdge == that.mSwipeEdge && this.mFrameTimeMillis == that.mFrameTimeMillis;
    }

    public String toString() {
        return "BackEvent{mTouchX=" + this.mTouchX + ", mTouchY=" + this.mTouchY + ", mProgress=" + this.mProgress + ", mSwipeEdge=" + this.mSwipeEdge + ", mFrameTimeMillis=" + this.mFrameTimeMillis + "}";
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SwipeEdge {
    }
}

