/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.appwidget.AppWidgetHostView;
import android.util.SparseIntArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.RemoteViews;
import java.util.stream.IntStream;

class RemoteCollectionItemsAdapter
extends BaseAdapter {
    private final int mViewTypeCount;
    private RemoteViews.RemoteCollectionItems mItems;
    private RemoteViews.InteractionHandler mInteractionHandler;
    private RemoteViews.ColorResources mColorResources;
    private boolean mOnLightBackground;
    private SparseIntArray mLayoutIdToViewType;

    RemoteCollectionItemsAdapter(@NonNull RemoteViews.RemoteCollectionItems items, @NonNull RemoteViews.InteractionHandler interactionHandler, @NonNull RemoteViews.ColorResources colorResources, boolean onLightBackground) {
        this.mViewTypeCount = items.getViewTypeCount();
        this.mItems = items;
        this.mInteractionHandler = interactionHandler;
        this.mColorResources = colorResources;
        this.mOnLightBackground = onLightBackground;
        this.initLayoutIdToViewType();
    }

    void setData(@NonNull RemoteViews.RemoteCollectionItems items, @NonNull RemoteViews.InteractionHandler interactionHandler, @NonNull RemoteViews.ColorResources colorResources, boolean onLightBackground) {
        if (this.mViewTypeCount < items.getViewTypeCount()) {
            throw new IllegalArgumentException("RemoteCollectionItemsAdapter cannot increase view type count after creation");
        }
        this.mItems = items;
        this.mInteractionHandler = interactionHandler;
        this.mColorResources = colorResources;
        this.mOnLightBackground = onLightBackground;
        this.initLayoutIdToViewType();
        this.notifyDataSetChanged();
    }

    private void initLayoutIdToViewType() {
        SparseIntArray previousLayoutIdToViewType = this.mLayoutIdToViewType;
        this.mLayoutIdToViewType = new SparseIntArray(this.mViewTypeCount);
        int[] layoutIds = IntStream.range(0, this.mItems.getItemCount()).map(position -> this.mItems.getItemView(position).getLayoutId()).distinct().toArray();
        if (layoutIds.length > this.mViewTypeCount) {
            throw new IllegalArgumentException("Collection items uses " + layoutIds.length + " distinct layouts, which is more than view type count of " + this.mViewTypeCount);
        }
        boolean[] processedLayoutIdIndices = new boolean[layoutIds.length];
        boolean[] assignedViewTypes = new boolean[this.mViewTypeCount];
        if (previousLayoutIdToViewType != null) {
            for (int i = 0; i < layoutIds.length; ++i) {
                int layoutId = layoutIds[i];
                int previousViewType = previousLayoutIdToViewType.get(layoutId, -1);
                if (previousViewType < 0) continue;
                this.mLayoutIdToViewType.put(layoutId, previousViewType);
                processedLayoutIdIndices[i] = true;
                assignedViewTypes[previousViewType] = true;
            }
        }
        int lastViewType = -1;
        for (int i = 0; i < layoutIds.length; ++i) {
            if (processedLayoutIdIndices[i]) continue;
            int layoutId = layoutIds[i];
            int viewType = IntStream.range(lastViewType + 1, layoutIds.length).filter(type -> !assignedViewTypes[type]).findFirst().orElseThrow(() -> new IllegalStateException("RemoteCollectionItems has more distinct layout ids than its view type count"));
            this.mLayoutIdToViewType.put(layoutId, viewType);
            processedLayoutIdIndices[i] = true;
            assignedViewTypes[viewType] = true;
            lastViewType = viewType;
        }
    }

    @Override
    public int getCount() {
        return this.mItems.getItemCount();
    }

    @Override
    public RemoteViews getItem(int position) {
        return this.mItems.getItemView(position);
    }

    @Override
    public long getItemId(int position) {
        return this.mItems.getItemId(position);
    }

    @Override
    public int getItemViewType(int position) {
        return this.mLayoutIdToViewType.get(this.mItems.getItemView(position).getLayoutId());
    }

    @Override
    public int getViewTypeCount() {
        return this.mViewTypeCount;
    }

    @Override
    public boolean hasStableIds() {
        return this.mItems.hasStableIds();
    }

    @Override
    @Nullable
    public View getView(int position, @Nullable View convertView, @NonNull ViewGroup parent) {
        AppWidgetHostView.AdapterChildHostView widgetChildView;
        if (position >= this.getCount()) {
            return null;
        }
        RemoteViews item = this.mItems.getItemView(position);
        item.addFlags(2);
        AppWidgetHostView.AdapterChildHostView newView = convertView instanceof AppWidgetHostView.AdapterChildHostView ? (widgetChildView = (AppWidgetHostView.AdapterChildHostView)convertView) : new AppWidgetHostView.AdapterChildHostView(parent.getContext());
        newView.setInteractionHandler(this.mInteractionHandler);
        newView.setColorResourcesNoReapply(this.mColorResources);
        newView.setOnLightBackground(this.mOnLightBackground);
        newView.updateAppWidget(item);
        return newView;
    }
}

