/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.AsyncQueryHandler;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.res.TypedArray;
import android.database.Cursor;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.provider.ContactsContract;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import com.android.internal.R;

public class QuickContactBadge
extends ImageView
implements View.OnClickListener {
    private Uri mContactUri;
    private String mContactEmail;
    private String mContactPhone;
    @UnsupportedAppUsage
    private Drawable mOverlay;
    private QueryHandler mQueryHandler;
    private Drawable mDefaultAvatar;
    private Bundle mExtras = null;
    private String mPrioritizedMimeType;
    protected String[] mExcludeMimes = null;
    private static final int TOKEN_EMAIL_LOOKUP = 0;
    private static final int TOKEN_PHONE_LOOKUP = 1;
    private static final int TOKEN_EMAIL_LOOKUP_AND_TRIGGER = 2;
    private static final int TOKEN_PHONE_LOOKUP_AND_TRIGGER = 3;
    private static final String EXTRA_URI_CONTENT = "uri_content";
    static final String[] EMAIL_LOOKUP_PROJECTION = new String[]{"contact_id", "lookup"};
    static final int EMAIL_ID_COLUMN_INDEX = 0;
    static final int EMAIL_LOOKUP_STRING_COLUMN_INDEX = 1;
    static final String[] PHONE_LOOKUP_PROJECTION = new String[]{"_id", "lookup"};
    static final int PHONE_ID_COLUMN_INDEX = 0;
    static final int PHONE_LOOKUP_STRING_COLUMN_INDEX = 1;

    public QuickContactBadge(Context context) {
        this(context, null);
    }

    public QuickContactBadge(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public QuickContactBadge(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public QuickContactBadge(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        TypedArray styledAttributes = this.mContext.obtainStyledAttributes(R.styleable.Theme);
        this.mOverlay = styledAttributes.getDrawable(339);
        styledAttributes.recycle();
        this.setOnClickListener(this);
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            this.mQueryHandler = new QueryHandler(this.mContext.getContentResolver());
        }
    }

    @Override
    protected void drawableStateChanged() {
        super.drawableStateChanged();
        Drawable overlay = this.mOverlay;
        if (overlay != null && overlay.isStateful() && overlay.setState(this.getDrawableState())) {
            this.invalidateDrawable(overlay);
        }
    }

    @Override
    public void drawableHotspotChanged(float x, float y) {
        super.drawableHotspotChanged(x, y);
        if (this.mOverlay != null) {
            this.mOverlay.setHotspot(x, y);
        }
    }

    public void setMode(int size) {
    }

    public void setPrioritizedMimeType(String prioritizedMimeType) {
        this.mPrioritizedMimeType = prioritizedMimeType;
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (!this.isEnabled()) {
            return;
        }
        if (this.mOverlay == null || this.mOverlay.getIntrinsicWidth() == 0 || this.mOverlay.getIntrinsicHeight() == 0) {
            return;
        }
        this.mOverlay.setBounds(0, 0, this.getWidth(), this.getHeight());
        if (this.mPaddingTop == 0 && this.mPaddingLeft == 0) {
            this.mOverlay.draw(canvas);
        } else {
            int saveCount = canvas.getSaveCount();
            canvas.save();
            canvas.translate(this.mPaddingLeft, this.mPaddingTop);
            this.mOverlay.draw(canvas);
            canvas.restoreToCount(saveCount);
        }
    }

    private boolean isAssigned() {
        return this.mContactUri != null || this.mContactEmail != null || this.mContactPhone != null;
    }

    public void setImageToDefault() {
        if (this.mDefaultAvatar == null) {
            this.mDefaultAvatar = this.mContext.getDrawable(17302538);
        }
        this.setImageDrawable(this.mDefaultAvatar);
    }

    public void assignContactUri(Uri contactUri) {
        this.mContactUri = contactUri;
        this.mContactEmail = null;
        this.mContactPhone = null;
        this.onContactUriChanged();
    }

    public void assignContactFromEmail(String emailAddress, boolean lazyLookup) {
        this.assignContactFromEmail(emailAddress, lazyLookup, null);
    }

    public void assignContactFromEmail(String emailAddress, boolean lazyLookup, Bundle extras) {
        this.mContactEmail = emailAddress;
        this.mExtras = extras;
        if (!lazyLookup && this.mQueryHandler != null) {
            this.mQueryHandler.startQuery(0, null, Uri.withAppendedPath(ContactsContract.CommonDataKinds.Email.CONTENT_LOOKUP_URI, Uri.encode(this.mContactEmail)), EMAIL_LOOKUP_PROJECTION, null, null, null);
        } else {
            this.mContactUri = null;
            this.onContactUriChanged();
        }
    }

    public void assignContactFromPhone(String phoneNumber, boolean lazyLookup) {
        this.assignContactFromPhone(phoneNumber, lazyLookup, new Bundle());
    }

    public void assignContactFromPhone(String phoneNumber, boolean lazyLookup, Bundle extras) {
        this.mContactPhone = phoneNumber;
        this.mExtras = extras;
        if (!lazyLookup && this.mQueryHandler != null) {
            this.mQueryHandler.startQuery(1, null, Uri.withAppendedPath(ContactsContract.PhoneLookup.CONTENT_FILTER_URI, this.mContactPhone), PHONE_LOOKUP_PROJECTION, null, null, null);
        } else {
            this.mContactUri = null;
            this.onContactUriChanged();
        }
    }

    public void setOverlay(Drawable overlay) {
        this.mOverlay = overlay;
    }

    private void onContactUriChanged() {
        this.setEnabled(this.isAssigned());
    }

    @Override
    public void onClick(View v) {
        Bundle extras;
        Bundle bundle = extras = this.mExtras == null ? new Bundle() : this.mExtras;
        if (this.mContactUri != null) {
            ContactsContract.QuickContact.showQuickContact(this.getContext(), (View)this, this.mContactUri, this.mExcludeMimes, this.mPrioritizedMimeType);
        } else if (this.mContactEmail != null && this.mQueryHandler != null) {
            extras.putString(EXTRA_URI_CONTENT, this.mContactEmail);
            this.mQueryHandler.startQuery(2, extras, Uri.withAppendedPath(ContactsContract.CommonDataKinds.Email.CONTENT_LOOKUP_URI, Uri.encode(this.mContactEmail)), EMAIL_LOOKUP_PROJECTION, null, null, null);
        } else if (this.mContactPhone != null && this.mQueryHandler != null) {
            extras.putString(EXTRA_URI_CONTENT, this.mContactPhone);
            this.mQueryHandler.startQuery(3, extras, Uri.withAppendedPath(ContactsContract.PhoneLookup.CONTENT_FILTER_URI, this.mContactPhone), PHONE_LOOKUP_PROJECTION, null, null, null);
        } else {
            return;
        }
    }

    @Override
    public CharSequence getAccessibilityClassName() {
        return QuickContactBadge.class.getName();
    }

    public void setExcludeMimes(String[] excludeMimes) {
        this.mExcludeMimes = excludeMimes;
    }

    private class QueryHandler
    extends AsyncQueryHandler {
        public QueryHandler(ContentResolver cr) {
            super(cr);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        protected void onQueryComplete(int token, Object cookie, Cursor cursor) {
            lookupUri = null;
            createUri = null;
            trigger = false;
            extras = cookie != null ? (Bundle)cookie : new Bundle();
            try {
                switch (token) {
                    case 3: {
                        trigger = true;
                        createUri = Uri.fromParts("tel", extras.getString("uri_content"), null);
                    }
                    case 1: {
                        if (cursor != null && cursor.moveToFirst()) {
                            contactId = cursor.getLong(0);
                            lookupKey = cursor.getString(1);
                            lookupUri = ContactsContract.Contacts.getLookupUri(contactId, lookupKey);
                            ** break;
                        }
lbl16:
                        // 3 sources

                        break;
                    }
                    case 2: {
                        trigger = true;
                        createUri = Uri.fromParts("mailto", extras.getString("uri_content"), null);
                    }
                    case 0: {
                        if (cursor != null && cursor.moveToFirst()) {
                            contactId = cursor.getLong(0);
                            lookupKey = cursor.getString(1);
                            lookupUri = ContactsContract.Contacts.getLookupUri(contactId, lookupKey);
                        }
                        break;
                    }
                    ** default:
lbl27:
                    // 1 sources

                    break;
                }
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            QuickContactBadge.this.mContactUri = lookupUri;
            QuickContactBadge.this.onContactUriChanged();
            if (trigger && QuickContactBadge.this.mContactUri != null) {
                ContactsContract.QuickContact.showQuickContact(QuickContactBadge.this.getContext(), (View)QuickContactBadge.this, QuickContactBadge.this.mContactUri, QuickContactBadge.this.mExcludeMimes, QuickContactBadge.this.mPrioritizedMimeType);
            } else if (createUri != null) {
                intent = new Intent("com.android.contacts.action.SHOW_OR_CREATE_CONTACT", createUri);
                if (extras != null) {
                    bundle = new Bundle(extras);
                    bundle.remove("uri_content");
                    intent.putExtras(bundle);
                }
                QuickContactBadge.this.getContext().startActivity(intent);
            }
        }
    }
}

