/*
 * Decompiled with CFR 0.152.
 */
package android.view.translation;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.icu.util.ULocale;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.AnnotationValidations;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

public class TranslationSpec
implements Parcelable {
    public static final int DATA_FORMAT_TEXT = 1;
    @Deprecated
    @NonNull
    private final String mLanguage;
    @NonNull
    private final ULocale mLocale;
    private final int mDataFormat;
    @NonNull
    public static final Parcelable.Creator<TranslationSpec> CREATOR = new Parcelable.Creator<TranslationSpec>(){

        public TranslationSpec[] newArray(int size) {
            return new TranslationSpec[size];
        }

        @Override
        public TranslationSpec createFromParcel(@NonNull Parcel in) {
            return new TranslationSpec(in);
        }
    };

    void parcelLocale(Parcel dest, int flags) {
        dest.writeSerializable(this.mLocale);
    }

    static ULocale unparcelLocale(Parcel in) {
        return in.readSerializable(ULocale.class.getClassLoader(), ULocale.class);
    }

    @Deprecated
    public TranslationSpec(@NonNull String language, int dataFormat) {
        this.mLanguage = language;
        this.mDataFormat = dataFormat;
        this.mLocale = new ULocale.Builder().setLanguage(language).build();
    }

    public TranslationSpec(@NonNull ULocale locale, int dataFormat) {
        Objects.requireNonNull(locale);
        this.mLanguage = locale.getLanguage();
        this.mLocale = locale;
        this.mDataFormat = dataFormat;
    }

    @Deprecated
    @NonNull
    public String getLanguage() {
        return this.mLanguage;
    }

    @NonNull
    public ULocale getLocale() {
        return this.mLocale;
    }

    public int getDataFormat() {
        return this.mDataFormat;
    }

    public String toString() {
        return "TranslationSpec { language = " + this.mLanguage + ", locale = " + this.mLocale + ", dataFormat = " + this.mDataFormat + " }";
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TranslationSpec that = (TranslationSpec)o;
        return Objects.equals(this.mLanguage, that.mLanguage) && Objects.equals(this.mLocale, that.mLocale) && this.mDataFormat == that.mDataFormat;
    }

    public int hashCode() {
        int _hash = 1;
        _hash = 31 * _hash + Objects.hashCode(this.mLanguage);
        _hash = 31 * _hash + Objects.hashCode(this.mLocale);
        _hash = 31 * _hash + this.mDataFormat;
        return _hash;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString(this.mLanguage);
        this.parcelLocale(dest, flags);
        dest.writeInt(this.mDataFormat);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    TranslationSpec(@NonNull Parcel in) {
        String language = in.readString();
        ULocale locale = TranslationSpec.unparcelLocale(in);
        int dataFormat = in.readInt();
        this.mLanguage = language;
        AnnotationValidations.validate(Deprecated.class, null, (Object)this.mLanguage);
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mLanguage);
        this.mLocale = locale;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mLocale);
        this.mDataFormat = dataFormat;
        AnnotationValidations.validate(DataFormat.class, null, this.mDataFormat);
    }

    @Deprecated
    private void __metadata() {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DataFormat {
    }
}

