/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.ActivityOptions;
import android.app.PendingIntent;
import android.app.RemoteAction;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.BitmapFactory;
import android.graphics.drawable.AdaptiveIconDrawable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.Icon;
import android.os.Bundle;
import android.os.LocaleList;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.SpannedString;
import android.util.ArrayMap;
import android.view.View;
import android.view.textclassifier.EntityConfidence;
import android.view.textclassifier.Log;
import android.view.textclassifier.SystemTextClassifierMetadata;
import android.view.textclassifier.TextClassifier;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class TextClassification
implements Parcelable {
    public static final TextClassification EMPTY = new Builder().build();
    private static final String LOG_TAG = "TextClassification";
    private static final int MAX_LEGACY_ICON_SIZE = 192;
    @NonNull
    private final String mText;
    @Nullable
    private final Drawable mLegacyIcon;
    @Nullable
    private final String mLegacyLabel;
    @Nullable
    private final Intent mLegacyIntent;
    @Nullable
    private final View.OnClickListener mLegacyOnClickListener;
    @NonNull
    private final List<RemoteAction> mActions;
    @NonNull
    private final EntityConfidence mEntityConfidence;
    @Nullable
    private final String mId;
    @NonNull
    private final Bundle mExtras;
    @NonNull
    public static final Parcelable.Creator<TextClassification> CREATOR = new Parcelable.Creator<TextClassification>(){

        @Override
        public TextClassification createFromParcel(Parcel in) {
            return new TextClassification(in);
        }

        public TextClassification[] newArray(int size) {
            return new TextClassification[size];
        }
    };

    private TextClassification(@Nullable String text, @Nullable Drawable legacyIcon, @Nullable String legacyLabel, @Nullable Intent legacyIntent, @Nullable View.OnClickListener legacyOnClickListener, @NonNull List<RemoteAction> actions, @NonNull EntityConfidence entityConfidence, @Nullable String id2, @NonNull Bundle extras) {
        this.mText = text;
        this.mLegacyIcon = legacyIcon;
        this.mLegacyLabel = legacyLabel;
        this.mLegacyIntent = legacyIntent;
        this.mLegacyOnClickListener = legacyOnClickListener;
        this.mActions = Collections.unmodifiableList(actions);
        this.mEntityConfidence = Objects.requireNonNull(entityConfidence);
        this.mId = id2;
        this.mExtras = extras;
    }

    @Nullable
    public String getText() {
        return this.mText;
    }

    public int getEntityCount() {
        return this.mEntityConfidence.getEntities().size();
    }

    @NonNull
    public String getEntity(int index) {
        return this.mEntityConfidence.getEntities().get(index);
    }

    public float getConfidenceScore(String entity) {
        return this.mEntityConfidence.getConfidenceScore(entity);
    }

    public List<RemoteAction> getActions() {
        return this.mActions;
    }

    @Deprecated
    @Nullable
    public Drawable getIcon() {
        return this.mLegacyIcon;
    }

    @Deprecated
    @Nullable
    public CharSequence getLabel() {
        return this.mLegacyLabel;
    }

    @Deprecated
    @Nullable
    public Intent getIntent() {
        return this.mLegacyIntent;
    }

    @Nullable
    public View.OnClickListener getOnClickListener() {
        return this.mLegacyOnClickListener;
    }

    @Nullable
    public String getId() {
        return this.mId;
    }

    @NonNull
    public Bundle getExtras() {
        return this.mExtras;
    }

    public Builder toBuilder() {
        return new Builder().setId(this.mId).setText(this.mText).addActions(this.mActions).setEntityConfidence(this.mEntityConfidence).setIcon(this.mLegacyIcon).setLabel(this.mLegacyLabel).setIntent(this.mLegacyIntent).setOnClickListener(this.mLegacyOnClickListener).setExtras(this.mExtras);
    }

    public String toString() {
        return String.format(Locale.US, "TextClassification {text=%s, entities=%s, actions=%s, id=%s, extras=%s}", this.mText, this.mEntityConfidence, this.mActions, this.mId, this.mExtras);
    }

    public static View.OnClickListener createIntentOnClickListener(@NonNull PendingIntent intent) {
        Objects.requireNonNull(intent);
        return v -> {
            try {
                intent.send(ActivityOptions.makeBasic().setPendingIntentBackgroundActivityStartMode(1).toBundle());
            }
            catch (PendingIntent.CanceledException e) {
                Log.e(LOG_TAG, "Error sending PendingIntent", e);
            }
        };
    }

    public static PendingIntent createPendingIntent(@NonNull Context context, @NonNull Intent intent, int requestCode) {
        return PendingIntent.getActivity(context, requestCode, intent, 0xC000000);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mText);
        dest.writeTypedList(this.mActions);
        this.mEntityConfidence.writeToParcel(dest, flags);
        dest.writeString(this.mId);
        dest.writeBundle(this.mExtras);
    }

    private TextClassification(Parcel in) {
        this.mText = in.readString();
        this.mActions = in.createTypedArrayList(RemoteAction.CREATOR);
        if (!this.mActions.isEmpty()) {
            RemoteAction action = this.mActions.get(0);
            this.mLegacyIcon = TextClassification.maybeLoadDrawable(action.getIcon());
            this.mLegacyLabel = action.getTitle().toString();
            this.mLegacyOnClickListener = TextClassification.createIntentOnClickListener(this.mActions.get(0).getActionIntent());
        } else {
            this.mLegacyIcon = null;
            this.mLegacyLabel = null;
            this.mLegacyOnClickListener = null;
        }
        this.mLegacyIntent = null;
        this.mEntityConfidence = EntityConfidence.CREATOR.createFromParcel(in);
        this.mId = in.readString();
        this.mExtras = in.readBundle();
    }

    @Nullable
    private static Drawable maybeLoadDrawable(Icon icon) {
        if (icon == null) {
            return null;
        }
        switch (icon.getType()) {
            case 1: {
                return new BitmapDrawable(Resources.getSystem(), icon.getBitmap());
            }
            case 5: {
                return new AdaptiveIconDrawable(null, new BitmapDrawable(Resources.getSystem(), icon.getBitmap()));
            }
            case 3: {
                return new BitmapDrawable(Resources.getSystem(), BitmapFactory.decodeByteArray(icon.getDataBytes(), icon.getDataOffset(), icon.getDataLength()));
            }
        }
        return null;
    }

    public static class Builder {
        @NonNull
        private final List<RemoteAction> mActions = new ArrayList<RemoteAction>();
        @NonNull
        private final Map<String, Float> mTypeScoreMap = new ArrayMap<String, Float>();
        @Nullable
        private String mText;
        @Nullable
        private Drawable mLegacyIcon;
        @Nullable
        private String mLegacyLabel;
        @Nullable
        private Intent mLegacyIntent;
        @Nullable
        private View.OnClickListener mLegacyOnClickListener;
        @Nullable
        private String mId;
        @Nullable
        private Bundle mExtras;

        @NonNull
        public Builder setText(@Nullable String text) {
            this.mText = text;
            return this;
        }

        @NonNull
        public Builder setEntityType(@NonNull String type, float confidenceScore) {
            this.mTypeScoreMap.put(type, Float.valueOf(confidenceScore));
            return this;
        }

        Builder setEntityConfidence(EntityConfidence scores) {
            this.mTypeScoreMap.clear();
            this.mTypeScoreMap.putAll(scores.toMap());
            return this;
        }

        public Builder clearEntityTypes() {
            this.mTypeScoreMap.clear();
            return this;
        }

        @NonNull
        public Builder addAction(@NonNull RemoteAction action) {
            Preconditions.checkArgument(action != null);
            this.mActions.add(action);
            return this;
        }

        public Builder addActions(Collection<RemoteAction> actions) {
            Objects.requireNonNull(actions);
            this.mActions.addAll(actions);
            return this;
        }

        public Builder clearActions() {
            this.mActions.clear();
            return this;
        }

        @Deprecated
        @NonNull
        public Builder setIcon(@Nullable Drawable icon) {
            this.mLegacyIcon = icon;
            return this;
        }

        @Deprecated
        @NonNull
        public Builder setLabel(@Nullable String label) {
            this.mLegacyLabel = label;
            return this;
        }

        @Deprecated
        @NonNull
        public Builder setIntent(@Nullable Intent intent) {
            this.mLegacyIntent = intent;
            return this;
        }

        @Deprecated
        @NonNull
        public Builder setOnClickListener(@Nullable View.OnClickListener onClickListener) {
            this.mLegacyOnClickListener = onClickListener;
            return this;
        }

        @NonNull
        public Builder setId(@Nullable String id2) {
            this.mId = id2;
            return this;
        }

        @NonNull
        public Builder setExtras(@Nullable Bundle extras) {
            this.mExtras = extras;
            return this;
        }

        @NonNull
        public TextClassification build() {
            EntityConfidence entityConfidence = new EntityConfidence(this.mTypeScoreMap);
            return new TextClassification(this.mText, this.mLegacyIcon, this.mLegacyLabel, this.mLegacyIntent, this.mLegacyOnClickListener, this.mActions, entityConfidence, this.mId, this.mExtras == null ? Bundle.EMPTY : this.mExtras);
        }
    }

    public static class Request
    implements Parcelable {
        private final CharSequence mText;
        private final int mStartIndex;
        private final int mEndIndex;
        @Nullable
        private final LocaleList mDefaultLocales;
        @Nullable
        private final ZonedDateTime mReferenceTime;
        @NonNull
        private final Bundle mExtras;
        @Nullable
        private SystemTextClassifierMetadata mSystemTcMetadata;
        @NonNull
        public static final Parcelable.Creator<Request> CREATOR = new Parcelable.Creator<Request>(){

            @Override
            public Request createFromParcel(Parcel in) {
                return Request.readFromParcel(in);
            }

            public Request[] newArray(int size) {
                return new Request[size];
            }
        };

        private Request(CharSequence text, int startIndex, int endIndex, LocaleList defaultLocales, ZonedDateTime referenceTime, Bundle extras) {
            this.mText = text;
            this.mStartIndex = startIndex;
            this.mEndIndex = endIndex;
            this.mDefaultLocales = defaultLocales;
            this.mReferenceTime = referenceTime;
            this.mExtras = extras;
        }

        @NonNull
        public CharSequence getText() {
            return this.mText;
        }

        public int getStartIndex() {
            return this.mStartIndex;
        }

        public int getEndIndex() {
            return this.mEndIndex;
        }

        @Nullable
        public LocaleList getDefaultLocales() {
            return this.mDefaultLocales;
        }

        @Nullable
        public ZonedDateTime getReferenceTime() {
            return this.mReferenceTime;
        }

        @Nullable
        public String getCallingPackageName() {
            return this.mSystemTcMetadata != null ? this.mSystemTcMetadata.getCallingPackageName() : null;
        }

        @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
        public void setSystemTextClassifierMetadata(@Nullable SystemTextClassifierMetadata systemTcMetadata) {
            this.mSystemTcMetadata = systemTcMetadata;
        }

        @Nullable
        public SystemTextClassifierMetadata getSystemTextClassifierMetadata() {
            return this.mSystemTcMetadata;
        }

        @NonNull
        public Bundle getExtras() {
            return this.mExtras;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeCharSequence(this.mText);
            dest.writeInt(this.mStartIndex);
            dest.writeInt(this.mEndIndex);
            dest.writeParcelable(this.mDefaultLocales, flags);
            dest.writeString(this.mReferenceTime == null ? null : this.mReferenceTime.toString());
            dest.writeBundle(this.mExtras);
            dest.writeParcelable(this.mSystemTcMetadata, flags);
        }

        private static Request readFromParcel(Parcel in) {
            CharSequence text = in.readCharSequence();
            int startIndex = in.readInt();
            int endIndex = in.readInt();
            LocaleList defaultLocales = in.readParcelable(null, LocaleList.class);
            String referenceTimeString = in.readString();
            ZonedDateTime referenceTime = referenceTimeString == null ? null : ZonedDateTime.parse(referenceTimeString);
            Bundle extras = in.readBundle();
            SystemTextClassifierMetadata systemTcMetadata = in.readParcelable(null, SystemTextClassifierMetadata.class);
            Request request = new Request(text, startIndex, endIndex, defaultLocales, referenceTime, extras);
            request.setSystemTextClassifierMetadata(systemTcMetadata);
            return request;
        }

        public static class Builder {
            private final CharSequence mText;
            private final int mStartIndex;
            private final int mEndIndex;
            private Bundle mExtras;
            @Nullable
            private LocaleList mDefaultLocales;
            @Nullable
            private ZonedDateTime mReferenceTime;

            public Builder(@NonNull CharSequence text, int startIndex, int endIndex) {
                TextClassifier.Utils.checkArgument(text, startIndex, endIndex);
                this.mText = text;
                this.mStartIndex = startIndex;
                this.mEndIndex = endIndex;
            }

            @NonNull
            public Builder setDefaultLocales(@Nullable LocaleList defaultLocales) {
                this.mDefaultLocales = defaultLocales;
                return this;
            }

            @NonNull
            public Builder setReferenceTime(@Nullable ZonedDateTime referenceTime) {
                this.mReferenceTime = referenceTime;
                return this;
            }

            @NonNull
            public Builder setExtras(@Nullable Bundle extras) {
                this.mExtras = extras;
                return this;
            }

            @NonNull
            public Request build() {
                return new Request(new SpannedString(this.mText), this.mStartIndex, this.mEndIndex, this.mDefaultLocales, this.mReferenceTime, this.mExtras == null ? Bundle.EMPTY : this.mExtras);
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface IntentType {
        public static final int UNSUPPORTED = -1;
        public static final int ACTIVITY = 0;
        public static final int SERVICE = 1;
    }
}

