/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.Person;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.SpannedString;
import android.view.textclassifier.ConversationAction;
import android.view.textclassifier.SystemTextClassifierMetadata;
import android.view.textclassifier.TextClassifier;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ConversationActions
implements Parcelable {
    @NonNull
    public static final Parcelable.Creator<ConversationActions> CREATOR = new Parcelable.Creator<ConversationActions>(){

        @Override
        public ConversationActions createFromParcel(Parcel in) {
            return new ConversationActions(in);
        }

        public ConversationActions[] newArray(int size) {
            return new ConversationActions[size];
        }
    };
    private final List<ConversationAction> mConversationActions;
    private final String mId;

    public ConversationActions(@NonNull List<ConversationAction> conversationActions, @Nullable String id2) {
        this.mConversationActions = Collections.unmodifiableList(Objects.requireNonNull(conversationActions));
        this.mId = id2;
    }

    private ConversationActions(Parcel in) {
        this.mConversationActions = Collections.unmodifiableList(in.createTypedArrayList(ConversationAction.CREATOR));
        this.mId = in.readString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeTypedList(this.mConversationActions);
        parcel.writeString(this.mId);
    }

    @NonNull
    public List<ConversationAction> getConversationActions() {
        return this.mConversationActions;
    }

    @Nullable
    public String getId() {
        return this.mId;
    }

    public static class Request
    implements Parcelable {
        public static final String HINT_FOR_IN_APP = "in_app";
        public static final String HINT_FOR_NOTIFICATION = "notification";
        @NonNull
        private final List<Message> mConversation;
        @NonNull
        private final TextClassifier.EntityConfig mTypeConfig;
        private final int mMaxSuggestions;
        @NonNull
        private final List<String> mHints;
        @NonNull
        private Bundle mExtras;
        @Nullable
        private SystemTextClassifierMetadata mSystemTcMetadata;
        @NonNull
        public static final Parcelable.Creator<Request> CREATOR = new Parcelable.Creator<Request>(){

            @Override
            public Request createFromParcel(Parcel in) {
                return Request.readFromParcel(in);
            }

            public Request[] newArray(int size) {
                return new Request[size];
            }
        };

        private Request(@NonNull List<Message> conversation, @NonNull TextClassifier.EntityConfig typeConfig, int maxSuggestions, @Nullable List<String> hints, @NonNull Bundle extras) {
            this.mConversation = Objects.requireNonNull(conversation);
            this.mTypeConfig = Objects.requireNonNull(typeConfig);
            this.mMaxSuggestions = maxSuggestions;
            this.mHints = hints;
            this.mExtras = extras;
        }

        private static Request readFromParcel(Parcel in) {
            ArrayList<Message> conversation = new ArrayList<Message>();
            in.readParcelableList(conversation, null, Message.class);
            TextClassifier.EntityConfig typeConfig = in.readParcelable(null, TextClassifier.EntityConfig.class);
            int maxSuggestions = in.readInt();
            ArrayList<String> hints = new ArrayList<String>();
            in.readStringList(hints);
            Bundle extras = in.readBundle();
            SystemTextClassifierMetadata systemTcMetadata = in.readParcelable(null, SystemTextClassifierMetadata.class);
            Request request = new Request(conversation, typeConfig, maxSuggestions, hints, extras);
            request.setSystemTextClassifierMetadata(systemTcMetadata);
            return request;
        }

        @Override
        public void writeToParcel(Parcel parcel, int flags) {
            parcel.writeParcelableList(this.mConversation, flags);
            parcel.writeParcelable(this.mTypeConfig, flags);
            parcel.writeInt(this.mMaxSuggestions);
            parcel.writeStringList(this.mHints);
            parcel.writeBundle(this.mExtras);
            parcel.writeParcelable(this.mSystemTcMetadata, flags);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @NonNull
        public TextClassifier.EntityConfig getTypeConfig() {
            return this.mTypeConfig;
        }

        @NonNull
        public List<Message> getConversation() {
            return this.mConversation;
        }

        public int getMaxSuggestions() {
            return this.mMaxSuggestions;
        }

        @NonNull
        public List<String> getHints() {
            return this.mHints;
        }

        @Nullable
        public String getCallingPackageName() {
            return this.mSystemTcMetadata != null ? this.mSystemTcMetadata.getCallingPackageName() : null;
        }

        void setSystemTextClassifierMetadata(@Nullable SystemTextClassifierMetadata systemTcData) {
            this.mSystemTcMetadata = systemTcData;
        }

        @Nullable
        public SystemTextClassifierMetadata getSystemTextClassifierMetadata() {
            return this.mSystemTcMetadata;
        }

        @NonNull
        public Bundle getExtras() {
            return this.mExtras;
        }

        public static class Builder {
            @NonNull
            private List<Message> mConversation;
            @Nullable
            private TextClassifier.EntityConfig mTypeConfig;
            private int mMaxSuggestions = -1;
            @Nullable
            private List<String> mHints;
            @Nullable
            private Bundle mExtras;

            public Builder(@NonNull List<Message> conversation) {
                this.mConversation = Objects.requireNonNull(conversation);
            }

            @NonNull
            public Builder setHints(@Nullable List<String> hints) {
                this.mHints = hints;
                return this;
            }

            @NonNull
            public Builder setTypeConfig(@Nullable TextClassifier.EntityConfig typeConfig) {
                this.mTypeConfig = typeConfig;
                return this;
            }

            @NonNull
            public Builder setMaxSuggestions(int maxSuggestions) {
                if (maxSuggestions < -1) {
                    throw new IllegalArgumentException("maxSuggestions has to be greater than or equal to -1.");
                }
                this.mMaxSuggestions = maxSuggestions;
                return this;
            }

            @NonNull
            public Builder setExtras(@Nullable Bundle bundle) {
                this.mExtras = bundle;
                return this;
            }

            @NonNull
            public Request build() {
                return new Request(Collections.unmodifiableList(this.mConversation), this.mTypeConfig == null ? new TextClassifier.EntityConfig.Builder().build() : this.mTypeConfig, this.mMaxSuggestions, this.mHints == null ? Collections.emptyList() : Collections.unmodifiableList(this.mHints), this.mExtras == null ? Bundle.EMPTY : this.mExtras);
            }
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Hint {
        }
    }

    public static class Message
    implements Parcelable {
        @NonNull
        public static final Person PERSON_USER_SELF = new Person.Builder().setKey("text-classifier-conversation-actions-user-self").build();
        @NonNull
        public static final Person PERSON_USER_OTHERS = new Person.Builder().setKey("text-classifier-conversation-actions-user-others").build();
        @Nullable
        private final Person mAuthor;
        @Nullable
        private final ZonedDateTime mReferenceTime;
        @Nullable
        private final CharSequence mText;
        @NonNull
        private final Bundle mExtras;
        @NonNull
        public static final Parcelable.Creator<Message> CREATOR = new Parcelable.Creator<Message>(){

            @Override
            public Message createFromParcel(Parcel in) {
                return new Message(in);
            }

            public Message[] newArray(int size) {
                return new Message[size];
            }
        };

        private Message(@Nullable Person author, @Nullable ZonedDateTime referenceTime, @Nullable CharSequence text, @NonNull Bundle bundle) {
            this.mAuthor = author;
            this.mReferenceTime = referenceTime;
            this.mText = text;
            this.mExtras = Objects.requireNonNull(bundle);
        }

        private Message(Parcel in) {
            this.mAuthor = in.readParcelable(null, Person.class);
            this.mReferenceTime = in.readInt() == 0 ? null : ZonedDateTime.parse(in.readString(), DateTimeFormatter.ISO_ZONED_DATE_TIME);
            this.mText = in.readCharSequence();
            this.mExtras = in.readBundle();
        }

        @Override
        public void writeToParcel(Parcel parcel, int flags) {
            parcel.writeParcelable(this.mAuthor, flags);
            parcel.writeInt(this.mReferenceTime != null ? 1 : 0);
            if (this.mReferenceTime != null) {
                parcel.writeString(this.mReferenceTime.format(DateTimeFormatter.ISO_ZONED_DATE_TIME));
            }
            parcel.writeCharSequence(this.mText);
            parcel.writeBundle(this.mExtras);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @NonNull
        public Person getAuthor() {
            return this.mAuthor;
        }

        @Nullable
        public ZonedDateTime getReferenceTime() {
            return this.mReferenceTime;
        }

        @Nullable
        public CharSequence getText() {
            return this.mText;
        }

        @NonNull
        public Bundle getExtras() {
            return this.mExtras;
        }

        public static class Builder {
            @Nullable
            private Person mAuthor;
            @Nullable
            private ZonedDateTime mReferenceTime;
            @Nullable
            private CharSequence mText;
            @Nullable
            private Bundle mExtras;

            public Builder(@NonNull Person author) {
                this.mAuthor = Objects.requireNonNull(author);
            }

            @NonNull
            public Builder setText(@Nullable CharSequence text) {
                this.mText = text;
                return this;
            }

            @NonNull
            public Builder setReferenceTime(@Nullable ZonedDateTime referenceTime) {
                this.mReferenceTime = referenceTime;
                return this;
            }

            @NonNull
            public Builder setExtras(@Nullable Bundle bundle) {
                this.mExtras = bundle;
                return this;
            }

            @NonNull
            public Message build() {
                return new Message(this.mAuthor, this.mReferenceTime, this.mText == null ? null : new SpannedString(this.mText), this.mExtras == null ? Bundle.EMPTY : this.mExtras);
            }
        }
    }
}

