/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.RemoteAction;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

public class ConversationAction
implements Parcelable {
    public static final String TYPE_VIEW_CALENDAR = "view_calendar";
    public static final String TYPE_VIEW_MAP = "view_map";
    public static final String TYPE_TRACK_FLIGHT = "track_flight";
    public static final String TYPE_OPEN_URL = "open_url";
    public static final String TYPE_SEND_SMS = "send_sms";
    public static final String TYPE_CALL_PHONE = "call_phone";
    public static final String TYPE_SEND_EMAIL = "send_email";
    public static final String TYPE_TEXT_REPLY = "text_reply";
    public static final String TYPE_CREATE_REMINDER = "create_reminder";
    public static final String TYPE_SHARE_LOCATION = "share_location";
    public static final String TYPE_ADD_CONTACT = "add_contact";
    public static final String TYPE_COPY = "copy";
    @NonNull
    public static final Parcelable.Creator<ConversationAction> CREATOR = new Parcelable.Creator<ConversationAction>(){

        @Override
        public ConversationAction createFromParcel(Parcel in) {
            return new ConversationAction(in);
        }

        public ConversationAction[] newArray(int size) {
            return new ConversationAction[size];
        }
    };
    @NonNull
    private final String mType;
    @NonNull
    private final CharSequence mTextReply;
    @Nullable
    private final RemoteAction mAction;
    private final float mScore;
    @NonNull
    private final Bundle mExtras;

    private ConversationAction(@NonNull String type, @Nullable RemoteAction action, @Nullable CharSequence textReply, float score, @NonNull Bundle extras) {
        this.mType = Objects.requireNonNull(type);
        this.mAction = action;
        this.mTextReply = textReply;
        this.mScore = score;
        this.mExtras = Objects.requireNonNull(extras);
    }

    private ConversationAction(Parcel in) {
        this.mType = in.readString();
        this.mAction = in.readParcelable(null, RemoteAction.class);
        this.mTextReply = in.readCharSequence();
        this.mScore = in.readFloat();
        this.mExtras = in.readBundle();
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeString(this.mType);
        parcel.writeParcelable(this.mAction, flags);
        parcel.writeCharSequence(this.mTextReply);
        parcel.writeFloat(this.mScore);
        parcel.writeBundle(this.mExtras);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @NonNull
    public String getType() {
        return this.mType;
    }

    @Nullable
    public RemoteAction getAction() {
        return this.mAction;
    }

    public float getConfidenceScore() {
        return this.mScore;
    }

    @Nullable
    public CharSequence getTextReply() {
        return this.mTextReply;
    }

    @NonNull
    public Bundle getExtras() {
        return this.mExtras;
    }

    public Builder toBuilder() {
        return new Builder(this.mType).setTextReply(this.mTextReply).setAction(this.mAction).setConfidenceScore(this.mScore).setExtras(this.mExtras);
    }

    public static class Builder {
        @Nullable
        private String mType;
        @Nullable
        private RemoteAction mAction;
        @Nullable
        private CharSequence mTextReply;
        private float mScore;
        @Nullable
        private Bundle mExtras;

        public Builder(@NonNull String actionType) {
            this.mType = Objects.requireNonNull(actionType);
        }

        @NonNull
        public Builder setAction(@Nullable RemoteAction action) {
            this.mAction = action;
            return this;
        }

        @NonNull
        public Builder setTextReply(@Nullable CharSequence textReply) {
            this.mTextReply = textReply;
            return this;
        }

        @NonNull
        public Builder setConfidenceScore(float score) {
            this.mScore = score;
            return this;
        }

        @NonNull
        public Builder setExtras(@Nullable Bundle extras) {
            this.mExtras = extras;
            return this;
        }

        @NonNull
        public ConversationAction build() {
            return new ConversationAction(this.mType, this.mAction, this.mTextReply, this.mScore, this.mExtras == null ? Bundle.EMPTY : this.mExtras);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ActionType {
    }
}

