/*
 * Decompiled with CFR 0.152.
 */
package android.view.inspector;

import android.annotation.NonNull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class IntFlagMapping {
    private final List<Flag> mFlags = new ArrayList<Flag>();

    @NonNull
    public Set<String> get(int value) {
        HashSet<String> enabledFlagNames = new HashSet<String>(this.mFlags.size());
        for (Flag flag : this.mFlags) {
            if (!flag.isEnabledFor(value)) continue;
            enabledFlagNames.add(flag.mName);
        }
        return Collections.unmodifiableSet(enabledFlagNames);
    }

    public void add(int mask, int target, @NonNull String name) {
        this.mFlags.add(new Flag(mask, target, name));
    }

    private static class Flag {
        @NonNull
        private final String mName;
        private final int mTarget;
        private final int mMask;

        private Flag(int mask, int target, @NonNull String name) {
            this.mTarget = target;
            this.mMask = mask;
            this.mName = Objects.requireNonNull(name);
        }

        private boolean isEnabledFor(int value) {
            return (value & this.mMask) == this.mTarget;
        }
    }
}

