/*
 * Decompiled with CFR 0.152.
 */
package android.view.inputmethod;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;

public class SurroundingText
implements Parcelable {
    @NonNull
    private final CharSequence mText;
    private final int mSelectionStart;
    private final int mSelectionEnd;
    private final int mOffset;
    @NonNull
    public static final Parcelable.Creator<SurroundingText> CREATOR = new Parcelable.Creator<SurroundingText>(){

        @Override
        @NonNull
        public SurroundingText createFromParcel(Parcel in) {
            CharSequence text = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
            int selectionHead = in.readInt();
            int selectionEnd = in.readInt();
            int offset = in.readInt();
            return new SurroundingText(text == null ? "" : text, selectionHead, selectionEnd, offset);
        }

        @NonNull
        public SurroundingText[] newArray(int size) {
            return new SurroundingText[size];
        }
    };

    public SurroundingText(@NonNull CharSequence text, int selectionStart, int selectionEnd, int offset) {
        this.mText = SurroundingText.copyWithParcelableSpans(text);
        this.mSelectionStart = selectionStart;
        this.mSelectionEnd = selectionEnd;
        this.mOffset = offset;
    }

    @NonNull
    public CharSequence getText() {
        return this.mText;
    }

    public int getSelectionStart() {
        return this.mSelectionStart;
    }

    public int getSelectionEnd() {
        return this.mSelectionEnd;
    }

    public int getOffset() {
        return this.mOffset;
    }

    @Override
    public void writeToParcel(@NonNull Parcel out, int flags) {
        TextUtils.writeToParcel(this.mText, out, flags);
        out.writeInt(this.mSelectionStart);
        out.writeInt(this.mSelectionEnd);
        out.writeInt(this.mOffset);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Nullable
    private static CharSequence copyWithParcelableSpans(@Nullable CharSequence source) {
        if (source == null) {
            return null;
        }
        Parcel parcel = null;
        try {
            parcel = Parcel.obtain();
            TextUtils.writeToParcel(source, parcel, 0);
            parcel.setDataPosition(0);
            CharSequence charSequence = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
            return charSequence;
        }
        finally {
            if (parcel != null) {
                parcel.recycle();
            }
        }
    }

    public boolean isEqualTo(@Nullable SurroundingText that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        return this.mSelectionStart == that.mSelectionStart && this.mSelectionEnd == that.mSelectionEnd && this.mOffset == that.mOffset && TextUtils.equals(this.mText, that.mText);
    }
}

