/*
 * Decompiled with CFR 0.152.
 */
package android.view.inputmethod;

import android.annotation.NonNull;
import android.annotation.SuppressLint;
import android.graphics.PointF;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.inputmethod.HandwritingGesture;
import com.android.layoutlib.androidx.annotation.Nullable;
import java.util.Objects;

public class InsertGesture
extends HandwritingGesture
implements Parcelable {
    private String mTextToInsert;
    private PointF mPoint;
    @NonNull
    public static final Parcelable.Creator<InsertGesture> CREATOR = new Parcelable.Creator<InsertGesture>(){

        @Override
        public InsertGesture createFromParcel(Parcel source) {
            return new InsertGesture(source);
        }

        public InsertGesture[] newArray(int size) {
            return new InsertGesture[size];
        }
    };

    private InsertGesture(String text, PointF point, String fallbackText) {
        this.mType = 2;
        this.mPoint = point;
        this.mTextToInsert = text;
        this.mFallbackText = fallbackText;
    }

    private InsertGesture(Parcel source) {
        this.mType = 2;
        this.mFallbackText = source.readString8();
        this.mTextToInsert = source.readString8();
        this.mPoint = source.readTypedObject(PointF.CREATOR);
    }

    @NonNull
    public String getTextToInsert() {
        return this.mTextToInsert;
    }

    @NonNull
    public PointF getInsertionPoint() {
        return this.mPoint;
    }

    public int hashCode() {
        return Objects.hash(this.mPoint, this.mTextToInsert, this.mFallbackText);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InsertGesture)) {
            return false;
        }
        InsertGesture that = (InsertGesture)o;
        if (!Objects.equals(this.mFallbackText, that.mFallbackText)) {
            return false;
        }
        if (!Objects.equals(this.mTextToInsert, that.mTextToInsert)) {
            return false;
        }
        return Objects.equals(this.mPoint, that.mPoint);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString8(this.mFallbackText);
        dest.writeString8(this.mTextToInsert);
        dest.writeTypedObject(this.mPoint, flags);
    }

    public static class Builder {
        private String mText;
        private PointF mPoint;
        private String mFallbackText;

        @NonNull
        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder setTextToInsert(@NonNull String text) {
            this.mText = text;
            return this;
        }

        @NonNull
        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder setInsertionPoint(@NonNull PointF point) {
            this.mPoint = point;
            return this;
        }

        @NonNull
        public Builder setFallbackText(@Nullable String fallbackText) {
            this.mFallbackText = fallbackText;
            return this;
        }

        @NonNull
        public InsertGesture build() {
            if (this.mPoint == null) {
                throw new IllegalArgumentException("Insertion point must be set.");
            }
            if (this.mText == null) {
                throw new IllegalArgumentException("Text to insert must be set.");
            }
            return new InsertGesture(this.mText, this.mPoint, this.mFallbackText);
        }
    }
}

