/*
 * Decompiled with CFR 0.152.
 */
package android.view.inputmethod;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.Context;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.Process;
import android.os.SystemProperties;
import android.text.TextUtils;
import android.util.Log;
import android.view.SurfaceControl;
import android.view.View;
import android.view.ViewProtoLogGroups;
import android.view.ViewRootImpl;
import android.view.inputmethod.IInputMethodManagerGlobalInvoker;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.hidden_from_bootclasspath.android.tracing.Flags;
import com.android.internal.inputmethod.InputMethodDebug;
import com.android.internal.jank.InteractionJankMonitor;
import com.android.internal.protolog.ProtoLog;
import com.android.internal.util.LatencyTracker;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;

public interface ImeTracker {
    public static final String TAG = "ImeTracker";
    public static final boolean DEBUG_IME_VISIBILITY = SystemProperties.getBoolean("persist.debug.imf_event", false);
    public static final String TOKEN_NONE = "TOKEN_NONE";
    public static final int TYPE_SHOW = 1;
    public static final int TYPE_HIDE = 2;
    public static final int TYPE_USER = 3;
    public static final int STATUS_RUN = 1;
    public static final int STATUS_CANCEL = 2;
    public static final int STATUS_FAIL = 3;
    public static final int STATUS_SUCCESS = 4;
    public static final int STATUS_TIMEOUT = 5;
    public static final int ORIGIN_CLIENT = 5;
    public static final int ORIGIN_SERVER = 6;
    public static final int ORIGIN_IME = 7;
    public static final int ORIGIN_WM_SHELL = 8;
    public static final int PHASE_NOT_SET = 0;
    public static final int PHASE_CLIENT_VIEW_SERVED = 1;
    public static final int PHASE_SERVER_CLIENT_KNOWN = 2;
    public static final int PHASE_SERVER_CLIENT_FOCUSED = 3;
    public static final int PHASE_SERVER_ACCESSIBILITY = 4;
    public static final int PHASE_SERVER_SYSTEM_READY = 5;
    public static final int PHASE_SERVER_HIDE_IMPLICIT = 6;
    public static final int PHASE_SERVER_HIDE_NOT_ALWAYS = 7;
    public static final int PHASE_SERVER_WAIT_IME = 8;
    public static final int PHASE_SERVER_HAS_IME = 9;
    public static final int PHASE_SERVER_SHOULD_HIDE = 10;
    public static final int PHASE_IME_WRAPPER = 11;
    public static final int PHASE_IME_WRAPPER_DISPATCH = 12;
    public static final int PHASE_IME_SHOW_SOFT_INPUT = 13;
    public static final int PHASE_IME_HIDE_SOFT_INPUT = 14;
    public static final int PHASE_IME_ON_SHOW_SOFT_INPUT_TRUE = 15;
    public static final int PHASE_WM_SHOW_IME_READY = 19;
    public static final int PHASE_WM_WINDOW_INSETS_CONTROL_TARGET_SHOW_INSETS = 21;
    public static final int PHASE_WM_WINDOW_INSETS_CONTROL_TARGET_HIDE_INSETS = 22;
    public static final int PHASE_WM_REMOTE_INSETS_CONTROL_TARGET_SHOW_INSETS = 23;
    public static final int PHASE_WM_REMOTE_INSETS_CONTROL_TARGET_HIDE_INSETS = 24;
    public static final int PHASE_WM_REMOTE_INSETS_CONTROLLER = 25;
    public static final int PHASE_WM_ANIMATION_CREATE = 26;
    public static final int PHASE_WM_ANIMATION_RUNNING = 27;
    public static final int PHASE_CLIENT_SHOW_INSETS = 28;
    public static final int PHASE_CLIENT_HIDE_INSETS = 29;
    public static final int PHASE_CLIENT_HANDLE_SHOW_INSETS = 30;
    public static final int PHASE_CLIENT_HANDLE_HIDE_INSETS = 31;
    public static final int PHASE_CLIENT_APPLY_ANIMATION = 32;
    public static final int PHASE_CLIENT_CONTROL_ANIMATION = 33;
    public static final int PHASE_CLIENT_ANIMATION_RUNNING = 39;
    public static final int PHASE_CLIENT_ANIMATION_CANCEL = 40;
    public static final int PHASE_CLIENT_ANIMATION_FINISHED_SHOW = 41;
    public static final int PHASE_WM_ABORT_SHOW_IME_POST_LAYOUT = 43;
    public static final int PHASE_IME_SHOW_WINDOW = 44;
    public static final int PHASE_IME_HIDE_WINDOW = 45;
    public static final int PHASE_IME_PRIVILEGED_OPERATIONS = 46;
    public static final int PHASE_SERVER_CURRENT_ACTIVE_IME = 47;
    public static final int PHASE_CLIENT_REPORT_REQUESTED_VISIBLE_TYPES = 48;
    public static final int PHASE_WM_SET_REMOTE_TARGET_IME_VISIBILITY = 49;
    public static final int PHASE_WM_POST_LAYOUT_NOTIFY_CONTROLS_CHANGED = 50;
    public static final int PHASE_CLIENT_HANDLE_DISPATCH_IME_VISIBILITY_CHANGED = 51;
    public static final int PHASE_CLIENT_NOTIFY_IME_VISIBILITY_CHANGED = 52;
    public static final int PHASE_CLIENT_UPDATE_REQUESTED_VISIBLE_TYPES = 53;
    public static final int PHASE_WM_REMOTE_INSETS_CONTROL_TARGET_SET_REQUESTED_VISIBILITY = 54;
    public static final int PHASE_WM_GET_CONTROL_WITH_LEASH = 55;
    public static final int PHASE_WM_UPDATE_REQUESTED_VISIBLE_TYPES = 56;
    public static final int PHASE_SERVER_SET_VISIBILITY_ON_FOCUSED_WINDOW = 57;
    public static final int PHASE_CLIENT_HANDLE_SET_IME_VISIBILITY = 58;
    public static final int PHASE_CLIENT_SET_IME_VISIBILITY = 59;
    public static final int PHASE_WM_DISPATCH_IME_REQUESTED_CHANGED = 60;
    public static final int PHASE_CLIENT_NO_ONGOING_USER_ANIMATION = 61;
    public static final int PHASE_WM_NOTIFY_IME_VISIBILITY_CHANGED_FROM_CLIENT = 62;
    public static final int PHASE_WM_POSTING_CHANGED_IME_VISIBILITY = 63;
    public static final int PHASE_WM_INVOKING_IME_REQUESTED_LISTENER = 64;
    public static final int PHASE_CLIENT_ALREADY_HIDDEN = 65;
    public static final int PHASE_CLIENT_VIEW_HANDLER_AVAILABLE = 66;
    public static final int PHASE_SERVER_UPDATE_CLIENT_VISIBILITY = 67;
    public static final int PHASE_WM_DISPLAY_IME_CONTROLLER_SET_IME_REQUESTED_VISIBLE = 68;
    public static final int PHASE_WM_UPDATE_DISPLAY_WINDOW_REQUESTED_VISIBLE_TYPES = 69;
    public static final int PHASE_WM_REQUESTED_VISIBLE_TYPES_NOT_CHANGED = 70;
    public static final int PHASE_CLIENT_UPDATE_ANIMATING_TYPES = 71;
    public static final int PHASE_WM_UPDATE_ANIMATING_TYPES = 72;
    public static final int PHASE_WM_WINDOW_ANIMATING_TYPES_CHANGED = 73;
    public static final int PHASE_WM_NOTIFY_HIDE_ANIMATION_FINISHED = 74;
    public static final int PHASE_WM_UPDATE_DISPLAY_WINDOW_ANIMATING_TYPES = 75;
    public static final int PHASE_CLIENT_ON_CONTROLS_CHANGED = 76;
    public static final int PHASE_SERVER_IME_INVOKER = 77;
    public static final int PHASE_SERVER_CLIENT_INVOKER = 78;
    public static final int PHASE_SERVER_ALREADY_VISIBLE = 79;
    @NonNull
    public static final ImeTracker LOGGER = new ImeTracker(){
        private boolean mLogProgress;
        private boolean mLogStackTrace;
        {
            this.reloadSystemProperties();
            SystemProperties.addChangeCallback(this::reloadSystemProperties);
            if (Flags.imetrackerProtolog()) {
                ProtoLog.registerLogGroupInProcess(ViewProtoLogGroups.IME_TRACKER);
            }
        }

        @Override
        @NonNull
        public Token onStart(@NonNull String component, int uid, int type, int origin, int reason, boolean fromUser) {
            String tag = Token.createTag(component);
            Token token = IInputMethodManagerGlobalInvoker.onStart(tag, uid, type, origin, reason, fromUser);
            ImeTracker.log("%s: %s at %s reason %s fromUser %s%s", token.mTag, 1.getOnStartPrefix(type), Debug.originToString(origin), InputMethodDebug.softInputDisplayReasonToString(reason), fromUser, this.mLogStackTrace ? " Stack trace=" + Log.getStackTraceString(new Throwable()) : "");
            return token;
        }

        @Override
        public void onProgress(@Nullable Token token, int phase) {
            if (token == null) {
                return;
            }
            IInputMethodManagerGlobalInvoker.onProgress(token.mBinder, phase);
            if (this.mLogProgress) {
                ImeTracker.log("%s: onProgress at %s", token.mTag, Debug.phaseToString(phase));
            }
        }

        @Override
        public void onFailed(@Nullable Token token, int phase) {
            if (token == null) {
                return;
            }
            IInputMethodManagerGlobalInvoker.onFailed(token, phase);
            ImeTracker.log("%s: onFailed at %s", token.mTag, Debug.phaseToString(phase));
        }

        @Override
        public void onTodo(@Nullable Token token, int phase) {
            if (token == null) {
                return;
            }
            ImeTracker.log("%s: onTodo at %s", token.mTag, Debug.phaseToString(phase));
        }

        @Override
        public void onCancelled(@Nullable Token token, int phase) {
            if (token == null) {
                return;
            }
            IInputMethodManagerGlobalInvoker.onCancelled(token, phase);
            ImeTracker.log("%s: onCancelled at %s", token.mTag, Debug.phaseToString(phase));
        }

        @Override
        public void onShown(@Nullable Token token) {
            if (token == null) {
                return;
            }
            IInputMethodManagerGlobalInvoker.onShown(token);
            ImeTracker.log("%s: onShown", token.mTag);
        }

        @Override
        public void onHidden(@Nullable Token token) {
            if (token == null) {
                return;
            }
            IInputMethodManagerGlobalInvoker.onHidden(token);
            ImeTracker.log("%s: onHidden", token.mTag);
        }

        @Override
        public void onDispatched(@Nullable Token token) {
            if (token == null) {
                return;
            }
            IInputMethodManagerGlobalInvoker.onDispatched(token);
            ImeTracker.log("%s: onDispatched", token.mTag);
        }

        @Override
        public void onUserFinished(@Nullable Token token, boolean shown) {
            if (token == null) {
                return;
            }
            ImeTracker.log("%s: onUserFinished %s", token.mTag, shown ? "shown" : "hidden");
        }

        @NonNull
        private static String getOnStartPrefix(int type) {
            String string2;
            switch (type) {
                case 1: {
                    string2 = "onRequestShow";
                    break;
                }
                case 2: {
                    string2 = "onRequestHide";
                    break;
                }
                case 3: {
                    string2 = "onRequestUser";
                    break;
                }
                default: {
                    string2 = "onRequestUnknown";
                }
            }
            return string2;
        }

        private void reloadSystemProperties() {
            this.mLogProgress = SystemProperties.getBoolean("persist.debug.imetracker", false);
            this.mLogStackTrace = SystemProperties.getBoolean("persist.debug.imerequest.logstacktrace", false);
        }
    };
    public static final ImeJankTracker JANK_TRACKER = new ImeJankTracker();
    public static final ImeLatencyTracker LATENCY_TRACKER = new ImeLatencyTracker();

    @NonNull
    public Token onStart(@NonNull String var1, int var2, int var3, int var4, int var5, boolean var6);

    @NonNull
    default public Token onStart(int type, int origin, int reason, boolean fromUser) {
        return this.onStart(Process.myProcessName(), Process.myUid(), type, origin, reason, fromUser);
    }

    public void onProgress(@Nullable Token var1, int var2);

    public void onFailed(@Nullable Token var1, int var2);

    public void onTodo(@Nullable Token var1, int var2);

    public void onCancelled(@Nullable Token var1, int var2);

    public void onShown(@Nullable Token var1);

    public void onHidden(@Nullable Token var1);

    public void onDispatched(@Nullable Token var1);

    public void onUserFinished(@Nullable Token var1, boolean var2);

    public static boolean isFromUser(@Nullable View view) {
        if (view == null) {
            return false;
        }
        Handler handler = view.getHandler();
        if (handler == null || handler.getLooper() == null || !handler.getLooper().isCurrentThread()) {
            return false;
        }
        ViewRootImpl viewRootImpl = view.getViewRootImpl();
        return viewRootImpl != null && viewRootImpl.isHandlingPointerEvent();
    }

    @NonNull
    public static ImeTracker forLogging() {
        return LOGGER;
    }

    @NonNull
    public static ImeJankTracker forJank() {
        return JANK_TRACKER;
    }

    @NonNull
    public static ImeLatencyTracker forLatency() {
        return LATENCY_TRACKER;
    }

    private static void log(@NonNull String messageString, Object ... args) {
        if (Flags.imetrackerProtolog()) {
            ProtoLog.i(ViewProtoLogGroups.IME_TRACKER, messageString, args);
        } else {
            String message = TextUtils.formatSimple(messageString, args);
            Log.i(TAG, message);
        }
    }

    public static class Token
    implements Parcelable {
        @Nullable
        private static IBinder sEmptyBinder;
        @NonNull
        private final IBinder mBinder;
        @NonNull
        private final String mTag;
        @NonNull
        public static final Parcelable.Creator<Token> CREATOR;

        public Token(@NonNull IBinder binder, @NonNull String tag) {
            this.mBinder = binder;
            this.mTag = tag;
        }

        private Token(@NonNull Parcel in) {
            this.mBinder = in.readStrongBinder();
            this.mTag = in.readString8();
        }

        @NonNull
        public IBinder getBinder() {
            return this.mBinder;
        }

        @NonNull
        public String getTag() {
            return this.mTag;
        }

        @NonNull
        private static String createTag(@NonNull String component) {
            return component + ":" + Integer.toHexString(ThreadLocalRandom.current().nextInt());
        }

        @NonNull
        @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
        public static Token empty() {
            String tag = Token.createTag(Process.myProcessName());
            return Token.empty(tag);
        }

        @NonNull
        static Token empty(@NonNull String tag) {
            return new Token(Token.getEmptyBinder(), tag);
        }

        @NonNull
        private static IBinder getEmptyBinder() {
            if (sEmptyBinder == null) {
                sEmptyBinder = new Binder();
            }
            return sEmptyBinder;
        }

        public String toString() {
            return super.toString() + "(tag: " + this.mTag + ")";
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeStrongBinder(this.mBinder);
            dest.writeString8(this.mTag);
        }

        static {
            CREATOR = new Parcelable.Creator<Token>(){

                @Override
                @NonNull
                public Token createFromParcel(@NonNull Parcel in) {
                    return new Token(in);
                }

                @NonNull
                public Token[] newArray(int size) {
                    return new Token[size];
                }
            };
        }
    }

    public static class ImeJankTracker {
        private ImeJankTracker() {
        }

        public void onRequestAnimation(@NonNull InputMethodJankContext jankContext, int animType, boolean useSeparatedThread) {
            int cujType = ImeJankTracker.getImeInsetsCujFromAnimation(animType);
            if (jankContext.getDisplayContext() == null || jankContext.getTargetSurfaceControl() == null || cujType == -1) {
                return;
            }
            InteractionJankMonitor.Configuration.Builder builder = InteractionJankMonitor.Configuration.Builder.withSurface(cujType, jankContext.getDisplayContext(), jankContext.getTargetSurfaceControl(), jankContext.getDisplayContext().getMainThreadHandler()).setTag(String.format(Locale.US, "%d@%d@%s", animType, useSeparatedThread ? 0 : 1, jankContext.getHostPackageName()));
            InteractionJankMonitor.getInstance().begin(builder);
        }

        public void onCancelAnimation(int animType) {
            int cujType = ImeJankTracker.getImeInsetsCujFromAnimation(animType);
            if (cujType != -1) {
                InteractionJankMonitor.getInstance().cancel(cujType);
            }
        }

        public void onFinishAnimation(int animType) {
            int cujType = ImeJankTracker.getImeInsetsCujFromAnimation(animType);
            if (cujType != -1) {
                InteractionJankMonitor.getInstance().end(cujType);
            }
        }

        private static int getImeInsetsCujFromAnimation(int animType) {
            switch (animType) {
                case 0: {
                    return 80;
                }
                case 1: {
                    return 81;
                }
            }
            return -1;
        }
    }

    public static class ImeLatencyTracker {
        private ImeLatencyTracker() {
        }

        private boolean shouldMonitorLatency(int reason) {
            return reason == 1 || reason == 4 || reason == 39 || reason == 26 || reason == 28 || reason == 3 || reason == 5;
        }

        public void onRequestShow(@Nullable Token token, int origin, int reason, @NonNull InputMethodLatencyContext latencyContext) {
            if (!this.shouldMonitorLatency(reason)) {
                return;
            }
            LatencyTracker.getInstance(latencyContext.getAppContext()).onActionStart(20, InputMethodDebug.softInputDisplayReasonToString(reason));
        }

        public void onRequestHide(@Nullable Token token, int origin, int reason, @NonNull InputMethodLatencyContext latencyContext) {
            if (!this.shouldMonitorLatency(reason)) {
                return;
            }
            LatencyTracker.getInstance(latencyContext.getAppContext()).onActionStart(21, InputMethodDebug.softInputDisplayReasonToString(reason));
        }

        public void onShowFailed(@Nullable Token token, int phase, @NonNull InputMethodLatencyContext latencyContext) {
            this.onShowCancelled(token, phase, latencyContext);
        }

        public void onHideFailed(@Nullable Token token, int phase, @NonNull InputMethodLatencyContext latencyContext) {
            this.onHideCancelled(token, phase, latencyContext);
        }

        public void onShowCancelled(@Nullable Token token, int phase, @NonNull InputMethodLatencyContext latencyContext) {
            LatencyTracker.getInstance(latencyContext.getAppContext()).onActionCancel(20);
        }

        public void onHideCancelled(@Nullable Token token, int phase, @NonNull InputMethodLatencyContext latencyContext) {
            LatencyTracker.getInstance(latencyContext.getAppContext()).onActionCancel(21);
        }

        public void onShown(@Nullable Token token, @NonNull InputMethodLatencyContext latencyContext) {
            LatencyTracker.getInstance(latencyContext.getAppContext()).onActionEnd(20);
        }

        public void onHidden(@Nullable Token token, @NonNull InputMethodLatencyContext latencyContext) {
            LatencyTracker.getInstance(latencyContext.getAppContext()).onActionEnd(21);
        }
    }

    public static interface InputMethodLatencyContext {
        public Context getAppContext();
    }

    public static interface InputMethodJankContext {
        public Context getDisplayContext();

        public SurfaceControl getTargetSurfaceControl();

        public String getHostPackageName();
    }

    public static class Debug {
        @NonNull
        private static final Map<Integer, String> sTypes = Debug.getFieldMapping(ImeTracker.class, "TYPE_");
        @NonNull
        private static final Map<Integer, String> sStatus = Debug.getFieldMapping(ImeTracker.class, "STATUS_");
        @NonNull
        private static final Map<Integer, String> sOrigins = Debug.getFieldMapping(ImeTracker.class, "ORIGIN_");
        @NonNull
        private static final Map<Integer, String> sPhases = Debug.getFieldMapping(ImeTracker.class, "PHASE_");

        @NonNull
        public static String typeToString(int type) {
            return sTypes.getOrDefault(type, "TYPE_" + type);
        }

        @NonNull
        public static String statusToString(int status) {
            return sStatus.getOrDefault(status, "STATUS_" + status);
        }

        @NonNull
        public static String originToString(int origin) {
            return sOrigins.getOrDefault(origin, "ORIGIN_" + origin);
        }

        @NonNull
        public static String phaseToString(int phase) {
            return sPhases.getOrDefault(phase, "PHASE_" + phase);
        }

        @NonNull
        private static Map<Integer, String> getFieldMapping(Class<?> cls, @NonNull String fieldPrefix) {
            return Arrays.stream(cls.getDeclaredFields()).filter(field -> field.getName().startsWith(fieldPrefix)).collect(Collectors.toMap(Debug::getFieldValue, Field::getName));
        }

        private static int getFieldValue(@NonNull Field field) {
            try {
                return field.getInt(null);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Phase {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Origin {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Status {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Type {
    }
}

