/*
 * Decompiled with CFR 0.152.
 */
package android.view.contentcapture;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.ComponentName;
import android.content.pm.ParceledListSlice;
import android.graphics.Insets;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.Trace;
import android.text.Selection;
import android.text.Spannable;
import android.text.TextUtils;
import android.util.LocalLog;
import android.util.Log;
import android.util.SparseArray;
import android.util.TimeUtils;
import android.view.View;
import android.view.ViewStructure;
import android.view.autofill.AutofillId;
import android.view.contentcapture.ChildContentCaptureSession;
import android.view.contentcapture.ContentCaptureContext;
import android.view.contentcapture.ContentCaptureEvent;
import android.view.contentcapture.ContentCaptureHelper;
import android.view.contentcapture.ContentCaptureManager;
import android.view.contentcapture.ContentCaptureSession;
import android.view.contentcapture.IContentCaptureDirectManager;
import android.view.contentcapture.IContentCaptureManager;
import android.view.contentcapture.ViewNode;
import android.view.contentprotection.ContentProtectionEventProcessor;
import android.view.inputmethod.BaseInputConnection;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.hidden_from_bootclasspath.android.view.contentcapture.flags.Flags;
import com.android.internal.lang.System_Delegate;
import com.android.internal.os.IResultReceiver;
import com.android.modules.expresslog.Counter;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

@VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
public class MainContentCaptureSession
extends ContentCaptureSession {
    private static final String TAG = MainContentCaptureSession.class.getSimpleName();
    private static final String CONTENT_CAPTURE_WRONG_THREAD_METRIC_ID = "content_capture.value_content_capture_wrong_thread_count";
    private static final boolean FORCE_FLUSH = true;
    private static final int MSG_FLUSH = 1;
    @NonNull
    private final AtomicBoolean mDisabled = new AtomicBoolean(false);
    @NonNull
    private final ContentCaptureManager.StrippedContext mContext;
    @NonNull
    private final ContentCaptureManager mManager;
    @NonNull
    private final Handler mUiHandler;
    @NonNull
    private final Handler mContentCaptureHandler;
    @NonNull
    private final IContentCaptureManager mSystemServerInterface;
    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    @Nullable
    public IContentCaptureDirectManager mDirectServiceInterface;
    @Nullable
    private IBinder.DeathRecipient mDirectServiceVulture;
    private int mState = 0;
    @Nullable
    private IBinder mApplicationToken;
    @Nullable
    private IBinder mShareableActivityToken;
    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    @Nullable
    public ComponentName mComponentName;
    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    @NonNull
    public final ConcurrentLinkedQueue<ContentCaptureEvent> mEventProcessQueue;
    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    @Nullable
    public ArrayList<ContentCaptureEvent> mEvents;
    private long mNextFlush;
    private boolean mNextFlushForTextChanged = false;
    @Nullable
    private final LocalLog mFlushHistory;
    private final AtomicInteger mWrongThreadCount = new AtomicInteger(0);
    @NonNull
    private final SessionStateReceiver mSessionStateReceiver;
    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    @Nullable
    public ContentProtectionEventProcessor mContentProtectionEventProcessor;

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PROTECTED)
    public MainContentCaptureSession(@NonNull ContentCaptureManager.StrippedContext context, @NonNull ContentCaptureManager manager, @NonNull Handler uiHandler, @NonNull Handler contentCaptureHandler, @NonNull IContentCaptureManager systemServerInterface) {
        this.mContext = context;
        this.mManager = manager;
        this.mUiHandler = uiHandler;
        this.mContentCaptureHandler = contentCaptureHandler;
        this.mSystemServerInterface = systemServerInterface;
        int logHistorySize = this.mManager.mOptions.logHistorySize;
        this.mFlushHistory = logHistorySize > 0 ? new LocalLog(logHistorySize) : null;
        this.mSessionStateReceiver = new SessionStateReceiver(this);
        this.mEventProcessQueue = new ConcurrentLinkedQueue();
    }

    @Override
    ContentCaptureSession getMainCaptureSession() {
        return this;
    }

    @Override
    ContentCaptureSession newChild(@NonNull ContentCaptureContext clientContext) {
        ChildContentCaptureSession child = new ChildContentCaptureSession(this, clientContext);
        this.internalNotifyChildSessionStarted(this.mId, child.mId, clientContext);
        return child;
    }

    @Override
    void start(@NonNull IBinder token, @NonNull IBinder shareableActivityToken, @NonNull ComponentName component, int flags) {
        this.runOnContentCaptureThread(() -> this.startImpl(token, shareableActivityToken, component, flags));
    }

    private void startImpl(@NonNull IBinder token, @NonNull IBinder shareableActivityToken, @NonNull ComponentName component, int flags) {
        this.checkOnContentCaptureThread();
        if (!this.isContentCaptureEnabled()) {
            return;
        }
        if (ContentCaptureHelper.sVerbose) {
            Log.v(TAG, "start(): token=" + token + ", comp=" + ComponentName.flattenToShortString(component));
        }
        if (this.hasStarted()) {
            if (ContentCaptureHelper.sDebug) {
                Log.d(TAG, "ignoring handleStartSession(" + token + "/" + ComponentName.flattenToShortString(component) + " while on state " + MainContentCaptureSession.getStateAsString(this.mState));
            }
            return;
        }
        this.mState = 1;
        this.mApplicationToken = token;
        this.mShareableActivityToken = shareableActivityToken;
        this.mComponentName = component;
        if (ContentCaptureHelper.sVerbose) {
            Log.v(TAG, "handleStartSession(): token=" + token + ", act=" + this.getDebugState() + ", id=" + this.mId);
        }
        try {
            this.mSystemServerInterface.startSession(this.mApplicationToken, this.mShareableActivityToken, component, this.mId, flags, this.mSessionStateReceiver);
        }
        catch (RemoteException e) {
            Log.w(TAG, "Error starting session for " + component.flattenToShortString() + ": " + e);
        }
    }

    @Override
    void onDestroy() {
        this.clearAndRunOnContentCaptureThread(() -> {
            try {
                this.flush(4);
            }
            finally {
                this.destroySession();
            }
        }, 1);
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    public void onSessionStarted(int resultCode, @Nullable IBinder binder) {
        this.checkOnContentCaptureThread();
        if (binder != null) {
            this.mDirectServiceInterface = IContentCaptureDirectManager.Stub.asInterface(binder);
            this.mDirectServiceVulture = () -> {
                Log.w(TAG, "Keeping session " + this.mId + " when service died");
                this.mState = 1024;
                this.mDisabled.set(true);
            };
            try {
                binder.linkToDeath(this.mDirectServiceVulture, 0);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed to link to death on " + binder + ": " + e);
            }
        }
        this.mContentProtectionEventProcessor = this.isContentProtectionEnabled() ? new ContentProtectionEventProcessor(this.mManager.getContentProtectionEventBuffer(), this.mContentCaptureHandler, this.mSystemServerInterface, this.mComponentName.getPackageName(), this.mManager.mOptions.contentProtectionOptions) : null;
        if ((resultCode & 4) != 0) {
            this.resetSession(resultCode);
        } else {
            this.mState = resultCode;
            this.mDisabled.set(false);
            this.flushIfNeeded(7);
        }
        if (ContentCaptureHelper.sVerbose) {
            Log.v(TAG, "handleSessionStarted() result: id=" + this.mId + " resultCode=" + resultCode + ", state=" + MainContentCaptureSession.getStateAsString(this.mState) + ", disabled=" + this.mDisabled.get() + ", binder=" + binder + ", events=" + (this.mEvents == null ? 0 : this.mEvents.size()));
        }
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    public void sendEvent(@NonNull ContentCaptureEvent event) {
        this.sendEvent(event, false);
    }

    private void sendEvent(@NonNull ContentCaptureEvent event, boolean forceFlush) {
        this.checkOnContentCaptureThread();
        int eventType = event.getType();
        if (ContentCaptureHelper.sVerbose) {
            Log.v(TAG, "handleSendEvent(" + this.getDebugState() + "): " + event);
        }
        if (!this.hasStarted() && eventType != -1 && eventType != 6) {
            if (ContentCaptureHelper.sVerbose) {
                Log.v(TAG, "handleSendEvent(" + this.getDebugState() + ", " + ContentCaptureEvent.getTypeAsString(eventType) + "): dropping because session not started yet");
            }
            return;
        }
        if (this.mDisabled.get()) {
            if (ContentCaptureHelper.sVerbose) {
                Log.v(TAG, "handleSendEvent(): ignoring when disabled");
            }
            return;
        }
        if (Trace.isTagEnabled(8L) && eventType == 4) {
            Trace.asyncTraceBegin(8L, "sendEventAsync", 0);
        }
        if (this.isContentProtectionReceiverEnabled()) {
            this.sendContentProtectionEvent(event);
        }
        if (this.isContentCaptureReceiverEnabled()) {
            this.sendContentCaptureEvent(event, forceFlush);
        }
        if (Trace.isTagEnabled(8L) && eventType == 5) {
            Trace.asyncTraceEnd(8L, "sendEventAsync", 0);
        }
    }

    private void sendContentProtectionEvent(@NonNull ContentCaptureEvent event) {
        this.checkOnContentCaptureThread();
        if (this.mContentProtectionEventProcessor != null) {
            this.mContentProtectionEventProcessor.processEvent(event);
        }
    }

    private void sendContentCaptureEvent(@NonNull ContentCaptureEvent event, boolean forceFlush) {
        int flushReason;
        int numberEvents;
        boolean bufferEvent;
        ContentCaptureEvent lastEvent;
        this.checkOnContentCaptureThread();
        int eventType = event.getType();
        int maxBufferSize = this.mManager.mOptions.maxBufferSize;
        if (this.mEvents == null) {
            if (ContentCaptureHelper.sVerbose) {
                Log.v(TAG, "handleSendEvent(): creating buffer for " + maxBufferSize + " events");
            }
            this.mEvents = new ArrayList(maxBufferSize);
        }
        boolean addEvent = true;
        if (eventType == 3) {
            CharSequence text = event.getText();
            boolean hasComposingSpan = event.hasComposingSpan();
            if (hasComposingSpan) {
                ContentCaptureEvent lastEvent2 = null;
                for (int index = this.mEvents.size() - 1; index >= 0; --index) {
                    ContentCaptureEvent tmpEvent = this.mEvents.get(index);
                    if (!event.getId().equals(tmpEvent.getId())) continue;
                    lastEvent2 = tmpEvent;
                    break;
                }
                if (lastEvent2 != null && lastEvent2.hasComposingSpan()) {
                    boolean equalContent;
                    CharSequence lastText = lastEvent2.getText();
                    boolean bothNonEmpty = !TextUtils.isEmpty(lastText) && !TextUtils.isEmpty(text);
                    boolean bl = equalContent = TextUtils.equals(lastText, text) && lastEvent2.hasSameComposingSpan(event) && lastEvent2.hasSameSelectionSpan(event);
                    if (equalContent) {
                        addEvent = false;
                    } else if (bothNonEmpty) {
                        lastEvent2.mergeEvent(event);
                        addEvent = false;
                    }
                    if (!addEvent && ContentCaptureHelper.sVerbose) {
                        Log.v(TAG, "Buffering VIEW_TEXT_CHANGED event, updated text=" + ContentCaptureHelper.getSanitizedString(text));
                    }
                }
            }
        }
        if (!this.mEvents.isEmpty() && eventType == 2 && (lastEvent = this.mEvents.get(this.mEvents.size() - 1)).getType() == 2 && event.getSessionId() == lastEvent.getSessionId()) {
            if (ContentCaptureHelper.sVerbose) {
                Log.v(TAG, "Buffering TYPE_VIEW_DISAPPEARED events for session " + lastEvent.getSessionId());
            }
            lastEvent.mergeEvent(event);
            addEvent = false;
        }
        if (addEvent) {
            this.mEvents.add(event);
        }
        boolean bl = bufferEvent = (numberEvents = this.mEvents.size()) < maxBufferSize;
        if (bufferEvent && !forceFlush) {
            int flushReason2;
            if (eventType == 3) {
                this.mNextFlushForTextChanged = true;
                flushReason2 = 6;
            } else {
                if (this.mNextFlushForTextChanged) {
                    if (ContentCaptureHelper.sVerbose) {
                        Log.i(TAG, "Not scheduling flush because next flush is for text changed");
                    }
                    return;
                }
                flushReason2 = 5;
            }
            this.scheduleFlush(flushReason2, true);
            return;
        }
        if (this.mState != 2 && numberEvents >= maxBufferSize) {
            if (ContentCaptureHelper.sDebug) {
                Log.d(TAG, "Closing session for " + this.getDebugState() + " after " + numberEvents + " delayed events");
            }
            this.resetSession(132);
            return;
        }
        switch (eventType) {
            case -1: {
                flushReason = 3;
                break;
            }
            case -2: {
                flushReason = 4;
                break;
            }
            case 4: {
                flushReason = 9;
                break;
            }
            case 5: {
                flushReason = 10;
                break;
            }
            default: {
                flushReason = forceFlush ? 8 : 1;
            }
        }
        this.flush(flushReason);
    }

    private boolean hasStarted() {
        this.checkOnContentCaptureThread();
        return this.mState != 0;
    }

    private void scheduleFlush(int reason, boolean checkExisting) {
        int flushFrequencyMs;
        this.checkOnContentCaptureThread();
        if (ContentCaptureHelper.sVerbose) {
            Log.v(TAG, "handleScheduleFlush(" + this.getDebugState(reason) + ", checkExisting=" + checkExisting);
        }
        if (!this.hasStarted()) {
            if (ContentCaptureHelper.sVerbose) {
                Log.v(TAG, "handleScheduleFlush(): session not started yet");
            }
            return;
        }
        if (this.mDisabled.get()) {
            Log.e(TAG, "handleScheduleFlush(" + this.getDebugState(reason) + "): should not be called when disabled. events=" + (this.mEvents == null ? null : Integer.valueOf(this.mEvents.size())));
            return;
        }
        if (checkExisting && this.mContentCaptureHandler.hasMessages(1)) {
            this.mContentCaptureHandler.removeMessages(1);
        }
        if (reason == 6) {
            flushFrequencyMs = this.mManager.mOptions.textChangeFlushingFrequencyMs;
        } else {
            if (reason != 5 && ContentCaptureHelper.sDebug) {
                Log.d(TAG, "handleScheduleFlush(" + this.getDebugState(reason) + "): not a timeout reason because mDirectServiceInterface is not ready yet");
            }
            flushFrequencyMs = this.mManager.mOptions.idleFlushingFrequencyMs;
        }
        this.mNextFlush = System_Delegate.currentTimeMillis() + (long)flushFrequencyMs;
        if (ContentCaptureHelper.sVerbose) {
            Log.v(TAG, "handleScheduleFlush(): scheduled to flush in " + flushFrequencyMs + "ms: " + TimeUtils.logTimeOfDay(this.mNextFlush));
        }
        this.mContentCaptureHandler.postDelayed(() -> this.flushIfNeeded(reason), 1, (long)flushFrequencyMs);
    }

    private void flushIfNeeded(int reason) {
        this.checkOnContentCaptureThread();
        if (this.mEvents == null || this.mEvents.isEmpty()) {
            if (ContentCaptureHelper.sVerbose) {
                Log.v(TAG, "Nothing to flush");
            }
            return;
        }
        this.flush(reason);
    }

    @Override
    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public void flush(int reason) {
        this.runOnContentCaptureThread(() -> this.flushImpl(reason));
    }

    private void flushImpl(int reason) {
        this.checkOnContentCaptureThread();
        if (this.mEvents == null || this.mEvents.size() == 0) {
            if (ContentCaptureHelper.sVerbose) {
                Log.v(TAG, "Don't flush for empty event buffer.");
            }
            return;
        }
        if (this.mDisabled.get()) {
            Log.e(TAG, "handleForceFlush(" + this.getDebugState(reason) + "): should not be when disabled");
            return;
        }
        if (!this.isContentCaptureReceiverEnabled()) {
            return;
        }
        if (this.mDirectServiceInterface == null) {
            if (ContentCaptureHelper.sVerbose) {
                Log.v(TAG, "handleForceFlush(" + this.getDebugState(reason) + "): hold your horses, client not ready: " + this.mEvents);
            }
            if (!this.mContentCaptureHandler.hasMessages(1)) {
                this.scheduleFlush(reason, false);
            }
            return;
        }
        this.mNextFlushForTextChanged = false;
        int numberEvents = this.mEvents.size();
        String reasonString = MainContentCaptureSession.getFlushReasonAsString(reason);
        if (ContentCaptureHelper.sVerbose) {
            ContentCaptureEvent event = this.mEvents.get(numberEvents - 1);
            String forceString = reason == 8 ? ". The force flush event " + ContentCaptureEvent.getTypeAsString(event.getType()) : "";
            Log.v(TAG, "Flushing " + numberEvents + " event(s) for " + this.getDebugState(reason) + forceString);
        }
        if (this.mFlushHistory != null) {
            String logRecord = "r=" + reasonString + " s=" + numberEvents + " m=" + this.mManager.mOptions.maxBufferSize + " i=" + this.mManager.mOptions.idleFlushingFrequencyMs;
            this.mFlushHistory.log(logRecord);
        }
        try {
            this.mContentCaptureHandler.removeMessages(1);
            ParceledListSlice<ContentCaptureEvent> events = this.clearEvents();
            this.mDirectServiceInterface.sendEvents(events, reason, this.mManager.mOptions);
        }
        catch (RemoteException e) {
            Log.w(TAG, "Error sending " + numberEvents + " for " + this.getDebugState() + ": " + e);
        }
    }

    @Override
    public void updateContentCaptureContext(@Nullable ContentCaptureContext context) {
        this.internalNotifyContextUpdated(this.mId, context);
    }

    @NonNull
    private ParceledListSlice<ContentCaptureEvent> clearEvents() {
        this.checkOnContentCaptureThread();
        if (this.mEvents == null) {
            return new ParceledListSlice<ContentCaptureEvent>(Collections.EMPTY_LIST);
        }
        ArrayList<ContentCaptureEvent> events = new ArrayList<ContentCaptureEvent>(this.mEvents);
        this.mEvents.clear();
        return new ParceledListSlice<ContentCaptureEvent>(events);
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    public void destroySession() {
        this.checkOnContentCaptureThread();
        if (ContentCaptureHelper.sDebug) {
            Log.d(TAG, "Destroying session (ctx=" + this.mContext + ", id=" + this.mId + ") with " + (this.mEvents == null ? 0 : this.mEvents.size()) + " event(s) for " + this.getDebugState());
        }
        this.reportWrongThreadMetric();
        try {
            this.mSystemServerInterface.finishSession(this.mId);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error destroying system-service session " + this.mId + " for " + this.getDebugState() + ": " + e);
        }
        if (this.mDirectServiceInterface != null) {
            this.mDirectServiceInterface.asBinder().unlinkToDeath(this.mDirectServiceVulture, 0);
        }
        this.mDirectServiceInterface = null;
        this.mContentProtectionEventProcessor = null;
        this.mEventProcessQueue.clear();
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    public void resetSession(int newState) {
        this.checkOnContentCaptureThread();
        if (ContentCaptureHelper.sVerbose) {
            Log.v(TAG, "handleResetSession(" + this.getActivityName() + "): from " + MainContentCaptureSession.getStateAsString(this.mState) + " to " + MainContentCaptureSession.getStateAsString(newState));
        }
        this.mState = newState;
        this.mDisabled.set((newState & 4) != 0);
        this.mApplicationToken = null;
        this.mShareableActivityToken = null;
        this.mComponentName = null;
        this.mEvents = null;
        if (this.mDirectServiceInterface != null) {
            try {
                this.mDirectServiceInterface.asBinder().unlinkToDeath(this.mDirectServiceVulture, 0);
            }
            catch (NoSuchElementException e) {
                Log.w(TAG, "IContentCaptureDirectManager does not exist");
            }
        }
        this.mDirectServiceInterface = null;
        this.mContentProtectionEventProcessor = null;
        this.mContentCaptureHandler.removeMessages(1);
    }

    @Override
    void internalNotifyViewAppeared(int sessionId, @NonNull ViewNode.ViewStructureImpl node) {
        ContentCaptureEvent event = new ContentCaptureEvent(sessionId, 1).setViewNode(node.mNode);
        this.enqueueEvent(event);
    }

    @Override
    void internalNotifyViewDisappeared(int sessionId, @NonNull AutofillId id2) {
        ContentCaptureEvent event = new ContentCaptureEvent(sessionId, 2).setAutofillId(id2);
        this.enqueueEvent(event);
    }

    @Override
    void internalNotifyViewTextChanged(int sessionId, @NonNull AutofillId id2, @Nullable CharSequence text) {
        int composingEnd;
        int composingStart;
        CharSequence eventText;
        CharSequence trimmed = TextUtils.trimToParcelableSize(text);
        CharSequence charSequence = eventText = trimmed != null && trimmed == text ? trimmed.toString() : trimmed;
        if (text instanceof Spannable) {
            composingStart = BaseInputConnection.getComposingSpanStart((Spannable)text);
            composingEnd = BaseInputConnection.getComposingSpanEnd((Spannable)text);
        } else {
            composingStart = -1;
            composingEnd = -1;
        }
        int startIndex = Selection.getSelectionStart(text);
        int endIndex = Selection.getSelectionEnd(text);
        ContentCaptureEvent event = new ContentCaptureEvent(sessionId, 3).setAutofillId(id2).setText(eventText).setComposingIndex(composingStart, composingEnd).setSelectionIndex(startIndex, endIndex);
        this.enqueueEvent(event);
    }

    @Override
    void internalNotifyViewInsetsChanged(int sessionId, @NonNull Insets viewInsets) {
        ContentCaptureEvent event = new ContentCaptureEvent(sessionId, 9).setInsets(viewInsets);
        this.enqueueEvent(event);
    }

    @Override
    public void internalNotifyViewTreeEvent(int sessionId, boolean started) {
        int type = started ? 4 : 5;
        boolean disableFlush = this.mManager.getFlushViewTreeAppearingEventDisabled();
        boolean forceFlush = disableFlush ? !started : true;
        ContentCaptureEvent event = new ContentCaptureEvent(sessionId, type);
        this.enqueueEvent(event, forceFlush);
    }

    @Override
    public void internalNotifySessionResumed() {
        ContentCaptureEvent event = new ContentCaptureEvent(this.mId, 7);
        this.enqueueEvent(event, true);
    }

    @Override
    public void internalNotifySessionPaused() {
        ContentCaptureEvent event = new ContentCaptureEvent(this.mId, 8);
        this.enqueueEvent(event, true);
    }

    @Override
    boolean isContentCaptureEnabled() {
        return super.isContentCaptureEnabled() && this.mManager.isContentCaptureEnabled();
    }

    @Override
    boolean isDisabled() {
        return this.mDisabled.get();
    }

    @Override
    boolean setDisabled(boolean disabled) {
        return this.mDisabled.compareAndSet(!disabled, disabled);
    }

    @Override
    void internalNotifyChildSessionStarted(int parentSessionId, int childSessionId, @NonNull ContentCaptureContext clientContext) {
        ContentCaptureEvent event = new ContentCaptureEvent(childSessionId, -1).setParentSessionId(parentSessionId).setClientContext(clientContext);
        this.enqueueEvent(event, true);
    }

    @Override
    void internalNotifyChildSessionFinished(int parentSessionId, int childSessionId) {
        ContentCaptureEvent event = new ContentCaptureEvent(childSessionId, -2).setParentSessionId(parentSessionId);
        this.enqueueEvent(event, true);
    }

    @Override
    void internalNotifyContextUpdated(int sessionId, @Nullable ContentCaptureContext context) {
        ContentCaptureEvent event = new ContentCaptureEvent(sessionId, 6).setClientContext(context);
        this.enqueueEvent(event, true);
    }

    @Override
    public void notifyWindowBoundsChanged(int sessionId, @NonNull Rect bounds) {
        ContentCaptureEvent event = new ContentCaptureEvent(sessionId, 10).setBounds(bounds);
        this.enqueueEvent(event);
    }

    @Override
    void internalNotifySessionFlushEvent(int sessionId) {
        ContentCaptureEvent event = new ContentCaptureEvent(sessionId, 11);
        this.enqueueEvent(event, true);
    }

    private List<ContentCaptureEvent> clearBufferEvents() {
        ContentCaptureEvent event;
        ArrayList<ContentCaptureEvent> bufferEvents = new ArrayList<ContentCaptureEvent>();
        while ((event = this.mEventProcessQueue.poll()) != null) {
            bufferEvents.add(event);
        }
        return bufferEvents;
    }

    private void enqueueEvent(@NonNull ContentCaptureEvent event) {
        this.enqueueEvent(event, false);
    }

    private void enqueueEvent(@NonNull ContentCaptureEvent event, boolean forceFlush) {
        if (forceFlush || this.mEventProcessQueue.size() >= this.mManager.mOptions.maxBufferSize - 1) {
            List<ContentCaptureEvent> batchEvents = this.clearBufferEvents();
            this.runOnContentCaptureThread(() -> {
                for (int i = 0; i < batchEvents.size(); ++i) {
                    this.sendEvent((ContentCaptureEvent)batchEvents.get(i));
                }
                this.sendEvent(event, true);
            });
        } else {
            this.mEventProcessQueue.offer(event);
        }
    }

    @Override
    public void notifyContentCaptureEvents(@NonNull SparseArray<ArrayList<Object>> contentCaptureEvents) {
        this.runOnUiThread(() -> {
            this.prepareViewStructures(contentCaptureEvents);
            this.runOnContentCaptureThread(() -> this.notifyContentCaptureEventsImpl(contentCaptureEvents));
        });
    }

    private void prepareViewStructures(@NonNull SparseArray<ArrayList<Object>> contentCaptureEvents) {
        for (int i = 0; i < contentCaptureEvents.size(); ++i) {
            int sessionId = contentCaptureEvents.keyAt(i);
            ArrayList<Object> events = contentCaptureEvents.valueAt(i);
            for (int j = 0; j < events.size(); ++j) {
                Object event = events.get(j);
                if (!(event instanceof View)) continue;
                View view = (View)event;
                ContentCaptureSession session = view.getContentCaptureSession();
                ViewStructureSession structureSession = new ViewStructureSession();
                events.set(j, structureSession);
                if (session == null) {
                    Log.w(TAG, "no content capture session on view: " + view);
                    continue;
                }
                int actualId = session.getId();
                if (actualId != sessionId) {
                    Log.w(TAG, "content capture session mismatch for view (" + view + "): was " + sessionId + " before, it's " + actualId + " now");
                    continue;
                }
                ViewStructure structure = session.newViewStructure(view);
                view.onProvideContentCaptureStructure(structure, 0);
                structureSession.setSession(session);
                structureSession.setStructure(structure);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyContentCaptureEventsImpl(@NonNull SparseArray<ArrayList<Object>> contentCaptureEvents) {
        this.checkOnContentCaptureThread();
        try {
            if (Trace.isTagEnabled(8L)) {
                Trace.traceBegin(8L, "notifyContentCaptureEvents");
            }
            for (int i = 0; i < contentCaptureEvents.size(); ++i) {
                int sessionId = contentCaptureEvents.keyAt(i);
                this.internalNotifyViewTreeEvent(sessionId, true);
                ArrayList<Object> events = contentCaptureEvents.valueAt(i);
                for (int j = 0; j < events.size(); ++j) {
                    Object event = events.get(j);
                    if (event instanceof AutofillId) {
                        this.internalNotifyViewDisappeared(sessionId, (AutofillId)event);
                        continue;
                    }
                    if (event instanceof ViewStructureSession) {
                        ViewStructureSession viewStructureSession = (ViewStructureSession)event;
                        viewStructureSession.notifyViewAppeared();
                        continue;
                    }
                    if (event instanceof Insets) {
                        this.internalNotifyViewInsetsChanged(sessionId, (Insets)event);
                        continue;
                    }
                    Log.w(TAG, "invalid content capture event: " + event);
                }
                this.internalNotifyViewTreeEvent(sessionId, false);
                if (!Flags.flushAfterEachFrame()) continue;
                this.internalNotifySessionFlushEvent(sessionId);
            }
        }
        finally {
            Trace.traceEnd(8L);
        }
    }

    @Override
    void dump(@NonNull String prefix, @NonNull PrintWriter pw) {
        super.dump(prefix, pw);
        pw.print(prefix);
        pw.print("mContext: ");
        pw.println(this.mContext);
        pw.print(prefix);
        pw.print("user: ");
        pw.println(this.mContext.getUserId());
        if (this.mDirectServiceInterface != null) {
            pw.print(prefix);
            pw.print("mDirectServiceInterface: ");
            pw.println(this.mDirectServiceInterface);
        }
        pw.print(prefix);
        pw.print("mDisabled: ");
        pw.println(this.mDisabled.get());
        pw.print(prefix);
        pw.print("isEnabled(): ");
        pw.println(this.isContentCaptureEnabled());
        pw.print(prefix);
        pw.print("state: ");
        pw.println(MainContentCaptureSession.getStateAsString(this.mState));
        if (this.mApplicationToken != null) {
            pw.print(prefix);
            pw.print("app token: ");
            pw.println(this.mApplicationToken);
        }
        if (this.mShareableActivityToken != null) {
            pw.print(prefix);
            pw.print("sharable activity token: ");
            pw.println(this.mShareableActivityToken);
        }
        if (this.mComponentName != null) {
            pw.print(prefix);
            pw.print("component name: ");
            pw.println(this.mComponentName.flattenToShortString());
        }
        if (this.mEvents != null && !this.mEvents.isEmpty()) {
            int numberEvents = this.mEvents.size();
            pw.print(prefix);
            pw.print("buffered events: ");
            pw.print(numberEvents);
            pw.print('/');
            pw.println(this.mManager.mOptions.maxBufferSize);
            if (ContentCaptureHelper.sVerbose && numberEvents > 0) {
                String prefix3 = prefix + "  ";
                for (int i = 0; i < numberEvents; ++i) {
                    ContentCaptureEvent event = this.mEvents.get(i);
                    pw.print(prefix3);
                    pw.print(i);
                    pw.print(": ");
                    event.dump(pw);
                    pw.println();
                }
            }
            pw.print(prefix);
            pw.print("mNextFlushForTextChanged: ");
            pw.println(this.mNextFlushForTextChanged);
            pw.print(prefix);
            pw.print("flush frequency: ");
            if (this.mNextFlushForTextChanged) {
                pw.println(this.mManager.mOptions.textChangeFlushingFrequencyMs);
            } else {
                pw.println(this.mManager.mOptions.idleFlushingFrequencyMs);
            }
            pw.print(prefix);
            pw.print("next flush: ");
            TimeUtils.formatDuration(this.mNextFlush - System_Delegate.currentTimeMillis(), pw);
            pw.print(" (");
            pw.print(TimeUtils.logTimeOfDay(this.mNextFlush));
            pw.println(")");
        }
        if (this.mFlushHistory != null) {
            pw.print(prefix);
            pw.println("flush history:");
            this.mFlushHistory.reverseDump(null, pw, null);
            pw.println();
        } else {
            pw.print(prefix);
            pw.println("not logging flush history");
        }
        super.dump(prefix, pw);
    }

    private String getActivityName() {
        return this.mComponentName == null ? "pkg:" + this.mContext.getPackageName() : "act:" + this.mComponentName.flattenToShortString();
    }

    @NonNull
    private String getDebugState() {
        return this.getActivityName() + " [state=" + MainContentCaptureSession.getStateAsString(this.mState) + ", disabled=" + this.mDisabled.get() + "]";
    }

    @NonNull
    private String getDebugState(int reason) {
        return this.getDebugState() + ", reason=" + MainContentCaptureSession.getFlushReasonAsString(reason);
    }

    private boolean isContentProtectionReceiverEnabled() {
        return this.mManager.mOptions.contentProtectionOptions.enableReceiver;
    }

    private boolean isContentCaptureReceiverEnabled() {
        return this.mManager.mOptions.enableReceiver;
    }

    private boolean isContentProtectionEnabled() {
        return this.mManager.mOptions.contentProtectionOptions.enableReceiver && this.mManager.getContentProtectionEventBuffer() != null && this.mComponentName != null && (!this.mManager.mOptions.contentProtectionOptions.requiredGroups.isEmpty() || !this.mManager.mOptions.contentProtectionOptions.optionalGroups.isEmpty());
    }

    private void checkOnContentCaptureThread() {
        boolean onContentCaptureThread = this.mContentCaptureHandler.getLooper().isCurrentThread();
        if (!onContentCaptureThread) {
            this.mWrongThreadCount.incrementAndGet();
            Log.e(TAG, "MainContentCaptureSession running on " + Thread.currentThread());
        }
    }

    private void reportWrongThreadMetric() {
        Counter.logIncrement(CONTENT_CAPTURE_WRONG_THREAD_METRIC_ID, this.mWrongThreadCount.getAndSet(0));
    }

    private void runOnContentCaptureThread(@NonNull Runnable r) {
        if (!this.mContentCaptureHandler.getLooper().isCurrentThread()) {
            this.mContentCaptureHandler.post(r);
        } else {
            r.run();
        }
    }

    private void clearAndRunOnContentCaptureThread(@NonNull Runnable r, int what) {
        if (!this.mContentCaptureHandler.getLooper().isCurrentThread()) {
            this.mContentCaptureHandler.removeMessages(what);
            this.mContentCaptureHandler.post(r);
        } else {
            r.run();
        }
    }

    private void runOnUiThread(@NonNull Runnable r) {
        if (this.mUiHandler.getLooper().isCurrentThread()) {
            r.run();
        } else {
            this.mUiHandler.post(r);
        }
    }

    private static class SessionStateReceiver
    extends IResultReceiver.Stub {
        private final WeakReference<MainContentCaptureSession> mMainSession;

        SessionStateReceiver(MainContentCaptureSession session) {
            this.mMainSession = new WeakReference<MainContentCaptureSession>(session);
        }

        @Override
        public void send(int resultCode, Bundle resultData) {
            IBinder binder;
            MainContentCaptureSession mainSession = (MainContentCaptureSession)this.mMainSession.get();
            if (mainSession == null) {
                Log.w(TAG, "received result after mina session released");
                return;
            }
            if (resultData != null) {
                boolean hasEnabled = resultData.getBoolean("enabled");
                if (hasEnabled) {
                    boolean disabled = resultCode == 2;
                    mainSession.mDisabled.set(disabled);
                    return;
                }
                binder = resultData.getBinder("binder");
                if (binder == null) {
                    Log.wtf(TAG, "No binder extra result");
                    mainSession.runOnContentCaptureThread(() -> mainSession.resetSession(260));
                    return;
                }
            } else {
                binder = null;
            }
            mainSession.runOnContentCaptureThread(() -> mainSession.onSessionStarted(resultCode, binder));
        }
    }

    private static class ViewStructureSession {
        @Nullable
        private ContentCaptureSession mSession;
        @Nullable
        private ViewStructure mStructure;

        ViewStructureSession() {
        }

        void setSession(@Nullable ContentCaptureSession session) {
            this.mSession = session;
        }

        void setStructure(@Nullable ViewStructure struct) {
            this.mStructure = struct;
        }

        void notifyViewAppeared() {
            if (this.mSession != null && this.mStructure != null) {
                this.mSession.notifyViewAppeared(this.mStructure);
            }
        }
    }
}

