/*
 * Decompiled with CFR 0.152.
 */
package android.view.contentcapture;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;

public interface IDataShareWriteAdapter
extends IInterface {
    public static final String DESCRIPTOR = "android.view.contentcapture.IDataShareWriteAdapter";

    public void write(ParcelFileDescriptor var1) throws RemoteException;

    public void error(int var1) throws RemoteException;

    public void rejected() throws RemoteException;

    public void finish() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IDataShareWriteAdapter {
        static final int TRANSACTION_write = 1;
        static final int TRANSACTION_error = 2;
        static final int TRANSACTION_rejected = 3;
        static final int TRANSACTION_finish = 4;

        public Stub() {
            this.attachInterface(this, IDataShareWriteAdapter.DESCRIPTOR);
        }

        public static IDataShareWriteAdapter asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IDataShareWriteAdapter.DESCRIPTOR);
            if (iin != null && iin instanceof IDataShareWriteAdapter) {
                return (IDataShareWriteAdapter)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "write";
                }
                case 2: {
                    return "error";
                }
                case 3: {
                    return "rejected";
                }
                case 4: {
                    return "finish";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IDataShareWriteAdapter.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    ParcelFileDescriptor _arg0 = data.readTypedObject(ParcelFileDescriptor.CREATOR);
                    data.enforceNoDataAvail();
                    this.write(_arg0);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.error(_arg0);
                    break;
                }
                case 3: {
                    this.rejected();
                    break;
                }
                case 4: {
                    this.finish();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 3;
        }

        private static class Proxy
        implements IDataShareWriteAdapter {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IDataShareWriteAdapter.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void write(ParcelFileDescriptor destination) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IDataShareWriteAdapter.DESCRIPTOR);
                    _data.writeTypedObject(destination, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void error(int errorCode) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IDataShareWriteAdapter.DESCRIPTOR);
                    _data.writeInt(errorCode);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void rejected() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IDataShareWriteAdapter.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void finish() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IDataShareWriteAdapter.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IDataShareWriteAdapter {
        @Override
        public void write(ParcelFileDescriptor destination) throws RemoteException {
        }

        @Override
        public void error(int errorCode) throws RemoteException {
        }

        @Override
        public void rejected() throws RemoteException {
        }

        @Override
        public void finish() throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

