/*
 * Decompiled with CFR 0.152.
 */
package android.view.accessibility;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.graphics.Rect;
import android.graphics.Region;
import android.os.LocaleList;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.LongArray;
import android.util.Pools;
import android.util.SparseArray;
import android.view.accessibility.AccessibilityInteractionClient;
import android.view.accessibility.AccessibilityNodeInfo;
import com.android.internal.hidden_from_bootclasspath.android.view.accessibility.Flags;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;

public class AccessibilityWindowInfo
implements Parcelable {
    private static final boolean DEBUG = false;
    public static final int TYPE_APPLICATION = 1;
    public static final int TYPE_INPUT_METHOD = 2;
    public static final int TYPE_SYSTEM = 3;
    public static final int TYPE_ACCESSIBILITY_OVERLAY = 4;
    public static final int TYPE_SPLIT_SCREEN_DIVIDER = 5;
    public static final int TYPE_MAGNIFICATION_OVERLAY = 6;
    @FlaggedApi(value="android.view.accessibility.enable_type_window_control")
    public static final int TYPE_WINDOW_CONTROL = 7;
    public static final int ACTIVE_WINDOW_ID = Integer.MAX_VALUE;
    public static final int UNDEFINED_CONNECTION_ID = -1;
    public static final int UNDEFINED_WINDOW_ID = -1;
    public static final int ANY_WINDOW_ID = -2;
    public static final int PICTURE_IN_PICTURE_ACTION_REPLACER_WINDOW_ID = -3;
    private static final int BOOLEAN_PROPERTY_ACTIVE = 1;
    private static final int BOOLEAN_PROPERTY_FOCUSED = 2;
    private static final int BOOLEAN_PROPERTY_ACCESSIBILITY_FOCUSED = 4;
    private static final int BOOLEAN_PROPERTY_PICTURE_IN_PICTURE = 8;
    private static final int MAX_POOL_SIZE = 10;
    private static final Pools.SynchronizedPool<AccessibilityWindowInfo> sPool = new Pools.SynchronizedPool(10);
    private static AtomicInteger sNumInstancesInUse;
    private int mDisplayId = -1;
    private int mType = -1;
    private int mLayer = -1;
    private int mBooleanProperties;
    private int mId = -1;
    private int mParentId = -1;
    private int mTaskId = -1;
    private Region mRegionInScreen = new Region();
    private LongArray mChildIds;
    private CharSequence mTitle;
    private long mAnchorId = AccessibilityNodeInfo.UNDEFINED_NODE_ID;
    private long mTransitionTime;
    private int mConnectionId = -1;
    private LocaleList mLocales = LocaleList.getEmptyLocaleList();
    @NonNull
    public static final Parcelable.Creator<AccessibilityWindowInfo> CREATOR;

    public AccessibilityWindowInfo() {
    }

    public AccessibilityWindowInfo(@NonNull AccessibilityWindowInfo info) {
        this.init(info);
    }

    @Nullable
    public CharSequence getTitle() {
        return this.mTitle;
    }

    public void setTitle(CharSequence title) {
        this.mTitle = title;
    }

    public int getType() {
        return this.mType;
    }

    public void setType(int type) {
        this.mType = type;
    }

    public int getLayer() {
        return this.mLayer;
    }

    public void setLayer(int layer) {
        this.mLayer = layer;
    }

    public AccessibilityNodeInfo getRoot() {
        return this.getRoot(4);
    }

    @Nullable
    public AccessibilityNodeInfo getRoot(int prefetchingStrategy) {
        if (this.mConnectionId == -1) {
            return null;
        }
        AccessibilityInteractionClient client = AccessibilityInteractionClient.getInstance();
        return client.findAccessibilityNodeInfoByAccessibilityId(this.mConnectionId, this.mId, AccessibilityNodeInfo.ROOT_NODE_ID, true, prefetchingStrategy, null);
    }

    public void setAnchorId(long anchorId) {
        this.mAnchorId = anchorId;
    }

    public AccessibilityNodeInfo getAnchor() {
        if (this.mConnectionId == -1 || this.mAnchorId == AccessibilityNodeInfo.UNDEFINED_NODE_ID || this.mParentId == -1) {
            return null;
        }
        AccessibilityInteractionClient client = AccessibilityInteractionClient.getInstance();
        return client.findAccessibilityNodeInfoByAccessibilityId(this.mConnectionId, this.mParentId, this.mAnchorId, true, 0, null);
    }

    public void setPictureInPicture(boolean pictureInPicture) {
        this.setBooleanProperty(8, pictureInPicture);
    }

    public boolean isInPictureInPictureMode() {
        return this.getBooleanProperty(8);
    }

    public AccessibilityWindowInfo getParent() {
        if (this.mConnectionId == -1 || this.mParentId == -1) {
            return null;
        }
        AccessibilityInteractionClient client = AccessibilityInteractionClient.getInstance();
        return client.getWindow(this.mConnectionId, this.mParentId);
    }

    public void setParentId(int parentId) {
        this.mParentId = parentId;
    }

    public int getId() {
        return this.mId;
    }

    public void setId(int id2) {
        this.mId = id2;
    }

    public int getTaskId() {
        return this.mTaskId;
    }

    public void setTaskId(int taskId) {
        this.mTaskId = taskId;
    }

    public void setConnectionId(int connectionId) {
        this.mConnectionId = connectionId;
    }

    public void getRegionInScreen(@NonNull Region outRegion) {
        outRegion.set(this.mRegionInScreen);
    }

    public void setRegionInScreen(Region region) {
        this.mRegionInScreen.set(region);
    }

    public void getBoundsInScreen(Rect outBounds) {
        outBounds.set(this.mRegionInScreen.getBounds());
    }

    public boolean isActive() {
        return this.getBooleanProperty(1);
    }

    public void setActive(boolean active) {
        this.setBooleanProperty(1, active);
    }

    public boolean isFocused() {
        return this.getBooleanProperty(2);
    }

    public void setFocused(boolean focused) {
        this.setBooleanProperty(2, focused);
    }

    public boolean isAccessibilityFocused() {
        return this.getBooleanProperty(4);
    }

    public void setAccessibilityFocused(boolean focused) {
        this.setBooleanProperty(4, focused);
    }

    public int getChildCount() {
        return this.mChildIds != null ? this.mChildIds.size() : 0;
    }

    public AccessibilityWindowInfo getChild(int index) {
        if (this.mChildIds == null) {
            throw new IndexOutOfBoundsException();
        }
        if (this.mConnectionId == -1) {
            return null;
        }
        int childId = (int)this.mChildIds.get(index);
        AccessibilityInteractionClient client = AccessibilityInteractionClient.getInstance();
        return client.getWindow(this.mConnectionId, childId);
    }

    public void addChild(int childId) {
        if (this.mChildIds == null) {
            this.mChildIds = new LongArray();
        }
        this.mChildIds.add(childId);
    }

    public void setDisplayId(int displayId) {
        this.mDisplayId = displayId;
    }

    public int getDisplayId() {
        return this.mDisplayId;
    }

    public void setTransitionTimeMillis(long transitionTime) {
        this.mTransitionTime = transitionTime;
    }

    public long getTransitionTimeMillis() {
        return this.mTransitionTime;
    }

    public void setLocales(@NonNull LocaleList locales) {
        this.mLocales = locales;
    }

    @NonNull
    public LocaleList getLocales() {
        return this.mLocales;
    }

    public static AccessibilityWindowInfo obtain() {
        AccessibilityWindowInfo info = sPool.acquire();
        if (info == null) {
            info = new AccessibilityWindowInfo();
        }
        if (sNumInstancesInUse != null) {
            sNumInstancesInUse.incrementAndGet();
        }
        return info;
    }

    public static AccessibilityWindowInfo obtain(AccessibilityWindowInfo info) {
        AccessibilityWindowInfo infoClone = AccessibilityWindowInfo.obtain();
        infoClone.init(info);
        return infoClone;
    }

    public static void setNumInstancesInUseCounter(AtomicInteger counter) {
        if (sNumInstancesInUse != null) {
            sNumInstancesInUse = counter;
        }
    }

    public void recycle() {
        this.clear();
        sPool.release(this);
        if (sNumInstancesInUse != null) {
            sNumInstancesInUse.decrementAndGet();
        }
    }

    @FlaggedApi(value="android.view.accessibility.enable_refresh_window_info")
    public boolean refresh() {
        if (this.mConnectionId == -1 || this.mId == -1) {
            return false;
        }
        AccessibilityInteractionClient client = AccessibilityInteractionClient.getInstance();
        AccessibilityWindowInfo refreshedInfo = client.getWindow(this.mConnectionId, this.mId, true);
        if (refreshedInfo == null) {
            return false;
        }
        this.init(refreshedInfo);
        refreshedInfo.recycle();
        return true;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeInt(this.mDisplayId);
        parcel.writeInt(this.mType);
        parcel.writeInt(this.mLayer);
        parcel.writeInt(this.mBooleanProperties);
        parcel.writeInt(this.mId);
        parcel.writeInt(this.mParentId);
        parcel.writeInt(this.mTaskId);
        this.mRegionInScreen.writeToParcel(parcel, flags);
        parcel.writeCharSequence(this.mTitle);
        parcel.writeLong(this.mAnchorId);
        parcel.writeLong(this.mTransitionTime);
        LongArray childIds = this.mChildIds;
        if (childIds == null) {
            parcel.writeInt(0);
        } else {
            int childCount = childIds.size();
            parcel.writeInt(childCount);
            for (int i = 0; i < childCount; ++i) {
                parcel.writeInt((int)childIds.get(i));
            }
        }
        parcel.writeInt(this.mConnectionId);
        parcel.writeParcelable(this.mLocales, flags);
    }

    private void init(AccessibilityWindowInfo other) {
        this.mDisplayId = other.mDisplayId;
        this.mType = other.mType;
        this.mLayer = other.mLayer;
        this.mBooleanProperties = other.mBooleanProperties;
        this.mId = other.mId;
        this.mParentId = other.mParentId;
        this.mTaskId = other.mTaskId;
        this.mRegionInScreen.set(other.mRegionInScreen);
        this.mTitle = other.mTitle;
        this.mAnchorId = other.mAnchorId;
        this.mTransitionTime = other.mTransitionTime;
        if (this.mChildIds != null) {
            this.mChildIds.clear();
        }
        if (other.mChildIds != null && other.mChildIds.size() > 0) {
            if (this.mChildIds == null) {
                this.mChildIds = other.mChildIds.clone();
            } else {
                this.mChildIds.addAll(other.mChildIds);
            }
        }
        this.mConnectionId = other.mConnectionId;
        this.mLocales = other.mLocales;
    }

    private void initFromParcel(Parcel parcel) {
        this.mDisplayId = parcel.readInt();
        this.mType = parcel.readInt();
        this.mLayer = parcel.readInt();
        this.mBooleanProperties = parcel.readInt();
        this.mId = parcel.readInt();
        this.mParentId = parcel.readInt();
        this.mTaskId = parcel.readInt();
        this.mRegionInScreen = Region.CREATOR.createFromParcel(parcel);
        this.mTitle = parcel.readCharSequence();
        this.mAnchorId = parcel.readLong();
        this.mTransitionTime = parcel.readLong();
        int childCount = parcel.readInt();
        if (childCount > 0) {
            if (this.mChildIds == null) {
                this.mChildIds = new LongArray(childCount);
            }
            for (int i = 0; i < childCount; ++i) {
                int childId = parcel.readInt();
                this.mChildIds.add(childId);
            }
        }
        this.mConnectionId = parcel.readInt();
        this.mLocales = parcel.readParcelable(null, LocaleList.class);
    }

    public int hashCode() {
        return this.mId;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AccessibilityWindowInfo other = (AccessibilityWindowInfo)obj;
        return this.mId == other.mId;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AccessibilityWindowInfo[");
        builder.append("title=").append(this.mTitle);
        builder.append(", displayId=").append(this.mDisplayId);
        builder.append(", id=").append(this.mId);
        builder.append(", taskId=").append(this.mTaskId);
        builder.append(", type=").append(AccessibilityWindowInfo.typeToString(this.mType));
        builder.append(", layer=").append(this.mLayer);
        builder.append(", region=").append(this.mRegionInScreen);
        builder.append(", bounds=").append(this.mRegionInScreen.getBounds());
        builder.append(", focused=").append(this.isFocused());
        builder.append(", active=").append(this.isActive());
        builder.append(", pictureInPicture=").append(this.isInPictureInPictureMode());
        builder.append(", transitionTime=").append(this.mTransitionTime);
        builder.append(", hasParent=").append(this.mParentId != -1);
        builder.append(", isAnchored=").append(this.mAnchorId != AccessibilityNodeInfo.UNDEFINED_NODE_ID);
        builder.append(", hasChildren=").append(this.mChildIds != null && this.mChildIds.size() > 0);
        builder.append(']');
        return builder.toString();
    }

    private void clear() {
        this.mDisplayId = -1;
        this.mType = -1;
        this.mLayer = -1;
        this.mBooleanProperties = 0;
        this.mId = -1;
        this.mParentId = -1;
        this.mTaskId = -1;
        this.mRegionInScreen.setEmpty();
        this.mChildIds = null;
        this.mConnectionId = -1;
        this.mAnchorId = AccessibilityNodeInfo.UNDEFINED_NODE_ID;
        this.mTitle = null;
        this.mTransitionTime = 0L;
        this.mLocales = LocaleList.getEmptyLocaleList();
    }

    private boolean getBooleanProperty(int property) {
        return (this.mBooleanProperties & property) != 0;
    }

    private void setBooleanProperty(int property, boolean value) {
        this.mBooleanProperties = value ? (this.mBooleanProperties |= property) : (this.mBooleanProperties &= ~property);
    }

    public static String typeToString(int type) {
        switch (type) {
            case 1: {
                return "TYPE_APPLICATION";
            }
            case 2: {
                return "TYPE_INPUT_METHOD";
            }
            case 3: {
                return "TYPE_SYSTEM";
            }
            case 4: {
                return "TYPE_ACCESSIBILITY_OVERLAY";
            }
            case 5: {
                return "TYPE_SPLIT_SCREEN_DIVIDER";
            }
            case 6: {
                return "TYPE_MAGNIFICATION_OVERLAY";
            }
        }
        if (Flags.enableTypeWindowControl() && type == 7) {
            return "TYPE_WINDOW_CONTROL";
        }
        return "<UNKNOWN:" + type + ">";
    }

    public int differenceFrom(AccessibilityWindowInfo other) {
        if (other.mId != this.mId) {
            throw new IllegalArgumentException("Not same window.");
        }
        if (other.mType != this.mType) {
            throw new IllegalArgumentException("Not same type.");
        }
        int changes = 0;
        if (!TextUtils.equals(this.mTitle, other.mTitle)) {
            changes |= 4;
        }
        if (!this.mRegionInScreen.equals(other.mRegionInScreen)) {
            changes |= 8;
        }
        if (this.mLayer != other.mLayer) {
            changes |= 0x10;
        }
        if (this.getBooleanProperty(1) != other.getBooleanProperty(1)) {
            changes |= 0x20;
        }
        if (this.getBooleanProperty(2) != other.getBooleanProperty(2)) {
            changes |= 0x40;
        }
        if (this.getBooleanProperty(4) != other.getBooleanProperty(4)) {
            changes |= 0x80;
        }
        if (this.getBooleanProperty(8) != other.getBooleanProperty(8)) {
            changes |= 0x400;
        }
        if (this.mParentId != other.mParentId) {
            changes |= 0x100;
        }
        if (!Objects.equals(this.mChildIds, other.mChildIds)) {
            changes |= 0x200;
        }
        return changes;
    }

    static {
        CREATOR = new Parcelable.Creator<AccessibilityWindowInfo>(){

            @Override
            public AccessibilityWindowInfo createFromParcel(Parcel parcel) {
                AccessibilityWindowInfo info = AccessibilityWindowInfo.obtain();
                info.initFromParcel(parcel);
                return info;
            }

            public AccessibilityWindowInfo[] newArray(int size) {
                return new AccessibilityWindowInfo[size];
            }
        };
    }

    public static class WindowListSparseArray
    extends SparseArray<List<AccessibilityWindowInfo>>
    implements Parcelable {
        public static final Parcelable.Creator<WindowListSparseArray> CREATOR = new Parcelable.Creator<WindowListSparseArray>(){

            @Override
            public WindowListSparseArray createFromParcel(Parcel source) {
                WindowListSparseArray array2 = new WindowListSparseArray();
                ClassLoader loader = array2.getClass().getClassLoader();
                int count = source.readInt();
                for (int i = 0; i < count; ++i) {
                    ArrayList windows = new ArrayList();
                    source.readParcelableList(windows, loader, AccessibilityWindowInfo.class);
                    array2.put(source.readInt(), windows);
                }
                return array2;
            }

            public WindowListSparseArray[] newArray(int size) {
                return new WindowListSparseArray[size];
            }
        };

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            int count = this.size();
            dest.writeInt(count);
            for (int i = 0; i < count; ++i) {
                dest.writeParcelableList((List)this.valueAt(i), 0);
                dest.writeInt(this.keyAt(i));
            }
        }
    }
}

