/*
 * Decompiled with CFR 0.152.
 */
package android.view.accessibility;

import android.annotation.Nullable;
import android.content.Context;
import android.os.Bundle;
import android.os.Message;
import android.view.View;
import android.view.accessibility.AccessibilityManager;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;

public abstract class AccessibilityRequestPreparer {
    public static final int REQUEST_TYPE_EXTRA_DATA = 1;
    private final WeakReference<View> mViewRef;
    private final int mAccessibilityViewId;
    private final int mRequestTypes;

    public AccessibilityRequestPreparer(View view, int requestTypes) {
        if (!view.isAttachedToWindow()) {
            throw new IllegalStateException("View must be attached to a window");
        }
        this.mViewRef = new WeakReference<View>(view);
        this.mAccessibilityViewId = view.getAccessibilityViewId();
        this.mRequestTypes = requestTypes;
        view.addOnAttachStateChangeListener(new ViewAttachStateListener());
    }

    public abstract void onPrepareExtraData(int var1, String var2, Bundle var3, Message var4);

    @Nullable
    public View getView() {
        return (View)this.mViewRef.get();
    }

    int getAccessibilityViewId() {
        return this.mAccessibilityViewId;
    }

    private class ViewAttachStateListener
    implements View.OnAttachStateChangeListener {
        private ViewAttachStateListener() {
        }

        @Override
        public void onViewAttachedToWindow(View v) {
        }

        @Override
        public void onViewDetachedFromWindow(View v) {
            Context context = v.getContext();
            if (context != null) {
                context.getSystemService(AccessibilityManager.class).removeAccessibilityRequestPreparer(AccessibilityRequestPreparer.this);
            }
            v.removeOnAttachStateChangeListener(this);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RequestTypes {
    }
}

