/*
 * Decompiled with CFR 0.152.
 */
package android.view.accessibility;

import android.accessibilityservice.AccessibilityServiceInfo;
import android.accessibilityservice.AccessibilityShortcutInfo;
import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.RemoteAction;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.res.Resources;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerExecutor;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.util.ArrayMap;
import android.util.Log;
import android.util.SparseArray;
import android.view.IWindow;
import android.view.SurfaceControl;
import android.view.accessibility.AccessibilityDisplayProxy;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityInteractionClient;
import android.view.accessibility.AccessibilityManager_Delegate;
import android.view.accessibility.AccessibilityRequestPreparer;
import android.view.accessibility.AccessibilityWindowAttributes;
import android.view.accessibility.IAccessibilityInteractionConnection;
import android.view.accessibility.IAccessibilityManager;
import android.view.accessibility.IAccessibilityManagerClient;
import android.view.accessibility.IMagnificationConnection;
import android.view.accessibility.IUserInitializationCompleteCallback;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.IntPair;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import org.xmlpull.v1.XmlPullParserException;

public class AccessibilityManager {
    private static final boolean DEBUG = false;
    private static final String LOG_TAG = "AccessibilityManager";
    public static final int STATE_FLAG_ACCESSIBILITY_ENABLED = 1;
    public static final int STATE_FLAG_TOUCH_EXPLORATION_ENABLED = 2;
    public static final int STATE_FLAG_HIGH_TEXT_CONTRAST_ENABLED = 4;
    public static final int STATE_FLAG_DISPATCH_DOUBLE_TAP = 8;
    public static final int STATE_FLAG_REQUEST_MULTI_FINGER_GESTURES = 16;
    public static final int STATE_FLAG_TRACE_A11Y_INTERACTION_CONNECTION_ENABLED = 256;
    public static final int STATE_FLAG_TRACE_A11Y_INTERACTION_CONNECTION_CB_ENABLED = 512;
    public static final int STATE_FLAG_TRACE_A11Y_INTERACTION_CLIENT_ENABLED = 1024;
    public static final int STATE_FLAG_TRACE_A11Y_SERVICE_ENABLED = 2048;
    public static final int STATE_FLAG_AUDIO_DESCRIPTION_BY_DEFAULT_ENABLED = 4096;
    public static final int DALTONIZER_DISABLED = -1;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final int DALTONIZER_SIMULATE_MONOCHROMACY = 0;
    public static final int DALTONIZER_CORRECT_DEUTERANOMALY = 12;
    public static final int AUTOCLICK_DELAY_DEFAULT = 600;
    public static final int AUTOCLICK_DELAY_WITH_INDICATOR_DEFAULT = 1000;
    public static final int AUTOCLICK_CURSOR_AREA_SIZE_DEFAULT = 60;
    public static final int AUTOCLICK_CURSOR_AREA_SIZE_MIN = 20;
    public static final int AUTOCLICK_CURSOR_AREA_SIZE_MAX = 100;
    public static final int AUTOCLICK_CURSOR_AREA_INCREMENT_SIZE = 20;
    public static final boolean AUTOCLICK_IGNORE_MINOR_CURSOR_MOVEMENT_DEFAULT = false;
    public static final boolean AUTOCLICK_REVERT_TO_LEFT_CLICK_DEFAULT = true;
    public static final String ACTION_CHOOSE_ACCESSIBILITY_BUTTON = "com.android.internal.intent.action.CHOOSE_ACCESSIBILITY_BUTTON";
    public static final int FLASH_REASON_CALL = 1;
    public static final int FLASH_REASON_ALARM = 2;
    public static final int FLASH_REASON_NOTIFICATION = 3;
    public static final int FLASH_REASON_PREVIEW = 4;
    public static final int FLAG_CONTENT_ICONS = 1;
    public static final int FLAG_CONTENT_TEXT = 2;
    public static final int FLAG_CONTENT_CONTROLS = 4;
    @UnsupportedAppUsage
    static final Object sInstanceSync = new Object();
    @UnsupportedAppUsage
    private static AccessibilityManager sInstance;
    @UnsupportedAppUsage
    private final Object mLock = new Object();
    @UnsupportedAppUsage
    private IAccessibilityManager mService;
    @UnsupportedAppUsage
    final int mUserId;
    @UnsupportedAppUsage
    final Handler mHandler;
    final Handler.Callback mCallback;
    @UnsupportedAppUsage(maxTargetSdk=28)
    boolean mIsEnabled;
    int mRelevantEventTypes = -1;
    int mInteractiveUiTimeout;
    int mNonInteractiveUiTimeout;
    boolean mIsTouchExplorationEnabled;
    @UnsupportedAppUsage(trackingBug=123768939L)
    boolean mIsHighContrastTextEnabled;
    boolean mIsAudioDescriptionByDefaultRequested;
    int mAccessibilityTracingState = 0;
    AccessibilityPolicy mAccessibilityPolicy;
    private int mPerformingAction = 0;
    private int mFocusStrokeWidth;
    private int mFocusColor;
    @UnsupportedAppUsage
    private final ArrayMap<AccessibilityStateChangeListener, Handler> mAccessibilityStateChangeListeners = new ArrayMap();
    private final ArrayMap<TouchExplorationStateChangeListener, Handler> mTouchExplorationStateChangeListeners = new ArrayMap();
    private final ArrayMap<HighContrastTextStateChangeListener, Executor> mHighContrastTextStateChangeListeners = new ArrayMap();
    private final ArrayMap<AccessibilityServicesStateChangeListener, Executor> mServicesStateChangeListeners = new ArrayMap();
    private final ArrayMap<AudioDescriptionRequestedChangeListener, Executor> mAudioDescriptionRequestedChangeListeners = new ArrayMap();
    private boolean mRequestFromAccessibilityTool;
    private SparseArray<List<AccessibilityRequestPreparer>> mRequestPreparerLists;
    private final Binder mBinder = new Binder();
    private final IAccessibilityManagerClient.Stub mClient = new IAccessibilityManagerClient.Stub(){

        @Override
        public void setState(int state) {
            AccessibilityManager.this.mHandler.obtainMessage(1, state, 0).sendToTarget();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notifyServicesStateChanged(long updatedUiTimeout) {
            ArrayMap<AccessibilityServicesStateChangeListener, Executor> listeners;
            AccessibilityManager.this.updateUiTimeout(updatedUiTimeout);
            Object object = AccessibilityManager.this.mLock;
            synchronized (object) {
                if (AccessibilityManager.this.mServicesStateChangeListeners.isEmpty()) {
                    return;
                }
                listeners = new ArrayMap<AccessibilityServicesStateChangeListener, Executor>(AccessibilityManager.this.mServicesStateChangeListeners);
            }
            int numListeners = listeners.size();
            for (int i = 0; i < numListeners; ++i) {
                AccessibilityServicesStateChangeListener listener = AccessibilityManager.this.mServicesStateChangeListeners.keyAt(i);
                AccessibilityManager.this.mServicesStateChangeListeners.valueAt(i).execute(() -> listener.onAccessibilityServicesStateChanged(AccessibilityManager.this));
            }
        }

        @Override
        public void setRelevantEventTypes(int eventTypes) {
            AccessibilityManager.this.mRelevantEventTypes = eventTypes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setFocusAppearance(int strokeWidth, int color2) {
            Object object = AccessibilityManager.this.mLock;
            synchronized (object) {
                AccessibilityManager.this.updateFocusAppearanceLocked(strokeWidth, color2);
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public static AccessibilityManager getInstance_Original(Context context) {
        Object object = sInstanceSync;
        synchronized (object) {
            if (sInstance == null) {
                int userId = Binder.getCallingUid() == 1000 || context.checkCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS") == 0 || context.checkCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL") == 0 ? -2 : context.getUserId();
                sInstance = new AccessibilityManager(context, null, userId);
            }
        }
        return sInstance;
    }

    @LayoutlibDelegate
    public static AccessibilityManager getInstance(Context context) {
        return AccessibilityManager_Delegate.getInstance(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessibilityManager(Context context, IAccessibilityManager service, int userId) {
        this.mCallback = new MyCallback();
        this.mHandler = new Handler(context.getMainLooper(), this.mCallback);
        this.mUserId = userId;
        Object object = this.mLock;
        synchronized (object) {
            this.initialFocusAppearanceLocked(context.getResources());
            this.tryConnectToServiceLocked(service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public AccessibilityManager(Context context, Handler handler, IAccessibilityManager service, int userId, boolean serviceConnect) {
        this.mCallback = new MyCallback();
        this.mHandler = handler;
        this.mUserId = userId;
        Object object = this.mLock;
        synchronized (object) {
            this.initialFocusAppearanceLocked(context.getResources());
            if (serviceConnect) {
                this.tryConnectToServiceLocked(service);
            }
        }
    }

    public IAccessibilityManagerClient getClient() {
        return this.mClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeClient() {
        Object object = this.mLock;
        synchronized (object) {
            IAccessibilityManager service = this.getServiceLocked();
            if (service == null) {
                return false;
            }
            try {
                return service.removeClient(this.mClient, this.mUserId);
            }
            catch (RemoteException re) {
                Log.e(LOG_TAG, "AccessibilityManagerService is dead", re);
            }
        }
        return false;
    }

    @VisibleForTesting
    public Handler.Callback getCallback() {
        return this.mCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mIsEnabled || this.hasAnyDirectConnection() || this.mAccessibilityPolicy != null && this.mAccessibilityPolicy.isEnabled(this.mIsEnabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FlaggedApi(value="android.view.accessibility.enable_trusted_accessibility_service_api")
    public boolean enableTrustedAccessibilityService(@NonNull ComponentName trustedAccessibilityService) {
        int userId;
        IAccessibilityManager service;
        Objects.requireNonNull(trustedAccessibilityService);
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return false;
            }
            userId = this.mUserId;
        }
        try {
            return service.enableTrustedAccessibilityService(trustedAccessibilityService, userId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FlaggedApi(value="android.view.accessibility.enable_trusted_accessibility_service_api")
    @RequiresPermission(value="android.permission.MANAGE_ACCESSIBILITY")
    @VisibleForTesting
    public void setTrustedAccessibilityServiceForTesting(@Nullable ComponentName trustedAccessibilityService) {
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return;
            }
        }
        try {
            service.setTrustedAccessibilityServiceForTesting(trustedAccessibilityService);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public boolean hasAnyDirectConnection() {
        return AccessibilityInteractionClient.hasAnyDirectConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTouchExplorationEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            IAccessibilityManager service = this.getServiceLocked();
            if (service == null) {
                return false;
            }
            return this.mIsTouchExplorationEnabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FlaggedApi(value="com.android.graphics.hwui.flags.high_contrast_text_small_text_rect")
    public boolean isHighContrastTextEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            IAccessibilityManager service = this.getServiceLocked();
            if (service == null) {
                return false;
            }
            return this.mIsHighContrastTextEnabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendAccessibilityEvent(AccessibilityEvent event) {
        int userId;
        AccessibilityEvent dispatchedEvent;
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return;
            }
            event.setEventTime(SystemClock.uptimeMillis());
            if (event.getAction() == 0) {
                event.setAction(this.mPerformingAction);
            }
            if (this.mAccessibilityPolicy != null) {
                dispatchedEvent = this.mAccessibilityPolicy.onAccessibilityEvent(event, this.mIsEnabled, this.mRelevantEventTypes);
                if (dispatchedEvent == null) {
                    return;
                }
            } else {
                dispatchedEvent = event;
            }
            if (!this.isEnabled()) {
                Looper myLooper = Looper.myLooper();
                if (myLooper == Looper.getMainLooper()) {
                    throw new IllegalStateException("Accessibility off. Did you forget to check that?");
                }
                Log.e(LOG_TAG, "AccessibilityEvent sent with accessibility disabled");
                return;
            }
            if ((dispatchedEvent.getEventType() & this.mRelevantEventTypes) == 0) {
                return;
            }
            userId = this.mUserId;
        }
        try {
            long identityToken = Binder.clearCallingIdentity();
            try {
                service.sendAccessibilityEvent(dispatchedEvent, userId);
            }
            finally {
                Binder.restoreCallingIdentity(identityToken);
            }
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error during sending " + dispatchedEvent + " ", re);
        }
        finally {
            if (event != dispatchedEvent) {
                event.recycle();
            }
            dispatchedEvent.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interrupt() {
        int userId;
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return;
            }
            if (!this.isEnabled()) {
                Looper myLooper = Looper.myLooper();
                if (myLooper == Looper.getMainLooper()) {
                    throw new IllegalStateException("Accessibility off. Did you forget to check that?");
                }
                Log.e(LOG_TAG, "Interrupt called with accessibility disabled");
                return;
            }
            userId = this.mUserId;
        }
        try {
            service.interrupt(userId);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error while requesting interrupt from all services. ", re);
        }
    }

    @Deprecated
    public List<ServiceInfo> getAccessibilityServiceList() {
        List<AccessibilityServiceInfo> infos = this.getInstalledAccessibilityServiceList();
        ArrayList<ServiceInfo> services = new ArrayList<ServiceInfo>();
        int infoCount = infos.size();
        for (int i = 0; i < infoCount; ++i) {
            AccessibilityServiceInfo info = infos.get(i);
            services.add(info.getResolveInfo().serviceInfo);
        }
        return Collections.unmodifiableList(services);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AccessibilityServiceInfo> getInstalledAccessibilityServiceList() {
        int userId;
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return Collections.emptyList();
            }
            userId = this.mUserId;
        }
        List<AccessibilityServiceInfo> services = null;
        try {
            services = service.getInstalledAccessibilityServiceList(userId).getList();
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error while obtaining the installed AccessibilityServices. ", re);
        }
        if (this.mAccessibilityPolicy != null) {
            services = this.mAccessibilityPolicy.getInstalledAccessibilityServiceList(services);
        }
        if (services != null) {
            return Collections.unmodifiableList(services);
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AccessibilityServiceInfo> getEnabledAccessibilityServiceList(int feedbackTypeFlags, int userId) {
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return Collections.emptyList();
            }
        }
        List<AccessibilityServiceInfo> services = null;
        try {
            services = service.getEnabledAccessibilityServiceList(feedbackTypeFlags, userId);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error while obtaining the enabled AccessibilityServices. ", re);
        }
        if (this.mAccessibilityPolicy != null) {
            services = this.mAccessibilityPolicy.getEnabledAccessibilityServiceList(feedbackTypeFlags, services);
        }
        if (services != null) {
            return Collections.unmodifiableList(services);
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AccessibilityServiceInfo> getEnabledAccessibilityServiceList(int feedbackTypeFlags) {
        int userId;
        Object object = this.mLock;
        synchronized (object) {
            userId = this.mUserId;
        }
        return this.getEnabledAccessibilityServiceList(feedbackTypeFlags, userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.MANAGE_ACCESSIBILITY")
    public boolean isAccessibilityServiceWarningRequired(@NonNull AccessibilityServiceInfo info) {
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return true;
            }
        }
        try {
            return service.isAccessibilityServiceWarningRequired(info);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error while checking isAccessibilityServiceWarningRequired: ", re);
            return true;
        }
    }

    public boolean addAccessibilityStateChangeListener(@NonNull AccessibilityStateChangeListener listener) {
        this.addAccessibilityStateChangeListener(listener, null);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAccessibilityStateChangeListener(@NonNull AccessibilityStateChangeListener listener, @Nullable Handler handler) {
        Object object = this.mLock;
        synchronized (object) {
            this.mAccessibilityStateChangeListeners.put(listener, handler == null ? this.mHandler : handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAccessibilityStateChangeListener(@NonNull AccessibilityStateChangeListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            int index = this.mAccessibilityStateChangeListeners.indexOfKey(listener);
            this.mAccessibilityStateChangeListeners.remove(listener);
            return index >= 0;
        }
    }

    public boolean addTouchExplorationStateChangeListener(@NonNull TouchExplorationStateChangeListener listener) {
        this.addTouchExplorationStateChangeListener(listener, null);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTouchExplorationStateChangeListener(@NonNull TouchExplorationStateChangeListener listener, @Nullable Handler handler) {
        Object object = this.mLock;
        synchronized (object) {
            this.mTouchExplorationStateChangeListeners.put(listener, handler == null ? this.mHandler : handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeTouchExplorationStateChangeListener(@NonNull TouchExplorationStateChangeListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            int index = this.mTouchExplorationStateChangeListeners.indexOfKey(listener);
            this.mTouchExplorationStateChangeListeners.remove(listener);
            return index >= 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAccessibilityServicesStateChangeListener(@NonNull Executor executor, @NonNull AccessibilityServicesStateChangeListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            this.mServicesStateChangeListeners.put(listener, executor);
        }
    }

    public void addAccessibilityServicesStateChangeListener(@NonNull AccessibilityServicesStateChangeListener listener) {
        this.addAccessibilityServicesStateChangeListener(new HandlerExecutor(this.mHandler), listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAccessibilityServicesStateChangeListener(@NonNull AccessibilityServicesStateChangeListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mServicesStateChangeListeners.remove(listener) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerUserInitializationCompleteCallback(@NonNull IUserInitializationCompleteCallback callback) {
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return;
            }
        }
        try {
            service.registerUserInitializationCompleteCallback(callback);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error while registering userInitializationCompleteCallback. ", re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterUserInitializationCompleteCallback(@NonNull IUserInitializationCompleteCallback callback) {
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return;
            }
        }
        try {
            service.unregisterUserInitializationCompleteCallback(callback);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error while unregistering userInitializationCompleteCallback. ", re);
        }
    }

    public boolean isRequestFromAccessibilityTool() {
        return this.mRequestFromAccessibilityTool;
    }

    public void setRequestFromAccessibilityTool(boolean requestFromAccessibilityTool) {
        this.mRequestFromAccessibilityTool = requestFromAccessibilityTool;
    }

    public void addAccessibilityRequestPreparer(AccessibilityRequestPreparer preparer) {
        int id2;
        List<AccessibilityRequestPreparer> requestPreparerList;
        if (this.mRequestPreparerLists == null) {
            this.mRequestPreparerLists = new SparseArray(1);
        }
        if ((requestPreparerList = this.mRequestPreparerLists.get(id2 = preparer.getAccessibilityViewId())) == null) {
            requestPreparerList = new ArrayList<AccessibilityRequestPreparer>(1);
            this.mRequestPreparerLists.put(id2, requestPreparerList);
        }
        requestPreparerList.add(preparer);
    }

    public void removeAccessibilityRequestPreparer(AccessibilityRequestPreparer preparer) {
        if (this.mRequestPreparerLists == null) {
            return;
        }
        int viewId = preparer.getAccessibilityViewId();
        List<AccessibilityRequestPreparer> requestPreparerList = this.mRequestPreparerLists.get(viewId);
        if (requestPreparerList != null) {
            requestPreparerList.remove(preparer);
            if (requestPreparerList.isEmpty()) {
                this.mRequestPreparerLists.remove(viewId);
            }
        }
    }

    public int getRecommendedTimeoutMillis(int originalTimeout, int uiContentFlags) {
        boolean hasControls = (uiContentFlags & 4) != 0;
        boolean hasIconsOrText = (uiContentFlags & 1) != 0 || (uiContentFlags & 2) != 0;
        int recommendedTimeout = originalTimeout;
        if (hasControls) {
            recommendedTimeout = Math.max(recommendedTimeout, this.mInteractiveUiTimeout);
        }
        if (hasIconsOrText) {
            recommendedTimeout = Math.max(recommendedTimeout, this.mNonInteractiveUiTimeout);
        }
        return recommendedTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAccessibilityFocusStrokeWidth() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mFocusStrokeWidth;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAccessibilityFocusColor() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mFocusColor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isA11yInteractionConnectionTraceEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            return (this.mAccessibilityTracingState & 0x100) != 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isA11yInteractionConnectionCBTraceEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            return (this.mAccessibilityTracingState & 0x200) != 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isA11yInteractionClientTraceEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            return (this.mAccessibilityTracingState & 0x400) != 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isA11yServiceTraceEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            return (this.mAccessibilityTracingState & 0x800) != 0;
        }
    }

    public List<AccessibilityRequestPreparer> getRequestPreparersForAccessibilityId(int id2) {
        if (this.mRequestPreparerLists == null) {
            return null;
        }
        return this.mRequestPreparerLists.get(id2);
    }

    public void notifyPerformingAction(int actionId) {
        this.mPerformingAction = actionId;
    }

    public int getPerformingAction() {
        return this.mPerformingAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FlaggedApi(value="com.android.graphics.hwui.flags.high_contrast_text_small_text_rect")
    public void addHighContrastTextStateChangeListener(@NonNull Executor executor, @NonNull HighContrastTextStateChangeListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            this.mHighContrastTextStateChangeListeners.put(listener, executor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FlaggedApi(value="com.android.graphics.hwui.flags.high_contrast_text_small_text_rect")
    public void removeHighContrastTextStateChangeListener(@NonNull HighContrastTextStateChangeListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            this.mHighContrastTextStateChangeListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAudioDescriptionRequestedChangeListener(@NonNull Executor executor, @NonNull AudioDescriptionRequestedChangeListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            this.mAudioDescriptionRequestedChangeListeners.put(listener, executor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAudioDescriptionRequestedChangeListener(@NonNull AudioDescriptionRequestedChangeListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mAudioDescriptionRequestedChangeListeners.remove(listener) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAccessibilityPolicy(@Nullable AccessibilityPolicy policy) {
        Object object = this.mLock;
        synchronized (object) {
            this.mAccessibilityPolicy = policy;
        }
    }

    public boolean isAccessibilityVolumeStreamActive() {
        List<AccessibilityServiceInfo> serviceInfos = this.getEnabledAccessibilityServiceList(-1);
        for (int i = 0; i < serviceInfos.size(); ++i) {
            if ((serviceInfos.get((int)i).flags & 0x80) == 0) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendFingerprintGesture(int keyCode) {
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return false;
            }
        }
        try {
            return service.sendFingerprintGesture(keyCode);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    public int getAccessibilityWindowId(@Nullable IBinder windowToken) {
        IAccessibilityManager service;
        if (windowToken == null) {
            return -1;
        }
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return -1;
            }
        }
        try {
            return service.getAccessibilityWindowId(windowToken);
        }
        catch (RemoteException e) {
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void associateEmbeddedHierarchy(@NonNull IBinder host, @NonNull IBinder embedded) {
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return;
            }
        }
        try {
            service.associateEmbeddedHierarchy(host, embedded);
        }
        catch (RemoteException e) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disassociateEmbeddedHierarchy(@NonNull IBinder token) {
        IAccessibilityManager service;
        if (token == null) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return;
            }
        }
        try {
            service.disassociateEmbeddedHierarchy(token);
        }
        catch (RemoteException e) {
            return;
        }
    }

    @UnsupportedAppUsage
    private void setStateLocked(int stateFlags) {
        boolean enabled = (stateFlags & 1) != 0;
        boolean touchExplorationEnabled = (stateFlags & 2) != 0;
        boolean highTextContrastEnabled = (stateFlags & 4) != 0;
        boolean audioDescriptionEnabled = (stateFlags & 0x1000) != 0;
        boolean wasEnabled = this.isEnabled();
        boolean wasTouchExplorationEnabled = this.mIsTouchExplorationEnabled;
        boolean wasHighTextContrastEnabled = this.mIsHighContrastTextEnabled;
        boolean wasAudioDescriptionByDefaultRequested = this.mIsAudioDescriptionByDefaultRequested;
        this.mIsEnabled = enabled;
        this.mIsTouchExplorationEnabled = touchExplorationEnabled;
        this.mIsHighContrastTextEnabled = highTextContrastEnabled;
        this.mIsAudioDescriptionByDefaultRequested = audioDescriptionEnabled;
        if (wasEnabled != this.isEnabled()) {
            this.notifyAccessibilityStateChanged();
        }
        if (wasTouchExplorationEnabled != touchExplorationEnabled) {
            this.notifyTouchExplorationStateChanged();
        }
        if (wasHighTextContrastEnabled != highTextContrastEnabled) {
            this.notifyHighContrastTextStateChanged();
        }
        if (wasAudioDescriptionByDefaultRequested != audioDescriptionEnabled) {
            this.notifyAudioDescriptionbyDefaultStateChanged();
        }
        this.updateAccessibilityTracingState(stateFlags);
    }

    public AccessibilityServiceInfo getInstalledServiceInfoWithComponentName(ComponentName componentName) {
        List<AccessibilityServiceInfo> installedServiceInfos = this.getInstalledAccessibilityServiceList();
        if (installedServiceInfos == null || componentName == null) {
            return null;
        }
        for (int i = 0; i < installedServiceInfos.size(); ++i) {
            if (!componentName.equals(installedServiceInfos.get(i).getComponentName())) continue;
            return installedServiceInfos.get(i);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addAccessibilityInteractionConnection(IWindow windowToken, IBinder leashToken, String packageName, IAccessibilityInteractionConnection connection) {
        int userId;
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return -1;
            }
            userId = this.mUserId;
        }
        try {
            return service.addAccessibilityInteractionConnection(windowToken, leashToken, connection, packageName, userId);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error while adding an accessibility interaction connection. ", re);
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAccessibilityInteractionConnection(IWindow windowToken) {
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return;
            }
        }
        try {
            service.removeAccessibilityInteractionConnection(windowToken);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error while removing an accessibility interaction connection. ", re);
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_ACCESSIBILITY")
    public void performAccessibilityShortcut() {
        this.performAccessibilityShortcut(0, 2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.MANAGE_ACCESSIBILITY")
    public void performAccessibilityShortcut(int displayId, int shortcutType, @Nullable String targetName) {
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return;
            }
        }
        try {
            service.performAccessibilityShortcut(displayId, shortcutType, targetName);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error performing accessibility shortcut. ", re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.MANAGE_ACCESSIBILITY")
    public void enableShortcutsForTargets(boolean enable, int shortcutTypes, @NonNull Set<String> targets, int userId) {
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return;
            }
        }
        try {
            service.enableShortcutsForTargets(enable, shortcutTypes, targets.stream().toList(), userId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.MANAGE_ACCESSIBILITY")
    @NonNull
    public Map<ComponentName, ComponentName> getA11yFeatureToTileMap(int userId) {
        IAccessibilityManager service;
        ArrayMap<ComponentName, ComponentName> a11yFeatureToTileMap = new ArrayMap<ComponentName, ComponentName>();
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return a11yFeatureToTileMap;
            }
        }
        try {
            Bundle a11yFeatureToTile = service.getA11yFeatureToTileMap(userId);
            for (String key : a11yFeatureToTile.keySet()) {
                ComponentName tileService;
                ComponentName feature = ComponentName.unflattenFromString(key);
                if (feature == null || (tileService = a11yFeatureToTile.getParcelable(key, ComponentName.class)) == null) continue;
                a11yFeatureToTileMap.put(feature, tileService);
            }
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
        return a11yFeatureToTileMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_ACCESSIBILITY")
    public void registerSystemAction(@NonNull RemoteAction action, int actionId) {
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return;
            }
        }
        try {
            service.registerSystemAction(action, actionId);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error registering system action " + action.getTitle() + " ", re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_ACCESSIBILITY")
    public void unregisterSystemAction(int actionId) {
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return;
            }
        }
        try {
            service.unregisterSystemAction(actionId);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error unregistering system action with actionId " + actionId + " ", re);
        }
    }

    @RequiresPermission(value="android.permission.STATUS_BAR_SERVICE")
    public void notifyAccessibilityButtonClicked(int displayId) {
        this.notifyAccessibilityButtonClicked(displayId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.STATUS_BAR_SERVICE")
    public void notifyAccessibilityButtonClicked(int displayId, @Nullable String targetName) {
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return;
            }
        }
        try {
            service.notifyAccessibilityButtonClicked(displayId, targetName);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error while dispatching accessibility button click", re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.STATUS_BAR_SERVICE")
    public void notifyAccessibilityButtonLongClicked(int displayId) {
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return;
            }
        }
        try {
            service.notifyAccessibilityButtonLongClicked(displayId);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error while dispatching accessibility button long click. ", re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAccessibilityButtonVisibilityChanged(boolean shown) {
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return;
            }
        }
        try {
            service.notifyAccessibilityButtonVisibilityChanged(shown);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error while dispatching accessibility button visibility change", re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPictureInPictureActionReplacingConnection(@Nullable IAccessibilityInteractionConnection connection) {
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return;
            }
        }
        try {
            service.setPictureInPictureActionReplacingConnection(connection);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error setting picture in picture action replacement", re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.MANAGE_ACCESSIBILITY")
    @NonNull
    public List<String> getAccessibilityShortcutTargets(int shortcutType, int userId) {
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
        }
        if (service != null) {
            try {
                return service.getAccessibilityShortcutTargets(shortcutType, userId);
            }
            catch (RemoteException re) {
                re.rethrowFromSystemServer();
            }
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.MANAGE_ACCESSIBILITY")
    @NonNull
    public List<String> getAccessibilityShortcutTargets(int shortcutType) {
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
        }
        if (service != null) {
            try {
                return service.getAccessibilityShortcutTargets(shortcutType, -2);
            }
            catch (RemoteException re) {
                re.rethrowFromSystemServer();
            }
        }
        return Collections.emptyList();
    }

    @NonNull
    public List<AccessibilityShortcutInfo> getInstalledAccessibilityShortcutListAsUser(@NonNull Context context, int userId) {
        ArrayList<AccessibilityShortcutInfo> shortcutInfos = new ArrayList<AccessibilityShortcutInfo>();
        int flags = 819329;
        Intent actionMain = new Intent("android.intent.action.MAIN");
        actionMain.addCategory("android.intent.category.ACCESSIBILITY_SHORTCUT_TARGET");
        PackageManager packageManager = context.getPackageManager();
        List<ResolveInfo> installedShortcutList = packageManager.queryIntentActivitiesAsUser(actionMain, 819329, userId);
        for (int i = 0; i < installedShortcutList.size(); ++i) {
            AccessibilityShortcutInfo shortcutInfo = this.getShortcutInfo(context, installedShortcutList.get(i));
            if (shortcutInfo == null) continue;
            shortcutInfos.add(shortcutInfo);
        }
        return shortcutInfos;
    }

    @Nullable
    private AccessibilityShortcutInfo getShortcutInfo(@NonNull Context context, @NonNull ResolveInfo resolveInfo) {
        ActivityInfo activityInfo = resolveInfo.activityInfo;
        if (activityInfo == null || activityInfo.metaData == null || activityInfo.metaData.getInt("android.accessibilityshortcut.target") == 0) {
            return null;
        }
        try {
            return new AccessibilityShortcutInfo(context, activityInfo);
        }
        catch (IOException | XmlPullParserException exp) {
            Log.e(LOG_TAG, "Error while initializing AccessibilityShortcutInfo", exp);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMagnificationConnection(@Nullable IMagnificationConnection connection) {
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return;
            }
        }
        try {
            service.setMagnificationConnection(connection);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error setting magnification connection", re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAudioDescriptionRequested() {
        Object object = this.mLock;
        synchronized (object) {
            IAccessibilityManager service = this.getServiceLocked();
            if (service == null) {
                return false;
            }
            return this.mIsAudioDescriptionByDefaultRequested;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSystemAudioCaptioningEnabled(boolean isEnabled, int userId) {
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return;
            }
        }
        try {
            service.setSystemAudioCaptioningEnabled(isEnabled, userId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSystemAudioCaptioningUiEnabled(int userId) {
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return false;
            }
        }
        try {
            return service.isSystemAudioCaptioningUiEnabled(userId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSystemAudioCaptioningUiEnabled(boolean isEnabled, int userId) {
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return;
            }
        }
        try {
            service.setSystemAudioCaptioningUiEnabled(isEnabled, userId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAccessibilityWindowAttributes(int displayId, int windowId, AccessibilityWindowAttributes attributes) {
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return;
            }
        }
        try {
            service.setAccessibilityWindowAttributes(displayId, windowId, this.mUserId, attributes);
        }
        catch (RemoteException re) {
            re.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(allOf={"android.permission.MANAGE_ACCESSIBILITY", "android.permission.CREATE_VIRTUAL_DEVICE"})
    public boolean registerDisplayProxy(@NonNull AccessibilityDisplayProxy proxy) {
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return false;
            }
        }
        try {
            return service.registerProxyForDisplay(proxy.mServiceClient, proxy.getDisplayId());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(allOf={"android.permission.MANAGE_ACCESSIBILITY", "android.permission.CREATE_VIRTUAL_DEVICE"})
    public boolean unregisterDisplayProxy(@NonNull AccessibilityDisplayProxy proxy) {
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return false;
            }
        }
        try {
            return service.unregisterProxyForDisplay(proxy.getDisplayId());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @FlaggedApi(value="android.view.accessibility.flash_notification_system_api")
    public boolean startFlashNotificationSequence(@NonNull Context context, int reason) {
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return false;
            }
        }
        try {
            return service.startFlashNotificationSequence(context.getOpPackageName(), reason, this.mBinder);
        }
        catch (RemoteException | SecurityException e) {
            Log.e(LOG_TAG, "Error while start flash notification sequence", e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @FlaggedApi(value="android.view.accessibility.flash_notification_system_api")
    public boolean stopFlashNotificationSequence(@NonNull Context context) {
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return false;
            }
        }
        try {
            return service.stopFlashNotificationSequence(context.getOpPackageName());
        }
        catch (RemoteException | SecurityException e) {
            Log.e(LOG_TAG, "Error while stop flash notification sequence", e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startFlashNotificationEvent(@NonNull Context context, int reason, @Nullable String reasonPkg) {
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return false;
            }
        }
        try {
            return service.startFlashNotificationEvent(context.getOpPackageName(), reason, reasonPkg);
        }
        catch (RemoteException | SecurityException e) {
            Log.e(LOG_TAG, "Error while start flash notification event", e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAccessibilityTargetAllowed(String packageName, int uid, int userId) {
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return false;
            }
        }
        try {
            return service.isAccessibilityTargetAllowed(packageName, uid, userId);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error while check accessibility target status", re);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendRestrictedDialogIntent(String packageName, int uid, int userId) {
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return false;
            }
        }
        try {
            return service.sendRestrictedDialogIntent(packageName, uid, userId);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error while show restricted dialog", re);
            return false;
        }
    }

    private IAccessibilityManager getServiceLocked() {
        if (this.mService == null) {
            this.tryConnectToServiceLocked(null);
        }
        return this.mService;
    }

    private void tryConnectToServiceLocked(IAccessibilityManager service) {
        if (service == null) {
            IBinder iBinder = ServiceManager.getService("accessibility");
            if (iBinder == null) {
                return;
            }
            service = IAccessibilityManager.Stub.asInterface(iBinder);
        }
        try {
            long userStateAndRelevantEvents = service.addClient(this.mClient, this.mUserId);
            this.setStateLocked(IntPair.first(userStateAndRelevantEvents));
            this.mRelevantEventTypes = IntPair.second(userStateAndRelevantEvents);
            this.updateUiTimeout(service.getRecommendedTimeoutMillis());
            this.updateFocusAppearanceLocked(service.getFocusStrokeWidth(), service.getFocusColor());
            this.mService = service;
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "AccessibilityManagerService is dead", re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAccessibilityStateChanged() {
        ArrayMap<AccessibilityStateChangeListener, Handler> listeners;
        boolean isEnabled;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mAccessibilityStateChangeListeners.isEmpty()) {
                return;
            }
            isEnabled = this.isEnabled();
            listeners = new ArrayMap<AccessibilityStateChangeListener, Handler>(this.mAccessibilityStateChangeListeners);
        }
        int numListeners = listeners.size();
        for (int i = 0; i < numListeners; ++i) {
            AccessibilityStateChangeListener listener = listeners.keyAt(i);
            listeners.valueAt(i).post(() -> listener.onAccessibilityStateChanged(isEnabled));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyTouchExplorationStateChanged() {
        ArrayMap<TouchExplorationStateChangeListener, Handler> listeners;
        boolean isTouchExplorationEnabled;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mTouchExplorationStateChangeListeners.isEmpty()) {
                return;
            }
            isTouchExplorationEnabled = this.mIsTouchExplorationEnabled;
            listeners = new ArrayMap<TouchExplorationStateChangeListener, Handler>(this.mTouchExplorationStateChangeListeners);
        }
        int numListeners = listeners.size();
        for (int i = 0; i < numListeners; ++i) {
            TouchExplorationStateChangeListener listener = listeners.keyAt(i);
            listeners.valueAt(i).post(() -> listener.onTouchExplorationStateChanged(isTouchExplorationEnabled));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyHighContrastTextStateChanged() {
        ArrayMap<HighContrastTextStateChangeListener, Executor> listeners;
        boolean isHighTextContrastEnabled;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mHighContrastTextStateChangeListeners.isEmpty()) {
                return;
            }
            isHighTextContrastEnabled = this.mIsHighContrastTextEnabled;
            listeners = new ArrayMap<HighContrastTextStateChangeListener, Executor>(this.mHighContrastTextStateChangeListeners);
        }
        int numListeners = listeners.size();
        for (int i = 0; i < numListeners; ++i) {
            HighContrastTextStateChangeListener listener = listeners.keyAt(i);
            listeners.valueAt(i).execute(() -> listener.onHighContrastTextStateChanged(isHighTextContrastEnabled));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyAudioDescriptionbyDefaultStateChanged() {
        ArrayMap<AudioDescriptionRequestedChangeListener, Executor> listeners;
        boolean isAudioDescriptionByDefaultRequested;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mAudioDescriptionRequestedChangeListeners.isEmpty()) {
                return;
            }
            isAudioDescriptionByDefaultRequested = this.mIsAudioDescriptionByDefaultRequested;
            listeners = new ArrayMap<AudioDescriptionRequestedChangeListener, Executor>(this.mAudioDescriptionRequestedChangeListeners);
        }
        int numListeners = listeners.size();
        for (int i = 0; i < numListeners; ++i) {
            AudioDescriptionRequestedChangeListener listener = listeners.keyAt(i);
            listeners.valueAt(i).execute(() -> listener.onAudioDescriptionRequestedChanged(isAudioDescriptionByDefaultRequested));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAccessibilityTracingState(int stateFlag) {
        Object object = this.mLock;
        synchronized (object) {
            this.mAccessibilityTracingState = stateFlag;
        }
    }

    private void updateUiTimeout(long uiTimeout) {
        this.mInteractiveUiTimeout = IntPair.first(uiTimeout);
        this.mNonInteractiveUiTimeout = IntPair.second(uiTimeout);
    }

    private void updateFocusAppearanceLocked(int strokeWidth, int color2) {
        if (this.mFocusStrokeWidth == strokeWidth && this.mFocusColor == color2) {
            return;
        }
        this.mFocusStrokeWidth = strokeWidth;
        this.mFocusColor = color2;
    }

    private void initialFocusAppearanceLocked(Resources resource) {
        try {
            this.mFocusStrokeWidth = resource.getDimensionPixelSize(0x1050011);
            this.mFocusColor = resource.getColor(17170673);
        }
        catch (Resources.NotFoundException re) {
            this.mFocusStrokeWidth = (int)(4.0f * resource.getDisplayMetrics().density);
            this.mFocusColor = -1086737152;
            Log.e(LOG_TAG, "Error while initialing the focus appearance data then setting to default value by hardcoded", re);
        }
    }

    public static boolean isAccessibilityButtonSupported() {
        Resources res = Resources.getSystem();
        return res.getBoolean(17891912);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAccessibilityManager.WindowTransformationSpec getWindowTransformationSpec_Original(int windowId) {
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return null;
            }
        }
        try {
            return service.getWindowTransformationSpec(windowId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @LayoutlibDelegate
    public IAccessibilityManager.WindowTransformationSpec getWindowTransformationSpec(int n) {
        return AccessibilityManager_Delegate.getWindowTransformationSpec(this, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.INTERNAL_SYSTEM_WINDOW")
    public void attachAccessibilityOverlayToDisplay(int displayId, @NonNull SurfaceControl surfaceControl) {
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return;
            }
        }
        try {
            service.attachAccessibilityOverlayToDisplay(displayId, surfaceControl);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.STATUS_BAR_SERVICE")
    public void notifyQuickSettingsTilesChanged(int userId, List<ComponentName> tileComponentNames) {
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return;
            }
        }
        try {
            service.notifyQuickSettingsTilesChanged(userId, tileComponentNames);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private class MyCallback
    implements Handler.Callback {
        public static final int MSG_SET_STATE = 1;

        private MyCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    int state = message.arg1;
                    Object object = AccessibilityManager.this.mLock;
                    synchronized (object) {
                        AccessibilityManager.this.setStateLocked(state);
                        break;
                    }
                }
            }
            return true;
        }
    }

    public static interface AccessibilityPolicy {
        public boolean isEnabled(boolean var1);

        @Nullable
        public AccessibilityEvent onAccessibilityEvent(@NonNull AccessibilityEvent var1, boolean var2, int var3);

        public int getRelevantEventTypes(int var1);

        @NonNull
        public List<AccessibilityServiceInfo> getInstalledAccessibilityServiceList(@Nullable List<AccessibilityServiceInfo> var1);

        @Nullable
        public List<AccessibilityServiceInfo> getEnabledAccessibilityServiceList(int var1, @Nullable List<AccessibilityServiceInfo> var2);
    }

    public static interface AccessibilityStateChangeListener {
        public void onAccessibilityStateChanged(boolean var1);
    }

    public static interface TouchExplorationStateChangeListener {
        public void onTouchExplorationStateChanged(boolean var1);
    }

    public static interface AccessibilityServicesStateChangeListener {
        public void onAccessibilityServicesStateChanged(@NonNull AccessibilityManager var1);
    }

    @FlaggedApi(value="com.android.graphics.hwui.flags.high_contrast_text_small_text_rect")
    public static interface HighContrastTextStateChangeListener {
        public void onHighContrastTextStateChanged(boolean var1);
    }

    public static interface AudioDescriptionRequestedChangeListener {
        public void onAudioDescriptionRequestedChanged(boolean var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FlashNotificationReason {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ContentFlag {
    }
}

