/*
 * Decompiled with CFR 0.152.
 */
package android.view.accessibility;

import android.accessibilityservice.AccessibilityService;
import android.accessibilityservice.IAccessibilityServiceConnection;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresNoPermission;
import android.annotation.SuppressLint;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os._Original_Build;
import android.util.Log;
import android.util.LongSparseArray;
import android.util.Pair;
import android.util.SparseArray;
import android.util.SparseLongArray;
import android.view.SurfaceControl;
import android.view.ViewConfiguration;
import android.view.accessibility.AccessibilityCache;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityWindowInfo;
import android.view.accessibility.DirectAccessibilityConnection;
import android.view.accessibility.IAccessibilityInteractionConnection;
import android.view.accessibility.IAccessibilityInteractionConnectionCallback;
import android.window.ScreenCapture;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.hidden_from_bootclasspath.android.view.accessibility.Flags;
import com.android.internal.util.ArrayUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntConsumer;

public class AccessibilityInteractionClient
extends IAccessibilityInteractionConnectionCallback.Stub {
    public static final int NO_ID = -1;
    public static final String CALL_STACK = "call_stack";
    public static final String IGNORE_CALL_STACK = "ignore_call_stack";
    private static final String LOG_TAG = "AccessibilityInteractionClient";
    private static final boolean DEBUG = false;
    private static final boolean CHECK_INTEGRITY = true;
    private static final long TIMEOUT_INTERACTION_MILLIS = 5000L;
    private static final long DISABLE_PREFETCHING_FOR_SCROLLING_MILLIS = (long)((double)ViewConfiguration.getSendRecurringAccessibilityEventsInterval() * 1.5);
    private static final Object sStaticLock = new Object();
    public static final LongSparseArray<AccessibilityInteractionClient> sClients = new LongSparseArray();
    public static final SparseArray<IAccessibilityServiceConnection> sConnectionCache = new SparseArray();
    private static int sDirectConnectionIdCounter = 0x40000000;
    public static int sDirectConnectionCount = 0;
    public static final SparseLongArray sScrollingWindows = new SparseLongArray();
    public static SparseArray<AccessibilityCache> sCaches = new SparseArray();
    private final AtomicInteger mInteractionIdCounter = new AtomicInteger();
    private final Object mInstanceLock = new Object();
    private final AccessibilityManager mAccessibilityManager;
    private volatile int mInteractionId = -1;
    private volatile int mCallingUid = -1;
    private List<StackTraceElement> mCallStackOfCallback;
    private AccessibilityNodeInfo mFindAccessibilityNodeInfoResult;
    private List<AccessibilityNodeInfo> mFindAccessibilityNodeInfosResult;
    private boolean mPerformAccessibilityActionResult;
    private final SparseArray<Pair<Executor, AccessibilityService.TakeScreenshotCallback>> mTakeScreenshotOfWindowCallbacks = new SparseArray();
    private final SparseArray<Pair<Executor, IntConsumer>> mAttachAccessibilityOverlayCallbacks = new SparseArray();
    private Message mSameThreadMessage;
    private int mInteractionIdWaitingForPrefetchResult = -1;
    private int mConnectionIdWaitingForPrefetchResult;
    private String[] mPackageNamesForNextPrefetchResult;
    private Handler mMainHandler = new Handler(Looper.getMainLooper());

    @UnsupportedAppUsage
    public static AccessibilityInteractionClient getInstance() {
        long threadId = Thread.currentThread().getId();
        return AccessibilityInteractionClient.getInstanceForThread(threadId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AccessibilityInteractionClient getInstanceForThread(long threadId) {
        Object object = sStaticLock;
        synchronized (object) {
            AccessibilityInteractionClient client = sClients.get(threadId);
            if (client == null) {
                client = new AccessibilityInteractionClient();
                sClients.put(threadId, client);
            }
            return client;
        }
    }

    public static AccessibilityInteractionClient getInstance(Context context) {
        long threadId = Thread.currentThread().getId();
        if (context != null) {
            return AccessibilityInteractionClient.getInstanceForThread(threadId, context);
        }
        return AccessibilityInteractionClient.getInstanceForThread(threadId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AccessibilityInteractionClient getInstanceForThread(long threadId, Context context) {
        Object object = sStaticLock;
        synchronized (object) {
            AccessibilityInteractionClient client = sClients.get(threadId);
            if (client == null) {
                client = new AccessibilityInteractionClient(context);
                sClients.put(threadId, client);
            }
            return client;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IAccessibilityServiceConnection getConnection(int connectionId) {
        SparseArray<IAccessibilityServiceConnection> sparseArray = sConnectionCache;
        synchronized (sparseArray) {
            return sConnectionCache.get(connectionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addConnection(int connectionId, IAccessibilityServiceConnection connection, boolean initializeCache) {
        if (connectionId == -1) {
            return;
        }
        SparseArray<IAccessibilityServiceConnection> sparseArray = sConnectionCache;
        synchronized (sparseArray) {
            IAccessibilityServiceConnection existingConnection = AccessibilityInteractionClient.getConnection(connectionId);
            if (existingConnection instanceof DirectAccessibilityConnection) {
                throw new IllegalArgumentException("Cannot add service connection with id " + connectionId + " which conflicts with existing direct connection.");
            }
            sConnectionCache.put(connectionId, connection);
            if (!initializeCache) {
                return;
            }
            sCaches.put(connectionId, new AccessibilityCache(new AccessibilityCache.AccessibilityNodeRefresher()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int addDirectConnection(IAccessibilityInteractionConnection connection, AccessibilityManager accessibilityManager) {
        SparseArray<IAccessibilityServiceConnection> sparseArray = sConnectionCache;
        synchronized (sparseArray) {
            int connectionId = sDirectConnectionIdCounter++;
            if (AccessibilityInteractionClient.getConnection(connectionId) != null) {
                throw new IllegalArgumentException("Cannot add direct connection with existing id " + connectionId);
            }
            DirectAccessibilityConnection directAccessibilityConnection = new DirectAccessibilityConnection(connection, accessibilityManager);
            sConnectionCache.put(connectionId, directAccessibilityConnection);
            ++sDirectConnectionCount;
            return connectionId;
        }
    }

    public static boolean hasAnyDirectConnection() {
        return sDirectConnectionCount > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AccessibilityCache getCache(int connectionId) {
        SparseArray<IAccessibilityServiceConnection> sparseArray = sConnectionCache;
        synchronized (sparseArray) {
            return sCaches.get(connectionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeConnection(int connectionId) {
        SparseArray<IAccessibilityServiceConnection> sparseArray = sConnectionCache;
        synchronized (sparseArray) {
            if (AccessibilityInteractionClient.getConnection(connectionId) instanceof DirectAccessibilityConnection) {
                --sDirectConnectionCount;
            }
            sConnectionCache.remove(connectionId);
            sCaches.remove(connectionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public static void setCache(int connectionId, AccessibilityCache cache) {
        SparseArray<IAccessibilityServiceConnection> sparseArray = sConnectionCache;
        synchronized (sparseArray) {
            sCaches.put(connectionId, cache);
        }
    }

    private AccessibilityInteractionClient() {
        this.mAccessibilityManager = null;
    }

    private AccessibilityInteractionClient(Context context) {
        this.mAccessibilityManager = context.getSystemService(AccessibilityManager.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void setSameThreadMessage(Message message) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            this.mSameThreadMessage = message;
            this.mInstanceLock.notifyAll();
        }
    }

    public AccessibilityNodeInfo getRootInActiveWindow(int connectionId, int strategy) {
        return this.findAccessibilityNodeInfoByAccessibilityId(connectionId, Integer.MAX_VALUE, AccessibilityNodeInfo.ROOT_NODE_ID, false, strategy, null);
    }

    public AccessibilityWindowInfo getWindow(int connectionId, int accessibilityWindowId) {
        return this.getWindow(connectionId, accessibilityWindowId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessibilityWindowInfo getWindow(int connectionId, int accessibilityWindowId, boolean bypassCache) {
        block10: {
            try {
                AccessibilityWindowInfo window;
                IAccessibilityServiceConnection connection = AccessibilityInteractionClient.getConnection(connectionId);
                if (connection == null) break block10;
                AccessibilityCache cache = AccessibilityInteractionClient.getCache(connectionId);
                if (cache != null && !bypassCache && (window = cache.getWindow(accessibilityWindowId)) != null) {
                    if (this.shouldTraceClient()) {
                        this.logTraceClient(connection, "getWindow cache", "connectionId=" + connectionId + ";accessibilityWindowId=" + accessibilityWindowId + ";bypassCache=false");
                    }
                    return window;
                }
                long identityToken = Binder.clearCallingIdentity();
                try {
                    window = connection.getWindow(accessibilityWindowId);
                }
                finally {
                    Binder.restoreCallingIdentity(identityToken);
                }
                if (this.shouldTraceClient()) {
                    this.logTraceClient(connection, "getWindow", "connectionId=" + connectionId + ";accessibilityWindowId=" + accessibilityWindowId + ";bypassCache=" + bypassCache);
                }
                if (window != null) {
                    if (!bypassCache && cache != null) {
                        cache.addWindow(window);
                    }
                    return window;
                }
            }
            catch (RemoteException re) {
                Log.e(LOG_TAG, "Error while calling remote getWindow", re);
            }
        }
        return null;
    }

    public List<AccessibilityWindowInfo> getWindows(int connectionId) {
        return this.getWindowsOnDisplay(connectionId, 0);
    }

    public List<AccessibilityWindowInfo> getWindowsOnDisplay(int connectionId, int displayId) {
        SparseArray<List<AccessibilityWindowInfo>> windows = this.getWindowsOnAllDisplays(connectionId);
        return windows.get(displayId, Collections.emptyList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SparseArray<List<AccessibilityWindowInfo>> getWindowsOnAllDisplays(int connectionId) {
        block10: {
            try {
                long populationTimeStamp;
                AccessibilityWindowInfo.WindowListSparseArray windows;
                IAccessibilityServiceConnection connection = AccessibilityInteractionClient.getConnection(connectionId);
                if (connection == null) break block10;
                AccessibilityCache cache = AccessibilityInteractionClient.getCache(connectionId);
                if (cache != null && (windows = cache.getWindowsOnAllDisplays()) != null) {
                    if (this.shouldTraceClient()) {
                        this.logTraceClient(connection, "getWindows cache", "connectionId=" + connectionId);
                    }
                    return windows;
                }
                long identityToken = Binder.clearCallingIdentity();
                try {
                    populationTimeStamp = SystemClock.uptimeMillis();
                    windows = connection.getWindows();
                }
                finally {
                    Binder.restoreCallingIdentity(identityToken);
                }
                if (this.shouldTraceClient()) {
                    this.logTraceClient(connection, "getWindows", "connectionId=" + connectionId);
                }
                if (windows != null) {
                    if (cache != null) {
                        cache.setWindowsOnAllDisplays(windows, populationTimeStamp);
                    }
                    return windows;
                }
            }
            catch (RemoteException re) {
                Log.e(LOG_TAG, "Error while calling remote getWindowsOnAllDisplays", re);
            }
        }
        SparseArray<List<AccessibilityWindowInfo>> emptyWindows = new SparseArray<List<AccessibilityWindowInfo>>();
        return emptyWindows;
    }

    @Nullable
    public AccessibilityNodeInfo findAccessibilityNodeInfoByAccessibilityId(int connectionId, @NonNull IBinder leashToken, long accessibilityNodeId, boolean bypassCache, int prefetchFlags, Bundle arguments) {
        if (leashToken == null) {
            return null;
        }
        int windowId = -1;
        try {
            IAccessibilityServiceConnection connection = AccessibilityInteractionClient.getConnection(connectionId);
            if (connection != null) {
                windowId = connection.getWindowIdForLeashToken(leashToken);
            }
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error while calling remote getWindowIdForLeashToken", re);
        }
        if (windowId == -1) {
            return null;
        }
        return this.findAccessibilityNodeInfoByAccessibilityId(connectionId, windowId, accessibilityNodeId, bypassCache, prefetchFlags, arguments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public AccessibilityNodeInfo findAccessibilityNodeInfoByAccessibilityId(int connectionId, int accessibilityWindowId, long accessibilityNodeId, boolean bypassCache, int prefetchFlags, Bundle arguments) {
        block19: {
            try {
                String[] packageNames;
                int descendantPrefetchFlags;
                IAccessibilityServiceConnection connection = AccessibilityInteractionClient.getConnection(connectionId);
                if (connection == null) break block19;
                if (!bypassCache) {
                    AccessibilityCache cache = AccessibilityInteractionClient.getCache(connectionId);
                    if (cache != null) {
                        AccessibilityNodeInfo cachedInfo = cache.getNode(accessibilityWindowId, accessibilityNodeId);
                        if (cachedInfo != null) {
                            if (this.shouldTraceClient()) {
                                this.logTraceClient(connection, "findAccessibilityNodeInfoByAccessibilityId cache", "connectionId=" + connectionId + ";accessibilityWindowId=" + accessibilityWindowId + ";accessibilityNodeId=" + accessibilityNodeId + ";bypassCache=" + bypassCache + ";prefetchFlags=" + prefetchFlags + ";arguments=" + arguments);
                            }
                            return cachedInfo;
                        }
                        if (!cache.isEnabled()) {
                            prefetchFlags &= 0xFFFFFFC0;
                        }
                    }
                } else {
                    prefetchFlags &= 0xFFFFFFC0;
                }
                if ((prefetchFlags & 0x3F) != 0 && this.isWindowScrolling(accessibilityWindowId)) {
                    prefetchFlags &= 0xFFFFFFC0;
                }
                if (((descendantPrefetchFlags = prefetchFlags & 0x1C) & descendantPrefetchFlags - 1) != 0) {
                    throw new IllegalArgumentException("There can be no more than one descendant prefetching strategy");
                }
                int interactionId = this.mInteractionIdCounter.getAndIncrement();
                if (this.shouldTraceClient()) {
                    this.logTraceClient(connection, "findAccessibilityNodeInfoByAccessibilityId", "InteractionId:" + interactionId + "connectionId=" + connectionId + ";accessibilityWindowId=" + accessibilityWindowId + ";accessibilityNodeId=" + accessibilityNodeId + ";bypassCache=" + bypassCache + ";prefetchFlags=" + prefetchFlags + ";arguments=" + arguments);
                }
                long identityToken = Binder.clearCallingIdentity();
                try {
                    packageNames = connection.findAccessibilityNodeInfoByAccessibilityId(accessibilityWindowId, accessibilityNodeId, interactionId, this, prefetchFlags, Thread.currentThread().getId(), arguments);
                }
                finally {
                    Binder.restoreCallingIdentity(identityToken);
                }
                if (packageNames == null) break block19;
                if ((prefetchFlags & 0x20) != 0) {
                    List<AccessibilityNodeInfo> infos = this.getFindAccessibilityNodeInfosResultAndClear(interactionId);
                    if (this.shouldTraceCallback()) {
                        this.logTraceCallback(connection, "findAccessibilityNodeInfoByAccessibilityId", "InteractionId:" + interactionId + ";connectionId=" + connectionId + ";Result: " + infos);
                    }
                    this.finalizeAndCacheAccessibilityNodeInfos(infos, connectionId, bypassCache, packageNames);
                    if (infos != null && !infos.isEmpty()) {
                        return infos.get(0);
                    }
                    break block19;
                }
                AccessibilityNodeInfo info = this.getFindAccessibilityNodeInfoResultAndClear(interactionId);
                if (this.shouldTraceCallback()) {
                    this.logTraceCallback(connection, "findAccessibilityNodeInfoByAccessibilityId", "InteractionId:" + interactionId + ";connectionId=" + connectionId + ";Result: " + info);
                }
                if ((prefetchFlags & 0x3F) != 0 && info != null) {
                    this.setInteractionWaitingForPrefetchResult(interactionId, connectionId, packageNames);
                }
                this.finalizeAndCacheAccessibilityNodeInfo(info, connectionId, bypassCache, packageNames);
                return info;
            }
            catch (RemoteException re) {
                Log.e(LOG_TAG, "Error while calling remote findAccessibilityNodeInfoByAccessibilityId", re);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInteractionWaitingForPrefetchResult(int interactionId, int connectionId, String[] packageNames) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            this.mInteractionIdWaitingForPrefetchResult = interactionId;
            this.mConnectionIdWaitingForPrefetchResult = connectionId;
            this.mPackageNamesForNextPrefetchResult = packageNames;
        }
    }

    private static String idToString(int accessibilityWindowId, long accessibilityNodeId) {
        return accessibilityWindowId + "/" + AccessibilityNodeInfo.idToString(accessibilityNodeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AccessibilityNodeInfo> findAccessibilityNodeInfosByViewId(int connectionId, int accessibilityWindowId, long accessibilityNodeId, String viewId) {
        block9: {
            try {
                String[] packageNames;
                IAccessibilityServiceConnection connection = AccessibilityInteractionClient.getConnection(connectionId);
                if (connection == null) break block9;
                int interactionId = this.mInteractionIdCounter.getAndIncrement();
                long identityToken = Binder.clearCallingIdentity();
                try {
                    if (this.shouldTraceClient()) {
                        this.logTraceClient(connection, "findAccessibilityNodeInfosByViewId", "InteractionId=" + interactionId + ";connectionId=" + connectionId + ";accessibilityWindowId=" + accessibilityWindowId + ";accessibilityNodeId=" + accessibilityNodeId + ";viewId=" + viewId);
                    }
                    packageNames = connection.findAccessibilityNodeInfosByViewId(accessibilityWindowId, accessibilityNodeId, viewId, interactionId, this, Thread.currentThread().getId());
                }
                finally {
                    Binder.restoreCallingIdentity(identityToken);
                }
                if (packageNames != null) {
                    List<AccessibilityNodeInfo> infos = this.getFindAccessibilityNodeInfosResultAndClear(interactionId);
                    if (this.shouldTraceCallback()) {
                        this.logTraceCallback(connection, "findAccessibilityNodeInfosByViewId", "InteractionId=" + interactionId + ";connectionId=" + connectionId + ":Result: " + infos);
                    }
                    if (infos != null) {
                        this.finalizeAndCacheAccessibilityNodeInfos(infos, connectionId, false, packageNames);
                        return infos;
                    }
                }
            }
            catch (RemoteException re) {
                Log.w(LOG_TAG, "Error while calling remote findAccessibilityNodeInfoByViewIdInActiveWindow", re);
            }
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void takeScreenshotOfWindow(int connectionId, int accessibilityWindowId, @NonNull Executor executor, @NonNull AccessibilityService.TakeScreenshotCallback callback) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            try {
                IAccessibilityServiceConnection connection = AccessibilityInteractionClient.getConnection(connectionId);
                if (connection == null) {
                    executor.execute(() -> callback.onFailure(1));
                    return;
                }
                long identityToken = Binder.clearCallingIdentity();
                try {
                    int interactionId = this.mInteractionIdCounter.getAndIncrement();
                    this.mTakeScreenshotOfWindowCallbacks.put(interactionId, Pair.create(executor, callback));
                    ScreenCapture.ScreenCaptureListener listener = new ScreenCapture.ScreenCaptureListener((screenshot, status) -> {
                        if (status != 0) {
                            this.sendTakeScreenshotOfWindowError(1, interactionId);
                        } else {
                            this.sendWindowScreenshotSuccess((ScreenCapture.ScreenshotHardwareBuffer)screenshot, interactionId);
                        }
                    });
                    connection.takeScreenshotOfWindow(accessibilityWindowId, interactionId, listener, this);
                    this.mMainHandler.postDelayed(() -> {
                        Object object = this.mInstanceLock;
                        synchronized (object) {
                            if (this.mTakeScreenshotOfWindowCallbacks.contains(interactionId)) {
                                this.sendTakeScreenshotOfWindowError(1, interactionId);
                            }
                        }
                    }, 5000L);
                }
                finally {
                    Binder.restoreCallingIdentity(identityToken);
                }
            }
            catch (RemoteException re) {
                executor.execute(() -> callback.onFailure(1));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AccessibilityNodeInfo> findAccessibilityNodeInfosByText(int connectionId, int accessibilityWindowId, long accessibilityNodeId, String text) {
        block9: {
            try {
                String[] packageNames;
                IAccessibilityServiceConnection connection = AccessibilityInteractionClient.getConnection(connectionId);
                if (connection == null) break block9;
                int interactionId = this.mInteractionIdCounter.getAndIncrement();
                if (this.shouldTraceClient()) {
                    this.logTraceClient(connection, "findAccessibilityNodeInfosByText", "InteractionId:" + interactionId + "connectionId=" + connectionId + ";accessibilityWindowId=" + accessibilityWindowId + ";accessibilityNodeId=" + accessibilityNodeId + ";text=" + text);
                }
                long identityToken = Binder.clearCallingIdentity();
                try {
                    packageNames = connection.findAccessibilityNodeInfosByText(accessibilityWindowId, accessibilityNodeId, text, interactionId, this, Thread.currentThread().getId());
                }
                finally {
                    Binder.restoreCallingIdentity(identityToken);
                }
                if (packageNames != null) {
                    List<AccessibilityNodeInfo> infos = this.getFindAccessibilityNodeInfosResultAndClear(interactionId);
                    if (this.shouldTraceCallback()) {
                        this.logTraceCallback(connection, "findAccessibilityNodeInfosByText", "InteractionId=" + interactionId + ";connectionId=" + connectionId + ";Result: " + infos);
                    }
                    if (infos != null) {
                        this.finalizeAndCacheAccessibilityNodeInfos(infos, connectionId, false, packageNames);
                        return infos;
                    }
                }
            }
            catch (RemoteException re) {
                Log.w(LOG_TAG, "Error while calling remote findAccessibilityNodeInfosByViewText", re);
            }
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"LongLogTag"})
    public AccessibilityNodeInfo findFocus(int connectionId, int accessibilityWindowId, long accessibilityNodeId, int focusType) {
        block9: {
            try {
                String[] packageNames;
                AccessibilityNodeInfo cachedInfo;
                IAccessibilityServiceConnection connection = AccessibilityInteractionClient.getConnection(connectionId);
                if (connection == null) break block9;
                AccessibilityCache cache = AccessibilityInteractionClient.getCache(connectionId);
                if (cache != null && (cachedInfo = cache.getFocus(focusType, accessibilityNodeId, accessibilityWindowId)) != null) {
                    return cachedInfo;
                }
                int interactionId = this.mInteractionIdCounter.getAndIncrement();
                if (this.shouldTraceClient()) {
                    this.logTraceClient(connection, "findFocus", "InteractionId:" + interactionId + "connectionId=" + connectionId + ";accessibilityWindowId=" + accessibilityWindowId + ";accessibilityNodeId=" + accessibilityNodeId + ";focusType=" + focusType);
                }
                long identityToken = Binder.clearCallingIdentity();
                try {
                    packageNames = connection.findFocus(accessibilityWindowId, accessibilityNodeId, focusType, interactionId, this, Thread.currentThread().getId());
                }
                finally {
                    Binder.restoreCallingIdentity(identityToken);
                }
                if (packageNames != null) {
                    AccessibilityNodeInfo info = this.getFindAccessibilityNodeInfoResultAndClear(interactionId);
                    if (this.shouldTraceCallback()) {
                        this.logTraceCallback(connection, "findFocus", "InteractionId=" + interactionId + ";connectionId=" + connectionId + ";Result:" + info);
                    }
                    this.finalizeAndCacheAccessibilityNodeInfo(info, connectionId, false, packageNames);
                    return info;
                }
            }
            catch (RemoteException re) {
                Log.w(LOG_TAG, "Error while calling remote findFocus", re);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessibilityNodeInfo focusSearch(int connectionId, int accessibilityWindowId, long accessibilityNodeId, int direction) {
        block8: {
            try {
                String[] packageNames;
                IAccessibilityServiceConnection connection = AccessibilityInteractionClient.getConnection(connectionId);
                if (connection == null) break block8;
                int interactionId = this.mInteractionIdCounter.getAndIncrement();
                if (this.shouldTraceClient()) {
                    this.logTraceClient(connection, "focusSearch", "InteractionId:" + interactionId + "connectionId=" + connectionId + ";accessibilityWindowId=" + accessibilityWindowId + ";accessibilityNodeId=" + accessibilityNodeId + ";direction=" + direction);
                }
                long identityToken = Binder.clearCallingIdentity();
                try {
                    packageNames = connection.focusSearch(accessibilityWindowId, accessibilityNodeId, direction, interactionId, this, Thread.currentThread().getId());
                }
                finally {
                    Binder.restoreCallingIdentity(identityToken);
                }
                if (packageNames != null) {
                    AccessibilityNodeInfo info = this.getFindAccessibilityNodeInfoResultAndClear(interactionId);
                    this.finalizeAndCacheAccessibilityNodeInfo(info, connectionId, false, packageNames);
                    if (this.shouldTraceCallback()) {
                        this.logTraceCallback(connection, "focusSearch", "InteractionId=" + interactionId + ";connectionId=" + connectionId + ";Result:" + info);
                    }
                    return info;
                }
            }
            catch (RemoteException re) {
                Log.w(LOG_TAG, "Error while calling remote accessibilityFocusSearch", re);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean performAccessibilityAction(int connectionId, int accessibilityWindowId, long accessibilityNodeId, int action, Bundle arguments) {
        block8: {
            try {
                boolean success;
                IAccessibilityServiceConnection connection = AccessibilityInteractionClient.getConnection(connectionId);
                if (connection == null) break block8;
                int interactionId = this.mInteractionIdCounter.getAndIncrement();
                if (this.shouldTraceClient()) {
                    this.logTraceClient(connection, "performAccessibilityAction", "InteractionId:" + interactionId + "connectionId=" + connectionId + ";accessibilityWindowId=" + accessibilityWindowId + ";accessibilityNodeId=" + accessibilityNodeId + ";action=" + action + ";arguments=" + arguments);
                }
                long identityToken = Binder.clearCallingIdentity();
                try {
                    success = connection.performAccessibilityAction(accessibilityWindowId, accessibilityNodeId, action, arguments, interactionId, this, Thread.currentThread().getId());
                }
                finally {
                    Binder.restoreCallingIdentity(identityToken);
                }
                if (success) {
                    boolean result = this.getPerformAccessibilityActionResultAndClear(interactionId);
                    if (this.shouldTraceCallback()) {
                        this.logTraceCallback(connection, "performAccessibilityAction", "InteractionId=" + interactionId + ";connectionId=" + connectionId + ";Result: " + result);
                    }
                    return result;
                }
            }
            catch (RemoteException re) {
                Log.w(LOG_TAG, "Error while calling remote performAccessibilityAction", re);
            }
        }
        return false;
    }

    @UnsupportedAppUsage(maxTargetSdk=31, publicAlternatives="{@link android.accessibilityservice.AccessibilityService#clearCache()}")
    public void clearCache(int connectionId) {
        AccessibilityCache cache = AccessibilityInteractionClient.getCache(connectionId);
        if (cache == null) {
            return;
        }
        cache.clear();
    }

    public void onAccessibilityEvent(AccessibilityEvent event, int connectionId) {
        switch (event.getEventType()) {
            case 4096: {
                this.updateScrollingWindow(event.getWindowId(), SystemClock.uptimeMillis());
                break;
            }
            case 0x400000: {
                if (event.getWindowChanges() != 2) break;
                this.deleteScrollingWindow(event.getWindowId());
                break;
            }
        }
        AccessibilityCache cache = AccessibilityInteractionClient.getCache(connectionId);
        if (cache == null) {
            return;
        }
        cache.onAccessibilityEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AccessibilityNodeInfo getFindAccessibilityNodeInfoResultAndClear(int interactionId) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            boolean success = this.waitForResultTimedLocked(interactionId);
            AccessibilityNodeInfo result = success ? this.mFindAccessibilityNodeInfoResult : null;
            this.clearResultLocked();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RequiresNoPermission
    public void setFindAccessibilityNodeInfoResult(AccessibilityNodeInfo info, int interactionId) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            if (interactionId > this.mInteractionId) {
                this.mFindAccessibilityNodeInfoResult = info;
                this.mInteractionId = interactionId;
                this.mCallingUid = Binder.getCallingUid();
                this.mCallStackOfCallback = new ArrayList<StackTraceElement>(Arrays.asList(Thread.currentThread().getStackTrace()));
            }
            this.mInstanceLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AccessibilityNodeInfo> getFindAccessibilityNodeInfosResultAndClear(int interactionId) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            boolean success = this.waitForResultTimedLocked(interactionId);
            List<AccessibilityNodeInfo> result = success ? this.mFindAccessibilityNodeInfosResult : Collections.emptyList();
            this.clearResultLocked();
            if (_Original_Build.IS_DEBUGGABLE) {
                this.checkFindAccessibilityNodeInfoResultIntegrity(result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RequiresNoPermission
    public void setFindAccessibilityNodeInfosResult(List<AccessibilityNodeInfo> infos, int interactionId) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            if (interactionId > this.mInteractionId) {
                if (infos != null) {
                    boolean isIpcCall;
                    boolean bl = isIpcCall = Binder.getCallingPid() != Process.myPid();
                    this.mFindAccessibilityNodeInfosResult = !isIpcCall ? new ArrayList<AccessibilityNodeInfo>(infos) : infos;
                } else {
                    this.mFindAccessibilityNodeInfosResult = Collections.emptyList();
                }
                this.mInteractionId = interactionId;
                this.mCallingUid = Binder.getCallingUid();
                this.mCallStackOfCallback = new ArrayList<StackTraceElement>(Arrays.asList(Thread.currentThread().getStackTrace()));
            }
            this.mInstanceLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RequiresNoPermission
    public void setPrefetchAccessibilityNodeInfoResult(@NonNull List<AccessibilityNodeInfo> infos, int interactionId) {
        int interactionIdWaitingForPrefetchResultCopy = -1;
        int connectionIdWaitingForPrefetchResultCopy = -1;
        String[] packageNamesForNextPrefetchResultCopy = null;
        if (infos.isEmpty()) {
            return;
        }
        Object object = this.mInstanceLock;
        synchronized (object) {
            if (this.mInteractionIdWaitingForPrefetchResult == interactionId) {
                interactionIdWaitingForPrefetchResultCopy = this.mInteractionIdWaitingForPrefetchResult;
                connectionIdWaitingForPrefetchResultCopy = this.mConnectionIdWaitingForPrefetchResult;
                if (this.mPackageNamesForNextPrefetchResult != null) {
                    packageNamesForNextPrefetchResultCopy = new String[this.mPackageNamesForNextPrefetchResult.length];
                    for (int i = 0; i < this.mPackageNamesForNextPrefetchResult.length; ++i) {
                        packageNamesForNextPrefetchResultCopy[i] = this.mPackageNamesForNextPrefetchResult[i];
                    }
                }
            }
        }
        if (interactionIdWaitingForPrefetchResultCopy == interactionId) {
            this.finalizeAndCacheAccessibilityNodeInfos(infos, connectionIdWaitingForPrefetchResultCopy, false, packageNamesForNextPrefetchResultCopy);
            if (this.shouldTraceCallback()) {
                this.logTrace(AccessibilityInteractionClient.getConnection(connectionIdWaitingForPrefetchResultCopy), "setPrefetchAccessibilityNodeInfoResult", "InteractionId:" + interactionId + ";connectionId=" + connectionIdWaitingForPrefetchResultCopy + ";Result: " + infos, Binder.getCallingUid(), Arrays.asList(Thread.currentThread().getStackTrace()), new HashSet<String>(Collections.singletonList("getStackTrace")), 32L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getPerformAccessibilityActionResultAndClear(int interactionId) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            boolean success = this.waitForResultTimedLocked(interactionId);
            boolean result = success ? this.mPerformAccessibilityActionResult : false;
            this.clearResultLocked();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RequiresNoPermission
    public void setPerformAccessibilityActionResult(boolean succeeded, int interactionId) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            if (interactionId > this.mInteractionId) {
                this.mPerformAccessibilityActionResult = succeeded;
                this.mInteractionId = interactionId;
                this.mCallingUid = Binder.getCallingUid();
                this.mCallStackOfCallback = new ArrayList<StackTraceElement>(Arrays.asList(Thread.currentThread().getStackTrace()));
            }
            this.mInstanceLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendWindowScreenshotSuccess(ScreenCapture.ScreenshotHardwareBuffer screenshot, int interactionId) {
        if (screenshot == null) {
            this.sendTakeScreenshotOfWindowError(1, interactionId);
            return;
        }
        Object object = this.mInstanceLock;
        synchronized (object) {
            if (this.mTakeScreenshotOfWindowCallbacks.contains(interactionId)) {
                AccessibilityService.ScreenshotResult result = new AccessibilityService.ScreenshotResult(screenshot.getHardwareBuffer(), screenshot.getColorSpace(), SystemClock.uptimeMillis());
                Pair<Executor, AccessibilityService.TakeScreenshotCallback> pair = this.mTakeScreenshotOfWindowCallbacks.get(interactionId);
                Executor executor = (Executor)pair.first;
                AccessibilityService.TakeScreenshotCallback callback = (AccessibilityService.TakeScreenshotCallback)pair.second;
                executor.execute(() -> callback.onSuccess(result));
                this.mTakeScreenshotOfWindowCallbacks.remove(interactionId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RequiresNoPermission
    public void sendTakeScreenshotOfWindowError(int errorCode, int interactionId) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            if (this.mTakeScreenshotOfWindowCallbacks.contains(interactionId)) {
                Pair<Executor, AccessibilityService.TakeScreenshotCallback> pair = this.mTakeScreenshotOfWindowCallbacks.get(interactionId);
                Executor executor = (Executor)pair.first;
                AccessibilityService.TakeScreenshotCallback callback = (AccessibilityService.TakeScreenshotCallback)pair.second;
                executor.execute(() -> callback.onFailure(errorCode));
                this.mTakeScreenshotOfWindowCallbacks.remove(interactionId);
            }
        }
    }

    private void clearResultLocked() {
        this.mInteractionId = -1;
        this.mFindAccessibilityNodeInfoResult = null;
        this.mFindAccessibilityNodeInfosResult = null;
        this.mPerformAccessibilityActionResult = false;
    }

    private boolean waitForResultTimedLocked(int interactionId) {
        long waitTimeMillis = 5000L;
        long startTimeMillis = SystemClock.uptimeMillis();
        while (true) {
            try {
                while (true) {
                    Message sameProcessMessage;
                    if ((sameProcessMessage = this.getSameProcessMessageAndClear()) != null) {
                        sameProcessMessage.getTarget().handleMessage(sameProcessMessage);
                    }
                    if (this.mInteractionId == interactionId) {
                        return true;
                    }
                    if (this.mInteractionId > interactionId) {
                        return false;
                    }
                    long elapsedTimeMillis = SystemClock.uptimeMillis() - startTimeMillis;
                    waitTimeMillis = 5000L - elapsedTimeMillis;
                    if (waitTimeMillis <= 0L) {
                        return false;
                    }
                    this.mInstanceLock.wait(waitTimeMillis);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private void finalizeAndCacheAccessibilityNodeInfo(AccessibilityNodeInfo info, int connectionId, boolean bypassCache, String[] packageNames) {
        if (info != null) {
            CharSequence packageName;
            info.setConnectionId(connectionId);
            if (!(ArrayUtils.isEmpty(packageNames) || (packageName = info.getPackageName()) != null && ArrayUtils.contains(packageNames, packageName.toString()))) {
                info.setPackageName(packageNames[0]);
            }
            info.setSealed(true);
            if (!bypassCache) {
                AccessibilityCache cache = AccessibilityInteractionClient.getCache(connectionId);
                if (cache == null) {
                    return;
                }
                cache.add(info);
            }
        }
    }

    private void finalizeAndCacheAccessibilityNodeInfos(List<AccessibilityNodeInfo> infos, int connectionId, boolean bypassCache, String[] packageNames) {
        if (infos != null) {
            int infosCount = infos.size();
            for (int i = 0; i < infosCount; ++i) {
                AccessibilityNodeInfo info = infos.get(i);
                this.finalizeAndCacheAccessibilityNodeInfo(info, connectionId, bypassCache, packageNames);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message getSameProcessMessageAndClear() {
        Object object = this.mInstanceLock;
        synchronized (object) {
            Message result = this.mSameThreadMessage;
            this.mSameThreadMessage = null;
            return result;
        }
    }

    private void checkFindAccessibilityNodeInfoResultIntegrity(List<AccessibilityNodeInfo> infos) {
        if (infos.size() == 0) {
            return;
        }
        AccessibilityNodeInfo root = infos.get(0);
        int infoCount = infos.size();
        block0: for (int i = 1; i < infoCount; ++i) {
            for (int j = i; j < infoCount; ++j) {
                AccessibilityNodeInfo candidate = infos.get(j);
                if (root.getParentNodeId() != candidate.getSourceNodeId()) continue;
                root = candidate;
                continue block0;
            }
        }
        if (root == null) {
            Log.e(LOG_TAG, "No root.");
        }
        HashSet<AccessibilityNodeInfo> seen = new HashSet<AccessibilityNodeInfo>();
        ArrayDeque<AccessibilityNodeInfo> fringe = new ArrayDeque<AccessibilityNodeInfo>();
        fringe.add(root);
        while (!fringe.isEmpty()) {
            AccessibilityNodeInfo current = (AccessibilityNodeInfo)fringe.poll();
            if (!seen.add(current)) {
                Log.e(LOG_TAG, "Duplicate node.");
                return;
            }
            int childCount = current.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                long childId = current.getChildId(i);
                for (int j = 0; j < infoCount; ++j) {
                    AccessibilityNodeInfo child = infos.get(j);
                    if (child.getSourceNodeId() != childId) continue;
                    fringe.add(child);
                }
            }
        }
        int disconnectedCount = infos.size() - seen.size();
        if (disconnectedCount > 0) {
            Log.e(LOG_TAG, disconnectedCount + " Disconnected nodes.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateScrollingWindow(int windowId, long uptimeMillis) {
        SparseLongArray sparseLongArray = sScrollingWindows;
        synchronized (sparseLongArray) {
            sScrollingWindows.put(windowId, uptimeMillis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteScrollingWindow(int windowId) {
        SparseLongArray sparseLongArray = sScrollingWindows;
        synchronized (sparseLongArray) {
            sScrollingWindows.delete(windowId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isWindowScrolling(int windowId) {
        SparseLongArray sparseLongArray = sScrollingWindows;
        synchronized (sparseLongArray) {
            long latestScrollingTime = sScrollingWindows.get(windowId);
            if (latestScrollingTime == 0L) {
                return false;
            }
            long currentUptime = SystemClock.uptimeMillis();
            if (currentUptime > latestScrollingTime + DISABLE_PREFETCHING_FOR_SCROLLING_MILLIS) {
                sScrollingWindows.delete(windowId);
                return false;
            }
        }
        return true;
    }

    private boolean shouldTraceClient() {
        return this.mAccessibilityManager != null && this.mAccessibilityManager.isA11yInteractionClientTraceEnabled();
    }

    private boolean shouldTraceCallback() {
        return this.mAccessibilityManager != null && this.mAccessibilityManager.isA11yInteractionConnectionCBTraceEnabled();
    }

    private void logTrace(IAccessibilityServiceConnection connection, String method, String params, int callingUid, List<StackTraceElement> callStack, HashSet<String> ignoreSet, long logTypes) {
        try {
            Bundle b = new Bundle();
            b.putSerializable(CALL_STACK, new ArrayList<StackTraceElement>(callStack));
            if (ignoreSet != null) {
                b.putSerializable(IGNORE_CALL_STACK, ignoreSet);
            }
            connection.logTrace(SystemClock.elapsedRealtimeNanos(), "AccessibilityInteractionClient." + method, logTypes, params, Process.myPid(), Thread.currentThread().getId(), callingUid, b);
        }
        catch (RemoteException e) {
            Log.e(LOG_TAG, "Failed to log trace. " + e);
        }
    }

    private void logTraceCallback(IAccessibilityServiceConnection connection, String method, String params) {
        this.logTrace(connection, method + " callback", params, this.mCallingUid, this.mCallStackOfCallback, new HashSet<String>(Arrays.asList("getStackTrace")), 32L);
    }

    private void logTraceClient(IAccessibilityServiceConnection connection, String method, String params) {
        this.logTrace(connection, method, params, Binder.getCallingUid(), Arrays.asList(Thread.currentThread().getStackTrace()), new HashSet<String>(Arrays.asList("getStackTrace", "logTraceClient")), 262144L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachAccessibilityOverlayToWindow(int connectionId, int accessibilityWindowId, SurfaceControl sc, @NonNull Executor executor, @NonNull IntConsumer callback) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            try {
                IAccessibilityServiceConnection connection = AccessibilityInteractionClient.getConnection(connectionId);
                if (connection == null) {
                    executor.execute(() -> callback.accept(1));
                    return;
                }
                int interactionId = this.mInteractionIdCounter.getAndIncrement();
                this.mAttachAccessibilityOverlayCallbacks.put(interactionId, Pair.create(executor, callback));
                connection.attachAccessibilityOverlayToWindow(interactionId, accessibilityWindowId, sc, this);
                this.mMainHandler.postDelayed(() -> {
                    Object object = this.mInstanceLock;
                    synchronized (object) {
                        if (this.mAttachAccessibilityOverlayCallbacks.contains(interactionId)) {
                            this.sendAttachOverlayResult(1, interactionId);
                        }
                    }
                }, 5000L);
            }
            catch (RemoteException re) {
                re.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachAccessibilityOverlayToDisplay(int connectionId, int displayId, SurfaceControl sc, @NonNull Executor executor, @NonNull IntConsumer callback) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            try {
                IAccessibilityServiceConnection connection = AccessibilityInteractionClient.getConnection(connectionId);
                if (connection == null) {
                    executor.execute(() -> callback.accept(1));
                    return;
                }
                int interactionId = this.mInteractionIdCounter.getAndIncrement();
                this.mAttachAccessibilityOverlayCallbacks.put(interactionId, Pair.create(executor, callback));
                connection.attachAccessibilityOverlayToDisplay(interactionId, displayId, sc, this);
                this.mMainHandler.postDelayed(() -> {
                    if (this.mAttachAccessibilityOverlayCallbacks.contains(interactionId)) {
                        this.sendAttachOverlayResult(1, interactionId);
                    }
                }, 5000L);
            }
            catch (RemoteException re) {
                re.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RequiresNoPermission
    public void sendAttachOverlayResult(int result, int interactionId) {
        if (!Flags.a11yOverlayCallbacks()) {
            return;
        }
        Object object = this.mInstanceLock;
        synchronized (object) {
            if (this.mAttachAccessibilityOverlayCallbacks.contains(interactionId)) {
                Pair<Executor, IntConsumer> pair = this.mAttachAccessibilityOverlayCallbacks.get(interactionId);
                if (pair == null) {
                    return;
                }
                Executor executor = (Executor)pair.first;
                IntConsumer callback = (IntConsumer)pair.second;
                if (executor == null || callback == null) {
                    return;
                }
                executor.execute(() -> callback.accept(result));
                this.mAttachAccessibilityOverlayCallbacks.remove(interactionId);
            }
        }
    }
}

