/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ComponentName;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Region;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import android.os.StrictMode;
import android.util.Log;
import android.view.Choreographer;
import android.view.CrossWindowBlurListeners;
import android.view.Display;
import android.view.KeyboardShortcutGroup;
import android.view.ScreenRecordingCallbacks;
import android.view.SurfaceControl;
import android.view.SurfaceControlInputReceiver;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewRootImpl;
import android.view.Window;
import android.view.WindowManager;
import android.view.WindowManagerGlobal;
import android.view.WindowManagerImpl;
import android.view.WindowMetrics;
import android.window.ITaskFpsCallback;
import android.window.InputTransferToken;
import android.window.TaskFpsCallback;
import android.window.TrustedPresentationThresholds;
import android.window.WindowMetricsController;
import android.window.WindowProvider;
import android.window.WindowProviderService;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.hidden_from_bootclasspath.com.android.window.flags.Flags;
import com.android.internal.os.IResultReceiver;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.IntConsumer;

public class _Original_WindowManagerImpl
implements WindowManager {
    private static final String TAG = "WindowManager";
    @UnsupportedAppUsage
    private final WindowManagerGlobal mGlobal = WindowManagerGlobal.getInstance();
    @VisibleForTesting
    public final Context mContext;
    private Window mParentWindow;
    private IBinder mDefaultToken;
    @Nullable
    private final IBinder mWindowContextToken;
    @GuardedBy(value={"mOnFpsCallbackListenerProxies"})
    private final ArrayList<WindowManagerImpl.OnFpsCallbackListenerProxy> mOnFpsCallbackListenerProxies = new ArrayList();
    @NonNull
    private final WindowMetricsController mWindowMetricsController;

    public _Original_WindowManagerImpl(Context context) {
        this(context, null, null);
    }

    public _Original_WindowManagerImpl(Context context, Window parentWindow, @Nullable IBinder windowContextToken) {
        this.mContext = context;
        this.mParentWindow = parentWindow;
        this.mWindowContextToken = windowContextToken;
        this.mWindowMetricsController = new WindowMetricsController(this.mContext);
    }

    @Override
    public WindowManager createLocalWindowManager(Window parentWindow) {
        return new _Original_WindowManagerImpl(this.mContext, parentWindow, this.mWindowContextToken);
    }

    public static WindowManager createWindowContextWindowManager(Context context) {
        IBinder clientToken = context.getWindowContextToken();
        return new _Original_WindowManagerImpl(context, null, clientToken);
    }

    public void setDefaultToken(IBinder token) {
        this.mDefaultToken = token;
    }

    @Override
    public void setParentWindow(@NonNull Window parentWindow) {
        this.mParentWindow = parentWindow;
    }

    @Override
    public void addView(@NonNull View view, @NonNull ViewGroup.LayoutParams params) {
        this.applyWindowTypeOverrideIfNeeded(params, view);
        this.applyTokens(params);
        this.mGlobal.addView(view, params, this.mContext.getDisplayNoVerify(), this.mParentWindow, this.mContext.getUserId());
    }

    @Override
    public void updateViewLayout(@NonNull View view, @NonNull ViewGroup.LayoutParams params) {
        this.applyWindowTypeOverrideIfNeeded(params, view);
        this.applyTokens(params);
        this.mGlobal.updateViewLayout(view, params);
    }

    private void applyTokens(@NonNull ViewGroup.LayoutParams params) {
        if (!(params instanceof WindowManager.LayoutParams)) {
            throw new IllegalArgumentException("Params must be WindowManager.LayoutParams");
        }
        WindowManager.LayoutParams wparams = (WindowManager.LayoutParams)params;
        this.assertWindowContextTypeMatches(wparams.type);
        if (this.mDefaultToken != null && this.mParentWindow == null && wparams.token == null) {
            wparams.token = this.mDefaultToken;
        }
        wparams.mWindowContextToken = this.mWindowContextToken;
    }

    private void assertWindowContextTypeMatches(int windowType) {
        Context context = this.mContext;
        if (!(context instanceof WindowProvider)) {
            return;
        }
        WindowProvider windowProvider = (WindowProvider)((Object)context);
        if (windowProvider.isValidWindowType(windowType)) {
            return;
        }
        IllegalArgumentException exception = new IllegalArgumentException("Window type mismatch. Window Context's window type is " + windowProvider.getWindowType() + ", while LayoutParams' type is set to " + windowType + ". Please create another Window Context via createWindowContext(getDisplay(), " + windowType + ", null) to add window with type:" + windowType);
        if (!WindowProviderService.isWindowProviderService(windowProvider.getWindowContextOptions())) {
            throw exception;
        }
        StrictMode.onIncorrectContextUsed("WindowContext's window type must match type in WindowManager.LayoutParams", exception);
    }

    private void applyWindowTypeOverrideIfNeeded(@NonNull ViewGroup.LayoutParams params, @NonNull View view) {
        if (!Flags.enableWindowContextOverrideType()) {
            return;
        }
        if (!(params instanceof WindowManager.LayoutParams)) {
            throw new IllegalArgumentException("Params must be WindowManager.LayoutParams");
        }
        WindowManager.LayoutParams wparams = (WindowManager.LayoutParams)params;
        Context context = this.mContext;
        if (!(context instanceof WindowProvider)) {
            return;
        }
        WindowProvider windowProvider = (WindowProvider)((Object)context);
        int windowTypeOverride = windowProvider.getWindowTypeOverride();
        if (windowTypeOverride == -1) {
            return;
        }
        if (!this.mGlobal.canApplyWindowTypeOverride(windowTypeOverride, view)) {
            return;
        }
        if (WindowManager.LayoutParams.isSubWindowType(windowTypeOverride) && this.mParentWindow == null) {
            throw new IllegalArgumentException("Sub-window must be attached to the parent window. Please try to obtain WindowManager from a window class, call WindowContext#attachWindow before adding any sub-windows.");
        }
        wparams.type = windowTypeOverride;
    }

    @Override
    public void removeView(View view) {
        this.mGlobal.removeView(view, false);
    }

    @Override
    public void removeViewImmediate(View view) {
        this.mGlobal.removeView(view, true);
    }

    @Override
    public void requestAppKeyboardShortcuts(final WindowManager.KeyboardShortcutsReceiver receiver, int deviceId) {
        IResultReceiver.Stub resultReceiver = new IResultReceiver.Stub(this){

            @Override
            public void send(int resultCode, Bundle resultData) throws RemoteException {
                ArrayList<KeyboardShortcutGroup> result = resultData.getParcelableArrayList("shortcuts_array", KeyboardShortcutGroup.class);
                receiver.onKeyboardShortcutsReceived(result);
            }
        };
        try {
            WindowManagerGlobal.getWindowManagerService().requestAppKeyboardShortcuts(resultReceiver, deviceId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public KeyboardShortcutGroup getApplicationLaunchKeyboardShortcuts(int deviceId) {
        try {
            return WindowManagerGlobal.getWindowManagerService().getApplicationLaunchKeyboardShortcuts(deviceId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public void requestImeKeyboardShortcuts(final WindowManager.KeyboardShortcutsReceiver receiver, int deviceId) {
        IResultReceiver.Stub resultReceiver = new IResultReceiver.Stub(this){

            @Override
            public void send(int resultCode, Bundle resultData) throws RemoteException {
                ArrayList<KeyboardShortcutGroup> result = resultData.getParcelableArrayList("shortcuts_array", KeyboardShortcutGroup.class);
                receiver.onKeyboardShortcutsReceived(result);
            }
        };
        try {
            WindowManagerGlobal.getWindowManagerService().requestImeKeyboardShortcuts(resultReceiver, deviceId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public Display getDefaultDisplay() {
        return this.mContext.getDisplayNoVerify();
    }

    @Override
    public Region getCurrentImeTouchRegion() {
        try {
            return WindowManagerGlobal.getWindowManagerService().getCurrentImeTouchRegion();
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    @Override
    public void setShouldShowWithInsecureKeyguard(int displayId, boolean shouldShow) {
        try {
            WindowManagerGlobal.getWindowManagerService().setShouldShowWithInsecureKeyguard(displayId, shouldShow);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void setShouldShowSystemDecors(int displayId, boolean shouldShow) {
        try {
            WindowManagerGlobal.getWindowManagerService().setShouldShowSystemDecors(displayId, shouldShow);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public boolean shouldShowSystemDecors(int displayId) {
        try {
            return WindowManagerGlobal.getWindowManagerService().shouldShowSystemDecors(displayId);
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    @Override
    public boolean isEligibleForDesktopMode(int displayId) {
        try {
            return WindowManagerGlobal.getWindowManagerService().isEligibleForDesktopMode(displayId);
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    @Override
    public void setDisplayImePolicy(int displayId, int imePolicy) {
        try {
            WindowManagerGlobal.getWindowManagerService().setDisplayImePolicy(displayId, imePolicy);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public int getDisplayImePolicy(int displayId) {
        try {
            return WindowManagerGlobal.getWindowManagerService().getDisplayImePolicy(displayId);
        }
        catch (RemoteException remoteException) {
            return 1;
        }
    }

    @Override
    public boolean isGlobalKey(int keyCode) {
        try {
            return WindowManagerGlobal.getWindowManagerService().isGlobalKey(keyCode);
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    @Override
    public WindowMetrics getCurrentWindowMetrics() {
        return this.mWindowMetricsController.getCurrentWindowMetrics();
    }

    @Override
    public WindowMetrics getMaximumWindowMetrics() {
        return this.mWindowMetricsController.getMaximumWindowMetrics();
    }

    @Override
    @NonNull
    public Set<WindowMetrics> getPossibleMaximumWindowMetrics(int displayId) {
        return this.mWindowMetricsController.getPossibleMaximumWindowMetrics(displayId);
    }

    @Override
    public void holdLock(IBinder token, int durationMs) {
        try {
            WindowManagerGlobal.getWindowManagerService().holdLock(token, durationMs);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public boolean isCrossWindowBlurEnabled() {
        return CrossWindowBlurListeners.getInstance().isCrossWindowBlurEnabled();
    }

    @Override
    public void addCrossWindowBlurEnabledListener(@NonNull Consumer<Boolean> listener) {
        this.addCrossWindowBlurEnabledListener(this.mContext.getMainExecutor(), listener);
    }

    @Override
    public void addCrossWindowBlurEnabledListener(@NonNull Executor executor, @NonNull Consumer<Boolean> listener) {
        CrossWindowBlurListeners.getInstance().addListener(executor, listener);
    }

    @Override
    public void removeCrossWindowBlurEnabledListener(@NonNull Consumer<Boolean> listener) {
        CrossWindowBlurListeners.getInstance().removeListener(listener);
    }

    @Override
    public void addProposedRotationListener(@NonNull Executor executor, @NonNull IntConsumer listener) {
        Objects.requireNonNull(executor, "executor must not be null");
        Objects.requireNonNull(listener, "listener must not be null");
        IBinder contextToken = Context.getToken(this.mContext);
        if (contextToken == null) {
            throw new UnsupportedOperationException("The context of this window manager instance must be a UI context, e.g. an Activity or a Context created by Context#createWindowContext()");
        }
        this.mGlobal.registerProposedRotationListener(contextToken, executor, listener);
    }

    @Override
    public void removeProposedRotationListener(@NonNull IntConsumer listener) {
        this.mGlobal.unregisterProposedRotationListener(Context.getToken(this.mContext), listener);
    }

    @Override
    public boolean isTaskSnapshotSupported() {
        try {
            return WindowManagerGlobal.getWindowManagerService().isTaskSnapshotSupported();
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerTaskFpsCallback(int taskId, @NonNull Executor executor, TaskFpsCallback callback) {
        OnFpsCallbackListenerProxy onFpsCallbackListenerProxy = new OnFpsCallbackListenerProxy(executor, callback);
        try {
            WindowManagerGlobal.getWindowManagerService().registerTaskFpsCallback(taskId, onFpsCallbackListenerProxy);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        ArrayList<WindowManagerImpl.OnFpsCallbackListenerProxy> arrayList = this.mOnFpsCallbackListenerProxies;
        synchronized (arrayList) {
            this.mOnFpsCallbackListenerProxies.add((WindowManagerImpl.OnFpsCallbackListenerProxy)onFpsCallbackListenerProxy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterTaskFpsCallback(TaskFpsCallback callback) {
        ArrayList<WindowManagerImpl.OnFpsCallbackListenerProxy> arrayList = this.mOnFpsCallbackListenerProxies;
        synchronized (arrayList) {
            Iterator<WindowManagerImpl.OnFpsCallbackListenerProxy> iterator = this.mOnFpsCallbackListenerProxies.iterator();
            while (iterator.hasNext()) {
                OnFpsCallbackListenerProxy proxy = (OnFpsCallbackListenerProxy)iterator.next();
                if (proxy.mCallback != callback) continue;
                try {
                    WindowManagerGlobal.getWindowManagerService().unregisterTaskFpsCallback(proxy);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
                iterator.remove();
            }
        }
    }

    @Override
    public Bitmap snapshotTaskForRecents(int taskId) {
        try {
            return WindowManagerGlobal.getWindowManagerService().snapshotTaskForRecents(taskId);
        }
        catch (RemoteException e) {
            e.rethrowAsRuntimeException();
            return null;
        }
    }

    @Override
    @NonNull
    public IBinder getDefaultToken() {
        return this.mDefaultToken;
    }

    @Override
    @NonNull
    public List<ComponentName> notifyScreenshotListeners(int displayId) {
        try {
            return List.copyOf(WindowManagerGlobal.getWindowManagerService().notifyScreenshotListeners(displayId));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public boolean replaceContentOnDisplayWithMirror(int displayId, @NonNull Window window) {
        View decorView = window.peekDecorView();
        if (decorView == null) {
            Log.e(TAG, "replaceContentOnDisplayWithMirror: Window's decorView was null.");
            return false;
        }
        ViewRootImpl viewRoot = decorView.getViewRootImpl();
        if (viewRoot == null) {
            Log.e(TAG, "replaceContentOnDisplayWithMirror: Window's viewRootImpl was null.");
            return false;
        }
        SurfaceControl sc = viewRoot.getSurfaceControl();
        if (!sc.isValid()) {
            Log.e(TAG, "replaceContentOnDisplayWithMirror: Window's SC is invalid.");
            return false;
        }
        return this.replaceContentOnDisplayWithSc(displayId, SurfaceControl.mirrorSurface(sc));
    }

    @Override
    public boolean replaceContentOnDisplayWithSc(int displayId, @NonNull SurfaceControl sc) {
        if (!sc.isValid()) {
            Log.e(TAG, "replaceContentOnDisplayWithSc: Invalid SC.");
            return false;
        }
        try {
            return WindowManagerGlobal.getWindowManagerService().replaceContentOnDisplay(displayId, sc);
        }
        catch (RemoteException e) {
            e.rethrowAsRuntimeException();
            return false;
        }
    }

    @Override
    public void registerTrustedPresentationListener(@NonNull IBinder window, @NonNull TrustedPresentationThresholds thresholds, @NonNull Executor executor, @NonNull Consumer<Boolean> listener) {
        Objects.requireNonNull(window, "window must not be null");
        Objects.requireNonNull(thresholds, "thresholds must not be null");
        Objects.requireNonNull(executor, "executor must not be null");
        Objects.requireNonNull(listener, "listener must not be null");
        this.mGlobal.registerTrustedPresentationListener(window, thresholds, executor, listener);
    }

    @Override
    public void unregisterTrustedPresentationListener(@NonNull Consumer<Boolean> listener) {
        Objects.requireNonNull(listener, "listener must not be null");
        this.mGlobal.unregisterTrustedPresentationListener(listener);
    }

    @Override
    @NonNull
    public InputTransferToken registerBatchedSurfaceControlInputReceiver(@NonNull InputTransferToken hostInputTransferToken, @NonNull SurfaceControl surfaceControl, @NonNull Choreographer choreographer, @NonNull SurfaceControlInputReceiver receiver) {
        Objects.requireNonNull(hostInputTransferToken);
        Objects.requireNonNull(surfaceControl);
        Objects.requireNonNull(choreographer);
        Objects.requireNonNull(receiver);
        return this.mGlobal.registerBatchedSurfaceControlInputReceiver(hostInputTransferToken, surfaceControl, choreographer, receiver);
    }

    @Override
    @NonNull
    public InputTransferToken registerUnbatchedSurfaceControlInputReceiver(@NonNull InputTransferToken hostInputTransferToken, @NonNull SurfaceControl surfaceControl, @NonNull Looper looper, @NonNull SurfaceControlInputReceiver receiver) {
        Objects.requireNonNull(hostInputTransferToken);
        Objects.requireNonNull(surfaceControl);
        Objects.requireNonNull(looper);
        Objects.requireNonNull(receiver);
        return this.mGlobal.registerUnbatchedSurfaceControlInputReceiver(hostInputTransferToken, surfaceControl, looper, receiver);
    }

    @Override
    public void unregisterSurfaceControlInputReceiver(@NonNull SurfaceControl surfaceControl) {
        Objects.requireNonNull(surfaceControl);
        this.mGlobal.unregisterSurfaceControlInputReceiver(surfaceControl);
    }

    @Override
    @Nullable
    public IBinder getSurfaceControlInputClientToken(@NonNull SurfaceControl surfaceControl) {
        Objects.requireNonNull(surfaceControl);
        return this.mGlobal.getSurfaceControlInputClientToken(surfaceControl);
    }

    @Override
    public boolean transferTouchGesture(@NonNull InputTransferToken transferFromToken, @NonNull InputTransferToken transferToToken) {
        Objects.requireNonNull(transferFromToken);
        Objects.requireNonNull(transferToToken);
        return this.mGlobal.transferTouchGesture(transferFromToken, transferToToken);
    }

    @Override
    public int addScreenRecordingCallback(@NonNull Executor executor, @NonNull Consumer<Integer> callback) {
        if (Flags.screenRecordingCallbacks()) {
            Objects.requireNonNull(executor, "executor must not be null");
            Objects.requireNonNull(callback, "callback must not be null");
            return ScreenRecordingCallbacks.getInstance().addCallback(executor, callback);
        }
        return 0;
    }

    @Override
    public void removeScreenRecordingCallback(@NonNull Consumer<Integer> callback) {
        if (Flags.screenRecordingCallbacks()) {
            Objects.requireNonNull(callback, "callback must not be null");
            ScreenRecordingCallbacks.getInstance().removeCallback(callback);
        }
    }

    private static class OnFpsCallbackListenerProxy
    extends ITaskFpsCallback.Stub {
        private final Executor mExecutor;
        private final TaskFpsCallback mCallback;

        private OnFpsCallbackListenerProxy(Executor executor, TaskFpsCallback callback) {
            this.mExecutor = executor;
            this.mCallback = callback;
        }

        @Override
        public void onFpsReported(float fps) {
            this.mExecutor.execute(() -> ((WindowManagerImpl.OnFpsCallbackListenerProxy)this).lambda$onFpsReported$0((float)fps));
        }

        private /* synthetic */ void lambda$onFpsReported$0(float fps) {
            this.mCallback.onFpsReported(fps);
        }
    }
}

