/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.ClipData;
import android.content.res.Configuration;
import android.graphics.PixelFormat;
import android.graphics.Rect;
import android.graphics.Region;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteCallback;
import android.os.RemoteException;
import android.util.Log;
import android.util.MergedConfiguration;
import android.view.ISurfaceControlViewHostParent;
import android.view.IWindow;
import android.view.IWindowId;
import android.view.IWindowSession;
import android.view.InputChannel;
import android.view.InsetsSourceControl;
import android.view.InsetsState;
import android.view.KeyEvent;
import android.view.SurfaceControl;
import android.view.View;
import android.view.ViewRootImpl;
import android.view.WindowInsets;
import android.view.WindowManager;
import android.view.WindowManagerGlobal;
import android.view.WindowRelayoutResult;
import android.view.WindowlessWindowLayout;
import android.view.inputmethod.ImeTracker;
import android.window.ClientWindowFrames;
import android.window.InputTransferToken;
import android.window.OnBackInvokedCallbackInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

public class WindowlessWindowManager
implements IWindowSession {
    private static final String TAG = "WindowlessWindowManager";
    final HashMap<IBinder, State> mStateForWindow = new HashMap();
    final HashMap<IBinder, ResizeCompleteCallback> mResizeCompletionForWindow = new HashMap();
    protected final SurfaceControl mRootSurface;
    private final Configuration mConfiguration;
    private final IWindowSession mRealWm;
    private InputTransferToken mHostInputTransferToken;
    private final InputTransferToken mInputTransferToken = new InputTransferToken();
    private InsetsState mInsetsState;
    private final ClientWindowFrames mTmpFrames = new ClientWindowFrames();
    private final MergedConfiguration mTmpConfig = new MergedConfiguration();
    private final WindowlessWindowLayout mLayout = new WindowlessWindowLayout();
    private ISurfaceControlViewHostParent mParentInterface;

    public WindowlessWindowManager(Configuration c, SurfaceControl rootSurface, InputTransferToken hostInputTransferToken) {
        this.mRootSurface = rootSurface;
        this.mConfiguration = new Configuration(c);
        this.mRealWm = WindowManagerGlobal.getWindowSession();
        this.mHostInputTransferToken = hostInputTransferToken;
    }

    public void setConfiguration(Configuration configuration) {
        this.mConfiguration.setTo(configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InputTransferToken getInputTransferToken(IBinder window) {
        WindowlessWindowManager windowlessWindowManager = this;
        synchronized (windowlessWindowManager) {
            if (this.mStateForWindow.isEmpty()) {
                return this.mInputTransferToken;
            }
            State state = this.mStateForWindow.get(window);
            if (state != null) {
                return state.mInputTransferToken;
            }
        }
        Log.w(TAG, "Failed to get focusGrantToken. Returning null token");
        return null;
    }

    void setHostInputTransferToken(InputTransferToken token) {
        this.mHostInputTransferToken = token;
    }

    InputTransferToken getHostInputTransferToken() {
        return this.mHostInputTransferToken;
    }

    void setCompletionCallback(IBinder window, ResizeCompleteCallback callback) {
        if (this.mResizeCompletionForWindow.get(window) != null) {
            Log.w(TAG, "Unsupported overlapping resizes");
        }
        this.mResizeCompletionForWindow.put(window, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setTouchRegion(IBinder window, @Nullable Region region) {
        WindowlessWindowManager windowlessWindowManager = this;
        synchronized (windowlessWindowManager) {
            State state = this.mStateForWindow.get(window);
            if (state == null) {
                return;
            }
            if (Objects.equals(region, state.mInputRegion)) {
                return;
            }
            state.mInputRegion = region != null ? new Region(region) : null;
            this.updateInputChannel(window);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateInputChannel(IBinder window) {
        WindowlessWindowManager windowlessWindowManager = this;
        synchronized (windowlessWindowManager) {
            State state = this.mStateForWindow.get(window);
            if (state == null) {
                return;
            }
            if (state.mInputChannelToken != null) {
                try {
                    this.mRealWm.updateInputChannel(state.mInputChannelToken, this.mHostInputTransferToken, state.mDisplayId, state.mSurfaceControl, state.mParams.flags, state.mParams.privateFlags, state.mParams.inputFeatures, state.mInputRegion);
                }
                catch (RemoteException e) {
                    Log.e(TAG, "Failed to update surface input channel: ", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SurfaceControl getParentSurface(IWindow window, WindowManager.LayoutParams attrs) {
        WindowlessWindowManager windowlessWindowManager = this;
        synchronized (windowlessWindowManager) {
            if (this.mStateForWindow.isEmpty()) {
                return this.mRootSurface;
            }
            return this.mStateForWindow.get((Object)attrs.token).mLeash;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int addToDisplay(IWindow window, WindowManager.LayoutParams attrs, int viewVisibility, int displayId, int requestedVisibleTypes, InputChannel outInputChannel, WindowRelayoutResult result) {
        SurfaceControl leash = new SurfaceControl.Builder().setName(attrs.getTitle().toString() + "Leash").setCallsite("WindowlessWindowManager.addToDisplay").setParent(this.getParentSurface(window, attrs)).build();
        SurfaceControl sc = new SurfaceControl.Builder().setFormat(attrs.format).setBLASTLayer().setName(attrs.getTitle().toString()).setCallsite("WindowlessWindowManager.addToDisplay").setHidden(false).setParent(leash).build();
        State state = new State(this, sc, attrs, displayId, window, leash, new Rect());
        WindowlessWindowManager windowlessWindowManager = this;
        synchronized (windowlessWindowManager) {
            State parentState = this.mStateForWindow.get(attrs.token);
            if (parentState != null) {
                state.mAttachedFrame = parentState.mFrame;
            }
            state.mInputTransferToken = this.mStateForWindow.isEmpty() ? this.mInputTransferToken : new InputTransferToken();
            this.mStateForWindow.put(window.asBinder(), state);
        }
        result.frames.attachedFrame = state.mAttachedFrame == null ? null : new Rect(state.mAttachedFrame);
        result.frames.compatScale = 1.0f;
        if ((attrs.inputFeatures & 1) == 0) {
            try {
                if (this.mRealWm instanceof IWindowSession.Stub) {
                    this.mRealWm.grantInputChannel(displayId, new SurfaceControl(sc, "WindowlessWindowManager.addToDisplay"), window.asBinder(), this.mHostInputTransferToken, attrs.flags, attrs.privateFlags, attrs.inputFeatures, attrs.type, attrs.token, state.mInputTransferToken, attrs.getTitle().toString(), outInputChannel);
                } else {
                    this.mRealWm.grantInputChannel(displayId, sc, window.asBinder(), this.mHostInputTransferToken, attrs.flags, attrs.privateFlags, attrs.inputFeatures, attrs.type, attrs.token, state.mInputTransferToken, attrs.getTitle().toString(), outInputChannel);
                }
                state.mInputChannelToken = outInputChannel != null ? outInputChannel.getToken() : null;
            }
            catch (RemoteException e) {
                Log.e(TAG, "Failed to grant input to surface: ", e);
            }
        }
        int res = 2;
        this.sendLayoutParamsToParent();
        return this.isInTouchModeInternal(displayId) ? 3 : 2;
    }

    @Override
    public int addToDisplayAsUser(IWindow window, WindowManager.LayoutParams attrs, int viewVisibility, int displayId, int userId, int requestedVisibleTypes, InputChannel outInputChannel, WindowRelayoutResult result) {
        return this.addToDisplay(window, attrs, viewVisibility, displayId, requestedVisibleTypes, outInputChannel, result);
    }

    @Override
    public int addToDisplayWithoutInputChannel(IWindow window, WindowManager.LayoutParams attrs, int viewVisibility, int layerStackId, WindowRelayoutResult result) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(IBinder clientToken) throws RemoteException {
        State state;
        this.mRealWm.remove(clientToken);
        WindowlessWindowManager windowlessWindowManager = this;
        synchronized (windowlessWindowManager) {
            state = this.mStateForWindow.remove(clientToken);
        }
        if (state == null) {
            throw new IllegalArgumentException("Invalid window token (never added or removed already)");
        }
        this.removeSurface(state.mSurfaceControl);
        this.removeSurface(state.mLeash);
    }

    protected void removeSurface(SurfaceControl sc) {
        try (SurfaceControl.Transaction t = new SurfaceControl.Transaction();){
            t.remove(sc).apply();
        }
    }

    private boolean isOpaque(WindowManager.LayoutParams attrs) {
        if (attrs.surfaceInsets != null && attrs.surfaceInsets.left != 0 || attrs.surfaceInsets.top != 0 || attrs.surfaceInsets.right != 0 || attrs.surfaceInsets.bottom != 0) {
            return false;
        }
        return !PixelFormat.formatHasAlpha(attrs.format);
    }

    private boolean isInTouchModeInternal(int displayId) {
        try {
            return WindowManagerGlobal.getWindowManagerService().isInTouchMode(displayId);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Unable to check if the window is in touch mode", e);
            return false;
        }
    }

    protected IBinder getWindowBinder(View rootView) {
        ViewRootImpl root = rootView.getViewRootImpl();
        if (root == null) {
            return null;
        }
        return root.mWindow.asBinder();
    }

    @Nullable
    protected SurfaceControl getSurfaceControl(View rootView) {
        ViewRootImpl root = rootView.getViewRootImpl();
        if (root == null) {
            return null;
        }
        return this.getSurfaceControl(root.mWindow);
    }

    @Nullable
    protected SurfaceControl getSurfaceControl(IWindow window) {
        State s = this.mStateForWindow.get(window.asBinder());
        if (s == null) {
            return null;
        }
        return s.mSurfaceControl;
    }

    @Override
    public int relayout(IWindow window, WindowManager.LayoutParams inAttrs, int requestedWidth, int requestedHeight, int viewFlags, int flags, int seq, int lastSyncSeqId, WindowRelayoutResult outRelayoutResult, SurfaceControl outSurface) {
        InsetsSourceControl.Array outActiveControls;
        InsetsState outInsetsState;
        MergedConfiguration outMergedConfiguration;
        ClientWindowFrames outFrames;
        SurfaceControl outSurfaceControl = outSurface;
        if (outRelayoutResult != null) {
            outFrames = outRelayoutResult.frames;
            outMergedConfiguration = outRelayoutResult.mergedConfiguration;
            outInsetsState = outRelayoutResult.insetsState;
            outActiveControls = outRelayoutResult.activeControls;
        } else {
            outFrames = null;
            outMergedConfiguration = null;
            outInsetsState = null;
            outActiveControls = null;
        }
        return this.relayoutInner(window, inAttrs, requestedWidth, requestedHeight, viewFlags, flags, seq, lastSyncSeqId, outFrames, outMergedConfiguration, outSurfaceControl, outInsetsState, outActiveControls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int relayoutInner(IWindow window, WindowManager.LayoutParams inAttrs, int requestedWidth, int requestedHeight, int viewFlags, int flags, int seq, int lastSyncSeqId, ClientWindowFrames outFrames, MergedConfiguration outMergedConfiguration, SurfaceControl outSurfaceControl, InsetsState outInsetsState, InsetsSourceControl.Array outActiveControls) {
        State state;
        WindowlessWindowManager windowlessWindowManager = this;
        synchronized (windowlessWindowManager) {
            state = this.mStateForWindow.get(window.asBinder());
        }
        if (state == null) {
            throw new IllegalArgumentException("Invalid window token (never added or removed already)");
        }
        SurfaceControl sc = state.mSurfaceControl;
        SurfaceControl leash = state.mLeash;
        SurfaceControl.Transaction t = new SurfaceControl.Transaction();
        int attrChanges = 0;
        if (inAttrs != null) {
            attrChanges = state.mParams.copyFrom(inAttrs);
        }
        WindowManager.LayoutParams attrs = state.mParams;
        ClientWindowFrames frames = new ClientWindowFrames();
        frames.attachedFrame = state.mAttachedFrame;
        this.mLayout.computeFrames(attrs, null, null, null, 0, requestedWidth, requestedHeight, 0, 0.0f, frames);
        state.mFrame.set(frames.frame);
        if (outFrames != null) {
            outFrames.frame.set(frames.frame);
            outFrames.parentFrame.set(frames.parentFrame);
            outFrames.displayFrame.set(frames.displayFrame);
        }
        t.setPosition(leash, frames.frame.left, frames.frame.top);
        if (viewFlags == 0) {
            t.setOpaque(sc, this.isOpaque(attrs)).show(leash).apply();
            if (outSurfaceControl != null) {
                outSurfaceControl.copyFrom(sc, "WindowlessWindowManager.relayout");
            }
        } else {
            t.hide(leash).apply();
            if (outSurfaceControl != null) {
                outSurfaceControl.release();
            }
        }
        if (outMergedConfiguration != null) {
            outMergedConfiguration.setConfiguration(this.mConfiguration, this.mConfiguration);
        }
        int inputChangeMask = 65540;
        if ((attrChanges & 0x10004) != 0 && state.mInputChannelToken != null) {
            try {
                if (this.mRealWm instanceof IWindowSession.Stub) {
                    this.mRealWm.updateInputChannel(state.mInputChannelToken, this.mHostInputTransferToken, state.mDisplayId, new SurfaceControl(sc, "WindowlessWindowManager.relayout"), attrs.flags, attrs.privateFlags, attrs.inputFeatures, state.mInputRegion);
                } else {
                    this.mRealWm.updateInputChannel(state.mInputChannelToken, this.mHostInputTransferToken, state.mDisplayId, sc, attrs.flags, attrs.privateFlags, attrs.inputFeatures, state.mInputRegion);
                }
            }
            catch (RemoteException e) {
                Log.e(TAG, "Failed to update surface input channel: ", e);
            }
        }
        if (outInsetsState != null && this.mInsetsState != null) {
            outInsetsState.set(this.mInsetsState);
        }
        this.sendLayoutParamsToParent();
        return 0;
    }

    @Override
    public void relayoutAsync(IWindow window, WindowManager.LayoutParams inAttrs, int requestedWidth, int requestedHeight, int viewFlags, int flags, int seq, int lastSyncSeqId) {
        this.relayoutInner(window, inAttrs, requestedWidth, requestedHeight, viewFlags, flags, seq, lastSyncSeqId, null, null, null, null, null);
    }

    @Override
    public boolean outOfMemory(IWindow window) {
        return false;
    }

    @Override
    public void setInsets(IWindow window, int touchableInsets, Rect contentInsets, Rect visibleInsets, Region touchableRegion) {
        this.setTouchRegion(window.asBinder(), touchableRegion);
    }

    @Override
    public void clearTouchableRegion(IWindow window) {
        this.setTouchRegion(window.asBinder(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishDrawing(IWindow window, SurfaceControl.Transaction postDrawTransaction, int seqId) {
        WindowlessWindowManager windowlessWindowManager = this;
        synchronized (windowlessWindowManager) {
            ResizeCompleteCallback c = this.mResizeCompletionForWindow.get(window.asBinder());
            if (c == null) {
                postDrawTransaction.apply();
                return;
            }
            c.finished(postDrawTransaction);
            this.mResizeCompletionForWindow.remove(window.asBinder());
        }
    }

    @Override
    public IBinder performDrag(IWindow window, int flags, SurfaceControl surface, int touchSource, int touchDeviceId, int touchPointerId, float touchX, float touchY, float thumbCenterX, float thumbCenterY, ClipData data) {
        return null;
    }

    @Override
    public void reportDropResult(IWindow window, boolean consumed) {
    }

    @Override
    public void cancelDragAndDrop(IBinder dragToken, boolean skipAnimation) {
    }

    @Override
    public void dragRecipientEntered(IWindow window) {
    }

    @Override
    public void dragRecipientExited(IWindow window) {
    }

    @Override
    public void setWallpaperPosition(IBinder windowToken, float x, float y, float xstep, float ystep) {
    }

    @Override
    public void setWallpaperZoomOut(IBinder windowToken, float zoom) {
    }

    @Override
    public void setShouldZoomOutWallpaper(IBinder windowToken, boolean shouldZoom) {
    }

    @Override
    public void wallpaperOffsetsComplete(IBinder window) {
    }

    @Override
    public void setWallpaperDisplayOffset(IBinder windowToken, int x, int y) {
    }

    @Override
    public void sendWallpaperCommand(IBinder window, String action, int x, int y, int z, Bundle extras, boolean sync) {
    }

    @Override
    public void wallpaperCommandComplete(IBinder window, Bundle result) {
    }

    @Override
    public void onRectangleOnScreenRequested(IBinder token, Rect rectangle, int source) {
    }

    @Override
    public IWindowId getWindowId(IBinder window) {
        return null;
    }

    @Override
    public void pokeDrawLock(IBinder window) {
    }

    @Override
    public boolean startMovingTask(IWindow window, float startX, float startY) {
        return false;
    }

    @Override
    public void finishMovingTask(IWindow window) {
    }

    @Override
    public void updateTapExcludeRegion(IWindow window, Region region) {
    }

    @Override
    public void updateRequestedVisibleTypes(IWindow window, int requestedVisibleTypes, @Nullable ImeTracker.Token imeStatsToken) throws RemoteException {
        this.mRealWm.updateRequestedVisibleTypes(window, requestedVisibleTypes & WindowInsets.Type.ime(), imeStatsToken);
    }

    @Override
    public void updateAnimatingTypes(IWindow window, int animatingTypes, @Nullable ImeTracker.Token statsToken) {
    }

    @Override
    public void reportSystemGestureExclusionChanged(IWindow window, List<Rect> exclusionRects) {
    }

    @Override
    public void reportDecorViewGestureInterceptionChanged(IWindow window, boolean intercepted) {
    }

    @Override
    public void reportKeepClearAreasChanged(IWindow window, List<Rect> restrictedRects, List<Rect> unrestrictedRects) {
    }

    @Override
    public void grantInputChannel(int displayId, SurfaceControl surface, IBinder clientToken, InputTransferToken hostInputToken, int flags, int privateFlags, int inputFeatures, int type, IBinder windowToken, InputTransferToken embeddedInputTransferToken, String inputHandleName, InputChannel outInputChannel) {
    }

    @Override
    public void updateInputChannel(IBinder channelToken, InputTransferToken hostInputToken, int displayId, SurfaceControl surface, int flags, int privateFlags, int inputFeatures, Region region) {
    }

    @Override
    public IBinder asBinder() {
        return null;
    }

    @Override
    public void grantEmbeddedWindowFocus(IWindow callingWindow, InputTransferToken targetInputToken, boolean grantFocus) {
    }

    @Override
    public void generateDisplayHash(IWindow window, Rect boundsInWindow, String hashAlgorithm, RemoteCallback callback) {
    }

    @Override
    public void setOnBackInvokedCallbackInfo(IWindow iWindow, OnBackInvokedCallbackInfo callbackInfo) throws RemoteException {
    }

    @Override
    public boolean dropForAccessibility(IWindow window, int x, int y) {
        return false;
    }

    public void setInsetsState(InsetsState state) {
        this.mInsetsState = state;
        for (State s : this.mStateForWindow.values()) {
            try {
                this.mTmpFrames.frame.set(0, 0, s.mParams.width, s.mParams.height);
                this.mTmpFrames.displayFrame.set(this.mTmpFrames.frame);
                this.mTmpConfig.setConfiguration(this.mConfiguration, this.mConfiguration);
                WindowRelayoutResult layout2 = new WindowRelayoutResult(this.mTmpFrames, this.mTmpConfig, state, null);
                layout2.syncSeqId = Integer.MAX_VALUE;
                s.mClient.resized(layout2, false, false, s.mDisplayId, false, false);
            }
            catch (RemoteException remoteException) {}
        }
    }

    @Override
    public boolean cancelDraw(IWindow window, int seqId) {
        return false;
    }

    @Override
    public boolean moveFocusToAdjacentWindow(IWindow fromWindow, int direction) {
        Log.e(TAG, "Received request to moveFocusToAdjacentWindow on WindowlessWindowManager. We shouldn't get here!");
        return false;
    }

    @Override
    public void notifyImeWindowVisibilityChangedFromClient(IWindow window, boolean visible, @NonNull ImeTracker.Token statsToken) {
    }

    void setParentInterface(@Nullable ISurfaceControlViewHostParent parentInterface) {
        IBinder newInterface;
        IBinder oldInterface = this.mParentInterface == null ? null : this.mParentInterface.asBinder();
        IBinder iBinder = newInterface = parentInterface == null ? null : parentInterface.asBinder();
        if (oldInterface != newInterface) {
            this.clearLastReportedParams();
        }
        this.mParentInterface = parentInterface;
        this.sendLayoutParamsToParent();
    }

    private void clearLastReportedParams() {
        WindowManager.LayoutParams emptyParam = new WindowManager.LayoutParams();
        for (State windowInfo : this.mStateForWindow.values()) {
            windowInfo.mLastReportedParams.copyFrom(emptyParam);
        }
    }

    private void sendLayoutParamsToParent() {
        if (this.mParentInterface == null) {
            return;
        }
        WindowManager.LayoutParams[] params = new WindowManager.LayoutParams[this.mStateForWindow.size()];
        int index = 0;
        boolean hasChanges = false;
        for (State windowInfo : this.mStateForWindow.values()) {
            int changes = windowInfo.mLastReportedParams.copyFrom(windowInfo.mParams);
            hasChanges |= changes != 0;
            params[index++] = windowInfo.mParams;
        }
        if (hasChanges) {
            try {
                this.mParentInterface.updateParams(params);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    boolean forwardBackKeyToParent(@NonNull KeyEvent keyEvent) {
        if (this.mParentInterface == null) {
            return false;
        }
        try {
            this.mParentInterface.forwardBackKeyToParent(keyEvent);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to forward back key To Parent: ", e);
            return false;
        }
        return true;
    }

    private class State {
        SurfaceControl mSurfaceControl;
        final WindowManager.LayoutParams mParams = new WindowManager.LayoutParams();
        final WindowManager.LayoutParams mLastReportedParams = new WindowManager.LayoutParams();
        int mDisplayId;
        IBinder mInputChannelToken;
        Region mInputRegion;
        IWindow mClient;
        SurfaceControl mLeash;
        Rect mFrame;
        Rect mAttachedFrame;
        InputTransferToken mInputTransferToken;

        State(WindowlessWindowManager windowlessWindowManager, SurfaceControl sc, WindowManager.LayoutParams p, int displayId, IWindow client, SurfaceControl leash, Rect frame) {
            this.mSurfaceControl = sc;
            this.mParams.copyFrom(p);
            this.mDisplayId = displayId;
            this.mClient = client;
            this.mLeash = leash;
            this.mFrame = frame;
        }
    }

    public static interface ResizeCompleteCallback {
        public void finished(SurfaceControl.Transaction var1);
    }
}

