/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.FlaggedApi;
import android.annotation.RequiresPermission;
import android.content.ComponentName;
import android.graphics.Bitmap;
import android.graphics.Region;
import android.os.IBinder;
import android.os.Looper;
import android.view.Choreographer;
import android.view.Display;
import android.view.KeyboardShortcutGroup;
import android.view.SurfaceControl;
import android.view.SurfaceControlInputReceiver;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.view.WindowMetrics;
import android.window.InputTransferToken;
import android.window.TaskFpsCallback;
import android.window.TrustedPresentationThresholds;
import com.android.layoutlib.androidx.annotation.NonNull;
import com.android.layoutlib.androidx.annotation.Nullable;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.IntConsumer;

public class WindowManagerWrapper
implements WindowManager {
    @NonNull
    private final WindowManager mBase;

    public WindowManagerWrapper(@NonNull WindowManager base) {
        this.mBase = base;
    }

    @Override
    public void addView(View view, ViewGroup.LayoutParams params) {
        this.mBase.addView(view, params);
    }

    @Override
    public void updateViewLayout(View view, ViewGroup.LayoutParams params) {
        this.mBase.updateViewLayout(view, params);
    }

    @Override
    public void removeView(View view) {
        this.mBase.removeView(view);
    }

    @Override
    @Deprecated
    public Display getDefaultDisplay() {
        return this.mBase.getDefaultDisplay();
    }

    @Override
    public void removeViewImmediate(View view) {
        this.mBase.removeViewImmediate(view);
    }

    @Override
    @NonNull
    public WindowMetrics getCurrentWindowMetrics() {
        return this.mBase.getCurrentWindowMetrics();
    }

    @Override
    @NonNull
    public WindowMetrics getMaximumWindowMetrics() {
        return this.mBase.getMaximumWindowMetrics();
    }

    @Override
    @NonNull
    public Set<WindowMetrics> getPossibleMaximumWindowMetrics(int displayId) {
        return this.mBase.getPossibleMaximumWindowMetrics(displayId);
    }

    @Override
    public void requestAppKeyboardShortcuts(WindowManager.KeyboardShortcutsReceiver receiver, int deviceId) {
        this.mBase.requestAppKeyboardShortcuts(receiver, deviceId);
    }

    @Override
    public KeyboardShortcutGroup getApplicationLaunchKeyboardShortcuts(int deviceId) {
        return this.mBase.getApplicationLaunchKeyboardShortcuts(deviceId);
    }

    @Override
    public void requestImeKeyboardShortcuts(WindowManager.KeyboardShortcutsReceiver receiver, int deviceId) {
        this.mBase.requestImeKeyboardShortcuts(receiver, deviceId);
    }

    @Override
    @RequiresPermission(value="android.permission.RESTRICTED_VR_ACCESS")
    public Region getCurrentImeTouchRegion() {
        return this.mBase.getCurrentImeTouchRegion();
    }

    @Override
    public void setShouldShowWithInsecureKeyguard(int displayId, boolean shouldShow) {
        this.mBase.setShouldShowWithInsecureKeyguard(displayId, shouldShow);
    }

    @Override
    public void setShouldShowSystemDecors(int displayId, boolean shouldShow) {
        this.mBase.setShouldShowSystemDecors(displayId, shouldShow);
    }

    @Override
    public boolean shouldShowSystemDecors(int displayId) {
        return this.mBase.shouldShowSystemDecors(displayId);
    }

    @Override
    public void setDisplayImePolicy(int displayId, int imePolicy) {
        this.mBase.setDisplayImePolicy(displayId, imePolicy);
    }

    @Override
    @FlaggedApi(value="com.android.server.display.feature.flags.enable_display_content_mode_management")
    public boolean isEligibleForDesktopMode(int displayId) {
        return this.mBase.isEligibleForDesktopMode(displayId);
    }

    @Override
    public int getDisplayImePolicy(int displayId) {
        return this.mBase.getDisplayImePolicy(displayId);
    }

    @Override
    public boolean isGlobalKey(int keyCode) {
        return this.mBase.isGlobalKey(keyCode);
    }

    @Override
    public boolean isCrossWindowBlurEnabled() {
        return this.mBase.isCrossWindowBlurEnabled();
    }

    @Override
    public void addCrossWindowBlurEnabledListener(@NonNull Consumer<Boolean> listener) {
        this.mBase.addCrossWindowBlurEnabledListener(listener);
    }

    @Override
    public void addCrossWindowBlurEnabledListener(@NonNull Executor executor, @NonNull Consumer<Boolean> listener) {
        this.mBase.addCrossWindowBlurEnabledListener(executor, listener);
    }

    @Override
    public void removeCrossWindowBlurEnabledListener(@NonNull Consumer<Boolean> listener) {
        this.mBase.removeCrossWindowBlurEnabledListener(listener);
    }

    @Override
    public void addProposedRotationListener(@NonNull Executor executor, @NonNull IntConsumer listener) {
        this.mBase.addProposedRotationListener(executor, listener);
    }

    @Override
    public void removeProposedRotationListener(@NonNull IntConsumer listener) {
        this.mBase.removeProposedRotationListener(listener);
    }

    @Override
    public void holdLock(IBinder token, int durationMs) {
        this.mBase.holdLock(token, durationMs);
    }

    @Override
    public boolean isTaskSnapshotSupported() {
        return this.mBase.isTaskSnapshotSupported();
    }

    @Override
    public void registerTaskFpsCallback(int taskId, @NonNull Executor executor, @NonNull TaskFpsCallback callback) {
        this.mBase.registerTaskFpsCallback(taskId, executor, callback);
    }

    @Override
    public void unregisterTaskFpsCallback(@NonNull TaskFpsCallback callback) {
        this.mBase.unregisterTaskFpsCallback(callback);
    }

    @Override
    @Nullable
    public Bitmap snapshotTaskForRecents(int taskId) {
        return this.mBase.snapshotTaskForRecents(taskId);
    }

    @Override
    @NonNull
    public List<ComponentName> notifyScreenshotListeners(int displayId) {
        return this.mBase.notifyScreenshotListeners(displayId);
    }

    @Override
    @RequiresPermission(value="android.permission.ACCESS_SURFACE_FLINGER")
    public boolean replaceContentOnDisplayWithMirror(int displayId, @NonNull Window window) {
        return this.mBase.replaceContentOnDisplayWithMirror(displayId, window);
    }

    @Override
    @RequiresPermission(value="android.permission.ACCESS_SURFACE_FLINGER")
    public boolean replaceContentOnDisplayWithSc(int displayId, @NonNull SurfaceControl sc) {
        return this.mBase.replaceContentOnDisplayWithSc(displayId, sc);
    }

    @Override
    @FlaggedApi(value="com.android.window.flags.trusted_presentation_listener_for_window")
    public void registerTrustedPresentationListener(@NonNull IBinder window, @NonNull TrustedPresentationThresholds thresholds, @NonNull Executor executor, @NonNull Consumer<Boolean> listener) {
        this.mBase.registerTrustedPresentationListener(window, thresholds, executor, listener);
    }

    @Override
    @FlaggedApi(value="com.android.window.flags.trusted_presentation_listener_for_window")
    public void unregisterTrustedPresentationListener(@NonNull Consumer<Boolean> listener) {
        this.mBase.unregisterTrustedPresentationListener(listener);
    }

    @Override
    @FlaggedApi(value="com.android.window.flags.surface_control_input_receiver")
    @NonNull
    public InputTransferToken registerBatchedSurfaceControlInputReceiver(@NonNull InputTransferToken hostInputTransferToken, @NonNull SurfaceControl surfaceControl, @NonNull Choreographer choreographer, @NonNull SurfaceControlInputReceiver receiver) {
        return this.mBase.registerBatchedSurfaceControlInputReceiver(hostInputTransferToken, surfaceControl, choreographer, receiver);
    }

    @Override
    @FlaggedApi(value="com.android.window.flags.surface_control_input_receiver")
    @NonNull
    public InputTransferToken registerUnbatchedSurfaceControlInputReceiver(@NonNull InputTransferToken hostInputTransferToken, @NonNull SurfaceControl surfaceControl, @NonNull Looper looper, @NonNull SurfaceControlInputReceiver receiver) {
        return this.mBase.registerUnbatchedSurfaceControlInputReceiver(hostInputTransferToken, surfaceControl, looper, receiver);
    }

    @Override
    @FlaggedApi(value="com.android.window.flags.surface_control_input_receiver")
    public void unregisterSurfaceControlInputReceiver(@NonNull SurfaceControl surfaceControl) {
        this.mBase.unregisterSurfaceControlInputReceiver(surfaceControl);
    }

    @Override
    @FlaggedApi(value="com.android.window.flags.surface_control_input_receiver")
    @Nullable
    public IBinder getSurfaceControlInputClientToken(@NonNull SurfaceControl surfaceControl) {
        return this.mBase.getSurfaceControlInputClientToken(surfaceControl);
    }

    @Override
    @FlaggedApi(value="com.android.window.flags.surface_control_input_receiver")
    public boolean transferTouchGesture(@NonNull InputTransferToken transferFromToken, @NonNull InputTransferToken transferToToken) {
        return this.mBase.transferTouchGesture(transferFromToken, transferToToken);
    }

    @Override
    @NonNull
    public IBinder getDefaultToken() {
        return this.mBase.getDefaultToken();
    }

    @Override
    @FlaggedApi(value="com.android.window.flags.screen_recording_callbacks")
    @RequiresPermission(value="android.permission.DETECT_SCREEN_RECORDING")
    public int addScreenRecordingCallback(@NonNull Executor executor, @NonNull Consumer<Integer> callback) {
        return this.mBase.addScreenRecordingCallback(executor, callback);
    }

    @Override
    @FlaggedApi(value="com.android.window.flags.screen_recording_callbacks")
    @RequiresPermission(value="android.permission.DETECT_SCREEN_RECORDING")
    public void removeScreenRecordingCallback(@NonNull Consumer<Integer> callback) {
        this.mBase.removeScreenRecordingCallback(callback);
    }

    @Override
    public WindowManager createLocalWindowManager(@NonNull Window parentWindow) {
        WindowManager newBase = this.mBase.createLocalWindowManager(parentWindow);
        return new WindowManagerWrapper(newBase);
    }

    @Override
    public void setParentWindow(@NonNull Window parentWindow) {
        this.mBase.setParentWindow(parentWindow);
    }
}

