/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.IBinder;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.DisplayCutout;
import android.view.DisplayInfo;
import android.view.DisplayShape;
import android.view.InsetsState;
import android.view.KeyboardShortcutGroup;
import android.view.KeyboardShortcutInfo;
import android.view.MotionEvent;
import android.view.PrivacyIndicatorBounds;
import android.view.RoundedCorners;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewRootImpl;
import android.view.ViewRootImpl_Accessor;
import android.view.Window;
import android.view.WindowInsets;
import android.view.WindowManager;
import android.view.WindowMetrics;
import android.widget.FrameLayout;
import com.android.internal.policy.DecorView;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.util.InsetUtil;
import com.android.server.wm.DisplayFrames;
import java.util.ArrayList;

public class WindowManagerImpl
implements WindowManager {
    private static final PrivacyIndicatorBounds sPrivacyIndicatorBounds = new PrivacyIndicatorBounds();
    private final Context mContext;
    private final DisplayMetrics mMetrics;
    private final DisplayInfo mDisplayInfo;
    private Display mDisplay;
    private ViewGroup mBaseRootView;
    private ViewGroup mCurrentRootView;
    private DisplayFrames mDisplayFrames;

    public WindowManagerImpl(BridgeContext context, DisplayMetrics metrics) {
        this.mContext = context;
        this.mMetrics = metrics;
        this.mDisplayInfo = new DisplayInfo();
        this.mDisplayInfo.logicalHeight = this.mMetrics.heightPixels;
        this.mDisplayInfo.logicalWidth = this.mMetrics.widthPixels;
        this.mDisplayInfo.supportedModes = new Display.Mode[]{new Display.Mode(0, this.mMetrics.widthPixels, this.mMetrics.heightPixels, 60.0f)};
        this.mDisplayInfo.logicalDensityDpi = this.mMetrics.densityDpi;
        this.mDisplayInfo.displayCutout = DisplayCutout.NO_CUTOUT;
        this.mDisplayInfo.rotation = context.getConfiguration().orientation == 2 ? 1 : 0;
    }

    @Override
    public WindowManagerImpl createLocalWindowManager(Window parentWindow) {
        return this;
    }

    public WindowManagerImpl createPresentationWindowManager(Context displayContext) {
        Bridge.getLog().fidelityWarning("unsupported", "The preview does not fully support multiple windows.", null, null, null);
        return this;
    }

    public void setDefaultToken(IBinder token) {
    }

    @Override
    public Display getDefaultDisplay() {
        if (this.mDisplay == null) {
            this.mDisplay = new Display(null, 0, this.mDisplayInfo, this.mContext.getResources());
        }
        return this.mDisplay;
    }

    @Override
    public void addView(View arg0, ViewGroup.LayoutParams arg1) {
        if (this.mBaseRootView == null) {
            return;
        }
        if (this.mCurrentRootView == null) {
            FrameLayout layout2 = new FrameLayout(this.mContext){

                @Override
                public boolean dispatchTouchEvent(MotionEvent ev) {
                    float offsetX = -this.getX();
                    float offsetY = -this.getY();
                    View baseRootParent = (View)((Object)WindowManagerImpl.this.mBaseRootView.getParent());
                    if (baseRootParent != null) {
                        offsetX -= baseRootParent.getX();
                        offsetY -= baseRootParent.getY();
                    }
                    ev.offsetLocation(offsetX, offsetY);
                    return super.dispatchTouchEvent(ev);
                }

                @Override
                protected void measureChildWithMargins(View child, int parentWidthMeasureSpec, int widthUsed, int parentHeightMeasureSpec, int heightUsed) {
                    int baseSize;
                    ViewGroup.LayoutParams lp = child.getLayoutParams();
                    int parentWidth = View.MeasureSpec.getSize(parentWidthMeasureSpec);
                    int parentHeight = View.MeasureSpec.getSize(parentHeightMeasureSpec);
                    int childWidthMeasureSpec = 0;
                    int childHeightMeasureSpec = ViewRootImpl.getRootMeasureSpec(parentHeight, lp.height, 0);
                    if (lp.width == -2 && (baseSize = this.mContext.getResources().getDimensionPixelSize(17105156)) != 0 && baseSize < parentWidth) {
                        childWidthMeasureSpec = ViewRootImpl.getRootMeasureSpec(baseSize, lp.width, 0);
                    }
                    if (childWidthMeasureSpec == 0) {
                        childWidthMeasureSpec = ViewRootImpl.getRootMeasureSpec(parentWidth, lp.width, 0);
                    }
                    child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
                }
            };
            layout2.setOnTouchListener((v, event) -> {
                event.offsetLocation(-arg0.getX(), -arg0.getY());
                return arg0.dispatchTouchEvent(event);
            });
            int layoutMode = -2;
            if (arg0 instanceof DecorView) {
                layoutMode = -1;
            }
            this.mBaseRootView.addView((View)layout2, new FrameLayout.LayoutParams(layoutMode, layoutMode));
            this.mCurrentRootView = layout2;
        }
        FrameLayout.LayoutParams frameLayoutParams = new FrameLayout.LayoutParams(arg1);
        if (arg1 instanceof WindowManager.LayoutParams) {
            WindowManager.LayoutParams params = (WindowManager.LayoutParams)arg1;
            frameLayoutParams.gravity = params.gravity;
            if ((params.flags & 2) != 0) {
                this.mCurrentRootView.setBackgroundColor(Color.argb(params.dimAmount, 0.0f, 0.0f, 0.0f));
            } else {
                int backgroundColor = -1;
                Drawable background = this.mBaseRootView.getBackground();
                if (background == null) {
                    background = this.mBaseRootView.getRootView().getBackground();
                }
                if (background instanceof ColorDrawable) {
                    backgroundColor = ((ColorDrawable)background).getColor();
                }
                this.mCurrentRootView.setBackgroundColor(backgroundColor);
            }
        }
        this.mCurrentRootView.addView(arg0, frameLayoutParams);
        ViewRootImpl_Accessor.setChild(this.mBaseRootView.getViewRootImpl(), arg0);
    }

    @Override
    public void removeView(View arg0) {
        ViewRootImpl viewRootImpl = arg0.getViewRootImpl();
        if (this.mCurrentRootView != null) {
            this.mCurrentRootView.removeView(arg0);
            if (this.mBaseRootView != null && this.mCurrentRootView.getChildCount() == 0) {
                this.mBaseRootView.removeView(this.mCurrentRootView);
                this.mCurrentRootView = null;
            }
        }
        if (viewRootImpl != null && viewRootImpl.getView() == arg0) {
            View newRoot = null;
            if (this.mCurrentRootView != null && this.mCurrentRootView.getChildCount() > 0) {
                ArrayList<View> childrenList = this.mCurrentRootView.buildOrderedChildList();
                newRoot = childrenList.get(childrenList.size() - 1);
            } else if (this.mBaseRootView != null) {
                View root = this.mBaseRootView;
                while (root.getParent() instanceof View) {
                    root = (View)((Object)root.getParent());
                }
                newRoot = root;
            }
            ViewRootImpl_Accessor.setChild(viewRootImpl, newRoot);
        }
    }

    @Override
    public void updateViewLayout(View view, ViewGroup.LayoutParams params) {
        if (view == null) {
            throw new IllegalArgumentException("view must not be null");
        }
        if (!(params instanceof WindowManager.LayoutParams)) {
            throw new IllegalArgumentException("Params must be WindowManager.LayoutParams");
        }
        WindowManager.LayoutParams wparams = (WindowManager.LayoutParams)params;
        FrameLayout.LayoutParams lparams = new FrameLayout.LayoutParams(params);
        lparams.gravity = wparams.gravity;
        view.setLayoutParams(lparams);
        if (this.mCurrentRootView != null) {
            Rect bounds = new Rect();
            this.mBaseRootView.getBoundsOnScreen(bounds);
            this.mCurrentRootView.setX(wparams.x - bounds.left);
            this.mCurrentRootView.setY(wparams.y - bounds.top);
            this.mCurrentRootView.setElevation(view.getElevation());
        }
    }

    @Override
    public void removeViewImmediate(View arg0) {
        this.removeView(arg0);
    }

    @Override
    public KeyboardShortcutGroup getApplicationLaunchKeyboardShortcuts(int deviceId) {
        return new KeyboardShortcutGroup((CharSequence)"", new ArrayList<KeyboardShortcutInfo>());
    }

    @Override
    public void requestAppKeyboardShortcuts(WindowManager.KeyboardShortcutsReceiver receiver, int deviceId) {
    }

    @Override
    public Region getCurrentImeTouchRegion() {
        return null;
    }

    @Override
    public void setShouldShowWithInsecureKeyguard(int displayId, boolean shouldShow) {
    }

    @Override
    public void setShouldShowSystemDecors(int displayId, boolean shouldShow) {
    }

    @Override
    public void setDisplayImePolicy(int displayId, int imePolicy) {
    }

    @Override
    public WindowMetrics getCurrentWindowMetrics() {
        Rect bound = InsetUtil.getCurrentBounds(this.mContext);
        return new WindowMetrics(bound, this.computeWindowInsets());
    }

    @Override
    public WindowMetrics getMaximumWindowMetrics() {
        return new WindowMetrics(this.getMaximumBounds(), this.computeWindowInsets());
    }

    private Rect getMaximumBounds() {
        Point displaySize = new Point();
        this.getDefaultDisplay().getRealSize(displaySize);
        return new Rect(0, 0, displaySize.x, displaySize.y);
    }

    private WindowInsets computeWindowInsets() {
        if (this.mBaseRootView == null) {
            return null;
        }
        return this.mBaseRootView.getViewRootImpl().getWindowInsets(true);
    }

    public void setBaseRootView(ViewGroup baseRootView) {
        ViewGroup composableRoot = this.findComposableRoot(baseRootView);
        this.mBaseRootView = composableRoot != null ? composableRoot : baseRootView;
    }

    private ViewGroup findComposableRoot(ViewGroup baseRootView) {
        if (baseRootView.getClass().getName().endsWith("ComposeViewAdapter")) {
            return baseRootView;
        }
        for (int i = 0; i < baseRootView.getChildCount(); ++i) {
            ViewGroup composableRoot;
            View child = baseRootView.getChildAt(i);
            if (!(child instanceof ViewGroup) || (composableRoot = this.findComposableRoot((ViewGroup)child)) == null) continue;
            return composableRoot;
        }
        return null;
    }

    public ViewGroup getCurrentRootView() {
        return this.mCurrentRootView;
    }

    public void createOrUpdateDisplayFrames(InsetsState insetsState) {
        if (this.mDisplayFrames == null) {
            this.mDisplayFrames = new DisplayFrames(insetsState, this.mDisplayInfo, this.mDisplayInfo.displayCutout, RoundedCorners.NO_ROUNDED_CORNERS, sPrivacyIndicatorBounds, DisplayShape.NONE);
        } else {
            this.mDisplayFrames.update(this.mDisplayInfo.rotation, this.mDisplayInfo.logicalWidth, this.mDisplayInfo.logicalHeight, this.mDisplayInfo.displayCutout, RoundedCorners.NO_ROUNDED_CORNERS, sPrivacyIndicatorBounds, DisplayShape.NONE);
        }
    }

    public void setupDisplayCutout() {
        int displayHeight;
        int displayWidth;
        if (this.mDisplayInfo.rotation == 1) {
            displayWidth = this.mMetrics.heightPixels;
            displayHeight = this.mMetrics.widthPixels;
        } else {
            displayWidth = this.mMetrics.widthPixels;
            displayHeight = this.mMetrics.heightPixels;
        }
        DisplayCutout displayCutout = DisplayCutout.fromResourcesRectApproximation(this.mContext.getResources(), null, displayWidth, displayHeight, displayWidth, displayHeight);
        if (displayCutout != null) {
            this.mDisplayInfo.displayCutout = displayCutout.getRotated(displayWidth, displayHeight, 0, this.mDisplayInfo.rotation);
        }
    }
}

