/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.content.Context;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os._Original_Build;
import android.util.Log;
import android.view.SurfaceControl;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.GcUtils;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Map;
import java.util.WeakHashMap;

public class SurfaceControlRegistry {
    private static final String TAG = "SurfaceControlRegistry";
    static final String APPLY = "apply";
    private static final int MAX_LAYERS_REPORTING_THRESHOLD = 1024;
    private static final int RESET_REPORTING_THRESHOLD = 256;
    private static final int DUMP_LIMIT = 256;
    private static final SurfaceControlRegistry NO_OP_REGISTRY = new NoOpRegistry();
    private static final Object sLock = new Object();
    private static final DefaultReporter sDefaultReporter = new DefaultReporter();
    private static volatile SurfaceControlRegistry sProcessRegistry;
    static boolean sCallStackDebuggingInitialized;
    static boolean sCallStackDebuggingEnabled;
    private static String sCallStackDebuggingMatchName;
    private static String sCallStackDebuggingMatchCall;
    static boolean sLogAllTxCallsOnApply;
    @GuardedBy(value={"sLock"})
    private final WeakHashMap<SurfaceControl, Long> mSurfaceControls;
    private int mMaxLayersReportingThreshold = 1024;
    private int mResetReportingThreshold = 256;
    private boolean mHasReportedExceedingMaxThreshold = false;
    private Reporter mReporter = sDefaultReporter;

    private SurfaceControlRegistry() {
        this.mSurfaceControls = new WeakHashMap(256);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void setReportingThresholds(int maxLayersReportingThreshold, int resetReportingThreshold, Reporter reporter) {
        Object object = sLock;
        synchronized (object) {
            if (maxLayersReportingThreshold <= 0 || resetReportingThreshold >= maxLayersReportingThreshold) {
                throw new IllegalArgumentException("Expected maxLayersReportingThreshold (" + maxLayersReportingThreshold + ") to be > 0 and resetReportingThreshold (" + resetReportingThreshold + ") to be < maxLayersReportingThreshold");
            }
            if (reporter == null) {
                throw new IllegalArgumentException("Expected non-null reporter");
            }
            this.mMaxLayersReportingThreshold = maxLayersReportingThreshold;
            this.mResetReportingThreshold = resetReportingThreshold;
            this.mHasReportedExceedingMaxThreshold = false;
            this.mReporter = reporter;
        }
    }

    @VisibleForTesting
    public void setCallStackDebuggingParams(String matchName, String matchCall) {
        sCallStackDebuggingMatchName = matchName.toLowerCase();
        sCallStackDebuggingMatchCall = matchCall.toLowerCase();
        sLogAllTxCallsOnApply = sCallStackDebuggingMatchCall.contains(APPLY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.READ_FRAME_BUFFER")
    @NonNull
    public static void createProcessInstance(Context context) {
        if (context.checkSelfPermission("android.permission.READ_FRAME_BUFFER") != 0) {
            throw new SecurityException("Expected caller to hold READ_FRAME_BUFFER");
        }
        Object object = sLock;
        synchronized (object) {
            if (sProcessRegistry == null) {
                sProcessRegistry = new SurfaceControlRegistry();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroyProcessInstance() {
        Object object = sLock;
        synchronized (object) {
            if (sProcessRegistry == null) {
                return;
            }
            sProcessRegistry = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SurfaceControlRegistry getProcessInstance() {
        Object object = sLock;
        synchronized (object) {
            return sProcessRegistry != null ? sProcessRegistry : NO_OP_REGISTRY;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(SurfaceControl sc) {
        Object object = sLock;
        synchronized (object) {
            this.mSurfaceControls.put(sc, SystemClock.elapsedRealtime());
            if (!this.mHasReportedExceedingMaxThreshold && this.mSurfaceControls.size() >= this.mMaxLayersReportingThreshold) {
                PrintWriter pw = new PrintWriter(System.out, true);
                this.mReporter.onMaxLayersExceeded(this.mSurfaceControls, 256, pw);
                this.mHasReportedExceedingMaxThreshold = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(SurfaceControl sc) {
        Object object = sLock;
        synchronized (object) {
            this.mSurfaceControls.remove(sc);
            if (this.mHasReportedExceedingMaxThreshold && this.mSurfaceControls.size() <= this.mResetReportingThreshold) {
                this.mHasReportedExceedingMaxThreshold = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        Object object = sLock;
        synchronized (object) {
            return this.mSurfaceControls.keySet().hashCode();
        }
    }

    static void initializeCallStackDebugging() {
        if (sCallStackDebuggingInitialized || !_Original_Build.IS_DEBUGGABLE) {
            return;
        }
        sCallStackDebuggingInitialized = true;
        SurfaceControlRegistry.updateCallStackDebuggingParams();
        if (sCallStackDebuggingEnabled) {
            Log.d(TAG, "Enabling transaction call stack debugging: matchCall=" + sCallStackDebuggingMatchCall + " matchName=" + sCallStackDebuggingMatchName + " logCallsWithApply=" + sLogAllTxCallsOnApply);
        }
    }

    void checkCallStackDebugging(@NonNull String call, @Nullable SurfaceControl.Transaction tx, @Nullable SurfaceControl sc, @Nullable String details) {
        String msg;
        if (sCallStackDebuggingInitialized && sCallStackDebuggingEnabled) {
            SurfaceControlRegistry.updateCallStackDebuggingParams();
        }
        if (!sCallStackDebuggingEnabled) {
            return;
        }
        String txMsg = tx != null ? "tx=" + tx.getId() + " " : "";
        String scMsg = sc != null ? " sc=" + sc.getName() + "" : "";
        String string2 = msg = details != null ? call + " (" + txMsg + scMsg + ") " + details : call + " (" + txMsg + scMsg + ")";
        if (sLogAllTxCallsOnApply && tx != null) {
            if (call == APPLY) {
                Log.e(TAG, msg, new Throwable());
                if (tx.mCalls != null) {
                    for (int i = 0; i < tx.mCalls.size(); ++i) {
                        Log.d(TAG, "        " + tx.mCalls.get(i));
                    }
                }
            } else if (this.matchesForCallStackDebugging(sc != null ? sc.getName() : null, call)) {
                Log.e(TAG, msg, new Throwable());
                if (tx.mCalls != null) {
                    tx.mCalls.add(msg);
                }
            }
        } else {
            if (!this.matchesForCallStackDebugging(sc != null ? sc.getName() : null, call)) {
                return;
            }
            Log.e(TAG, msg, new Throwable());
        }
    }

    private static void updateCallStackDebuggingParams() {
        sCallStackDebuggingMatchCall = SystemProperties.get("persist.wm.debug.sc.tx.log_match_call", null).toLowerCase();
        sCallStackDebuggingMatchName = SystemProperties.get("persist.wm.debug.sc.tx.log_match_name", null).toLowerCase();
        sLogAllTxCallsOnApply = sCallStackDebuggingMatchCall.contains(APPLY);
        sCallStackDebuggingEnabled = !sCallStackDebuggingMatchCall.isEmpty() || !sCallStackDebuggingMatchName.isEmpty();
    }

    @VisibleForTesting
    public boolean matchesForCallStackDebugging(@Nullable String name, @NonNull String call) {
        boolean matchName;
        boolean matchCall;
        boolean bl = matchCall = !sCallStackDebuggingMatchCall.isEmpty();
        if (matchCall && !sCallStackDebuggingMatchCall.contains(call.toLowerCase())) {
            return false;
        }
        boolean bl2 = matchName = !sCallStackDebuggingMatchName.isEmpty();
        if (!matchName) {
            return true;
        }
        if (name == null) {
            return false;
        }
        return sCallStackDebuggingMatchName.contains(name.toLowerCase()) || name.toLowerCase().contains(sCallStackDebuggingMatchName);
    }

    static boolean isCallStackDebuggingEnabled() {
        return sCallStackDebuggingEnabled;
    }

    private static void runGcAndFinalizers() {
        long t = SystemClock.elapsedRealtime();
        GcUtils.runGcAndFinalizersSync();
        Log.i(TAG, "Ran gc and finalizers (" + (SystemClock.elapsedRealtime() - t) + "ms)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dump(int limit, boolean runGc, PrintWriter pw) {
        if (runGc) {
            SurfaceControlRegistry.runGcAndFinalizers();
        }
        Object object = sLock;
        synchronized (object) {
            if (sProcessRegistry != null) {
                sDefaultReporter.onMaxLayersExceeded(SurfaceControlRegistry.sProcessRegistry.mSurfaceControls, limit, pw);
                pw.println("sCallStackDebuggingInitialized=" + sCallStackDebuggingInitialized);
                pw.println("sCallStackDebuggingEnabled=" + sCallStackDebuggingEnabled);
                pw.println("sCallStackDebuggingMatchName=" + sCallStackDebuggingMatchName);
                pw.println("sCallStackDebuggingMatchCall=" + sCallStackDebuggingMatchCall);
                pw.println("sLogAllTxCallsOnApply=" + sLogAllTxCallsOnApply);
            }
        }
    }

    private static class DefaultReporter
    implements Reporter {
        private DefaultReporter() {
        }

        @Override
        public void onMaxLayersExceeded(WeakHashMap<SurfaceControl, Long> surfaceControls, int limit, PrintWriter pw) {
            long now = SystemClock.elapsedRealtime();
            ArrayList<Map.Entry<SurfaceControl, Long>> entries = new ArrayList<Map.Entry<SurfaceControl, Long>>();
            for (Map.Entry<SurfaceControl, Long> entry : surfaceControls.entrySet()) {
                entries.add(entry);
            }
            entries.sort((o1, o2) -> Long.compare((Long)o1.getValue(), (Long)o2.getValue()));
            int size = Math.min(entries.size(), limit);
            pw.println(SurfaceControlRegistry.TAG);
            pw.println("----------------------");
            pw.println("Listing oldest " + size + " of " + surfaceControls.size());
            for (int i = 0; i < size; ++i) {
                Map.Entry entry = (Map.Entry)entries.get(i);
                SurfaceControl sc = (SurfaceControl)entry.getKey();
                if (sc == null) continue;
                long timeRegistered = (Long)entry.getValue();
                pw.print("  ");
                pw.print(sc.getName());
                pw.print(" (" + sc.getCallsite() + ")");
                pw.println(" [" + (now - timeRegistered) / 1000L + "s ago]");
            }
        }
    }

    public static interface Reporter {
        public void onMaxLayersExceeded(WeakHashMap<SurfaceControl, Long> var1, int var2, PrintWriter var3);
    }

    private static class NoOpRegistry
    extends SurfaceControlRegistry {
        private NoOpRegistry() {
        }

        @Override
        public void setReportingThresholds(int maxLayersReportingThreshold, int resetReportingThreshold, Reporter reporter) {
        }

        @Override
        void add(SurfaceControl sc) {
        }

        @Override
        void remove(SurfaceControl sc) {
        }
    }
}

