/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.view.IScrollCaptureConnection;
import com.android.internal.util.AnnotationValidations;
import java.util.ArrayList;

public class ScrollCaptureResponse
implements Parcelable {
    @NonNull
    private String mDescription = "";
    @Nullable
    private IScrollCaptureConnection mConnection = null;
    @Nullable
    private Rect mWindowBounds = null;
    @Nullable
    private Rect mBoundsInWindow = null;
    @Nullable
    private String mWindowTitle = null;
    @Nullable
    private String mPackageName = null;
    @NonNull
    private ArrayList<String> mMessages = new ArrayList();
    @NonNull
    public static final Parcelable.Creator<ScrollCaptureResponse> CREATOR = new Parcelable.Creator<ScrollCaptureResponse>(){

        public ScrollCaptureResponse[] newArray(int size) {
            return new ScrollCaptureResponse[size];
        }

        @Override
        public ScrollCaptureResponse createFromParcel(@NonNull Parcel in) {
            return new ScrollCaptureResponse(in);
        }
    };

    public boolean isConnected() {
        return this.mConnection != null && this.mConnection.asBinder().isBinderAlive();
    }

    public void close() {
        if (this.mConnection != null) {
            try {
                this.mConnection.close();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            this.mConnection = null;
        }
    }

    ScrollCaptureResponse(@NonNull String description, @Nullable IScrollCaptureConnection connection, @Nullable Rect windowBounds, @Nullable Rect boundsInWindow, @Nullable String windowTitle, @Nullable String packageName, @NonNull ArrayList<String> messages) {
        this.mDescription = description;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mDescription);
        this.mConnection = connection;
        this.mWindowBounds = windowBounds;
        this.mBoundsInWindow = boundsInWindow;
        this.mWindowTitle = windowTitle;
        this.mPackageName = packageName;
        this.mMessages = messages;
        AnnotationValidations.validate(NonNull.class, null, this.mMessages);
    }

    @NonNull
    public String getDescription() {
        return this.mDescription;
    }

    @Nullable
    public IScrollCaptureConnection getConnection() {
        return this.mConnection;
    }

    @Nullable
    public Rect getWindowBounds() {
        return this.mWindowBounds;
    }

    @Nullable
    public Rect getBoundsInWindow() {
        return this.mBoundsInWindow;
    }

    @Nullable
    public String getWindowTitle() {
        return this.mWindowTitle;
    }

    @Nullable
    public String getPackageName() {
        return this.mPackageName;
    }

    @NonNull
    public ArrayList<String> getMessages() {
        return this.mMessages;
    }

    public String toString() {
        return "ScrollCaptureResponse { description = " + this.mDescription + ", connection = " + this.mConnection + ", windowBounds = " + this.mWindowBounds + ", boundsInWindow = " + this.mBoundsInWindow + ", windowTitle = " + this.mWindowTitle + ", packageName = " + this.mPackageName + ", messages = " + this.mMessages + " }";
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        byte flg = 0;
        if (this.mConnection != null) {
            flg = (byte)(flg | 2);
        }
        if (this.mWindowBounds != null) {
            flg = (byte)(flg | 4);
        }
        if (this.mBoundsInWindow != null) {
            flg = (byte)(flg | 8);
        }
        if (this.mWindowTitle != null) {
            flg = (byte)(flg | 0x10);
        }
        if (this.mPackageName != null) {
            flg = (byte)(flg | 0x20);
        }
        dest.writeByte(flg);
        dest.writeString(this.mDescription);
        if (this.mConnection != null) {
            dest.writeStrongInterface(this.mConnection);
        }
        if (this.mWindowBounds != null) {
            dest.writeTypedObject(this.mWindowBounds, flags);
        }
        if (this.mBoundsInWindow != null) {
            dest.writeTypedObject(this.mBoundsInWindow, flags);
        }
        if (this.mWindowTitle != null) {
            dest.writeString(this.mWindowTitle);
        }
        if (this.mPackageName != null) {
            dest.writeString(this.mPackageName);
        }
        dest.writeStringList(this.mMessages);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    protected ScrollCaptureResponse(@NonNull Parcel in) {
        byte flg = in.readByte();
        String description = in.readString();
        IScrollCaptureConnection connection = (flg & 2) == 0 ? null : IScrollCaptureConnection.Stub.asInterface(in.readStrongBinder());
        Rect windowBounds = (flg & 4) == 0 ? null : in.readTypedObject(Rect.CREATOR);
        Rect boundsInWindow = (flg & 8) == 0 ? null : in.readTypedObject(Rect.CREATOR);
        String windowTitle = (flg & 0x10) == 0 ? null : in.readString();
        String packageName = (flg & 0x20) == 0 ? null : in.readString();
        ArrayList<String> messages = new ArrayList<String>();
        in.readStringList(messages);
        this.mDescription = description;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mDescription);
        this.mConnection = connection;
        this.mWindowBounds = windowBounds;
        this.mBoundsInWindow = boundsInWindow;
        this.mWindowTitle = windowTitle;
        this.mPackageName = packageName;
        this.mMessages = messages;
        AnnotationValidations.validate(NonNull.class, null, this.mMessages);
    }

    @Deprecated
    private void __metadata() {
    }

    public static class Builder {
        @NonNull
        private String mDescription;
        @Nullable
        private IScrollCaptureConnection mConnection;
        @Nullable
        private Rect mWindowBounds;
        @Nullable
        private Rect mBoundsInWindow;
        @Nullable
        private String mWindowTitle;
        @Nullable
        private String mPackageName;
        @NonNull
        private ArrayList<String> mMessages;
        private long mBuilderFieldsSet = 0L;

        @NonNull
        public Builder setDescription(@NonNull String value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 1L;
            this.mDescription = value;
            return this;
        }

        @NonNull
        public Builder setConnection(@Nullable IScrollCaptureConnection value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 2L;
            this.mConnection = value;
            return this;
        }

        @NonNull
        public Builder setWindowBounds(@NonNull Rect value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 4L;
            this.mWindowBounds = value;
            return this;
        }

        @NonNull
        public Builder setBoundsInWindow(@NonNull Rect value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 8L;
            this.mBoundsInWindow = value;
            return this;
        }

        @NonNull
        public Builder setWindowTitle(@NonNull String value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x10L;
            this.mWindowTitle = value;
            return this;
        }

        @NonNull
        public Builder setPackageName(@NonNull String value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x20L;
            this.mPackageName = value;
            return this;
        }

        @NonNull
        public Builder setMessages(@NonNull ArrayList<String> value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x40L;
            this.mMessages = value;
            return this;
        }

        @NonNull
        public Builder addMessage(@NonNull String value) {
            if (this.mMessages == null) {
                this.setMessages(new ArrayList<String>());
            }
            this.mMessages.add(value);
            return this;
        }

        @NonNull
        public ScrollCaptureResponse build() {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x80L;
            if ((this.mBuilderFieldsSet & 1L) == 0L) {
                this.mDescription = "";
            }
            if ((this.mBuilderFieldsSet & 2L) == 0L) {
                this.mConnection = null;
            }
            if ((this.mBuilderFieldsSet & 4L) == 0L) {
                this.mWindowBounds = null;
            }
            if ((this.mBuilderFieldsSet & 8L) == 0L) {
                this.mBoundsInWindow = null;
            }
            if ((this.mBuilderFieldsSet & 0x10L) == 0L) {
                this.mWindowTitle = null;
            }
            if ((this.mBuilderFieldsSet & 0x20L) == 0L) {
                this.mPackageName = null;
            }
            if ((this.mBuilderFieldsSet & 0x40L) == 0L) {
                this.mMessages = new ArrayList();
            }
            ScrollCaptureResponse o = new ScrollCaptureResponse(this.mDescription, this.mConnection, this.mWindowBounds, this.mBoundsInWindow, this.mWindowTitle, this.mPackageName, this.mMessages);
            return o;
        }

        private void checkNotUsed() {
            if ((this.mBuilderFieldsSet & 0x80L) != 0L) {
                throw new IllegalStateException("This Builder should not be reused. Use a new Builder instance instead");
            }
        }
    }
}

